module NWConst::Library
  # 回想・ＣＧ閲覧用デフォルト背景（ピクチャフォルダ参照）
  H_SCENE_DEFAULT_MEMORY_BG_IMAGE = ""

  # 回想・ＣＧ閲覧用背景
  # :bb1 => 戦闘背景１から背景を選択します
  # :bb2 => 戦闘背景２から背景を選択します
  # :pic => ピクチャフォルダから背景を選択します
  H_SCENE_MEMORY_BG_IMAGE = {

  # ポケット魔王城
    1 => {:bb1 => "bg195" },

  # 平原
    2 => {:bb1 => "Grassland", :bb2 => "Grassland"},

  # 森
    3 => {:bb1 => "GrassMaze", :bb2 => "Forest1"},
    4 => {:bb1 => "GrassMaze", :bb2 => "Forest2"},
    5 => {:bb1 => "GrassMaze", :bb2 => "GrassMaze"},

  # 荒野
    6 => {:bb1 => "Wasteland", :bb2 => "Wasteland"},
    7 => {:bb1 => "Dirt1", :bb2 => "Wasteland"},

  # 岩地
    8 => {:bb1 => "DirtCave", :bb2 => "DirtCave"},
    9 => {:bb1 => "Dirt1", :bb2 => "Cliff"},
    10 => {:bb1 => "Dirt2", :bb2 => "Cliff"},

  # 砂漠
    11 => {:bb1 => "Desert", :bb2 => "Desert"},
    12 => {:bb1 => "砂漠"},

  # 毒沼
    13 => {:bb1 => "PoisonSwamp", :bb2 => "PoisonSwamp"},

  # 砂浜
    14 => {:bb1 => "Sand", :bb2 => "Sea"},

  # 雪原
    15 => {:bb1 => "Snow", :bb2 => "Snowfield"},

  # 溶岩
    16 => {:bb1 => "Lava2", :bb2 => "RockCave"},
    17 => {:bb1 => "Lava2", :bb2 => "LavaCave"},

  # 魔の大地
    18 => {:bb1 => "Lava1", :bb2 => "Lava"},

  # 洞窟
    19 => {:bb1 => "DirtCave", :bb2 => "Mine"},
    20 => {:bb1 => "RockCave1", :bb2 => "RockCave"},
    21 => {:bb1 => "RockCave2", :bb2 => "RockCave"},
    22 => {:bb1 => "Road1", :bb2 => "RockCave"},
    78 => {:bb1 => "DirtCave", :bb2 => "RockCave"},

  # 氷の洞窟
    23 => {:bb1 => "IceCave", :bb2 => "IceCave"},
    24 => {:bb1 => "Crystal1", :bb2 => "Crystal"},

  # 塔
    25 => {:bb1 => "Cobblestones1", :bb2 => "Stone1"},
    26 => {:bb1 => "Stone1", :bb2 => "Stone3"},
    27 => {:bb1 => "Cobblestones1", :bb2 => "Tower"},
    28 => {:bb1 => "Cobblestones1", :bb2 => "Fort2"},
    29 => {:bb1 => "Stone3", :bb2 => "Stone5"},
    30 => {:bb1 => "Fort", :bb2 => "Fort2"},
    31 => {:bb1 => "Stone2", :bb2 => "Tower"},

  # 屋外
    32 => {:bb1 => "DirtField", :bb2 => "Town3"},
    33 => {:bb1 => "Cobblestones1", :bb2 => "Brick"},
    34 => {:bb1 => "Cobblestones1", :bb2 => "Castle1"},
    35 => {:bb1 => "Cobblestones1", :bb2 => "Town2"},

  # 屋内
    36 => {:bb1 => "Wood1", :bb2 => "Room1"},
    37 => {:bb1 => "Wood1", :bb2 => "Room4"},
    38 => {:bb1 => "Wood1", :bb2 => "Room2"},

  # 城
    39 => {:bb1 => "DecorativeTile", :bb2 => "castle3"},
    40 => {:bb1 => "DecorativeTile", :bb2 => "Castle2"},
    41 => {:bb1 => "DecorativeTile", :bb2 => "DemonCastle1"},
    42 => {:bb1 => "DecorativeTile", :bb2 => "DemonCastle3"},

  # 船
    43 => {:bb1 => "ship", :bb2 => "ship"},

  # 空
    44 => {:bb1 => "Sky", :bb2 => "Sky"},

  # タルタロス
    45 => {:bb1 => "Factory1"},

  # 研究所跡
    46 => {:bb1 => "hivecity-slum"},

  # 亜空間
    47 => {:bb1 => "DarkSpace", :bb2 => "DarkSpace"},
    48 => {:bb1 => "DirtCave", :bb2 => "DarkSpace"},
    49 => {:bb1 => "Stone2", :bb2 => "DarkSpace"},
    50 => {:bb1 => "DarkSpace"},
    51 => {:bb1 => "DemonicWorld1", :bb2 => "DemonicWorld"},

    52 => {:bb1 => "イリアスヴィル裏山"},
    53 => {:bb1 => "海底神殿"},
    54 => {:bb1 => "地下図書館"},
    55 => {:bb1 => "北のお化け屋敷1"},
    56 => {:bb1 => "北のお化け屋敷3"},
    57 => {:bb1 => "ピラミッド1"},
    58 => {:bb1 => "ピラミッド2"},
    59 => {:bb1 => "城内"},
    60 => {:bb1 => "恵みのオアシス"},
    61 => {:bb1 => "劇場"},
    62 => {:bb1 => "リリィの屋敷1"},
    63 => {:bb1 => "リリィの屋敷2"},
    64 => {:bb1 => "魔導の塔"},
    65 => {:bb1 => "コロシアム"},
    66 => {:bb1 => "座敷"},
    67 => {:bb1 => "幽霊船2"},
    68 => {:bb1 => "風光明媚の丘"},
    69 => {:bb1 => "イリアス神殿跡"},
    70 => {:bb1 => "トゥーロマンサ1"},
    71 => {:bb1 => "トゥーロマンサ2"},
    72 => {:bb1 => "ヤマタイ"},
    73 => {:bb1 => "Dirt2", :bb2 => "Stone2"},
    74 => {:bb1 => "slagbg"},
    75 => {:bb1 => "bg022"},
    77 => {:bb1 => "DemonCastle", :bb2 => "Castle2"},
    79 => {:bb1 => "Meadow", :bb2 => "Clouds"},
    80 => {:bb1 => "屋敷内"},

  # 天界
    81 => {:bb1 => "Clouds", :bb2 => "Sky"},

  # 管理者の塔・天界グランドノア
    82 => {:bb1 => "Cobblestones4", :bb2 => "Tower"},

  # 天界グランゴルド
    83 => {:bb1 => "GrassMaze", :bb2 => "Tower"},

  # 天界ゴルドポート
    84 => {:bb1 => "Dirt1", :bb2 => "Town3"},

  # 天界崩壊魔王城
    85 => {:bb1 => "Stone2", :bb2 => "DemonCastle1"},

  # レミナ研究所
    86 => {:bb1 => "bg022"},
    87 => {:bb1 => "bg196"},
    88 => {:bb1 => "bg199"},

  # 占領魔王城
    89 => {:bb1 => "Stone2", :bb2 => "Temple"},

  # 天界ナタリアポート
    90 => {:bb1 => "Cobblestones1", :bb2 => "Town1"},

  # 天界サン・イリア
    91 => {:bb1 => "Cobblestones2", :bb2 => "Town1"},

  # 天界罪人の封牢
    92 => {:bb1 => "bg137"},

  # 月面
    93 => {:bb1 => "bg240"},

  # 天界聖山アモス
    94 => {:bb1 => "GrassMaze", :bb2 => "Clouds"},

  # 天界イリアス神殿
    95 => {:bb1 => "Paved", :bb2 => "DarkSpace"},
    108 => {:bb1 => "bg001"},

  # 魔界グランゴルド城
    96 => {:bb1 => "GrassMaze", :bb2 => "Castle2"},

  # 魔界グランドノア城
    97 => {:bb1 => "Stone2", :bb2 => "Castle2"},

  # 魔界ヤマタイ
    98 => {:bb1 => "yamatai"},

  # 魔界フィノア
    99 => {:bb1 => "GrassMaze", :bb2 => "Town3"},

  # 魔界サン・イリア
    100 => {:bb1 => "魔界サンイリア2"},
    101 => {:bb1 => "魔界サンイリア3"},

  # 人形遣いの塔
    102 => {:bb1 => "Cobblestones4", :bb2 => "Stone3"},

  # デミウルゴス
    103 => {:bb1 => "InBody", :bb2 => "InBody"},
    116 => {:bb1 => "InBody", :bb2 => "DarkSpace"},

  # 魔界駅
    104 => {:bb1 => "Cobblestones1", :bb2 => "DarkSpace"},

  # 魔界エンリカ
    105 => {:bb1 => "Grassland", :bb2 => "Town3"},

  # 黒の屋敷・地下
    106 => {:bb1 => "Stone2", :bb2 => "Stone2"},

  # 邪神城
    107 => {:bb1 => "PoisonSwamp", :bb2 => "DarkSpace"},
    109 => {:bb1 => "DemonicWorld2", :bb2 => "DarkSpace"},

  # 混沌イリアス神殿
    110 => {:bb1 => "Cobblestones4", :bb2 => "Temple"},

  # 混沌魔導学園
    111 => {:bb1 => "ship", :bb2 => "Room4"},

  # 月面機械要塞
    112 => {:bb1 => "engineering", :bb2 => "engineering-conduit"},

  # 銀河
    113 => {:bb1 => "bg239"},

  # ルルイエ
    114 => {:bb1 => "ルルイエ"},

  # 大罪の殿堂
    115 => {:bb1 => "Translucent", :bb2 => "DarkSpace"},

  # カオスの領域
    117 => {:bb1 => "DecorativeTile", :bb2 => "DarkSpace"},
    118 => {:bb1 => "Cobblestones4", :bb2 => "DarkSpace"},
    119 => {:bb1 => "Lava2", :bb2 => "DarkSpace"},



  }

  H_SCENE_ITEMS = {
    # ID
    1 => {
      :name => "Alice (Small)",
      :condition => {
        :type => 2,
        :id => 5
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alice_H10_1"],
          2 => ["Graphics/Pictures/", "ev_alice_H10_2"],
          3 => ["Graphics/Pictures/", "ev_alice_H10_3"],
          4 => ["Graphics/Pictures/", "ev_alice_H10_4"],
          5 => ["Graphics/Pictures/", "ev_alice_H10_5"],
          6 => ["Graphics/Pictures/", "ev_alice_H10_6"],
          7 => ["Graphics/Pictures/", "ev_alice_H10_7"],
          8 => ["Graphics/Pictures/", "ev_alice_H10_8"],
          9 => ["Graphics/Pictures/", "ev_alice_H10_9"],
          10 => ["Graphics/Pictures/", "ev_alice_H14_1"],
          11 => ["Graphics/Pictures/", "ev_alice_H14_2"],
          12 => ["Graphics/Pictures/", "ev_alice_H14_3"],
          13 => ["Graphics/Pictures/", "ev_alice_H14_4"],
          14 => ["Graphics/Pictures/", "ev_alice_H14_5"],
          15 => ["Graphics/Pictures/", "ev_alice_H14_6"],
          16 => ["Graphics/Pictures/", "ev_alice_H14_7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
        ],
          :condition => {
            :type => 1,
            :id => 3005,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Blowjob)",
          :common => 4001,
          :condition => {
            :type => 1,
            :id => 3005,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4002,
          :condition => {
            :type => 1,
            :id => 3005,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    2 => {
      :name => "Alice (Adult)",
      :condition => {
        :type => 3,
        :id => 144
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alice_h01_1"],
          2 => ["Graphics/Pictures/", "ev_alice_h01_2"],
          3 => ["Graphics/Pictures/", "ev_alice_h01_3"],
          4 => ["Graphics/Pictures/", "ev_alice_h01_4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 4
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alice_st23"],
          2 => ["Graphics/Pictures/", "ev_alice_st24"],
          3 => ["Graphics/Pictures/", "ev_alice_h03_1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
      :condition => {
        :type => 3,
        :id => 823
      },
          :background => {
            :id => 51
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alice_h04_1"],
          2 => ["Graphics/Pictures/", "ev_alice_h04_2"],
          3 => ["Graphics/Pictures/", "ev_alice_h04_3"],
          4 => ["Graphics/Pictures/", "ev_alice_h04_4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3005,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 4
          }
        },
        4 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alice_h02_1"],
          2 => ["Graphics/Pictures/", "ev_alice_h02_2"],
          3 => ["Graphics/Pictures/", "ev_alice_h02_3"],
          4 => ["Graphics/Pictures/", "ev_alice_h02_4"],
          5 => ["Graphics/Pictures/", "ev_alice_h02_5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 1,
            :id => 3005,
            :op => 1,
            :value => 20
          },
          :background => {
            :id => 4
          }
        },
        5 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alice_h06_1r"],
          2 => ["Graphics/Pictures/", "ev_alice_h06_2r"],
          3 => ["Graphics/Pictures/", "ev_alice_h06_3r"],
          4 => ["Graphics/Pictures/", "ev_alice_h06_4r"],
          5 => ["Graphics/Pictures/", "ev_alice_h06_5r"],
          6 => ["Graphics/Pictures/", "ev_alice_h06_6r"],
          7 => ["Graphics/Pictures/", "ev_alice_h06_7r"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :condition => {
            :type => 1,
            :id => 3005,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 4
          }
        },
        6 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alice_h05_1"],
          2 => ["Graphics/Pictures/", "ev_alice_h05_2"],
          3 => ["Graphics/Pictures/", "ev_alice_h05_3"],
          4 => ["Graphics/Pictures/", "ev_alice_h05_4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3005,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 4
          }
        },
        7 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alice_h07_1r"],
          2 => ["Graphics/Pictures/", "ev_alice_h07_2r"],
          3 => ["Graphics/Pictures/", "ev_alice_h07_3r"],
          4 => ["Graphics/Pictures/", "ev_alice_h07_4r"],
          5 => ["Graphics/Pictures/", "ev_alice_h07_5r"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 1,
            :id => 3005,
            :op => 1,
            :value => 80
          },
          :background => {
            :id => 4
          }
        },
        8 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alice_h11_1"],
          2 => ["Graphics/Pictures/", "ev_alice_h11_2"],
          3 => ["Graphics/Pictures/", "ev_alice_h11_3"],
          4 => ["Graphics/Pictures/", "ev_alice_h11_4"],
          5 => ["Graphics/Pictures/", "ev_alice_h11_5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 1,
            :id => 3005,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 4
          }
        },
        9 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alice_h09_1r"],
          2 => ["Graphics/Pictures/", "ev_alice_h09_2r"],
          3 => ["Graphics/Pictures/", "ev_alice_h09_3r"],
          4 => ["Graphics/Pictures/", "ev_alice_h09_4r"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3005,
            :op => 1,
            :value => 200
          },
          :background => {
            :id => 4
          }
        },
        10 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alice_h12_1"],
          2 => ["Graphics/Pictures/", "ev_alice_h12_2"],
          3 => ["Graphics/Pictures/", "ev_alice_h12_3"],
          4 => ["Graphics/Pictures/", "ev_alice_ct01"],
          5 => ["Graphics/Pictures/", "ev_alice_ct02"],
          6 => ["Graphics/Pictures/", "ev_alice_ct03"],
          7 => ["Graphics/Pictures/", "ev_alice_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [2,4],
          [2,5],
          [2,6],
          [2,7],
          [3,7],
        ],
          :condition => {
            :type => 1,
            :id => 3005,
            :op => 1,
            :value => 300
          },
          :background => {
            :id => 4
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3144,
          :background => {
            :id => 4
          }
        },
        2 => {
          :name => "Defeat 2",
          :common => 3823,
          :condition => {
            :type => 3,
            :id => 823
          },
          :background => {
            :id => 51
          }
        },
        3 => {
          :name => "Request 1 (Tail Job)",
          :common => 4003,
          :condition => {
            :type => 1,
            :id => 3005,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 2 (Handjob)",
          :common => 4004,
          :condition => {
            :type => 1,
            :id => 3005,
            :op => 1,
            :value => 20
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 3 (Hair Job)",
          :common => 4005,
          :condition => {
            :type => 1,
            :id => 3005,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        6 => {
          :name => "Request 4 (Paizuri)",
          :common => 4006,
          :condition => {
            :type => 1,
            :id => 3005,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        7 => {
          :name => "Request 5 (Fellatio)",
          :common => 4007,
          :condition => {
            :type => 1,
            :id => 3005,
            :op => 1,
            :value => 80
          },
          :background => {
            :id => 1
          }
        },
        8 => {
          :name => "Request 6 (69 Paizuri Fellatio)",
          :common => 4008,
          :condition => {
            :type => 1,
            :id => 3005,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        9 => {
          :name => "Request 7 (Reverse Rape 1)",
          :common => 4009,
          :condition => {
            :type => 1,
            :id => 3005,
            :op => 1,
            :value => 200
          },
          :background => {
            :id => 1
          }
        },
        10 => {
          :name => "Request 8 (Reverse Rape 2)",
          :common => 4010,
          :condition => {
            :type => 1,
            :id => 3005,
            :op => 1,
            :value => 300
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    3 => {
      :name => "Alice (Dark Goddess)",
      :condition => {
        :type => 2,
        :id => 7
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alice_H13_1"],
          2 => ["Graphics/Pictures/", "ev_alice_H13_2"],
          3 => ["Graphics/Pictures/", "ev_alice_H13_3"],
          4 => ["Graphics/Pictures/", "ev_alice_H13_4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4011,
          :condition => {
            :type => 1,
            :id => 3005,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    4 => {
      :name => "Ilias (Small)",
      :condition => {
        :type => 2,
        :id => 26
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_iriasu_hc1"],
          2 => ["Graphics/Pictures/", "ev_iriasu_hc2"],
          3 => ["Graphics/Pictures/", "ev_iriasu_hc3"],
          4 => ["Graphics/Pictures/", "ev_iriasu_hc4"],
          5 => ["Graphics/Pictures/", "ev_iriasu_hd1"],
          6 => ["Graphics/Pictures/", "ev_iriasu_hd2"],
          7 => ["Graphics/Pictures/", "ev_iriasu_hd3"],
          8 => ["Graphics/Pictures/", "ev_iriasu_hd4"],
          9 => ["Graphics/Pictures/", "ev_iriasu_hd5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :condition => {
            :type => 1,
            :id => 3026,
            :op => 1,
            :value => 300
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_iriasu_hc1"],
          2 => ["Graphics/Pictures/", "ev_iriasu_hc2"],
          3 => ["Graphics/Pictures/", "ev_iriasu_hc3"],
          4 => ["Graphics/Pictures/", "ev_iriasu_hc4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 3,
            :id => 608
          },
          :background => {
            :id => 89
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3608,
          :condition => {
            :type => 3,
            :id => 608
          },
          :background => {
            :id => 89
          }
        },
        2 => {
          :name => "Request 1 (Footjob)",
          :common => 4021,
          :condition => {
            :type => 1,
            :id => 3026,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4022,
          :condition => {
            :type => 1,
            :id => 3026,
            :op => 1,
            :value => 300
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    5 => {
      :name => "Ilias (Adult)",
      :condition => {
        :type => 2,
        :id => 26
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_iriasu_st02"],
          2 => ["Graphics/Pictures/", "ev_iriasu_ct01"],
          3 => ["Graphics/Pictures/", "ev_iriasu_ct02"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
        ],
          :condition => {
            :type => 1,
            :id => 3026,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_iriasu_hb1"],
          2 => ["Graphics/Pictures/", "ev_iriasu_hb2"],
          3 => ["Graphics/Pictures/", "ev_iriasu_hb3"],
          4 => ["Graphics/Pictures/", "ev_iriasu_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3026,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_iriasu_h1"],
          2 => ["Graphics/Pictures/", "ev_iriasu_h2"],
          3 => ["Graphics/Pictures/", "ev_iriasu_h3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :condition => {
            :type => 1,
            :id => 3026,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Handjob)",
          :common => 4023,
          :condition => {
            :type => 1,
            :id => 3026,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :name => "Request 2 (Paizuri)",
          :common => 4024,
          :condition => {
            :type => 1,
            :id => 3026,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 3 (Reverse Rape)",
          :common => 4025,
          :condition => {
            :type => 1,
            :id => 3026,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    6 => {
      :name => "Ilias (Adult Holy-Dark Fusion)",
      :condition => {
        :type => 2,
        :id => 29
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_iriasu2_ha1"],
          2 => ["Graphics/Pictures/", "ev_iriasu2_ct01"],
          3 => ["Graphics/Pictures/", "ev_iriasu2_ha2"],
          4 => ["Graphics/Pictures/", "ev_iriasu2_ct02"],
          5 => ["Graphics/Pictures/", "ev_iriasu2_ha3"],
          6 => ["Graphics/Pictures/", "ev_iriasu2_ct03"],
          7 => ["Graphics/Pictures/", "ev_iriasu2_ha4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,2],
          [3,4],
          [5,6],
          [6,7],
        ],
          :condition => {
            :type => 1,
            :id => 3029,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_iriasu2_hb1"],
          2 => ["Graphics/Pictures/", "ev_iriasu2_hb2"],
          3 => ["Graphics/Pictures/", "ev_iriasu2_hb3"],
          4 => ["Graphics/Pictures/", "ev_iriasu2_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3029,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Extraction Device Reverse Rape)",
          :common => 4026,
          :condition => {
            :type => 1,
            :id => 3029,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :name => "Request 1 (Body Reverse Rape)",
          :common => 4027,
          :condition => {
            :type => 1,
            :id => 3029,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    7 => {
      :name => "Ilias (AD)",
      :condition => {
        :type => 3,
        :id => 687
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_iriasu_he1"],
          2 => ["Graphics/Pictures/", "ev_iriasu_he2"],
          3 => ["Graphics/Pictures/", "ev_iriasu_he3"],
          4 => ["Graphics/Pictures/", "ev_iriasu_he4"],
          5 => ["Graphics/Pictures/", "ev_iriasu_he5"],
          6 => ["Graphics/Pictures/", "ev_iriasu_he6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 108
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3687,
          :background => {
            :id => 108
          }
        },
        2 => {
          :name => "Request 1 (Handjob)",
          :common => 4028,
          :condition => {
            :type => 1,
            :id => 3029,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    8 => {
      :name => "Chaos Ilias",
      :condition => {
        :type => 3,
        :id => 688
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_iriasu3_ha1"],
          2 => ["Graphics/Pictures/", "ev_iriasu3_ha2"],
          3 => ["Graphics/Pictures/", "ev_iriasu3_ha3"],
          4 => ["Graphics/Pictures/", "ev_iriasu3_ha4"],
          5 => ["Graphics/Pictures/", "ev_iriasu3_ha5"],
          6 => ["Graphics/Pictures/", "ev_iriasu3_ha6"],
          7 => ["Graphics/Pictures/", "ev_iriasu3_ha7"],
          8 => ["Graphics/Pictures/", "ev_iriasu3_ha8"],
          9 => ["Graphics/Pictures/", "ev_iriasu3_ha9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 95
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3688,
          :background => {
            :id => 95
          }
        },
        2 => {
          :name => "Request 1 (Unbirth)",
          :common => 4029,
          :condition => {
            :type => 1,
            :id => 3029,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    9 => {
      :name => "Sylph",
      :condition => {
        :type => 3,
        :id => 93
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_sylph_h1"],
          2 => ["Graphics/Pictures/", "ev_sylph_h2"],
          3 => ["Graphics/Pictures/", "ev_sylph_h3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :background => {
            :id => 3
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_sylph_hb1"],
          2 => ["Graphics/Pictures/", "ev_sylph_hb2"],
          3 => ["Graphics/Pictures/", "ev_sylph_hb3"],
          4 => ["Graphics/Pictures/", "ev_sylph_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3012,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3093,
          :background => {
            :id => 3
          }
        },
        2 => {
          :name => "Request 1 (Fairy Hug)",
          :common => 4031,
          :condition => {
            :type => 1,
            :id => 3012,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4032,
          :condition => {
            :type => 1,
            :id => 3012,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    10 => {
      :name => "Gnome",
      :condition => {
        :type => 3,
        :id => 133
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_gnome_h0"],
          2 => ["Graphics/Pictures/", "ev_gnome_h1"],
          3 => ["Graphics/Pictures/", "ev_gnome_h2"],
          4 => ["Graphics/Pictures/", "ev_gnome_h3"],
          5 => ["Graphics/Pictures/", "ev_gnome_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 12
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_gnome_hb1"],
          2 => ["Graphics/Pictures/", "ev_gnome_hb2"],
          3 => ["Graphics/Pictures/", "ev_gnome_hb3"],
          4 => ["Graphics/Pictures/", "ev_gnome_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3013,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3133,
          :background => {
            :id => 12
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Mud Dolls)",
          :common => 4036,
          :condition => {
            :type => 1,
            :id => 3013,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4037,
          :condition => {
            :type => 1,
            :id => 3013,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    11 => {
      :name => "Undine",
      :condition => {
        :type => 3,
        :id => 231
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_undine_ha1"],
          2 => ["Graphics/Pictures/", "ev_undine_ha2"],
          3 => ["Graphics/Pictures/", "ev_undine_ha3"],
          4 => ["Graphics/Pictures/", "ev_undine_ct01"],
          5 => ["Graphics/Pictures/", "ev_undine_ct02"],
          6 => ["Graphics/Pictures/", "ev_undine_ct03"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,4],
          [1,5],
          [2,5],
          [2,6],
          [3],
        ],
          :background => {
            :id => 20
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_undine_hb1"],
          2 => ["Graphics/Pictures/", "ev_undine_hb2"],
          3 => ["Graphics/Pictures/", "ev_undine_hb3"],
          4 => ["Graphics/Pictures/", "ev_undine_hb4"],
          5 => ["Graphics/Pictures/", "ev_undine_ct11"],
          6 => ["Graphics/Pictures/", "ev_undine_ct12"],
          7 => ["Graphics/Pictures/", "ev_undine_ct13"],
        },
        # 表示パターンの指定
        :draw => [
          [1,5],
          [2,6],
          [3,6],
          [4,7],
        ],
          :condition => {
            :type => 1,
            :id => 3014,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3231,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Absorption)",
          :common => 4736,
          :condition => {
            :type => 1,
            :id => 3014,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Slime Press)",
          :common => 4737,
          :condition => {
            :type => 1,
            :id => 3014,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    12 => {
      :name => "Salamander",
      :condition => {
        :type => 3,
        :id => 285
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_salamander_ha1"],
          2 => ["Graphics/Pictures/", "ev_salamander_ha2"],
          3 => ["Graphics/Pictures/", "ev_salamander_ha3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :background => {
            :id => 17
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_salamander_hb1"],
          2 => ["Graphics/Pictures/", "ev_salamander_hb2"],
          3 => ["Graphics/Pictures/", "ev_salamander_hb3"],
          4 => ["Graphics/Pictures/", "ev_salamander_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3015,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3285,
          :background => {
            :id => 17
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 4741,
          :condition => {
            :type => 1,
            :id => 3015,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Cowgirl)",
          :common => 4742,
          :condition => {
            :type => 1,
            :id => 3015,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    13 => {
      :name => "Granberia",
      :condition => {
        :type => 3,
        :id => 178
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_granberia_st62"],
          2 => ["Graphics/Pictures/", "ev_granberia_ct01"],
          3 => ["Graphics/Pictures/", "ev_granberia_ct02"],
          4 => ["Graphics/Pictures/", "ev_granberia_ct03"],
          5 => ["Graphics/Pictures/", "ev_granberia_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
        ],
          :background => {
            :id => 65
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_granberia_hc1"],
          2 => ["Graphics/Pictures/", "ev_granberia_hc2"],
          3 => ["Graphics/Pictures/", "ev_granberia_hc3"],
          4 => ["Graphics/Pictures/", "ev_granberia_hc4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 3,
            :id => 286,
          },
          :background => {
            :id => 17
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_granberia_hh1"],
          2 => ["Graphics/Pictures/", "ev_granberia_hh2"],
          3 => ["Graphics/Pictures/", "ev_granberia_hh3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :condition => {
            :type => 3,
            :id => 536,
          },
          :background => {
            :id => 41
          }
        },
        4 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_granberia_hg1"],
          2 => ["Graphics/Pictures/", "ev_granberia_hg2"],
          3 => ["Graphics/Pictures/", "ev_granberia_hg3"],
          4 => ["Graphics/Pictures/", "ev_granberia_hg4"],
          5 => ["Graphics/Pictures/", "ev_granberia_hg5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 1,
            :id => 3016,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 17
          }
        },
        5 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_granberia_ha1"],
          2 => ["Graphics/Pictures/", "ev_granberia_ha2"],
          3 => ["Graphics/Pictures/", "ev_granberia_ha3"],
          4 => ["Graphics/Pictures/", "ev_granberia_ha4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3016,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 17
          }
        },
        6 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_granberia_hd1"],
          2 => ["Graphics/Pictures/", "ev_granberia_hd2"],
          3 => ["Graphics/Pictures/", "ev_granberia_hd3"],
          4 => ["Graphics/Pictures/", "ev_granberia_hd4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3016,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 17
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3178,
          :background => {
            :id => 65
          }
        },
        2 => {
          :name => "Defeat 2",
          :common => 3286,
          :background => {
            :id => 17
          }
        },
        3 => {
          :name => "Defeat 3",
          :common => 3536,
          :condition => {
            :type => 3,
            :id => 536,
          },
          :background => {
            :id => 41
          }
        },
        4 => {
          :name => "Request 1 (Torture Hand Job)",
          :common => 5861,
          :condition => {
            :type => 1,
            :id => 3016,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 2 (Handjob)",
          :common => 5862,
          :condition => {
            :type => 1,
            :id => 3016,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        6 => {
          :name => "Request 3 (Footjob)",
          :common => 5863,
          :condition => {
            :type => 1,
            :id => 3016,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        7 => {
          :name => "Request 4 (Paizuri)",
          :common => 5864,
          :condition => {
            :type => 1,
            :id => 3016,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        8 => {
          :name => "Request 5 (Blowjob)",
          :common => 5865,
          :condition => {
            :type => 1,
            :id => 3016,
            :op => 1,
            :value => 200
          },
          :background => {
            :id => 1
          }
        },
        9 => {
          :name => "Request 6 (Reverse Rape)",
          :common => 5866,
          :condition => {
            :type => 1,
            :id => 3016,
            :op => 1,
            :value => 300
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    14 => {
      :name => "Alma Elma",
      :condition => {
        :type => 3,
        :id => 177
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_arumaeruma_he1"],
          2 => ["Graphics/Pictures/", "ev_arumaeruma_he2"],
          3 => ["Graphics/Pictures/", "ev_arumaeruma_he3"],
          4 => ["Graphics/Pictures/", "ev_arumaeruma_he4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 65
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_arumaeruma_hi1"],
          2 => ["Graphics/Pictures/", "ev_arumaeruma_hi2"],
          3 => ["Graphics/Pictures/", "ev_arumaeruma_hi3"],
          4 => ["Graphics/Pictures/", "ev_arumaeruma_hi4"],
          5 => ["Graphics/Pictures/", "ev_arumaeruma_hi5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 3,
            :id => 385,
          },
          :background => {
            :id => 46
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_arumaeruma_hj1"],
          2 => ["Graphics/Pictures/", "ev_arumaeruma_hj2"],
          3 => ["Graphics/Pictures/", "ev_arumaeruma_hj3"],
          4 => ["Graphics/Pictures/", "ev_arumaeruma_hj4"],
          5 => ["Graphics/Pictures/", "ev_arumaeruma_hj5"],
          6 => ["Graphics/Pictures/", "ev_arumaeruma_hj6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3019,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_arumaeruma_hc1"],
          2 => ["Graphics/Pictures/", "ev_arumaeruma_hc2"],
          3 => ["Graphics/Pictures/", "ev_arumaeruma_hc3"],
          4 => ["Graphics/Pictures/", "ev_arumaeruma_hc4"],
          5 => ["Graphics/Pictures/", "ev_arumaeruma_hk1"],
          6 => ["Graphics/Pictures/", "ev_arumaeruma_hk2"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3177,
          :background => {
            :id => 65
          }
        },
        2 => {
          :name => "Defeat 2",
          :common => 3385,
          :background => {
            :id => 46
          }
        },
        3 => {
          :name => "Request 1 (Handjob)",
          :common => 5731,
          :condition => {
            :type => 1,
            :id => 3019,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 2 (Tail Swallow)",
          :common => 5732,
          :condition => {
            :type => 1,
            :id => 3019,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 3 (Reverse Rape)",
          :common => 5733,
          :condition => {
            :type => 1,
            :id => 3019,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        6 => {
          :name => "Loop Event (Footjob)",
          :common => 5796,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        },
        7 => {
          :name => "Loop Event (Blowjob)",
          :common => 5836,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    15 => {
      :name => "Tamamo",
      :condition => {
        :type => 3,
        :id => 534
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_tamamo_h1"],
          2 => ["Graphics/Pictures/", "ev_tamamo_h2"],
          3 => ["Graphics/Pictures/", "ev_tamamo_h3"],
          4 => ["Graphics/Pictures/", "ev_tamamo_h4"],
          5 => ["Graphics/Pictures/", "ev_tamamo_h5"],
          6 => ["Graphics/Pictures/", "ev_tamamo_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 41
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_tamamo_hb1"],
          2 => ["Graphics/Pictures/", "ev_tamamo_hb2"],
          3 => ["Graphics/Pictures/", "ev_tamamo_hb3"],
          4 => ["Graphics/Pictures/", "ev_tamamo_hb4"],
          5 => ["Graphics/Pictures/", "ev_tamamo_hb5"],
          6 => ["Graphics/Pictures/", "ev_tamamo_hb6"],
          7 => ["Graphics/Pictures/", "ev_tamamo_hb7"],
          8 => ["Graphics/Pictures/", "ev_tamamo_hb8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
      :condition => {
        :type => 3,
        :id => 728
      },
          :background => {
            :id => 15
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3534,
          :background => {
            :id => 41
          }
        },
        2 => {
          :name => "Defeat 2",
          :common => 3728,
      :condition => {
        :type => 3,
        :id => 728
      },
          :background => {
            :id => 15
          }
        },
        3 => {
          :name => "Request 1 (Tailjob)",
          :common => 5871,
          :condition => {
            :type => 1,
            :id => 3021,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 2 (Blowjob)",
          :common => 5872,
          :condition => {
            :type => 1,
            :id => 3021,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 3 (Reverse Rape)",
          :common => 5873,
          :condition => {
            :type => 1,
            :id => 3021,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    16 => {
      :name => "Tamamo (Unsealed)",
      :condition => {
        :type => 2,
        :id => 21
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_tamamo_he01"],
          2 => ["Graphics/Pictures/", "ev_tamamo_he02"],
          3 => ["Graphics/Pictures/", "ev_tamamo_he03"],
          4 => ["Graphics/Pictures/", "ev_tamamo_he04"],
          5 => ["Graphics/Pictures/", "ev_tamamo_he05"],
          6 => ["Graphics/Pictures/", "ev_tamamo_he06"],
          7 => ["Graphics/Pictures/", "ev_tamamo_he07"],
          8 => ["Graphics/Pictures/", "ev_tamamo_he08"],
          9 => ["Graphics/Pictures/", "ev_tamamo_he09"],
          10 => ["Graphics/Pictures/", "ev_tamamo_he10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :condition => {
            :type => 1,
            :id => 3021,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_tamamo_hd01"],
          2 => ["Graphics/Pictures/", "ev_tamamo_hd02"],
          3 => ["Graphics/Pictures/", "ev_tamamo_hd03"],
          4 => ["Graphics/Pictures/", "ev_tamamo_hd04"],
          5 => ["Graphics/Pictures/", "ev_tamamo_hd05"],
          6 => ["Graphics/Pictures/", "ev_tamamo_hd06"],
          7 => ["Graphics/Pictures/", "ev_tamamo_hd07"],
          8 => ["Graphics/Pictures/", "ev_tamamo_hd08"],
          9 => ["Graphics/Pictures/", "ev_tamamo_hd09"],
          10 => ["Graphics/Pictures/", "ev_tamamo_h10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :condition => {
            :type => 1,
            :id => 3021,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Tailjob)",
          :common => 5876,
          :condition => {
            :type => 1,
            :id => 3021,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5877,
          :condition => {
            :type => 1,
            :id => 3021,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    17 => {
      :name => "Erubetie",
      :condition => {
        :type => 3,
        :id => 232
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_erbetie_ha1r"],
          2 => ["Graphics/Pictures/", "ev_erbetie_ha2r"],
          3 => ["Graphics/Pictures/", "ev_erbetie_ha3r"],
          4 => ["Graphics/Pictures/", "ev_erbetie_ha4r"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 20
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_erbetie_hb1r"],
          2 => ["Graphics/Pictures/", "ev_erbetie_hb2r"],
          3 => ["Graphics/Pictures/", "ev_erbetie_hb3r"],
          4 => ["Graphics/Pictures/", "ev_erbetie_hb4r"],
          5 => ["Graphics/Pictures/", "ev_erbetie_hb5r"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 3,
            :id => 505,
          },
          :background => {
            :id => 27
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_erbetie_hc1"],
          2 => ["Graphics/Pictures/", "ev_erbetie_hc2"],
          3 => ["Graphics/Pictures/", "ev_erbetie_hc3"],
          4 => ["Graphics/Pictures/", "ev_erbetie_hc4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 3,
            :id => 535,
          },
          :background => {
            :id => 41
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3232,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Defeat 2 (Clone)",
          :common => 3505,
          :condition => {
           :type => 3,
           :id => 505
          },
          :background => {
            :id => 27
          }
        },
        3 => {
          :name => "Defeat 3",
          :common => 3506,
          :condition => {
           :type => 3,
           :id => 535
          },
          :background => {
            :id => 41
          }
        },
        4 => {
          :name => "Request 1 (Dissolution Consumption)",
          :common => 5880,
          :condition => {
            :type => 1,
            :id => 3023,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Begging 2 (Dissolving Predation?)",
          :common => 5881,
          :condition => {
            :type => 1,
            :id => 3023,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        6 => {
          :name => "Begging 3 (Child Transformation)",
          :common => 5882,
          :condition => {
            :type => 1,
            :id => 3023,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        7 => {
          :name => "Begging 4 (Harem)",
          :common => 5883,
          :condition => {
            :type => 1,
            :id => 3023,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    18 => {
      :name => "Erubetie Kanade",
      :condition => {
        :type => 3,
        :id => 811
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_erbetie_he1"],
          2 => ["Graphics/Pictures/", "ev_erbetie_he2"],
          3 => ["Graphics/Pictures/", "ev_erbetie_he3"],
          4 => ["Graphics/Pictures/", "ev_erbetie_he4"],
          5 => ["Graphics/Pictures/", "ev_erbetie_he5"],
          6 => ["Graphics/Pictures/", "ev_erbetie_he6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 103
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3811,
          :background => {
            :id => 103
          }
        },
        2 => {
          :name => "Request 1 (Dissolution Consumption)",
          :common => 5884,
          :condition => {
            :type => 1,
            :id => 3023,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Begging 2 (Dissolving Predation?)",
          :common => 5885,
          :condition => {
            :type => 1,
            :id => 3023,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    19 => {
      :name => "Morrigan",
      :condition => {
        :type => 3,
        :id => 51
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_morrigan_ha1"],
          2 => ["Graphics/Pictures/", "ev_morrigan_ha2"],
          3 => ["Graphics/Pictures/", "ev_morrigan_ha3"],
          4 => ["Graphics/Pictures/", "ev_morrigan_ha4"],
          5 => ["Graphics/Pictures/", "ev_morrigan_ha5"],
          6 => ["Graphics/Pictures/", "ev_morrigan_ha6"],
          7 => ["Graphics/Pictures/", "ev_morrigan_ha7"],
          8 => ["Graphics/Pictures/", "ev_morrigan_hb1"],
          9 => ["Graphics/Pictures/", "ev_morrigan_hb2"],
          10 => ["Graphics/Pictures/", "ev_morrigan_hb3"],
          11 => ["Graphics/Pictures/", "ev_morrigan_hb4"],
          12 => ["Graphics/Pictures/", "ev_morrigan_hb5"],
          13 => ["Graphics/Pictures/", "ev_morrigan_hb6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
        ],
          :background => {
            :id => 43
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_morrigan_hc1"],
          2 => ["Graphics/Pictures/", "ev_morrigan_hc2"],
          3 => ["Graphics/Pictures/", "ev_morrigan_hc3"],
          4 => ["Graphics/Pictures/", "ev_morrigan_hc4"],
          5 => ["Graphics/Pictures/", "ev_morrigan_hc5"],
          6 => ["Graphics/Pictures/", "ev_morrigan_hc6"],
          7 => ["Graphics/Pictures/", "ev_morrigan_hd1"],
          8 => ["Graphics/Pictures/", "ev_morrigan_hd2"],
          9 => ["Graphics/Pictures/", "ev_morrigan_hd3"],
          10 => ["Graphics/Pictures/", "ev_morrigan_hd4"],
          11 => ["Graphics/Pictures/", "ev_morrigan_hd5"],
          12 => ["Graphics/Pictures/", "ev_morrigan_hd6"],
          13 => ["Graphics/Pictures/", "ev_morrigan_he1"],
          14 => ["Graphics/Pictures/", "ev_morrigan_he2"],
          15 => ["Graphics/Pictures/", "ev_morrigan_he3"],
          16 => ["Graphics/Pictures/", "ev_morrigan_he4"],
          17 => ["Graphics/Pictures/", "ev_morrigan_he5"],
          18 => ["Graphics/Pictures/", "ev_morrigan_he6"],
          19 => ["Graphics/Pictures/", "ev_morrigan_hf1"],
          20 => ["Graphics/Pictures/", "ev_morrigan_hf2"],
          21 => ["Graphics/Pictures/", "ev_morrigan_hf3"],
          22 => ["Graphics/Pictures/", "ev_morrigan_hf4"],
          23 => ["Graphics/Pictures/", "ev_morrigan_hf5"],
          24 => ["Graphics/Pictures/", "ev_morrigan_hf6"],
          25 => ["Graphics/Pictures/", "ev_morrigan_hf7"],
          26 => ["Graphics/Pictures/", "ev_morrigan_hg1"],
          27 => ["Graphics/Pictures/", "ev_morrigan_hg2"],
          28 => ["Graphics/Pictures/", "ev_morrigan_hg3"],
          29 => ["Graphics/Pictures/", "ev_morrigan_hg4"],
          30 => ["Graphics/Pictures/", "ev_morrigan_hg5"],
          31 => ["Graphics/Pictures/", "ev_morrigan_hg6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
          [26],
          [27],
          [28],
          [29],
          [30],
          [31],
        ],
          :condition => {
            :type => 1,
            :id => 3382,
            :op => 1,
            :value => 200
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lilith2_hp3"],
          2 => ["Graphics/Pictures/", "ev_lilith2_hp4"],
          3 => ["Graphics/Pictures/", "ev_lilith2_hp5"],
          4 => ["Graphics/Pictures/", "ev_lilith2_hp6"],
          5 => ["Graphics/Pictures/", "ev_lilith2_hp7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 3,
            :id => 939
          },
          :background => {
            :id => 32
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3051,
          :background => {
            :id => 43
          }
        },
        2 => {
          :name => "Defeat 2",
          :common => 3542,
          :background => {
            :id => 41
          }
        },
        3 => {
          :name => "Defeat 2 (Three Sisters)",
          :common => 3939,
          :condition => {
            :type => 3,
            :id => 939
          },
          :background => {
            :id => 32
          }
        },
        4 => {
          :name => "Request 1 (Psy Sierra 1)",
          :common => 5721,
          :condition => {
            :type => 1,
            :id => 3382,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 2 (Footjob 1)",
          :common => 5722,
          :condition => {
            :type => 1,
            :id => 3382,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        6 => {
          :name => "Request 3 (Footjob 2)",
          :common => 5723,
          :condition => {
            :type => 1,
            :id => 3382,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        7 => {
          :name => "Request 4 (Psy Sierra 2)",
          :common => 5718,
          :condition => {
            :type => 1,
            :id => 3382,
            :op => 1,
            :value => 130
          },
          :background => {
            :id => 1
          }
        },
        8 => {
          :name => "Request 5 (Cowgirl Drain)",
          :common => 5719,
          :condition => {
            :type => 1,
            :id => 3382,
            :op => 1,
            :value => 160
          },
          :background => {
            :id => 1
          }
        },
        9 => {
          :name => "Request 6 (Cowgirl Drain...?)",
          :common => 5720,
          :condition => {
            :type => 1,
            :id => 3382,
            :op => 1,
            :value => 200
          },
          :background => {
            :id => 1
          }
        },
        10 => {
          :name => "Loop Event (Reverse Rape)",
          :common => 5837,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        },
        11 => {
          :name => "Event (Luddite Village Annihilation)",
          :common => 367,
          :fadeout => 1,
          map: [613, 1, 0],
        },
        12 => {
          :name => "Event (Chaos Esta Annihilation)",
          :common => 9116,
          :fadeout => 1,
          :condition => {
            :type => 1,
            :id => 1331,
            :op => 1,
            :value => 5
          },
          map: [1966, 1, 0],
        },
        13 => {
          :name => "Event (Chaos Gold Port Annihilation)",
          :common => 9119,
          :fadeout => 1,
          :condition => {
            :type => 1,
            :id => 1325,
            :op => 1,
            :value => 12
          },
          map: [1969, 1, 0],
        },
        14 => {
          :name => "Event (Chaos Luddite Village Annihilation)",
          :common => 9123,
          :fadeout => 1,
          :condition => {
            :type => 1,
            :id => 1335,
            :op => 1,
            :value => 2
          },
          map: [1972, 1, 0],
        }
      }
    },
    20 => {
      :name => "Astaroth",
      :condition => {
        :type => 3,
        :id => 110
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_astaroth_ha1"],
          2 => ["Graphics/Pictures/", "ev_astaroth_ha2"],
          3 => ["Graphics/Pictures/", "ev_astaroth_ha3"],
          4 => ["Graphics/Pictures/", "ev_astaroth_ha4"],
          5 => ["Graphics/Pictures/", "ev_astaroth_ha5"],
          6 => ["Graphics/Pictures/", "ev_astaroth_hd1"],
          7 => ["Graphics/Pictures/", "ev_astaroth_he1"],
          8 => ["Graphics/Pictures/", "ev_astaroth_he2"],
          9 => ["Graphics/Pictures/", "ev_astaroth_he3"],
          10 => ["Graphics/Pictures/", "ev_astaroth_he4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 32
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_astaroth_hf1"],
          2 => ["Graphics/Pictures/", "ev_astaroth_hf2"],
          3 => ["Graphics/Pictures/", "ev_astaroth_hf3"],
          4 => ["Graphics/Pictures/", "ev_astaroth_hf4"],
          5 => ["Graphics/Pictures/", "ev_astaroth_hf5"],
          6 => ["Graphics/Pictures/", "ev_astaroth_hf6"],
          7 => ["Graphics/Pictures/", "ev_astaroth_hf7"],
          8 => ["Graphics/Pictures/", "ev_astaroth_hg1"],
          9 => ["Graphics/Pictures/", "ev_astaroth_hg2"],
          10 => ["Graphics/Pictures/", "ev_astaroth_hg3"],
          11 => ["Graphics/Pictures/", "ev_astaroth_hg4"],
          12 => ["Graphics/Pictures/", "ev_astaroth_hg5"],
          13 => ["Graphics/Pictures/", "ev_astaroth_hg6"],
          14 => ["Graphics/Pictures/", "ev_astaroth_hg7"],
          },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lilith2_hp3"],
          2 => ["Graphics/Pictures/", "ev_lilith2_hp4"],
          3 => ["Graphics/Pictures/", "ev_lilith2_hp5"],
          4 => ["Graphics/Pictures/", "ev_lilith2_hp6"],
          5 => ["Graphics/Pictures/", "ev_lilith2_hp7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 3,
            :id => 939
          },
          :background => {
            :id => 32
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3110,
          :background => {
            :id => 32
          }
        },
        2 => {
          :name => "Defeat 2",
          :common => 3543,
          :background => {
            :id => 41
          }
        },
        3 => {
          :name => "Defeat 3 (Three Sisters)",
          :common => 3939,
          :condition => {
            :type => 3,
            :id => 939
          },
          :background => {
            :id => 32
          }
        },
        4 => {
          :name => "Begging 1 (Tail Energy Drain)",
          :common => 5906,
          :condition => {
            :type => 1,
            :id => 394,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Begging 2 (Fellatio 1)",
          :common => 5907,
          :condition => {
            :type => 1,
            :id => 394,
            :op => 1,
            :value => 20
          },
          :background => {
            :id => 1
          }
        },
        6 => {
          :name => "Begging 3 (Fellatio 2)",
          :common => 5908,
          :condition => {
            :type => 1,
            :id => 394,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        7 => {
          :name => "Begging 4 (Breast Smothering)",
          :common => 5909,
          :condition => {
            :type => 1,
            :id => 394,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        8 => {
          :name => "Begging 5 (Breast Smothering?)",
          :common => 5910,
          :condition => {
            :type => 1,
            :id => 394,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        9 => {
          :name => "Begging 6 (Cowgirl Smothering)",
          :common => 5911,
          :condition => {
            :type => 1,
            :id => 394,
            :op => 1,
            :value => 150
          },
          :background => {
            :id => 1
          }
        },
        10 => {
          :name => "Begging 7 (Cowgirl Smothering?)",
          :common => 5912,
          :condition => {
            :type => 1,
            :id => 394,
            :op => 1,
            :value => 200
          },
          :background => {
            :id => 1
          }
        },
        11 => {
          :name => "Loop Event (Reverse Rape)",
          :common => 5838,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        },
        12 => {
          :name => "Event (Luddite Village Annihilation)",
          :common => 367,
          :fadeout => 1,
          map: [613, 1, 0],
        },
        13 => {
          :name => "Event (Chaos Esta Annihilation)",
          :common => 9116,
          :fadeout => 1,
          :condition => {
            :type => 1,
            :id => 1331,
            :op => 1,
            :value => 5
          },
          map: [1966, 1, 0],
        },
        14 => {
          :name => "Event (Chaos Gold Port Annihilation)",
          :common => 9119,
          :fadeout => 1,
          :condition => {
            :type => 1,
            :id => 1325,
            :op => 1,
            :value => 12
          },
          map: [1969, 1, 0],
        },
        15 => {
          :name => "Event (Chaos Luddite Village Annihilation)",
          :common => 9123,
          :fadeout => 1,
          :condition => {
            :type => 1,
            :id => 1335,
            :op => 1,
            :value => 2
          },
          map: [1972, 1, 0],
        }
      }
    },
    21 => {
      :name => "Lilith",
      :condition => {
        :type => 3,
        :id => 255
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lilith2_ha1"],
          2 => ["Graphics/Pictures/", "ev_lilith2_ha2"],
          3 => ["Graphics/Pictures/", "ev_lilith2_he1"],
          4 => ["Graphics/Pictures/", "ev_lilith2_he2"],
          5 => ["Graphics/Pictures/", "ev_lilith2_he3"],
          6 => ["Graphics/Pictures/", "ev_lilith2_he4"],
          7 => ["Graphics/Pictures/", "ev_lilith2_hf1"],
          8 => ["Graphics/Pictures/", "ev_lilith2_hf2"],
          9 => ["Graphics/Pictures/", "ev_lilith2_hf3"],
          10 => ["Graphics/Pictures/", "ev_lilith2_hg1"],
          11 => ["Graphics/Pictures/", "ev_lilith2_hg2"],
          12 => ["Graphics/Pictures/", "ev_lilith2_hg3"],
          13 => ["Graphics/Pictures/", "ev_lilith2_hg4"],
          14 => ["Graphics/Pictures/", "ev_lilith2_hg5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
        ],
          :background => {
            :id => 31
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lilith2_hp3"],
          2 => ["Graphics/Pictures/", "ev_lilith2_hp4"],
          3 => ["Graphics/Pictures/", "ev_lilith2_hp5"],
          4 => ["Graphics/Pictures/", "ev_lilith2_hp6"],
          5 => ["Graphics/Pictures/", "ev_lilith2_hp7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 3,
            :id => 939
          },
          :background => {
            :id => 32
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3255,
          :background => {
            :id => 31
          }
        },
        2 => {
          :name => "Defeat 2 (Three Sisters Simultaneous Energy Drain)",
          :common => 3939,
          :condition => {
            :type => 3,
            :id => 939
          },
          :background => {
            :id => 32
          }
        },
        3 => {
          :name => "Begging 1 (Embrace Energy Drain)",
          :common => 5916,
          :condition => {
            :type => 1,
            :id => 395,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Begging 2 (Embrace Energy Drain - Special Service)",
          :common => 5917,
          :condition => {
            :type => 1,
            :id => 395,
            :op => 1,
            :value => 20
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Begging 3 (Breast Smothering 1)",
          :common => 5918,
          :condition => {
            :type => 1,
            :id => 395,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        6 => {
          :name => "Begging 4 (Breast Smothering 1?)",
          :common => 5919,
          :condition => {
            :type => 1,
            :id => 395,
            :op => 1,
            :value => 40
          },
          :background => {
            :id => 1
          }
        },
        7 => {
          :name => "Begging 5 (Breast Smothering 2)",
          :common => 5920,
          :condition => {
            :type => 1,
            :id => 395,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        8 => {
          :name => "Begging 6 (Breast Smothering 2?)",
          :common => 5921,
          :condition => {
            :type => 1,
            :id => 395,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        9 => {
          :name => "Begging 7 (Cowgirl Smothering)",
          :common => 5922,
          :condition => {
            :type => 1,
            :id => 395,
            :op => 1,
            :value => 150
          },
          :background => {
            :id => 1
          }
        },
        10 => {
          :name => "Begging 8 (Riding Position Death?)",
          :common => 5923,
          :condition => {
            :type => 1,
            :id => 395,
            :op => 1,
            :value => 200
          },
          :background => {
            :id => 1
          }
        },
        11 => {
          :name => "Begging 9 (Simultaneous Siphoning by Three Sisters)",
          :common => 5929,
          :condition => {
            :type => 1,
            :id => 395,
            :op => 1,
            :value => 300
          },
          :background => {
            :id => 1
          }
        },
        12 => {
          :name => "Event (Luddite Village Destruction)",
          :common => 367,
          :fadeout => 1,
          map: [613, 1, 0],
        },
        13 => {
          :name => "Event (Chaos Esta Annihilation)",
          :common => 9116,
          :fadeout => 1,
          :condition => {
            :type => 1,
            :id => 1331,
            :op => 1,
            :value => 5
          },
          map: [1966, 1, 0],
        },
        14 => {
          :name => "Event (Chaos Gold Port Annihilation)",
          :common => 9119,
          :fadeout => 1,
          :condition => {
            :type => 1,
            :id => 1325,
            :op => 1,
            :value => 12
          },
          map: [1969, 1, 0],
        },
        15 => {
          :name => "Event (Chaos Luddite Village Annihilation)",
          :common => 9123,
          :fadeout => 1,
          :condition => {
            :type => 1,
            :id => 1335,
            :op => 1,
            :value => 2
          },
          map: [1972, 1, 0],
        }
      }
    },
    22 => {
      :name => "Lilith Origin",
      :condition => {
        :type => 3,
        :id => 809
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lilith2_hm1"],
          2 => ["Graphics/Pictures/", "ev_lilith2_hm2"],
          3 => ["Graphics/Pictures/", "ev_lilith2_hm3"],
          4 => ["Graphics/Pictures/", "ev_lilith2_hm4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 103
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lilith2_hn1"],
          2 => ["Graphics/Pictures/", "ev_lilith2_hn2"],
          3 => ["Graphics/Pictures/", "ev_lilith2_hn3"],
          4 => ["Graphics/Pictures/", "ev_lilith2_hn4"],
          5 => ["Graphics/Pictures/", "ev_lilith2_hn5"],
          6 => ["Graphics/Pictures/", "ev_lilith2_hn6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3395,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3809,
          :background => {
            :id => 103
          }
        },
        2 => {
          :name => "Begging 1 (Cruel Riding Position Death)",
          :common => 5926,
          :condition => {
            :type => 1,
            :id => 3395,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Begging 2 (Sweet Riding Position Death)",
          :common => 5927,
          :condition => {
            :type => 1,
            :id => 3395,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Begging 3 (Sweet Riding Position Death?)",
          :common => 5928,
          :condition => {
            :type => 1,
            :id => 3395,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    23 => {
      :name => "Minagi",
      :condition => {
        :type => 3,
        :id => 751
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_minagi_ha1"],
          2 => ["Graphics/Pictures/", "ev_minagi_ha2"],
          3 => ["Graphics/Pictures/", "ev_minagi_ha3"],
          4 => ["Graphics/Pictures/", "ev_minagi_ha4"],
          5 => ["Graphics/Pictures/", "ev_minagi_ha5"],
          6 => ["Graphics/Pictures/", "ev_minagi_ha6"],
          7 => ["Graphics/Pictures/", "ev_minagi_ha7"],
          8 => ["Graphics/Pictures/", "ev_minagi_ha8"],
          9 => ["Graphics/Pictures/", "ev_minagi_ha9"],
          10 => ["Graphics/Pictures/", "ev_minagi_ha10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :condition => {
            :type => 1,
            :id => 3678,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_minagi_hd1"],
          2 => ["Graphics/Pictures/", "ev_minagi_hd2"],
          3 => ["Graphics/Pictures/", "ev_minagi_hd3"],
          4 => ["Graphics/Pictures/", "ev_minagi_hd4"],
          5 => ["Graphics/Pictures/", "ev_minagi_he1"],
          6 => ["Graphics/Pictures/", "ev_minagi_he2"],
          7 => ["Graphics/Pictures/", "ev_minagi_he3"],
          8 => ["Graphics/Pictures/", "ev_minagi_he4"],
          9 => ["Graphics/Pictures/", "ev_minagi_he5"],
          10 => ["Graphics/Pictures/", "ev_minagi_he6"],
          11 => ["Graphics/Pictures/", "ev_minagi_he7"],
          12 => ["Graphics/Pictures/", "ev_minagi_he8"],
          13 => ["Graphics/Pictures/", "ev_minagi_he9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
        ],
          :background => {
            :id => 100
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3751,
          :background => {
            :id => 100
          }
        },
        2 => {
          :name => "Request 1 (Handjob)",
          :common => 6871,
          :condition => {
            :type => 1,
            :id => 3678,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Begging 2 (Riding Position Death)",
          :common => 6872,
          :condition => {
            :type => 1,
            :id => 3678,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Begging 3 (Riding Position Death?)",
          :common => 6873,
          :condition => {
            :type => 1,
            :id => 3678,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "BF",
          :common => 7561,
          :condition => {
            :type => 1,
            :id => 858,
            :op => 1,
            :value => 2
          },
          :background => {
            :id => 36
          }
        }
      }
    },
    24 => {
      :name => "Kanade",
      :condition => {
        :type => 3,
        :id => 712
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kanade_hc1"],
          2 => ["Graphics/Pictures/", "ev_kanade_hc2"],
          3 => ["Graphics/Pictures/", "ev_kanade_hc3"],
          4 => ["Graphics/Pictures/", "ev_kanade_hc4"],
          5 => ["Graphics/Pictures/", "ev_kanade_hc5"],
          6 => ["Graphics/Pictures/", "ev_kanade_hc6"],
          7 => ["Graphics/Pictures/", "ev_kanade_hc7"],
          8 => ["Graphics/Pictures/", "ev_kanade_hc8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :condition => {
            :type => 1,
            :id => 3679,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kanade_ha01"],
          2 => ["Graphics/Pictures/", "ev_kanade_ha02"],
          3 => ["Graphics/Pictures/", "ev_kanade_ha03"],
          4 => ["Graphics/Pictures/", "ev_kanade_ha04"],
          5 => ["Graphics/Pictures/", "ev_kanade_ha05"],
          6 => ["Graphics/Pictures/", "ev_kanade_ha06"],
          7 => ["Graphics/Pictures/", "ev_kanade_ha07"],
          8 => ["Graphics/Pictures/", "ev_kanade_ha08"],
          9 => ["Graphics/Pictures/", "ev_kanade_ha09"],
          10 => ["Graphics/Pictures/", "ev_kanade_ha10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 97
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kanade_hz01"],
          2 => ["Graphics/Pictures/", "ev_kanade_hz02"],
          3 => ["Graphics/Pictures/", "ev_kanade_hz03"],
          4 => ["Graphics/Pictures/", "ev_kanade_hz04"],
          5 => ["Graphics/Pictures/", "ev_kanade_hz05"],
          6 => ["Graphics/Pictures/", "ev_kanade_hz06"],
          7 => ["Graphics/Pictures/", "ev_kanade_hz07"],
          8 => ["Graphics/Pictures/", "ev_kanade_hz08"],
          9 => ["Graphics/Pictures/", "ev_kanade_hz09"],
          10 => ["Graphics/Pictures/", "ev_kanade_hz10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :condition => {
          :type => 3,
          :id => 994
      },
          :background => {
            :id => 103
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3712,
          :background => {
            :id => 97
          }
        },
        2 => {
          :name => "Defeat (Kanade, Hiruko, Kanon)",
          :common => 3994,
          :condition => {
          :type => 3,
          :id => 994
      },
          :background => {
            :id => 103
          }
        },
        3 => {
          :name => "Request 1 (Handjob)",
          :common => 6876,
          :condition => {
            :type => 1,
            :id => 3679,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 6877,
          :condition => {
            :type => 1,
            :id => 3679,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    25 => {
      :name => "Hiruko",
      :condition => {
        :type => 3,
        :id => 784
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_hiruko_hc01"],
          2 => ["Graphics/Pictures/", "ev_hiruko_hc02"],
          3 => ["Graphics/Pictures/", "ev_hiruko_hc03"],
          4 => ["Graphics/Pictures/", "ev_hiruko_hc04"],
          5 => ["Graphics/Pictures/", "ev_hiruko_hc05"],
          6 => ["Graphics/Pictures/", "ev_hiruko_hc06"],
          7 => ["Graphics/Pictures/", "ev_hiruko_hc07"],
          8 => ["Graphics/Pictures/", "ev_hiruko_hc08"],
          9 => ["Graphics/Pictures/", "ev_hiruko_hc09"],
          10 => ["Graphics/Pictures/", "ev_hiruko_hc10"],
          11 => ["Graphics/Pictures/", "ev_hiruko_hc11"],
          12 => ["Graphics/Pictures/", "ev_hiruko_hc12"],
          13 => ["Graphics/Pictures/", "ev_hiruko_hc13"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
        ],
          :background => {
            :id => 103
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_hiruko_ha01"],
          2 => ["Graphics/Pictures/", "ev_hiruko_ha02"],
          3 => ["Graphics/Pictures/", "ev_hiruko_ha03"],
          4 => ["Graphics/Pictures/", "ev_hiruko_ha04"],
          5 => ["Graphics/Pictures/", "ev_hiruko_ha05"],
          6 => ["Graphics/Pictures/", "ev_hiruko_ha06"],
          7 => ["Graphics/Pictures/", "ev_hiruko_ha07"],
          8 => ["Graphics/Pictures/", "ev_hiruko_ha08"],
          9 => ["Graphics/Pictures/", "ev_hiruko_ha09"],
          10 => ["Graphics/Pictures/", "ev_hiruko_ha10"],
          11 => ["Graphics/Pictures/", "ev_hiruko_ha11"],
          12 => ["Graphics/Pictures/", "ev_hiruko_ha12"],
          13 => ["Graphics/Pictures/", "ev_hiruko_ha13"],
          14 => ["Graphics/Pictures/", "ev_hiruko_ha14"],
          15 => ["Graphics/Pictures/", "ev_hiruko_ha15"],
          16 => ["Graphics/Pictures/", "ev_hiruko_ha16"],
          17 => ["Graphics/Pictures/", "ev_hiruko_ha17"],
          18 => ["Graphics/Pictures/", "ev_hiruko_ha18"],
          19 => ["Graphics/Pictures/", "ev_hiruko_ha19"],
          20 => ["Graphics/Pictures/", "ev_hiruko_ha20"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
        ],
          :background => {
            :id => 103
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kanade_hz01"],
          2 => ["Graphics/Pictures/", "ev_kanade_hz02"],
          3 => ["Graphics/Pictures/", "ev_kanade_hz03"],
          4 => ["Graphics/Pictures/", "ev_kanade_hz04"],
          5 => ["Graphics/Pictures/", "ev_kanade_hz05"],
          6 => ["Graphics/Pictures/", "ev_kanade_hz06"],
          7 => ["Graphics/Pictures/", "ev_kanade_hz07"],
          8 => ["Graphics/Pictures/", "ev_kanade_hz08"],
          9 => ["Graphics/Pictures/", "ev_kanade_hz09"],
          10 => ["Graphics/Pictures/", "ev_kanade_hz10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :condition => {
          :type => 3,
          :id => 994
      },
          :background => {
            :id => 103
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3784,
          :background => {
            :id => 103
          }
        },
        2 => {
          :name => "Defeat (Split Body)",
          :common => 3779,
          :background => {
            :id => 103
          }
        },
        3 => {
          :name => "Defeat (Kanade, Hiruko, Kanon)",
          :common => 3994,
          :condition => {
          :type => 3,
          :id => 994
      },
          :background => {
            :id => 103
          }
        },
        4 => {
          :name => "Pleasure Request 1 (Handjob Consumption)",
          :common => 6881,
          :condition => {
            :type => 1,
            :id => 3680,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Pleasure Request 2 (Cowgirl Consumption)",
          :common => 6882,
          :condition => {
            :type => 1,
            :id => 3680,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    26 => {
      :name => "Kanon",
      :condition => {
        :type => 3,
        :id => 705
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kanon_hb1"],
          2 => ["Graphics/Pictures/", "ev_kanon_hb2"],
          3 => ["Graphics/Pictures/", "ev_kanon_hb3"],
          4 => ["Graphics/Pictures/", "ev_kanon_hb4"],
          5 => ["Graphics/Pictures/", "ev_kanon_hb5"],
          6 => ["Graphics/Pictures/", "ev_kanon_hb6"],
          7 => ["Graphics/Pictures/", "ev_kanon_hb7"],
          8 => ["Graphics/Pictures/", "ev_kanon_hb8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :condition => {
            :type => 1,
            :id => 3681,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kanon_hc1"],
          2 => ["Graphics/Pictures/", "ev_kanon_hc2"],
          3 => ["Graphics/Pictures/", "ev_kanon_hc3"],
          4 => ["Graphics/Pictures/", "ev_kanon_hc4"],
          5 => ["Graphics/Pictures/", "ev_kanon_hc5"],
          6 => ["Graphics/Pictures/", "ev_kanon_hc6"],
          7 => ["Graphics/Pictures/", "ev_kanon_hc7"],
          8 => ["Graphics/Pictures/", "ev_kanon_hc8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 96
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kanade_hz01"],
          2 => ["Graphics/Pictures/", "ev_kanade_hz02"],
          3 => ["Graphics/Pictures/", "ev_kanade_hz03"],
          4 => ["Graphics/Pictures/", "ev_kanade_hz04"],
          5 => ["Graphics/Pictures/", "ev_kanade_hz05"],
          6 => ["Graphics/Pictures/", "ev_kanade_hz06"],
          7 => ["Graphics/Pictures/", "ev_kanade_hz07"],
          8 => ["Graphics/Pictures/", "ev_kanade_hz08"],
          9 => ["Graphics/Pictures/", "ev_kanade_hz09"],
          10 => ["Graphics/Pictures/", "ev_kanade_hz10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :condition => {
          :type => 3,
          :id => 994
      },
          :background => {
            :id => 103
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3705,
          :background => {
            :id => 96
          }
        },
        2 => {
          :name => "Defeat (Kanade, Hiruko, Kanon)",
          :common => 3994,
          :condition => {
          :type => 3,
          :id => 994
      },
          :background => {
            :id => 103
          }
        },
        3 => {
          :name => "Pleasure Request 1 (Embrace Assimilation)",
          :common => 6886,
          :condition => {
            :type => 1,
            :id => 3681,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Pleasure Request 2 (Reverse Rape Assimilation)",
          :common => 6887,
          :condition => {
            :type => 1,
            :id => 3681,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Pleasure Request 3 (Reverse Rape Assimilation?)",
          :common => 6888,
          :condition => {
            :type => 1,
            :id => 3681,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    27 => {
      :name => "Tamamo (MR)",
      :condition => {
        :type => 3,
        :id => 731
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_tamamo2_hd1"],
          2 => ["Graphics/Pictures/", "ev_tamamo2_hd2"],
          3 => ["Graphics/Pictures/", "ev_tamamo2_hd3"],
          4 => ["Graphics/Pictures/", "ev_tamamo2_hd4"],
          5 => ["Graphics/Pictures/", "ev_tamamo2_hd5"],
          6 => ["Graphics/Pictures/", "ev_tamamo2_hd6"],
          7 => ["Graphics/Pictures/", "ev_tamamo2_hd7"],
          8 => ["Graphics/Pictures/", "ev_tamamo2_hd8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 98
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3731,
          :background => {
            :id => 98
          }
        },
        2 => {
          :name => "Pleasure Request 1 (Cowgirl Death by Squeeze)",
          :common => 6891,
          :condition => {
            :type => 1,
            :id => 3682,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Pleasure Request 2 (Cowgirl Death by Squeeze?)",
          :common => 6892,
          :condition => {
            :type => 1,
            :id => 3682,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
      }
    },
    28 => {
      :name => "Saja",
      :condition => {
        :type => 3,
        :id => 824
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_sazya_hd1"],
          2 => ["Graphics/Pictures/", "ev_sazya_ct21"],
          3 => ["Graphics/Pictures/", "ev_sazya_hd2"],
          4 => ["Graphics/Pictures/", "ev_sazya_ct22"],
          5 => ["Graphics/Pictures/", "ev_sazya_hd3"],
          6 => ["Graphics/Pictures/", "ev_sazya_ct23"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,2],
          [3,4],
          [5,6],
        ],
          :background => {
            :id => 107
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3824,
          :background => {
            :id => 107
          }
        },
        2 => {
          :name => "Pleasure Request 1 (Reverse Rape Death by Squeeze)",
          :common => 6896,
          :condition => {
            :type => 1,
            :id => 3683,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Pleasure Request 2 (Reverse Rape Death by Squeeze?)",
          :common => 6897,
          :condition => {
            :type => 1,
            :id => 3683,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    29 => {
      :name => "Alipheese (Small)",
      :condition => {
        :type => 2,
        :id => 684
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alice0_he1"],
          2 => ["Graphics/Pictures/", "ev_alice0_he2"],
          3 => ["Graphics/Pictures/", "ev_alice0_he3"],
          4 => ["Graphics/Pictures/", "ev_alice0_he4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3684,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Pleasure Request 1 (Restrained Reverse Rape)",
          :common => 6906,
          :condition => {
            :type => 1,
            :id => 3684,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    30 => {
      :name => "Alipheese",
      :condition => {
        :type => 3,
        :id => 825
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alice0_ha1"],
          2 => ["Graphics/Pictures/", "ev_alice0_ha2"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
        ],
          :background => {
            :id => 109
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3825,
          :background => {
            :id => 109
          }
        },
        2 => {
          :name => "Begging 1 (Ravaging Death by Squeeze)",
          :common => 6907,
          :condition => {
            :type => 1,
            :id => 3684,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Begging 2 (Ravaging Death by Squeeze?)",
          :common => 6908,
          :condition => {
            :type => 1,
            :id => 3684,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    31 => {
      :name => "Chaospheese",
      :condition => {
        :type => 3,
        :id => 826
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alice0_hd01"],
          2 => ["Graphics/Pictures/", "ev_alice0_hd02"],
          3 => ["Graphics/Pictures/", "ev_alice0_hd03"],
          4 => ["Graphics/Pictures/", "ev_alice0_hd04"],
          5 => ["Graphics/Pictures/", "ev_alice0_hd05"],
          6 => ["Graphics/Pictures/", "ev_alice0_hd06"],
          7 => ["Graphics/Pictures/", "ev_alice0_hd07"],
          8 => ["Graphics/Pictures/", "ev_alice0_hd08"],
          9 => ["Graphics/Pictures/", "ev_alice0_hd09"],
          10 => ["Graphics/Pictures/", "ev_alice0_hd10"],
          11 => ["Graphics/Pictures/", "ev_alice0_hd11"],
          12 => ["Graphics/Pictures/", "ev_alice0_hd12"],
          13 => ["Graphics/Pictures/", "ev_alice0_hd13"],
          14 => ["Graphics/Pictures/", "ev_alice0_hd14"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
        ],
          :background => {
            :id => 109
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3826,
          :background => {
            :id => 109
          }
        },
        2 => {
          :name => "Begging 1 (Eternal Ravaging)",
          :common => 6911,
          :condition => {
            :type => 1,
            :id => 3684,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Begging 2 (Eternal Ravaging?)",
          :common => 6912,
          :condition => {
            :type => 1,
            :id => 3684,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    32 => {
      :name => "Eden",
      :condition => {
        :type => 3,
        :id => 365
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_eden_hc1"],
          2 => ["Graphics/Pictures/", "ev_eden_hc2"],
          3 => ["Graphics/Pictures/", "ev_eden_hc3"],
          4 => ["Graphics/Pictures/", "ev_eden_hc4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 24
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_eden_he1"],
          2 => ["Graphics/Pictures/", "ev_eden_hf1"],
          3 => ["Graphics/Pictures/", "ev_eden_hg1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3365,
          :background => {
            :id => 24
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5726,
          :condition => {
            :type => 1,
            :id => 3383,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Loop Event (Cowgirl+Impregnation)",
          :common => 5845,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        },
        3 => {
          :name => "Loop Event (Paizuri with Sonya)",
          :common => 5846,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    33 => {
      :name => "Eden (Final Form)",
      :condition => {
        :type => 3,
        :id => 667
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_eden_ha1"],
          2 => ["Graphics/Pictures/", "ev_eden_ha2"],
          3 => ["Graphics/Pictures/", "ev_eden_ha3"],
          4 => ["Graphics/Pictures/", "ev_eden_ha4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3383,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_eden_hb1"],
          2 => ["Graphics/Pictures/", "ev_eden_hb2"],
          3 => ["Graphics/Pictures/", "ev_eden_hb3"],
          4 => ["Graphics/Pictures/", "ev_eden_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 94
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3667,
          :background => {
            :id => 94
          }
        },
        2 => {
          :name => "Begging 1 (Hell Energy Drain)",
          :common => 5727,
          :condition => {
            :type => 1,
            :id => 3383,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Begging 2 (Heaven Energy Drain)",
          :common => 5728,
          :condition => {
            :type => 1,
            :id => 3383,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    34 => {
      :name => "Eden (AD)",
      :condition => {
        :type => 3,
        :id => 540
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_eden_hd1"],
          2 => ["Graphics/Pictures/", "ev_eden_hd2"],
          3 => ["Graphics/Pictures/", "ev_eden_hd3"],
          4 => ["Graphics/Pictures/", "ev_eden_hd4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 41
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3540,
          :background => {
            :id => 41
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5901,
          :condition => {
            :type => 1,
            :id => 3385,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    35 => {
      :name => "Eden (AD: Enhanced)",
      :condition => {
        :type => 2,
        :id => 385
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_eden_hh1"],
          2 => ["Graphics/Pictures/", "ev_eden_hh2"],
          3 => ["Graphics/Pictures/", "ev_eden_hh3"],
          4 => ["Graphics/Pictures/", "ev_eden_hh4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3385,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5902,
          :condition => {
            :type => 1,
            :id => 3385,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    36 => {
      :name => "Eden (MR)",
      :condition => {
        :type => 2,
        :id => 387
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_eden_hj1"],
          2 => ["Graphics/Pictures/", "ev_eden_hj2"],
          3 => ["Graphics/Pictures/", "ev_eden_hj3"],
          4 => ["Graphics/Pictures/", "ev_eden_hj4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3387,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 41
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5903,
          :condition => {
            :type => 1,
            :id => 3387,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    37 => {
      :name => "Eden Trinity",
      :condition => {
        :type => 2,
        :id => 388
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_eden_hi1"],
          2 => ["Graphics/Pictures/", "ev_eden_hi2"],
          3 => ["Graphics/Pictures/", "ev_eden_hi3"],
          4 => ["Graphics/Pictures/", "ev_eden_hi4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3388,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5729,
          :condition => {
            :type => 1,
            :id => 3388,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    38 => {
      :name => "Zion",
      :condition => {
        :type => 3,
        :id => 224
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_shion_ha01"],
          2 => ["Graphics/Pictures/", "ev_shion_ha02"],
          3 => ["Graphics/Pictures/", "ev_shion_ha03"],
          4 => ["Graphics/Pictures/", "ev_shion_ha04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 44
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3224,
          :background => {
            :id => 44
          }
        },
        2 => {
          :name => "Begging 1 (Vibrating Arm)",
          :common => 5931,
          :condition => {
            :type => 1,
            :id => 3397,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Begging 2 (Riding Position Death)",
          :common => 5932,
          :condition => {
            :type => 1,
            :id => 3397,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Begging 3 (Riding Position Death?)",
          :common => 5933,
          :condition => {
            :type => 1,
            :id => 3397,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    39 => {
      :name => "Gnosis",
      :condition => {
        :type => 3,
        :id => 223
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_gnosis_ha01"],
          2 => ["Graphics/Pictures/", "ev_gnosis_ha02"],
          3 => ["Graphics/Pictures/", "ev_gnosis_ha03"],
          4 => ["Graphics/Pictures/", "ev_gnosis_ha04"],
          5 => ["Graphics/Pictures/", "ev_gnosis_ha05"],
          6 => ["Graphics/Pictures/", "ev_gnosis_ha06"],
          7 => ["Graphics/Pictures/", "ev_gnosis_ha07"],
          8 => ["Graphics/Pictures/", "ev_gnosis_ha08"],
          9 => ["Graphics/Pictures/", "ev_gnosis_ha09"],
          10 => ["Graphics/Pictures/", "ev_gnosis_ha10"],
          11 => ["Graphics/Pictures/", "ev_gnosis_ha11"],
          12 => ["Graphics/Pictures/", "ev_gnosis_ha12"],
          13 => ["Graphics/Pictures/", "ev_gnosis_ha13"],
          14 => ["Graphics/Pictures/", "ev_gnosis_ha14"],
          15 => ["Graphics/Pictures/", "ev_gnosis_ha15"],
          16 => ["Graphics/Pictures/", "ev_gnosis_ha16"],
          17 => ["Graphics/Pictures/", "ev_gnosis_ha17"],
          18 => ["Graphics/Pictures/", "ev_gnosis_ha18"],
          19 => ["Graphics/Pictures/", "ev_gnosis_ha19"],
          20 => ["Graphics/Pictures/", "ev_gnosis_ha20"],
          21 => ["Graphics/Pictures/", "ev_gnosis_ha21"],
          22 => ["Graphics/Pictures/", "ev_gnosis_ha22"],
          23 => ["Graphics/Pictures/", "ev_gnosis_ha23"],
          24 => ["Graphics/Pictures/", "ev_gnosis_ha24"],
          25 => ["Graphics/Pictures/", "ev_gnosis_ha25"],
          26 => ["Graphics/Pictures/", "ev_gnosis_ha26"],
          27 => ["Graphics/Pictures/", "ev_gnosis_ha27"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
          [26],
          [27],
        ],
          :background => {
            :id => 44
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3223,
          :background => {
            :id => 44
          }
        },
        2 => {
          :name => "Begging 1 (Fellatio Death by Squeeze)",
          :common => 5936,
          :condition => {
            :type => 1,
            :id => 3401,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Begging 2 (Fellatio Death by Squeeze?)",
          :common => 5937,
          :condition => {
            :type => 1,
            :id => 3401,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    40 => {
      :name => "Micaela",
      :condition => {
        :type => 3,
        :id => 686
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_micaela_hb1"],
          2 => ["Graphics/Pictures/", "ev_micaela_hb2"],
          3 => ["Graphics/Pictures/", "ev_micaela_hb3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :background => {
            :id => 31
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3686,
          :background => {
            :id => 31
          }
        },
        2 => {
          :name => "Begging 1 (Execution Reverse Rape)",
          :common => 5886,
          :condition => {
            :type => 1,
            :id => 3032,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    41 => {
      :name => "Micaela (Fallen Angel)",
      :condition => {
        :type => 2,
        :id => 33
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_micaela_hc1"],
          2 => ["Graphics/Pictures/", "ev_micaela_hc2"],
          3 => ["Graphics/Pictures/", "ev_micaela_hc3"],
          4 => ["Graphics/Pictures/", "ev_micaela_hc4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3033,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Cowgirl)",
          :common => 5888,
          :condition => {
            :type => 1,
            :id => 3033,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    42 => {
      :name => "Micaela-chan",
      :condition => {
        :type => 2,
        :id => 34
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_micaelac_h1"],
          2 => ["Graphics/Pictures/", "ev_micaelac_h2"],
          3 => ["Graphics/Pictures/", "ev_micaelac_h3"],
          4 => ["Graphics/Pictures/", "ev_micaelac_hb1"],
          5 => ["Graphics/Pictures/", "ev_micaelac_hb2"],
          6 => ["Graphics/Pictures/", "ev_micaelac_hb3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3034,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_micaelac_hc1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4746,
          :condition => {
            :type => 1,
            :id => 3034,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :name => "Request 2 (Sisters' Torture)",
          :common => 4747,
          :condition => {
            :type => 1,
            :id => 3034,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Loop Event (Sisters' Bath)",
          :common => 5817,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    43 => {
      :name => "Lucifina",
      :condition => {
        :type => 3,
        :id => 661
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_rucyfina_hb1"],
          2 => ["Graphics/Pictures/", "ev_rucyfina_hb2"],
          3 => ["Graphics/Pictures/", "ev_rucyfina_hb3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :background => {
            :id => 93
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_rucyfina_ha1"],
          2 => ["Graphics/Pictures/", "ev_rucyfina_ha2"],
          3 => ["Graphics/Pictures/", "ev_rucyfina_ha3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :condition => {
            :type => 1,
            :id => 3035,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3661,
          :background => {
            :id => 93
          }
        },
        2 => {
          :name => "Request 1 (Unbirth)",
          :common => 5891,
          :condition => {
            :type => 1,
            :id => 3035,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Breastfeeding+Handjob)",
          :common => 5892,
          :condition => {
            :type => 1,
            :id => 3035,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    44 => {
      :name => "Lucifina-chan",
      :condition => {
        :type => 2,
        :id => 36
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_rusifinachan_h1"],
          2 => ["Graphics/Pictures/", "ev_rusifinachan_h2"],
          3 => ["Graphics/Pictures/", "ev_rusifinachan_h3"],
          4 => ["Graphics/Pictures/", "ev_rusifinachan_h4"],
          5 => ["Graphics/Pictures/", "ev_rusifinachan_ct01"],
          6 => ["Graphics/Pictures/", "ev_rusifinachan_ct02"],
          7 => ["Graphics/Pictures/", "ev_rusifinachan_ct03"],
          8 => ["Graphics/Pictures/", "ev_rusifinachan_ct04"],
          9 => ["Graphics/Pictures/", "ev_micaelac_hb1"],
          10 => ["Graphics/Pictures/", "ev_micaelac_hb2"],
          11 => ["Graphics/Pictures/", "ev_micaelac_hb3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,5],
          [2,6],
          [3,7],
          [4,8],
          [9],
          [10],
          [11],
        ],
          :condition => {
            :type => 1,
            :id => 3036,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_micaelac_hc1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4751,
          :condition => {
            :type => 1,
            :id => 3036,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :name => "Request 2 (Sisters' Torture)",
          :common => 4747,
          :condition => {
            :type => 1,
            :id => 3036,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Loop Event (Sisters' Bath)",
          :common => 5817,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    45 => {
      :name => "Raphaela",
      :condition => {
        :type => 3,
        :id => 537
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_rafael_h01"],
          2 => ["Graphics/Pictures/", "ev_rafael_h02"],
          3 => ["Graphics/Pictures/", "ev_rafael_h03"],
          4 => ["Graphics/Pictures/", "ev_rafael_h04"],
          5 => ["Graphics/Pictures/", "ev_rafael_h05"],
          6 => ["Graphics/Pictures/", "ev_rafael_h06"],
          7 => ["Graphics/Pictures/", "ev_rafael_h07"],
          8 => ["Graphics/Pictures/", "ev_rafael_h08"],
          9 => ["Graphics/Pictures/", "ev_rafael_h09"],
          10 => ["Graphics/Pictures/", "ev_rafael_h10"],
          11 => ["Graphics/Pictures/", "ev_rafael_h11"],
          12 => ["Graphics/Pictures/", "ev_rafael_h12"],
          13 => ["Graphics/Pictures/", "ev_rafael_h13"],
          14 => ["Graphics/Pictures/", "ev_rafael_h14"],
          15 => ["Graphics/Pictures/", "ev_rafael_h15"],
          16 => ["Graphics/Pictures/", "ev_rafael_h16"],
          17 => ["Graphics/Pictures/", "ev_rafael_h17"],
          18 => ["Graphics/Pictures/", "ev_rafael_h18"],
          19 => ["Graphics/Pictures/", "ev_rafael_h19"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
        ],
          :background => {
            :id => 41
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3537,
          :background => {
            :id => 41
          }
        },
        2 => {
          :name => "Request 1 (Paizuri+Reverse Rape)",
          :common => 6476,
          :condition => {
            :type => 1,
            :id => 3510,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    46 => {
      :name => "Gabriela",
      :condition => {
        :type => 3,
        :id => 567
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_gaburiera_ha01"],
          2 => ["Graphics/Pictures/", "ev_gaburiera_ha02"],
          3 => ["Graphics/Pictures/", "ev_gaburiera_ha03"],
          4 => ["Graphics/Pictures/", "ev_gaburiera_ha04"],
          5 => ["Graphics/Pictures/", "ev_gaburiera_ha05"],
          6 => ["Graphics/Pictures/", "ev_gaburiera_ha06"],
          7 => ["Graphics/Pictures/", "ev_gaburiera_ha07"],
          8 => ["Graphics/Pictures/", "ev_gaburiera_ha08"],
          9 => ["Graphics/Pictures/", "ev_gaburiera_ha09"],
          10 => ["Graphics/Pictures/", "ev_gaburiera_ha10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 83
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3567,
          :background => {
            :id => 83
          }
        },
        2 => {
          :name => "Begging 1 (Demon Flower Squeeze Death)",
          :common => 6481,
          :condition => {
            :type => 1,
            :id => 3511,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Begging 2 (Demon Flower Squeeze Death?)",
          :common => 6482,
          :condition => {
            :type => 1,
            :id => 3511,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    47 => {
      :name => "Uriela",
      :condition => {
        :type => 3,
        :id => 573
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_uriera_h01"],
          2 => ["Graphics/Pictures/", "ev_uriera_h02"],
          3 => ["Graphics/Pictures/", "ev_uriera_h03"],
          4 => ["Graphics/Pictures/", "ev_uriera_h04"],
          5 => ["Graphics/Pictures/", "ev_uriera_h05"],
          6 => ["Graphics/Pictures/", "ev_uriera_h06"],
          7 => ["Graphics/Pictures/", "ev_uriera_h07"],
          8 => ["Graphics/Pictures/", "ev_uriera_h08"],
          9 => ["Graphics/Pictures/", "ev_uriera_h09"],
          10 => ["Graphics/Pictures/", "ev_uriera_h10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 65
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3573,
          :background => {
            :id => 65
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 6486,
          :condition => {
            :type => 1,
            :id => 3512,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    48 => {
      :name => "Sariela",
      :condition => {
        :type => 3,
        :id => 576
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_sariera_h01"],
          2 => ["Graphics/Pictures/", "ev_sariera_h02"],
          3 => ["Graphics/Pictures/", "ev_sariera_h03"],
          4 => ["Graphics/Pictures/", "ev_sariera_h04"],
          5 => ["Graphics/Pictures/", "ev_sariera_h05"],
          6 => ["Graphics/Pictures/", "ev_sariera_h06"],
          7 => ["Graphics/Pictures/", "ev_sariera_h07"],
          8 => ["Graphics/Pictures/", "ev_sariera_h08"],
          9 => ["Graphics/Pictures/", "ev_sariera_h09"],
          10 => ["Graphics/Pictures/", "ev_sariera_h10"],
          11 => ["Graphics/Pictures/", "ev_sariera_h11"],
          12 => ["Graphics/Pictures/", "ev_sariera_h12"],
          13 => ["Graphics/Pictures/", "ev_sariera_h13"],
          14 => ["Graphics/Pictures/", "ev_sariera_h14"],
          15 => ["Graphics/Pictures/", "ev_sariera_h15"],
          16 => ["Graphics/Pictures/", "ev_sariera_h16"],
          17 => ["Graphics/Pictures/", "ev_sariera_h17"],
          18 => ["Graphics/Pictures/", "ev_sariera_h18"],
          19 => ["Graphics/Pictures/", "ev_sariera_h19"],
          20 => ["Graphics/Pictures/", "ev_sariera_h20"],
          21 => ["Graphics/Pictures/", "ev_sariera_h21"],
          22 => ["Graphics/Pictures/", "ev_sariera_h22"],
          23 => ["Graphics/Pictures/", "ev_sariera_h23"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
        ],
          :background => {
            :id => 31
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3576,
          :background => {
            :id => 31
          }
        },
        2 => {
          :name => "Begging 1 (Torture Execution)",
          :common => 6491,
          :condition => {
            :type => 1,
            :id => 3513,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Begging 2 (Torture Execution?)",
          :common => 6492,
          :condition => {
            :type => 1,
            :id => 3513,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    49 => {
      :name => "Metatronne",
      :condition => {
        :type => 3,
        :id => 599
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_metatorone_h01"],
          2 => ["Graphics/Pictures/", "ev_metatorone_h02"],
          3 => ["Graphics/Pictures/", "ev_metatorone_h03"],
          4 => ["Graphics/Pictures/", "ev_metatorone_h04"],
          5 => ["Graphics/Pictures/", "ev_metatorone_h05"],
          6 => ["Graphics/Pictures/", "ev_metatorone_h06"],
          7 => ["Graphics/Pictures/", "ev_metatorone_h07"],
          8 => ["Graphics/Pictures/", "ev_metatorone_h08"],
          9 => ["Graphics/Pictures/", "ev_metatorone_h09"],
          10 => ["Graphics/Pictures/", "ev_metatorone_h10"],
          11 => ["Graphics/Pictures/", "ev_metatorone_h11"],
          12 => ["Graphics/Pictures/", "ev_metatorone_h12"],
          13 => ["Graphics/Pictures/", "ev_metatorone_h13"],
          14 => ["Graphics/Pictures/", "ev_metatorone_h14"],
          15 => ["Graphics/Pictures/", "ev_metatorone_h15"],
          16 => ["Graphics/Pictures/", "ev_metatorone_h16"],
          17 => ["Graphics/Pictures/", "ev_metatorone_h17"],
          18 => ["Graphics/Pictures/", "ev_metatorone_h18"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
        ],
          :background => {
            :id => 88
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3599,
          :background => {
            :id => 88
          }
        },
        2 => {
          :name => "Request 1 (Double Reverse Rape)",
          :common => 6496,
          :condition => {
            :type => 1,
            :id => 3514,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    50 => {
      :name => "Sandalphone",
      :condition => {
        :type => 3,
        :id => 600
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_metatorone_h01"],
          2 => ["Graphics/Pictures/", "ev_metatorone_h02"],
          3 => ["Graphics/Pictures/", "ev_metatorone_h03"],
          4 => ["Graphics/Pictures/", "ev_metatorone_h04"],
          5 => ["Graphics/Pictures/", "ev_metatorone_h05"],
          6 => ["Graphics/Pictures/", "ev_metatorone_h06"],
          7 => ["Graphics/Pictures/", "ev_metatorone_h07"],
          8 => ["Graphics/Pictures/", "ev_metatorone_h08"],
          9 => ["Graphics/Pictures/", "ev_metatorone_h09"],
          10 => ["Graphics/Pictures/", "ev_metatorone_h10"],
          11 => ["Graphics/Pictures/", "ev_metatorone_h11"],
          12 => ["Graphics/Pictures/", "ev_metatorone_h12"],
          13 => ["Graphics/Pictures/", "ev_metatorone_h13"],
          14 => ["Graphics/Pictures/", "ev_metatorone_h14"],
          15 => ["Graphics/Pictures/", "ev_metatorone_h15"],
          16 => ["Graphics/Pictures/", "ev_metatorone_h16"],
          17 => ["Graphics/Pictures/", "ev_metatorone_h17"],
          18 => ["Graphics/Pictures/", "ev_metatorone_h18"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
        ],
          :background => {
            :id => 88
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3599,
          :background => {
            :id => 88
          }
        },
        2 => {
          :name => "Request 1 (Double Reverse Rape)",
          :common => 6496,
          :condition => {
            :type => 1,
            :id => 3515,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    51 => {
      :name => "Puruel",
      :condition => {
        :type => 2,
        :id => 516
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_puruel_h1"],
          2 => ["Graphics/Pictures/", "ev_puruel_h2"],
          3 => ["Graphics/Pictures/", "ev_puruel_h3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :condition => {
            :type => 1,
            :id => 3516,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Begging 1 (Slime Squeeze)",
          :common => 6501,
          :condition => {
            :type => 1,
            :id => 3516,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    52 => {
      :name => "Inuel",
      :condition => {
        :type => 2,
        :id => 517
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_inuel_h1"],
          2 => ["Graphics/Pictures/", "ev_inuel_h2"],
          3 => ["Graphics/Pictures/", "ev_inuel_h3"],
          4 => ["Graphics/Pictures/", "ev_inuel_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3517,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Begging 1 (Reverse Cowgirl Rape)",
          :common => 6506,
          :condition => {
            :type => 1,
            :id => 3517,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    53 => {
      :name => "Promestein (Small)",
      :condition => {
        :type => 2,
        :id => 41
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_stein_hsb1"],
          2 => ["Graphics/Pictures/", "ev_stein_hsb2"],
          3 => ["Graphics/Pictures/", "ev_stein_hsb3"],
          4 => ["Graphics/Pictures/", "ev_stein_hsb4"],
          5 => ["Graphics/Pictures/", "ev_stein_hsc1"],
          6 => ["Graphics/Pictures/", "ev_stein_hsc2"],
          7 => ["Graphics/Pictures/", "ev_stein_hsc3"],
          8 => ["Graphics/Pictures/", "ev_stein_hsc4"],
          9 => ["Graphics/Pictures/", "ev_stein_hsd1"],
          10 => ["Graphics/Pictures/", "ev_stein_hsd2"],
          11 => ["Graphics/Pictures/", "ev_stein_hsd3"],
          12 => ["Graphics/Pictures/", "ev_stein_hsd4"],
          13 => ["Graphics/Pictures/", "ev_stein_hse1"],
          14 => ["Graphics/Pictures/", "ev_stein_hse2"],
          15 => ["Graphics/Pictures/", "ev_stein_hse3"],
          16 => ["Graphics/Pictures/", "ev_stein_hse4"],
          17 => ["Graphics/Pictures/", "ev_stein_hsa1"],
          18 => ["Graphics/Pictures/", "ev_stein_hsa2"],
          19 => ["Graphics/Pictures/", "ev_stein_hsa3"],
          20 => ["Graphics/Pictures/", "ev_stein_hsa4"],
          21 => ["Graphics/Pictures/", "ev_stein_hsa5"],
          22 => ["Graphics/Pictures/", "ev_stein_hsf1"],
          23 => ["Graphics/Pictures/", "ev_stein_hsf2"],
          24 => ["Graphics/Pictures/", "ev_stein_hsf3"],
          25 => ["Graphics/Pictures/", "ev_stein_hsf4"],
          26 => ["Graphics/Pictures/", "ev_stein_hsf5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
          [26],
        ],
          :condition => {
            :type => 1,
            :id => 3041,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_stein_hsg1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Gloved Handjob)",
          :common => 4041,
          :condition => {
            :type => 1,
            :id => 3041,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :name => "Request 2 (Onahole)",
          :common => 4042,
          :condition => {
            :type => 1,
            :id => 3041,
            :op => 1,
            :value => 20
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 3 (Onahole)",
          :common => 4043,
          :condition => {
            :type => 1,
            :id => 3041,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 4 (Living Onahole)",
          :common => 4044,
          :condition => {
            :type => 1,
            :id => 3041,
            :op => 1,
            :value => 40
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 5 (Bare Handjob)",
          :common => 4045,
          :condition => {
            :type => 1,
            :id => 3041,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        6 => {
          :name => "Request 6 (Reverse Rape)",
          :common => 4046,
          :condition => {
            :type => 1,
            :id => 3041,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        7 => {
          :name => "Loop Event (Mirror of Temptation)",
          :common => 5791,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    54 => {
      :name => "Promestein (Adult)",
      :condition => {
        :type => 2,
        :id => 37
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_stein2_hb1"],
          2 => ["Graphics/Pictures/", "ev_stein2_hb2"],
          3 => ["Graphics/Pictures/", "ev_stein2_hb3"],
          4 => ["Graphics/Pictures/", "ev_stein2_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3037,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Paizuri)",
          :common => 5896,
          :condition => {
            :type => 1,
            :id => 3037,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    55 => {
      :name => "Promestein (Major Mutation)",
      :condition => {
        :type => 2,
        :id => 37
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_stein_hb1"],
          2 => ["Graphics/Pictures/", "ev_stein_hb2"],
          3 => ["Graphics/Pictures/", "ev_stein_ct01"],
          4 => ["Graphics/Pictures/", "ev_stein_hb3"],
          5 => ["Graphics/Pictures/", "ev_stein_ct02"],
          6 => ["Graphics/Pictures/", "ev_stein_hb4"],
          7 => ["Graphics/Pictures/", "ev_stein_ct03"],
          8 => ["Graphics/Pictures/", "ev_stein_hb5"],
          9 => ["Graphics/Pictures/", "ev_stein_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2,3],
          [4,5],
          [6,7],
          [7,8],
          [8,9],
        ],
          :condition => {
            :type => 1,
            :id => 3037,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Begging 1 (Plant Squeeze)",
          :common => 5897,
          :condition => {
            :type => 1,
            :id => 3037,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    56 => {
      :name => "Promestein (Major Final Mutation)",
      :condition => {
        :type => 2,
        :id => 37
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_stein2_h1"],
          2 => ["Graphics/Pictures/", "ev_stein2_h2"],
          3 => ["Graphics/Pictures/", "ev_stein2_h3"],
          4 => ["Graphics/Pictures/", "ev_stein2_ct01"],
          5 => ["Graphics/Pictures/", "ev_stein2_ct02"],
          6 => ["Graphics/Pictures/", "ev_stein2_h4"],
          7 => ["Graphics/Pictures/", "ev_stein2_ct03"],
          8 => ["Graphics/Pictures/", "ev_stein2_h5"],
          9 => ["Graphics/Pictures/", "ev_stein2_ct04"],
          10 => ["Graphics/Pictures/", "ev_stein2_h6"],
          11 => ["Graphics/Pictures/", "ev_stein2_ct11"],
          12 => ["Graphics/Pictures/", "ev_stein2_ct12"],
          13 => ["Graphics/Pictures/", "ev_stein2_ct14"],
          14 => ["Graphics/Pictures/", "ev_stein2_ct15"],
          15 => ["Graphics/Pictures/", "ev_stein2_ct16"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [3,4],
          [3,5],
          [6,7],
          [8,9],
          [10],
          [10,11],
          [10,12],
          [10,13],
          [10,14],
          [10,15],
        ],
          :condition => {
            :type => 1,
            :id => 3037,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Begging 1 (Swallowed Whole Consumption)",
          :common => 5898,
          :condition => {
            :type => 1,
            :id => 3037,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    57 => {
      :name => "Promestein (Fusion)",
      :condition => {
        :type => 2,
        :id => 37
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_stein2_hc1"],
          2 => ["Graphics/Pictures/", "ev_stein2_hc2"],
          3 => ["Graphics/Pictures/", "ev_stein2_hc3"],
          4 => ["Graphics/Pictures/", "ev_stein2_hc4"],
          5 => ["Graphics/Pictures/", "ev_stein2_hc5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 1,
            :id => 3037,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5899,
          :condition => {
            :type => 1,
            :id => 3037,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    58 => {
      :name => "Laplace",
      :condition => {
        :type => 3,
        :id => 592
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_laplace_st02"],
          2 => ["Graphics/Pictures/", "ev_laplace_ct01"],
          3 => ["Graphics/Pictures/", "ev_laplace_ct02"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
        ],
          :condition => {
            :type => 1,
            :id => 3458,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_laplace_st02"],
          2 => ["Graphics/Pictures/", "ev_laplace_ct11"],
          3 => ["Graphics/Pictures/", "ev_laplace_ct12"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
        ],
          :condition => {
            :type => 1,
            :id => 3458,
            :op => 1,
            :value => 20
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_laplace_st02"],
          2 => ["Graphics/Pictures/", "ev_laplace_ct21"],
          3 => ["Graphics/Pictures/", "ev_laplace_ct22"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
        ],
          :condition => {
            :type => 1,
            :id => 3458,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_laplace_ha01"],
          2 => ["Graphics/Pictures/", "ev_laplace_ha02"],
          3 => ["Graphics/Pictures/", "ev_laplace_ha03"],
          4 => ["Graphics/Pictures/", "ev_laplace_ha04"],
          5 => ["Graphics/Pictures/", "ev_laplace_ha05"],
          6 => ["Graphics/Pictures/", "ev_laplace_ha06"],
          7 => ["Graphics/Pictures/", "ev_laplace_ha07"],
          8 => ["Graphics/Pictures/", "ev_laplace_ha08"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :condition => {
            :type => 1,
            :id => 3458,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_laplace_ha01"],
          2 => ["Graphics/Pictures/", "ev_laplace_ha11"],
          3 => ["Graphics/Pictures/", "ev_laplace_ha12"],
          4 => ["Graphics/Pictures/", "ev_laplace_ha13"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3458,
            :op => 1,
            :value => 80
          },
          :background => {
            :id => 1
          }
        },
        6 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_laplace_hb11"],
          2 => ["Graphics/Pictures/", "ev_laplace_hb12"],
          3 => ["Graphics/Pictures/", "ev_laplace_hb13"],
          4 => ["Graphics/Pictures/", "ev_laplace_hb14"],
          5 => ["Graphics/Pictures/", "ev_laplace_hb15"],
          6 => ["Graphics/Pictures/", "ev_laplace_hb16"],
          7 => ["Graphics/Pictures/", "ev_laplace_hb17"],
          8 => ["Graphics/Pictures/", "ev_laplace_hb18"],
          9 => ["Graphics/Pictures/", "ev_laplace_hb19"],
          10 => ["Graphics/Pictures/", "ev_laplace_hb20"],
          11 => ["Graphics/Pictures/", "ev_laplace_hb21"],
          12 => ["Graphics/Pictures/", "ev_laplace_hb22"],
          13 => ["Graphics/Pictures/", "ev_laplace_hb23"],
          14 => ["Graphics/Pictures/", "ev_laplace_hb24"],
          15 => ["Graphics/Pictures/", "ev_laplace_hb25"],
          16 => ["Graphics/Pictures/", "ev_laplace_hb26"],
          17 => ["Graphics/Pictures/", "ev_laplace_hb27"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
        ],
          :background => {
            :id => 85
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3592,
          :background => {
            :id => 85
          }
        },
        2 => {
          :name => "Request 1 (Handjob)",
          :common => 6216,
          :condition => {
            :type => 1,
            :id => 3458,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 10
          }
        },
        3 => {
          :name => "Begging 2 (Onahole)",
          :common => 6217,
          :condition => {
            :type => 1,
            :id => 3458,
            :op => 1,
            :value => 20
          },
          :background => {
            :id => 30
          }
        },
        4 => {
          :name => "Begging 3 (Anal Vibe)",
          :common => 6218,
          :condition => {
            :type => 1,
            :id => 3458,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 50
          }
        },
        5 => {
          :name => "Begging 4 (Sumata)",
          :common => 6219,
          :condition => {
            :type => 1,
            :id => 3458,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 80
          }
        },
        6 => {
          :name => "Request 5 (Reverse Rape)",
          :common => 6220,
          :condition => {
            :type => 1,
            :id => 3458,
            :op => 1,
            :value => 80
          },
          :background => {
            :id => 100
          }
        },
        7 => {
          :name => "Begging 6 (Milking)",
          :common => 6221,
          :condition => {
            :type => 1,
            :id => 3458,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 100
          }
        }
      }
    },
    59 => {
      :name => "Alicetroemeria",
      :condition => {
        :type => 2,
        :id => 45
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alicetromeria_h1"],
          2 => ["Graphics/Pictures/", "ev_alicetromeria_h2"],
          3 => ["Graphics/Pictures/", "ev_alicetromeria_h3"],
          4 => ["Graphics/Pictures/", "ev_alicetromeria_h4"],
          5 => ["Graphics/Pictures/", "ev_alicetromeria_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 1,
            :id => 3045,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Blowjob)",
          :common => 4756,
          :condition => {
            :type => 1,
            :id => 3045,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    60 => {
      :name => "Black Alice (1st Form)",
      :condition => {
        :type => 3,
        :id => 348
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alice8th_hb1"],
          2 => ["Graphics/Pictures/", "ev_alice8th_hb2"],
          3 => ["Graphics/Pictures/", "ev_alice8th_hb3"],
          4 => ["Graphics/Pictures/", "ev_alice8th_hb4"],
          5 => ["Graphics/Pictures/", "ev_alice8th_hb5"],
          6 => ["Graphics/Pictures/", "ev_alice8th_hb6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 42
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3348,
          :background => {
            :id => 42
          }
        },
        2 => {
          :name => "Begging 1 (Bear Consumption)",
          :common => 7736,
          :condition => {
            :type => 1,
            :id => 3045,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Begging 2 (Reverse Rape Consumption)",
          :common => 7737,
          :condition => {
            :type => 1,
            :id => 3045,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Begging 3 (Reverse Rape Consumption?)",
          :common => 7738,
          :condition => {
            :type => 1,
            :id => 3045,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    61 => {
      :name => "Black Alice (2nd Form)",
      :condition => {
        :type => 3,
        :id => 349
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alice8th2_h1"],
          2 => ["Graphics/Pictures/", "ev_alice8th2_h2"],
          3 => ["Graphics/Pictures/", "ev_alice8th2_h3"],
          4 => ["Graphics/Pictures/", "ev_alice8th2_h4"],
          5 => ["Graphics/Pictures/", "ev_alice8th2_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 42
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3349,
          :background => {
            :id => 42
          }
        },
        2 => {
          :name => "Begging 1 (Semen Squeeze Swallowed Whole)",
          :common => 7741,
          :condition => {
            :type => 1,
            :id => 3045,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    62 => {
      :name => "Black Alice (3rd Form)",
      :condition => {
        :type => 3,
        :id => 350
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alice8th3_h1"],
          2 => ["Graphics/Pictures/", "ev_alice8th3_h2"],
          3 => ["Graphics/Pictures/", "ev_alice8th3_h3"],
          4 => ["Graphics/Pictures/", "ev_alice8th3_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 42
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3350,
          :background => {
            :id => 42
          }
        },
        2 => {
          :name => "Begging 1 (Semen Squeeze Hole Death)",
          :common => 7743,
          :condition => {
            :type => 1,
            :id => 3045,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    63 => {
      :name => "Black Alice (4th Form)",
      :condition => {
        :type => 2,
        :id => 709
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alice8th4_hh1"],
          2 => ["Graphics/Pictures/", "ev_alice8th4_hh2"],
          3 => ["Graphics/Pictures/", "ev_alice8th4_hh3"],
          4 => ["Graphics/Pictures/", "ev_alice8th4_hh4"],
          5 => ["Graphics/Pictures/", "ev_alice8th4_hh5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 1,
            :id => 3045,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Begging 1 (Reverse Rape Consumption)",
          :common => 7746,
          :condition => {
            :type => 1,
            :id => 3045,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    64 => {
      :name => "Black Alice (Third God)",
      :condition => {
        :type => 3,
        :id => 648
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alice8th5_h1"],
          2 => ["Graphics/Pictures/", "ev_alice8th5_h2"],
          3 => ["Graphics/Pictures/", "ev_alice8th5_h3"],
          4 => ["Graphics/Pictures/", "ev_alice8th5_h4"],
          5 => ["Graphics/Pictures/", "ev_alice8th5_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 39
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3648,
          :background => {
            :id => 39
          }
        },
        2 => {
          :name => "Pleasure Request 1 (Reverse Rape Death by Squeeze)",
          :common => 7755,
          :condition => {
            :type => 1,
            :id => 3713,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    65 => {
      :name => "Nuruko",
      :condition => {
        :type => 3,
        :id => 22
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_nuruko_ha1"],
          2 => ["Graphics/Pictures/", "ev_nuruko_ha2"],
          3 => ["Graphics/Pictures/", "ev_nuruko_ha3"],
          4 => ["Graphics/Pictures/", "ev_nuruko_ha4"],
          5 => ["Graphics/Pictures/", "ev_nuruko_ha5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 36
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_nuruko_hb1"],
          2 => ["Graphics/Pictures/", "ev_nuruko_hb2"],
          3 => ["Graphics/Pictures/", "ev_nuruko_hb3"],
          4 => ["Graphics/Pictures/", "ev_nuruko_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3079,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3022,
          :background => {
            :id => 36
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Tentacle)",
          :common => 4186,
          :condition => {
            :type => 1,
            :id => 3079,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Paizuri)",
          :common => 4187,
          :condition => {
            :type => 1,
            :id => 3079,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    66 => {
      :name => "Null Cogito",
      :condition => {
        :type => 3,
        :id => 961
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_nurukox_hb1"],
          2 => ["Graphics/Pictures/", "ev_nurukox_hb2"],
          3 => ["Graphics/Pictures/", "ev_nurukox_hb3"],
          4 => ["Graphics/Pictures/", "ev_nurukox_hb4"],
          5 => ["Graphics/Pictures/", "ev_nurukox_hb5"],
          6 => ["Graphics/Pictures/", "ev_nurukox_hb6"],
          7 => ["Graphics/Pictures/", "ev_nurukox_hb7"],
          8 => ["Graphics/Pictures/", "ev_nurukox_hb8"],
          9 => ["Graphics/Pictures/", "ev_nurukox_hb9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :condition => {
            :type => 1,
            :id => 3706,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_nurukox_ha1"],
          2 => ["Graphics/Pictures/", "ev_nurukox_ha2"],
          3 => ["Graphics/Pictures/", "ev_nurukox_ha3"],
          4 => ["Graphics/Pictures/", "ev_nurukox_ha4"],
          5 => ["Graphics/Pictures/", "ev_nurukox_hc2"],
          6 => ["Graphics/Pictures/", "ev_nurukox_hc3"],
          7 => ["Graphics/Pictures/", "ev_nurukox_hc4"],
          8 => ["Graphics/Pictures/", "ev_nurukox_hb5"],
          9 => ["Graphics/Pictures/", "ev_nurukox_hc5"],
          10 => ["Graphics/Pictures/", "ev_nurukox_hc6"],
          11 => ["Graphics/Pictures/", "ev_nurukox_hc7"],
          12 => ["Graphics/Pictures/", "ev_nurukox_hb7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
        ],
          :background => {
            :id => 27
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3961,
          :background => {
            :id => 27
          }
        },
        2 => {
          :name => "Begging 1 (Tentacle Death by Squeeze)",
          :common => 7599,
          :condition => {
            :type => 1,
            :id => 3706,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Begging 2 (Reverse Rape Death by Squeeze)",
          :common => 7600,
          :condition => {
            :type => 1,
            :id => 3706,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    67 => {
      :name => "Hild",
      :condition => {
        :type => 3,
        :id => 74
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_brunhild_ha01"],
          2 => ["Graphics/Pictures/", "ev_brunhild_ha02"],
          3 => ["Graphics/Pictures/", "ev_brunhild_ha03"],
          4 => ["Graphics/Pictures/", "ev_brunhild_ha04"],
          5 => ["Graphics/Pictures/", "ev_brunhild_ha05"],
          6 => ["Graphics/Pictures/", "ev_brunhild_ha06"],
          7 => ["Graphics/Pictures/", "ev_brunhild_ha07"],
          8 => ["Graphics/Pictures/", "ev_brunhild_ha08"],
          9 => ["Graphics/Pictures/", "ev_brunhild_ha09"],
          10 => ["Graphics/Pictures/", "ev_brunhild_ha10"],
          11 => ["Graphics/Pictures/", "ev_brunhild_ha11"],
          12 => ["Graphics/Pictures/", "ev_brunhild_ha12"],
          13 => ["Graphics/Pictures/", "ev_brunhild_ha13"],
          14 => ["Graphics/Pictures/", "ev_brunhild_ha14"],
          15 => ["Graphics/Pictures/", "ev_brunhild_ha15"],
          16 => ["Graphics/Pictures/", "ev_brunhild_ha16"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
        ],
          :background => {
            :id => 46
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_brunhild_hb01"],
          2 => ["Graphics/Pictures/", "ev_brunhild_hb02"],
          3 => ["Graphics/Pictures/", "ev_brunhild_hb03"],
          4 => ["Graphics/Pictures/", "ev_brunhild_hb04"],
          5 => ["Graphics/Pictures/", "ev_brunhild_hb05"],
          6 => ["Graphics/Pictures/", "ev_brunhild_hb06"],
          7 => ["Graphics/Pictures/", "ev_brunhild_hb07"],
          8 => ["Graphics/Pictures/", "ev_brunhild_hb08"],
          9 => ["Graphics/Pictures/", "ev_brunhild_hb09"],
          10 => ["Graphics/Pictures/", "ev_brunhild_hb10"],
          11 => ["Graphics/Pictures/", "ev_brunhild_hb11"],
          12 => ["Graphics/Pictures/", "ev_brunhild_hb12"],
          13 => ["Graphics/Pictures/", "ev_brunhild_hb13"],
          14 => ["Graphics/Pictures/", "ev_brunhild_hb14"],
          15 => ["Graphics/Pictures/", "ev_brunhild_hb15"],
          16 => ["Graphics/Pictures/", "ev_brunhild_hb16"],
          17 => ["Graphics/Pictures/", "ev_brunhild_hb17"],
          18 => ["Graphics/Pictures/", "ev_brunhild_hb18"],
          19 => ["Graphics/Pictures/", "ev_brunhild_hb19"],
          20 => ["Graphics/Pictures/", "ev_brunhild_hb20"],
          21 => ["Graphics/Pictures/", "ev_brunhild_hb21"],
          22 => ["Graphics/Pictures/", "ev_brunhild_hb22"],
          23 => ["Graphics/Pictures/", "ev_brunhild_hb23"],
          24 => ["Graphics/Pictures/", "ev_brunhild_hb24"],
          25 => ["Graphics/Pictures/", "ev_brunhild_hc01"],
          26 => ["Graphics/Pictures/", "ev_brunhild_hc02"],
          27 => ["Graphics/Pictures/", "ev_brunhild_hc03"],
          28 => ["Graphics/Pictures/", "ev_brunhild_hc04"],
          29 => ["Graphics/Pictures/", "ev_brunhild_hc05"],
          30 => ["Graphics/Pictures/", "ev_brunhild_hc06"],
          31 => ["Graphics/Pictures/", "ev_brunhild_hc07"],
          32 => ["Graphics/Pictures/", "ev_brunhild_hc08"],
          33 => ["Graphics/Pictures/", "ev_brunhild_hc09"],
          34 => ["Graphics/Pictures/", "ev_brunhild_hc10"],
          35 => ["Graphics/Pictures/", "ev_brunhild_hc11"],
          36 => ["Graphics/Pictures/", "ev_brunhild_hc12"],
          37 => ["Graphics/Pictures/", "ev_brunhild_hc13"],
          38 => ["Graphics/Pictures/", "ev_brunhild_hc14"],
          39 => ["Graphics/Pictures/", "ev_brunhild_hc15"],
          40 => ["Graphics/Pictures/", "ev_brunhild_hc16"],
          41 => ["Graphics/Pictures/", "ev_brunhild_hc17"],
          42 => ["Graphics/Pictures/", "ev_brunhild_hc18"],
          43 => ["Graphics/Pictures/", "ev_brunhild_hc19"],
          44 => ["Graphics/Pictures/", "ev_brunhild_hc20"],
          45 => ["Graphics/Pictures/", "ev_brunhild_hc21"],
          46 => ["Graphics/Pictures/", "ev_brunhild_hc22"],
          47 => ["Graphics/Pictures/", "ev_brunhild_hc23"],
          48 => ["Graphics/Pictures/", "ev_brunhild_hc24"],
          49 => ["Graphics/Pictures/", "ev_brunhild_hc25"],
          50 => ["Graphics/Pictures/", "ev_brunhild_hc26"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
          [26],
          [27],
          [28],
          [29],
          [30],
          [31],
          [32],
          [33],
          [34],
          [35],
          [36],
          [37],
          [38],
          [39],
          [40],
          [41],
          [42],
          [43],
          [44],
          [45],
          [46],
          [47],
          [48],
          [49],
          [50],
        ],
          :condition => {
            :type => 1,
            :id => 3129,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3074,
          :background => {
            :id => 46
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4436,
          :condition => {
            :type => 1,
            :id => 3129,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape: Swimsuit)",
          :common => 4437,
          :condition => {
            :type => 1,
            :id => 3129,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Event (Hild Impregnation)",
          :common => 4438,
          :condition => {
            :type => 1,
            :id => 1143,
            :op => 1,
            :value => 4
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    68 => {
      :name => "Deus Ex Machina",
      :condition => {
        :type => 2,
        :id => 759
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_deusex_ha1"],
          2 => ["Graphics/Pictures/", "ev_deusex_ha2"],
          3 => ["Graphics/Pictures/", "ev_deusex_ha3"],
          4 => ["Graphics/Pictures/", "ev_deusex_ha4"],
          5 => ["Graphics/Pictures/", "ev_deusex_ha5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 1,
            :id => 3759,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 7916,
          :condition => {
            :type => 1,
            :id => 3759,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    69 => {
      :name => "Deus Ex Machina (Rampage)",
      :condition => {
        :type => 3,
        :id => 990
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_deusex_hb1"],
          2 => ["Graphics/Pictures/", "ev_deusex_hb2"],
          3 => ["Graphics/Pictures/", "ev_deusex_hb3"],
          4 => ["Graphics/Pictures/", "ev_deusex_hb4"],
          5 => ["Graphics/Pictures/", "ev_deusex_hc1"],
          6 => ["Graphics/Pictures/", "ev_deusex_hc2"],
          7 => ["Graphics/Pictures/", "ev_deusex_hc3"],
          8 => ["Graphics/Pictures/", "ev_deusex_hc4"],
          9 => ["Graphics/Pictures/", "ev_deusex_hc5"],
          10 => ["Graphics/Pictures/", "ev_deusex_hc6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 47
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3990,
          :background => {
            :id => 47
          }
        },
        2 => {
          :name => "Pleasure Request 1 (Reverse Rape Death by Squeeze)",
          :common => 7917,
          :condition => {
            :type => 1,
            :id => 3759,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    70 => {
      :name => "Sigrdrifa",
      :condition => {
        :type => 3,
        :id => 654
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_sigurd_ha1"],
          2 => ["Graphics/Pictures/", "ev_sigurd_ha2"],
          3 => ["Graphics/Pictures/", "ev_sigurd_ha3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :background => {
            :id => 87
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_sigurd_hb1"],
          2 => ["Graphics/Pictures/", "ev_sigurd_hb2"],
          3 => ["Graphics/Pictures/", "ev_sigurd_hb3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :condition => {
            :type => 1,
            :id => 3761,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3654,
          :background => {
            :id => 87
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 7921,
          :condition => {
            :type => 1,
            :id => 3761,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Begging 2 (Nude Reverse Rape)",
          :common => 7922,
          :condition => {
            :type => 1,
            :id => 3761,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    71 => {
      :name => "Chrome",
      :condition => {
        :type => 3,
        :id => 83
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_chrom_hd1"],
          2 => ["Graphics/Pictures/", "ev_chrom_hd2"],
          3 => ["Graphics/Pictures/", "ev_chrom_hd3"],
          4 => ["Graphics/Pictures/", "ev_chrom_hd4"],
          5 => ["Graphics/Pictures/", "ev_chrom_ha1"],
          6 => ["Graphics/Pictures/", "ev_chrom_ha2"],
          7 => ["Graphics/Pictures/", "ev_chrom_ha3"],
          8 => ["Graphics/Pictures/", "ev_chrom_hb1"],
          9 => ["Graphics/Pictures/", "ev_chrom_hb2"],
          10 => ["Graphics/Pictures/", "ev_chrom_hb3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 56
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_chrom_he01"],
          2 => ["Graphics/Pictures/", "ev_chrom_he02"],
          3 => ["Graphics/Pictures/", "ev_chrom_he03"],
          4 => ["Graphics/Pictures/", "ev_chrom_he04"],
          5 => ["Graphics/Pictures/", "ev_chrom_he05"],
          6 => ["Graphics/Pictures/", "ev_chrom_he06"],
          7 => ["Graphics/Pictures/", "ev_chrom_he07"],
          8 => ["Graphics/Pictures/", "ev_chrom_he08"],
          9 => ["Graphics/Pictures/", "ev_chrom_he09"],
          10 => ["Graphics/Pictures/", "ev_chrom_he10"],
          11 => ["Graphics/Pictures/", "ev_chrom_he11"],
          12 => ["Graphics/Pictures/", "ev_chrom_he12"],
          13 => ["Graphics/Pictures/", "ev_chrom_he13"],
          14 => ["Graphics/Pictures/", "ev_chrom_he14"],
          15 => ["Graphics/Pictures/", "ev_chrom_he15"],
          16 => ["Graphics/Pictures/", "ev_chrom_he16"],
          17 => ["Graphics/Pictures/", "ev_chrom_hf1"],
          18 => ["Graphics/Pictures/", "ev_chrom_hf2"],
          19 => ["Graphics/Pictures/", "ev_chrom_hf3"],
          20 => ["Graphics/Pictures/", "ev_chrom_hf4"],
          21 => ["Graphics/Pictures/", "ev_chrom_hf5"],
          22 => ["Graphics/Pictures/", "ev_chrom_hf6"],
          23 => ["Graphics/Pictures/", "ev_chrom_hf7"],
          24 => ["Graphics/Pictures/", "ev_chrom_hf8"],
          25 => ["Graphics/Pictures/", "ev_chrom_hg1"],
          26 => ["Graphics/Pictures/", "ev_chrom_hg2"],
          27 => ["Graphics/Pictures/", "ev_chrom_hg3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
          [26],
          [27],
        ],
          :condition => {
            :type => 1,
            :id => 3134,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_chrom_hc01"],
          2 => ["Graphics/Pictures/", "ev_chrom_hc02"],
          3 => ["Graphics/Pictures/", "ev_chrom_hc03"],
          4 => ["Graphics/Pictures/", "ev_chrom_hc04"],
          5 => ["Graphics/Pictures/", "ev_chrom_hc05"],
          6 => ["Graphics/Pictures/", "ev_chrom_hc06"],
          7 => ["Graphics/Pictures/", "ev_chrom_hc07"],
          8 => ["Graphics/Pictures/", "ev_chrom_hc08"],
          9 => ["Graphics/Pictures/", "ev_chrom_hc09"],
          10 => ["Graphics/Pictures/", "ev_chrom_hc10"],
          11 => ["Graphics/Pictures/", "ev_chrom_hc11"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
        ],
      :condition => {
        :type => 3,
        :id => 748
      },
          :background => {
            :id => 100
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3083,
          :background => {
            :id => 56
          }
        },
        2 => {
          :name => "Defeat 2",
          :common => 3748,
      :condition => {
        :type => 3,
        :id => 748
      },
          :background => {
            :id => 100
          }
        },
        3 => {
          :name => "Request 1 (Handjob)",
          :common => 4466,
          :condition => {
            :type => 1,
            :id => 3134,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4467,
          :condition => {
            :type => 1,
            :id => 3134,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    72 => {
      :name => "Frederica",
      :condition => {
        :type => 3,
        :id => 82
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_frederika_h1"],
          2 => ["Graphics/Pictures/", "ev_frederika_h2"],
          3 => ["Graphics/Pictures/", "ev_frederika_h3"],
          4 => ["Graphics/Pictures/", "ev_frederika_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 56
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_frederika_hb1"],
          2 => ["Graphics/Pictures/", "ev_frederika_hb2"],
          3 => ["Graphics/Pictures/", "ev_frederika_hb3"],
          4 => ["Graphics/Pictures/", "ev_frederika_hc1"],
          5 => ["Graphics/Pictures/", "ev_frederika_hc2"],
          6 => ["Graphics/Pictures/", "ev_frederika_hc3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3135,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_frederika_hd1"],
          2 => ["Graphics/Pictures/", "ev_frederika_he1"],
          3 => ["Graphics/Pictures/", "ev_frederika_he2"],
          4 => ["Graphics/Pictures/", "ev_frederika_he3"],
          5 => ["Graphics/Pictures/", "ev_frederika_he4"],
          6 => ["Graphics/Pictures/", "ev_frederika_he5"],
          7 => ["Graphics/Pictures/", "ev_frederika_he6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3082,
          :background => {
            :id => 56
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 4471,
          :condition => {
            :type => 1,
            :id => 3135,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4472,
          :condition => {
            :type => 1,
            :id => 3135,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Loop Event (Spanking)",
          :common => 5802,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        },
        5 => {
          :name => "Loop Event (Blowjob + Handjob)",
          :common => 5803,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    73 => {
      :name => "You",
      :condition => {
        :type => 3,
        :id => 749
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_chromg_ha4"],
          2 => ["Graphics/Pictures/", "ev_chromg_ha5"],
          3 => ["Graphics/Pictures/", "ev_chromg_ha6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :background => {
            :id => 100
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_chromg_ha4"],
          2 => ["Graphics/Pictures/", "ev_chromg_ha7"],
          3 => ["Graphics/Pictures/", "ev_chromg_ha8"],
          4 => ["Graphics/Pictures/", "ev_chromg_ha9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3763,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3749,
          :background => {
            :id => 100
          }
        },
        2 => {
          :name => "Pleasure Request 1 (Reverse Rape Death by Squeeze)",
          :common => 7925,
          :condition => {
            :type => 1,
            :id => 3763,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Pleasure Request 2 (Reverse Rape Death by Squeeze?)",
          :common => 7926,
          :condition => {
            :type => 1,
            :id => 3763,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Begging 3 (Double Reverse Rape)",
          :common => 7929,
          :condition => {
            :type => 1,
            :id => 3763,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    74 => {
      :name => "Rei",
      :condition => {
        :type => 3,
        :id => 750
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_chromg_ha1"],
          2 => ["Graphics/Pictures/", "ev_chromg_ha2"],
          3 => ["Graphics/Pictures/", "ev_chromg_ha3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :background => {
            :id => 100
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_chromg_ha4"],
          2 => ["Graphics/Pictures/", "ev_chromg_ha7"],
          3 => ["Graphics/Pictures/", "ev_chromg_ha8"],
          4 => ["Graphics/Pictures/", "ev_chromg_ha9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3764,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3750,
          :background => {
            :id => 100
          }
        },
        2 => {
          :name => "Pleasure Request 1 (Reverse Rape Death by Squeeze)",
          :common => 7927,
          :condition => {
            :type => 1,
            :id => 3764,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Pleasure Request 2 (Reverse Rape Death by Squeeze?)",
          :common => 7928,
          :condition => {
            :type => 1,
            :id => 3764,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Begging 3 (Double Reverse Rape)",
          :common => 7929,
          :condition => {
            :type => 1,
            :id => 3764,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    75 => {
      :name => "La Croix",
      :condition => {
        :type => 2,
        :id => 766
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_shirom_hb1"],
          2 => ["Graphics/Pictures/", "ev_shirom_hb2"],
          3 => ["Graphics/Pictures/", "ev_shirom_hb3"],
          4 => ["Graphics/Pictures/", "ev_shirom_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3766,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_shirom_h1"],
          2 => ["Graphics/Pictures/", "ev_shirom_h2"],
          3 => ["Graphics/Pictures/", "ev_shirom_h3"],
          4 => ["Graphics/Pictures/", "ev_shirom_h4"],
          5 => ["Graphics/Pictures/", "ev_shirom_h5"],
          6 => ["Graphics/Pictures/", "ev_shirom_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3766,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_shirom_hb5"],
          2 => ["Graphics/Pictures/", "ev_shirom_hb6"],
          3 => ["Graphics/Pictures/", "ev_shirom_hb7"],
          4 => ["Graphics/Pictures/", "ev_shirom_hb8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3766,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Begging 1 (Handjob Squeeze)",
          :common => 7931,
          :condition => {
            :type => 1,
            :id => 3766,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :name => "Begging 2 (Reverse Rape Death by Squeeze)",
          :common => 7932,
          :condition => {
            :type => 1,
            :id => 3766,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Begging 3 (Reverse Rape Death by Squeeze?)",
          :common => 7933,
          :condition => {
            :type => 1,
            :id => 3766,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    76 => {
      :name => "Mephisto (Yoma)",
      :condition => {
        :type => 2,
        :id => 233
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_mefist_ha01"],
          2 => ["Graphics/Pictures/", "ev_mefist_ha02"],
          3 => ["Graphics/Pictures/", "ev_mefist_ha03"],
          4 => ["Graphics/Pictures/", "ev_mefist_ha04"],
          5 => ["Graphics/Pictures/", "ev_mefist_ha05"],
          6 => ["Graphics/Pictures/", "ev_mefist_ha06"],
          7 => ["Graphics/Pictures/", "ev_mefist_ha07"],
          8 => ["Graphics/Pictures/", "ev_mefist_ha08"],
          9 => ["Graphics/Pictures/", "ev_mefist_ha09"],
          10 => ["Graphics/Pictures/", "ev_mefist_ha10"],
          11 => ["Graphics/Pictures/", "ev_mefist_ha11"],
          12 => ["Graphics/Pictures/", "ev_mefist_ha12"],
          13 => ["Graphics/Pictures/", "ev_mefist_ha13"],
          14 => ["Graphics/Pictures/", "ev_mefist_ha14"],
          15 => ["Graphics/Pictures/", "ev_mefist_ha15"],
          16 => ["Graphics/Pictures/", "ev_mefist_ha16"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
        ],
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Semen Squeezing Lesson)",
          :common => 4981,
          :condition => {
            :type => 1,
            :id => 3233,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    77 => {
      :name => "Mephisto (Giant Serpent)",
      :condition => {
        :type => 3,
        :id => 203
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_mefist_hb1"],
          2 => ["Graphics/Pictures/", "ev_mefist_hb2"],
          3 => ["Graphics/Pictures/", "ev_mefist_hb3"],
          4 => ["Graphics/Pictures/", "ev_mefist_hb4"],
          5 => ["Graphics/Pictures/", "ev_mefist_hb5"],
          6 => ["Graphics/Pictures/", "ev_mefist_hb6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 37
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3203,
          :background => {
            :id => 37
          }
        },
        2 => {
          :name => "Request 1 (Predation)",
          :common => 4982,
          :condition => {
            :type => 1,
            :id => 3391,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Predation...?)",
          :common => 4983,
          :condition => {
            :type => 1,
            :id => 3391,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    78 => {
      :name => "Mephisto (MR: Yoma)",
      :condition => {
        :type => 3,
        :id => 780
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_mefist_hc1"],
          2 => ["Graphics/Pictures/", "ev_mefist_hc2"],
          3 => ["Graphics/Pictures/", "ev_mefist_hc3"],
          4 => ["Graphics/Pictures/", "ev_mefist_hc4"],
          5 => ["Graphics/Pictures/", "ev_mefist_hc5"],
          6 => ["Graphics/Pictures/", "ev_mefist_hc6"],
          7 => ["Graphics/Pictures/", "ev_mefist_hc7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 103
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3780,
          :background => {
            :id => 103
          }
        },
        2 => {
          :name => "Begging 1 (Tentacle Death by Squeeze)",
          :common => 6916,
          :condition => {
            :type => 1,
            :id => 3233,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    79 => {
      :name => "Mephisto (MR: Giant Serpent)",
      :condition => {
        :type => 3,
        :id => 816
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_mefist_hg1"],
          2 => ["Graphics/Pictures/", "ev_mefist_hg2"],
          3 => ["Graphics/Pictures/", "ev_mefist_hg3"],
          4 => ["Graphics/Pictures/", "ev_mefist_hg4"],
          5 => ["Graphics/Pictures/", "ev_mefist_hg5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 1,
            :id => 3233,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_mefist_hg1"],
          2 => ["Graphics/Pictures/", "ev_mefist_hg2"],
          3 => ["Graphics/Pictures/", "ev_mefist_hh1"],
          4 => ["Graphics/Pictures/", "ev_mefist_hh2"],
          5 => ["Graphics/Pictures/", "ev_mefist_hh3"],
          6 => ["Graphics/Pictures/", "ev_mefist_hh4"],
          7 => ["Graphics/Pictures/", "ev_mefist_hh5"],
          8 => ["Graphics/Pictures/", "ev_mefist_hh6"],
          9 => ["Graphics/Pictures/", "ev_mefist_hh7"],
          10 => ["Graphics/Pictures/", "ev_mefist_hh8"],
          11 => ["Graphics/Pictures/", "ev_mefist_hf1"],
          12 => ["Graphics/Pictures/", "ev_mefist_hf2"],
          13 => ["Graphics/Pictures/", "ev_mefist_hf3"],
          14 => ["Graphics/Pictures/", "ev_mefist_hf4"],
          15 => ["Graphics/Pictures/", "ev_mefist_hf5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
        ],
          :background => {
            :id => 27
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3816,
          :background => {
            :id => 27
          }
        },
        2 => {
          :name => "Begging 1 (Tentacle Extraction)",
          :common => 6922,
          :condition => {
            :type => 1,
            :id => 3233,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Begging 2 (Consumption)",
          :common => 6923,
          :condition => {
            :type => 1,
            :id => 3233,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    80 => {
      :name => "Galda",
      :condition => {
        :type => 3,
        :id => 501
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_galda_h1"],
          2 => ["Graphics/Pictures/", "ev_galda_h2"],
          3 => ["Graphics/Pictures/", "ev_galda_h3"],
          4 => ["Graphics/Pictures/", "ev_galda_h4"],
          5 => ["Graphics/Pictures/", "ev_galda_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 79
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3501,
          :background => {
            :id => 79
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5941,
          :condition => {
            :type => 1,
            :id => 3403,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    81 => {
      :name => "Kagetsumugi",
      :condition => {
        :type => 3,
        :id => 769
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kagetumugi_ha01"],
          2 => ["Graphics/Pictures/", "ev_kagetumugi_ha08"],
          3 => ["Graphics/Pictures/", "ev_kagetumugi_ha09"],
          4 => ["Graphics/Pictures/", "ev_kagetumugi_ha10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3767,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kagetumugi_ha02"],
          2 => ["Graphics/Pictures/", "ev_kagetumugi_ha04"],
          3 => ["Graphics/Pictures/", "ev_kagetumugi_ha06"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :condition => {
            :type => 1,
            :id => 3767,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kagetumugi_hd1"],
          2 => ["Graphics/Pictures/", "ev_kagetumugi_hd2"],
          3 => ["Graphics/Pictures/", "ev_kagetumugi_hd3"],
          4 => ["Graphics/Pictures/", "ev_kagetumugi_hd4"],
          5 => ["Graphics/Pictures/", "ev_kagetumugi_hd5"],
          6 => ["Graphics/Pictures/", "ev_kagetumugi_hd6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 102
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3769,
          :background => {
            :id => 102
          }
        },
        2 => {
          :name => "Begging 1 (Forced Masturbation)",
          :common => 7936,
          :condition => {
            :type => 1,
            :id => 3767,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Begging 2 (Footjob Extraction)",
          :common => 7937,
          :condition => {
            :type => 1,
            :id => 3767,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Begging 3 (Reverse Rape Extraction)",
          :common => 7938,
          :condition => {
            :type => 1,
            :id => 3767,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    82 => {
      :name => "Kagetsumugi (Final Form)",
      :condition => {
        :type => 3,
        :id => 795
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kagetumugi_hj01"],
          2 => ["Graphics/Pictures/", "ev_kagetumugi_hj16"],
          3 => ["Graphics/Pictures/", "ev_kagetumugi_hj17"],
          4 => ["Graphics/Pictures/", "ev_kagetumugi_hj18"],
          5 => ["Graphics/Pictures/", "ev_kagetumugi_hj19"],
          6 => ["Graphics/Pictures/", "ev_kagetumugi_hj20"],
          7 => ["Graphics/Pictures/", "ev_kagetumugi_hj21"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 106
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3795,
          :background => {
            :id => 106
          }
        },
        2 => {
          :name => "Begging 1 (Reverse Rape Extraction)",
          :common => 7945,
          :condition => {
            :type => 1,
            :id => 3767,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    83 => {
      :name => "Kagetsumugi (Tea Serving)",
      :condition => {
        :type => 2,
        :id => 928
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kagetumugi2_h01"],
          2 => ["Graphics/Pictures/", "ev_kagetumugi2_h02"],
          3 => ["Graphics/Pictures/", "ev_kagetumugi2_h03"],
          4 => ["Graphics/Pictures/", "ev_kagetumugi2_h04"],
          5 => ["Graphics/Pictures/", "ev_kagetumugi2_h05"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 1,
            :id => 3928,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kagetumugi2_h06"],
          2 => ["Graphics/Pictures/", "ev_kagetumugi2_h07"],
          3 => ["Graphics/Pictures/", "ev_kagetumugi2_h08"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :condition => {
            :type => 1,
            :id => 3928,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kagetumugi2_h09"],
          2 => ["Graphics/Pictures/", "ev_kagetumugi2_h10"],
          3 => ["Graphics/Pictures/", "ev_kagetumugi2_h11"],
          4 => ["Graphics/Pictures/", "ev_kagetumugi2_h12"],
          5 => ["Graphics/Pictures/", "ev_kagetumugi2_h13"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 1,
            :id => 3928,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kagetumugi2_hb01"],
          2 => ["Graphics/Pictures/", "ev_kagetumugi2_hb02"],
          3 => ["Graphics/Pictures/", "ev_kagetumugi2_hb03"],
          4 => ["Graphics/Pictures/", "ev_kagetumugi2_hb04"],
          5 => ["Graphics/Pictures/", "ev_kagetumugi2_hb05"],
          6 => ["Graphics/Pictures/", "ev_kagetumugi2_hb06"],
          7 => ["Graphics/Pictures/", "ev_kagetumugi2_hb07"],
          8 => ["Graphics/Pictures/", "ev_kagetumugi2_hb08"],
          9 => ["Graphics/Pictures/", "ev_kagetumugi2_hb09"],
          10 => ["Graphics/Pictures/", "ev_kagetumugi2_hb10"],
          11 => ["Graphics/Pictures/", "ev_kagetumugi2_hb11"],
          12 => ["Graphics/Pictures/", "ev_kagetumugi2_hb12"],
          13 => ["Graphics/Pictures/", "ev_kagetumugi2_hb13"],
          14 => ["Graphics/Pictures/", "ev_kagetumugi2_hb14"],
          15 => ["Graphics/Pictures/", "ev_kagetumugi2_hb15"],
          16 => ["Graphics/Pictures/", "ev_kagetumugi2_hb16"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
        ],
          :condition => {
            :type => 1,
            :id => 3928,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Begging 1 (Masturbation)",
          :common => 8331,
          :condition => {
            :type => 1,
            :id => 3928,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :name => "Begging 2 (Magic Hand)",
          :common => 8332,
          :condition => {
            :type => 1,
            :id => 3928,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Begging 3 (Cleaning Function)",
          :common => 8333,
          :condition => {
            :type => 1,
            :id => 3928,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Begging 4 (Fellatio)",
          :common => 8334,
          :condition => {
            :type => 1,
            :id => 3928,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    84 => {
      :name => "Yomigumo",
      :condition => {
        :type => 3,
        :id => 770
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kagetumugi_hg1"],
          2 => ["Graphics/Pictures/", "ev_kagetumugi_hg2"],
          3 => ["Graphics/Pictures/", "ev_kagetumugi_hg3"],
          4 => ["Graphics/Pictures/", "ev_kagetumugi_hg4"],
          5 => ["Graphics/Pictures/", "ev_kagetumugi_hg5"],
          6 => ["Graphics/Pictures/", "ev_kagetumugi_hg6"],
          7 => ["Graphics/Pictures/", "ev_kagetumugi_hg7"],
          8 => ["Graphics/Pictures/", "ev_kagetumugi_hg8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 102
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3770,
          :background => {
            :id => 102
          }
        },
        2 => {
          :name => "Begging 1 (Breast Squeezing Death)",
          :common => 7951,
          :condition => {
            :type => 1,
            :id => 3769,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    85 => {
      :name => "Kaiko Kitsune",
      :condition => {
        :type => 3,
        :id => 771
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kagetumugi_hf1"],
          2 => ["Graphics/Pictures/", "ev_kagetumugi_hf2"],
          3 => ["Graphics/Pictures/", "ev_kagetumugi_hf3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :condition => {
            :type => 1,
            :id => 3770,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kagetumugi_hf4"],
          2 => ["Graphics/Pictures/", "ev_kagetumugi_hf5"],
          3 => ["Graphics/Pictures/", "ev_kagetumugi_hf6"],
          4 => ["Graphics/Pictures/", "ev_kagetumugi_hf7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 102
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3771,
          :background => {
            :id => 102
          }
        },
        2 => {
          :name => "Begging 1 (Butt Job Milking)",
          :common => 7956,
          :condition => {
            :type => 1,
            :id => 3770,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Begging 2 (Reverse Rape Death by Squeeze)",
          :common => 7957,
          :condition => {
            :type => 1,
            :id => 3770,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    86 => {
      :name => "Rantengu",
      :condition => {
        :type => 3,
        :id => 772
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kagetumugi_he02"],
          2 => ["Graphics/Pictures/", "ev_kagetumugi_he03"],
          3 => ["Graphics/Pictures/", "ev_kagetumugi_he04"],
          4 => ["Graphics/Pictures/", "ev_kagetumugi_he05"],
          5 => ["Graphics/Pictures/", "ev_kagetumugi_he06"],
          6 => ["Graphics/Pictures/", "ev_kagetumugi_he07"],
          7 => ["Graphics/Pictures/", "ev_kagetumugi_he08"],
          8 => ["Graphics/Pictures/", "ev_kagetumugi_he09"],
          9 => ["Graphics/Pictures/", "ev_kagetumugi_he10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 102
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3772,
          :background => {
            :id => 102
          }
        },
        2 => {
          :name => "Pleasure Request 1 (Reverse Rape Death by Squeeze)",
          :common => 7961,
          :condition => {
            :type => 1,
            :id => 3771,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    87 => {
      :name => "Magatsu-Karura",
      :condition => {
        :type => 3,
        :id => 796
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kagetumugi_hk01"],
          2 => ["Graphics/Pictures/", "ev_kagetumugi_hk02"],
          3 => ["Graphics/Pictures/", "ev_kagetumugi_hk03"],
          4 => ["Graphics/Pictures/", "ev_kagetumugi_hk04"],
          5 => ["Graphics/Pictures/", "ev_kagetumugi_hk05"],
          6 => ["Graphics/Pictures/", "ev_kagetumugi_hk06"],
          7 => ["Graphics/Pictures/", "ev_kagetumugi_hk07"],
          8 => ["Graphics/Pictures/", "ev_kagetumugi_hk08"],
          9 => ["Graphics/Pictures/", "ev_kagetumugi_hk09"],
          10 => ["Graphics/Pictures/", "ev_kagetumugi_hk10"],
          11 => ["Graphics/Pictures/", "ev_kagetumugi_hk11"],
          12 => ["Graphics/Pictures/", "ev_kagetumugi_hk12"],
          13 => ["Graphics/Pictures/", "ev_kagetumugi_hk13"],
          14 => ["Graphics/Pictures/", "ev_kagetumugi_hk14"],
          15 => ["Graphics/Pictures/", "ev_kagetumugi_hk15"],
          16 => ["Graphics/Pictures/", "ev_kagetumugi_hk16"],
          17 => ["Graphics/Pictures/", "ev_kagetumugi_hk17"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
        ],
          :background => {
            :id => 106
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3796,
          :background => {
            :id => 106
          }
        },
        2 => {
          :name => "Pleasure Request 1 (Reverse Rape Death by Squeeze)",
          :common => 7966,
          :condition => {
            :type => 1,
            :id => 3772,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    118 => {
      :name => "Slime Girl",
      :condition => {
        :type => 3,
        :id => 1
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_slime_h1"],
          2 => ["Graphics/Pictures/", "ev_slime_h2"],
          3 => ["Graphics/Pictures/", "ev_slime_h3"],
          4 => ["Graphics/Pictures/", "ev_slime_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 52
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_slime_hb1"],
          2 => ["Graphics/Pictures/", "ev_slime_hb2"],
          3 => ["Graphics/Pictures/", "ev_slime_hb3"],
          4 => ["Graphics/Pictures/", "ev_slime_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3053,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3001,
          :background => {
            :id => 52
          }
        },
        2 => {
          :name => "Request 1 (Slime Teasing)",
          :common => 4076,
          :condition => {
            :type => 1,
            :id => 3053,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Slime Wrap)",
          :common => 4077,
          :condition => {
            :type => 1,
            :id => 3053,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    119 => {
      :name => "Bunny Slime",
      :condition => {
        :type => 3,
        :id => 2
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_bunnyslime_h1"],
          2 => ["Graphics/Pictures/", "ev_bunnyslime_h2"],
          3 => ["Graphics/Pictures/", "ev_bunnyslime_h3"],
          4 => ["Graphics/Pictures/", "ev_bunnyslime_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 52
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3002,
          :background => {
            :id => 52
          }
        },
        2 => {
          :name => "Request 1 (Slime Paizuri)",
          :common => 4081,
          :condition => {
            :type => 1,
            :id => 3054,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    120 => {
      :name => "Slug Girl",
      :condition => {
        :type => 3,
        :id => 4
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_name_ct01"],
          2 => ["Graphics/Pictures/", "ev_name_ct02"],
          3 => ["Graphics/Pictures/", "ev_name_h01"],
          4 => ["Graphics/Pictures/", "ev_name_h02"],
          5 => ["Graphics/Pictures/", "ev_name_h03"],
          6 => ["Graphics/Pictures/", "ev_name_h04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 2
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_name_hb01"],
          2 => ["Graphics/Pictures/", "ev_name_hb02"],
          3 => ["Graphics/Pictures/", "ev_name_hb03"],
          4 => ["Graphics/Pictures/", "ev_name_hb04"],
          5 => ["Graphics/Pictures/", "ev_name_hb05"],
          6 => ["Graphics/Pictures/", "ev_name_hb06"],
          7 => ["Graphics/Pictures/", "ev_name_hb07"],
          8 => ["Graphics/Pictures/", "ev_name_hb08"],
          9 => ["Graphics/Pictures/", "ev_name_hb09"],
          10 => ["Graphics/Pictures/", "ev_name_hb10"],
          11 => ["Graphics/Pictures/", "ev_name_hb11"],
          12 => ["Graphics/Pictures/", "ev_name_hb12"],
          13 => ["Graphics/Pictures/", "ev_name_hb13"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
        ],
          :condition => {
            :type => 1,
            :id => 3055,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3004,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Semen Slurping Tongue)",
          :common => 4086,
          :condition => {
            :type => 1,
            :id => 3055,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Sluggy Blowjob)",
          :common => 4087,
          :condition => {
            :type => 1,
            :id => 3055,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Mating)",
          :common => 4088,
          :condition => {
            :type => 1,
            :id => 3055,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    121 => {
      :name => "Imp (Rami)",
      :condition => {
        :type => 3,
        :id => 5
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "80_inp_st01"],
          2 => ["Graphics/Pictures/", "ev_inp_hb1"],
          3 => ["Graphics/Pictures/", "ev_inp_hb2"],
          4 => ["Graphics/Pictures/", "ev_inp_hb3"],
          5 => ["Graphics/Pictures/", "ev_inp_hb4"],
          6 => ["Graphics/Pictures/", "ev_inp_ct01"],
          7 => ["Graphics/Pictures/", "ev_inp_ct02"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 6],
          [1, 7],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 19
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_inp_hd1"],
          2 => ["Graphics/Pictures/", "ev_inp_hd2"],
          3 => ["Graphics/Pictures/", "ev_inp_hd3"],
          4 => ["Graphics/Pictures/", "ev_inp_hd4"],
          5 => ["Graphics/Pictures/", "ev_inp_hd5"],
          6 => ["Graphics/Pictures/", "ev_inp_hd6"],
          7 => ["Graphics/Pictures/", "ev_inp_hd7"],
          8 => ["Graphics/Pictures/", "ev_inp_hd8"],
          9 => ["Graphics/Pictures/", "ev_inp_ha1"],
          10 => ["Graphics/Pictures/", "ev_inp_ha2"],
          11 => ["Graphics/Pictures/", "ev_inp_ha3"],
          12 => ["Graphics/Pictures/", "ev_inp_ha4"],
          13 => ["Graphics/Pictures/", "ev_inp_ha5"],
          14 => ["Graphics/Pictures/", "ev_inp_ha6"],
          15 => ["Graphics/Pictures/", "ev_inp_he1"],
          16 => ["Graphics/Pictures/", "ev_inp_he2"],
          17 => ["Graphics/Pictures/", "ev_inp_he3"],
          18 => ["Graphics/Pictures/", "ev_inp_he4"],
          19 => ["Graphics/Pictures/", "ev_inp_he5"],
          20 => ["Graphics/Pictures/", "ev_inp_hc1"],
          21 => ["Graphics/Pictures/", "ev_inp_hc2"],
          22 => ["Graphics/Pictures/", "ev_inp_hc3"],
          23 => ["Graphics/Pictures/", "ev_inp_hc4"],
          24 => ["Graphics/Pictures/", "ev_inp_hg1"],
          25 => ["Graphics/Pictures/", "ev_inp_hg2"],
          26 => ["Graphics/Pictures/", "ev_inp_hg3"],
          27 => ["Graphics/Pictures/", "ev_inp_hg4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
          [26],
          [27],
        ],
          :condition => {
            :type => 1,
            :id => 3056,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3005,
          :background => {
            :id => 19
          }
        },
        2 => {
          :name => "Request 1 (Imp Blowjob)",
          :common => 4091,
          :condition => {
            :type => 1,
            :id => 3056,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Milking)",
          :common => 4092,
          :condition => {
            :type => 1,
            :id => 3056,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Imp Paizuri)",
          :common => 4093,
          :condition => {
            :type => 1,
            :id => 3056,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 4 (Imp Paizuri: Swimsuit)",
          :common => 4095,
          :condition => {
            :type => 1,
            :id => 3056,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        6 => {
          :name => "Request 5 (Imp Rape)",
          :common => 4094,
          :condition => {
            :type => 1,
            :id => 3056,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    122 => {
      :name => "Imp (Rumi)",
      :condition => {
        :type => 2,
        :id => 57
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_inp_st21"],
          2 => ["Graphics/Pictures/", "ev_inp_ct21"],
          3 => ["Graphics/Pictures/", "ev_inp_ct22"],
          4 => ["Graphics/Pictures/", "ev_inp_hf1"],
          5 => ["Graphics/Pictures/", "ev_inp_hf2"],
          6 => ["Graphics/Pictures/", "ev_inp_hf3"],
          7 => ["Graphics/Pictures/", "ev_inp_hf4"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [4],
          [5],
          [6],
          [7],
        ],
          :condition => {
            :type => 1,
            :id => 3057,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Handjob)",
          :common => 4096,
          :condition => {
            :type => 1,
            :id => 3057,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :name => "Request 2 (Threesome)",
          :common => 4097,
          :condition => {
            :type => 1,
            :id => 3057,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    123 => {
      :name => "Imp (Remi)",
      :condition => {
        :type => 2,
        :id => 58
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_inp_st11"],
          2 => ["Graphics/Pictures/", "ev_inp_ct11"],
          3 => ["Graphics/Pictures/", "ev_inp_ct12"],
          4 => ["Graphics/Pictures/", "ev_inp_hf1"],
          5 => ["Graphics/Pictures/", "ev_inp_hf2"],
          6 => ["Graphics/Pictures/", "ev_inp_hf3"],
          7 => ["Graphics/Pictures/", "ev_inp_hf4"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [4],
          [5],
          [6],
          [7],
        ],
          :condition => {
            :type => 1,
            :id => 3058,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Imp Blowjob)",
          :common => 4101,
          :condition => {
            :type => 1,
            :id => 3058,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :name => "Request 2 (Threesome)",
          :common => 4097,
          :condition => {
            :type => 1,
            :id => 3057,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    124 => {
      :name => "Mandragora",
      :condition => {
        :type => 3,
        :id => 6
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_mdg_st01"],
          2 => ["Graphics/Pictures/", "ev_mdg_ct21"],
          3 => ["Graphics/Pictures/", "ev_mdg_ct22"],
          4 => ["Graphics/Pictures/", "ev_mdg_ct23"],
          5 => ["Graphics/Pictures/", "ev_mdg_ct31"],
          6 => ["Graphics/Pictures/", "ev_mdg_ct32"],
          7 => ["Graphics/Pictures/", "ev_mdg_ct33"],
          8 => ["Graphics/Pictures/", "ev_mdg_ct34"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [1, 4],
          [1, 5],
          [1, 6],
          [1, 7],
          [1, 8],
        ],
          :background => {
            :id => 2
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_mdg_st01"],
          2 => ["Graphics/Pictures/", "ev_mdg_ct11"],
          3 => ["Graphics/Pictures/", "ev_mdg_ct12"],
          4 => ["Graphics/Pictures/", "ev_mdg_ct13"],
          5 => ["Graphics/Pictures/", "ev_mdg_h1"],
          6 => ["Graphics/Pictures/", "ev_mdg_h2"],
          7 => ["Graphics/Pictures/", "ev_mdg_h3"],
          8 => ["Graphics/Pictures/", "ev_mdg_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [1, 4],
          [5],
          [6],
          [7],
          [8],
        ],
          :condition => {
            :type => 1,
            :id => 3059,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3006,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 4106,
          :condition => {
            :type => 1,
            :id => 3059,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Blowjob)",
          :common => 4107,
          :condition => {
            :type => 1,
            :id => 3059,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Reverse Rape)",
          :common => 4108,
          :condition => {
            :type => 1,
            :id => 3059,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    125 => {
      :name => "Dog Girl",
      :condition => {
        :type => 3,
        :id => 7
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_dog_h1"],
          2 => ["Graphics/Pictures/", "ev_dog_h2"],
          3 => ["Graphics/Pictures/", "ev_dog_h3"],
          4 => ["Graphics/Pictures/", "ev_dog_h4"],
          5 => ["Graphics/Pictures/", "ev_dog_h5"],
          6 => ["Graphics/Pictures/", "ev_dog_h6"],
          7 => ["Graphics/Pictures/", "ev_dog_h7"],
          8 => ["Graphics/Pictures/", "ev_dog_h8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 2
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3007,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Licking)",
          :common => 4111,
          :condition => {
            :type => 1,
            :id => 3060,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    126 => {
      :name => "Earthworm Girl",
      :condition => {
        :type => 3,
        :id => 8
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_mimizu_h1"],
          2 => ["Graphics/Pictures/", "ev_mimizu_h2"],
          3 => ["Graphics/Pictures/", "ev_mimizu_h3"],
          4 => ["Graphics/Pictures/", "ev_mimizu_h4"],
          5 => ["Graphics/Pictures/", "ev_mimizu_h5"],
          6 => ["Graphics/Pictures/", "ev_mimizu_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 2
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3008,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Sweet Worm)",
          :common => 4116,
          :condition => {
            :type => 1,
            :id => 3061,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    127 => {
      :name => "Goblin Girl",
      :condition => {
        :type => 3,
        :id => 9
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_gob_h1"],
          2 => ["Graphics/Pictures/", "ev_gob_h2"],
          3 => ["Graphics/Pictures/", "ev_gob_h3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :background => {
            :id => 20
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3009,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4121,
          :condition => {
            :type => 1,
            :id => 3062,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    128 => {
      :name => "Greedy Gob",
      :condition => {
        :type => 2,
        :id => 63
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_gob_ha0"],
          2 => ["Graphics/Pictures/", "ev_gob_ha1"],
          3 => ["Graphics/Pictures/", "ev_gob_ha2"],
          4 => ["Graphics/Pictures/", "ev_gob_ha3"],
          5 => ["Graphics/Pictures/", "ev_gob_ha4"],
          6 => ["Graphics/Pictures/", "ev_gob_ha5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3063,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_gob_hb0"],
          2 => ["Graphics/Pictures/", "ev_gob_hb1"],
          3 => ["Graphics/Pictures/", "ev_gob_hb2"],
          4 => ["Graphics/Pictures/", "ev_gob_hb3"],
          5 => ["Graphics/Pictures/", "ev_gob_hb4"],
          6 => ["Graphics/Pictures/", "ev_gob_hb5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3063,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4122,
          :condition => {
            :type => 1,
            :id => 3063,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :name => "Begging 2 (Reverse Rape - Naked)",
          :common => 4123,
          :condition => {
            :type => 1,
            :id => 3063,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },

    129 => {
      :name => "Swift Runner",
      :condition => {
        :type => 2,
        :id => 773
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_gob_hc0"],
          2 => ["Graphics/Pictures/", "ev_gob_hc1"],
          3 => ["Graphics/Pictures/", "ev_gob_hc2"],
          4 => ["Graphics/Pictures/", "ev_gob_hc3"],
          5 => ["Graphics/Pictures/", "ev_gob_hc4"],
          6 => ["Graphics/Pictures/", "ev_gob_hc5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3773,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_gob_hd0"],
          2 => ["Graphics/Pictures/", "ev_gob_hd1"],
          3 => ["Graphics/Pictures/", "ev_gob_hd2"],
          4 => ["Graphics/Pictures/", "ev_gob_hd3"],
          5 => ["Graphics/Pictures/", "ev_gob_hd4"],
          6 => ["Graphics/Pictures/", "ev_gob_hd5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3773,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 6931,
          :condition => {
            :type => 1,
            :id => 3773,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :name => "Begging 2 (Reverse Rape - Naked)",
          :common => 6932,
          :condition => {
            :type => 1,
            :id => 3773,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },

    130 => {
      :name => "Tiny Lamia",
      :condition => {
        :type => 3,
        :id => 10
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_pramia_h1"],
          2 => ["Graphics/Pictures/", "ev_pramia_h2"],
          3 => ["Graphics/Pictures/", "ev_pramia_h3"],
          4 => ["Graphics/Pictures/", "ev_pramia_h4"],
          5 => ["Graphics/Pictures/", "ev_pramia_h5"],
          6 => ["Graphics/Pictures/", "ev_pramia_ct01"],
          7 => ["Graphics/Pictures/", "ev_pramia_ct02"],
          8 => ["Graphics/Pictures/", "ev_pramia_ct03"],
          9 => ["Graphics/Pictures/", "ev_pramia_ct04"],
          10 => ["Graphics/Pictures/", "ev_pramia_ct05"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 6],
          [2, 7],
          [3, 8],
          [4, 9],
          [5, 10],
        ],
          :background => {
            :id => 20
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3010,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4126,
          :condition => {
            :type => 1,
            :id => 3064,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    131 => {
      :name => "Greedy Teeny",
      :condition => {
        :type => 3,
        :id => 911
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_pramia_hb01"],
          2 => ["Graphics/Pictures/", "ev_pramia_hb02"],
          3 => ["Graphics/Pictures/", "ev_pramia_hb03"],
          4 => ["Graphics/Pictures/", "ev_pramia_hb04"],
          5 => ["Graphics/Pictures/", "ev_pramia_hb05"],
          6 => ["Graphics/Pictures/", "ev_pramia_hb06"],
          7 => ["Graphics/Pictures/", "ev_pramia_hb07"],
          8 => ["Graphics/Pictures/", "ev_pramia_hb08"],
          9 => ["Graphics/Pictures/", "ev_pramia_hb09"],
          10 => ["Graphics/Pictures/", "ev_pramia_h10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 19
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3911,
          :background => {
            :id => 19
          }
        },
        2 => {
          :name => "Begging 1 (Wrapped Reverse Rape)",
          :common => 4127,
          :condition => {
            :type => 1,
            :id => 3064,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    132 => {
      :name => "Puchina",
      :condition => {
        :type => 2,
        :id => 774
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_pramia_hc01"],
          2 => ["Graphics/Pictures/", "ev_pramia_hc02"],
          3 => ["Graphics/Pictures/", "ev_pramia_hc03"],
          4 => ["Graphics/Pictures/", "ev_pramia_hc04"],
          5 => ["Graphics/Pictures/", "ev_pramia_hc05"],
          6 => ["Graphics/Pictures/", "ev_pramia_hc06"],
          7 => ["Graphics/Pictures/", "ev_pramia_hc07"],
          8 => ["Graphics/Pictures/", "ev_pramia_hc08"],
          9 => ["Graphics/Pictures/", "ev_pramia_hc09"],
          10 => ["Graphics/Pictures/", "ev_pramia_hc10"],
          11 => ["Graphics/Pictures/", "ev_pramia_hc11"],
          12 => ["Graphics/Pictures/", "ev_pramia_hc12"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
        ],
          :condition => {
            :type => 1,
            :id => 3774,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 6936,
          :condition => {
            :type => 1,
            :id => 3774,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    133 => {
      :name => "Vampire Girl",
      :condition => {
        :type => 3,
        :id => 11
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_vgirl_h1"],
          2 => ["Graphics/Pictures/", "ev_vgirl_h2"],
          3 => ["Graphics/Pictures/", "ev_vgirl_h3"],
          4 => ["Graphics/Pictures/", "ev_vgirl_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 20
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_vgirl_ct01"],
          2 => ["Graphics/Pictures/", "ev_vgirl_ct02"],
          3 => ["Graphics/Pictures/", "ev_vgirl_ct03"],
          4 => ["Graphics/Pictures/", "ev_vgirl_ct04"],
          5 => ["Graphics/Pictures/", "ev_vgirl_ct05"],
          6 => ["Graphics/Pictures/", "ev_vgirl_ct06"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3066,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3011,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Blowjob)",
          :common => 4131,
          :condition => {
            :type => 1,
            :id => 3066,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4132,
          :condition => {
            :type => 1,
            :id => 3066,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    134 => {
      :name => "Greedy Vanilla",
      :condition => {
        :type => 3,
        :id => 912
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_vgirl_hc01"],
          2 => ["Graphics/Pictures/", "ev_vgirl_hc02"],
          3 => ["Graphics/Pictures/", "ev_vgirl_hc03"],
          4 => ["Graphics/Pictures/", "ev_vgirl_hc04"],
          5 => ["Graphics/Pictures/", "ev_vgirl_hc05"],
          6 => ["Graphics/Pictures/", "ev_vgirl_hc06"],
          7 => ["Graphics/Pictures/", "ev_vgirl_hc07"],
          8 => ["Graphics/Pictures/", "ev_vgirl_hc08"],
          9 => ["Graphics/Pictures/", "ev_vgirl_hc09"],
          10 => ["Graphics/Pictures/", "ev_vgirl_hc10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 19
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3912,
          :background => {
            :id => 19
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4133,
          :condition => {
            :type => 1,
            :id => 3066,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    135 => {
      :name => "Vanguard",
      :condition => {
        :type => 2,
        :id => 775
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_vgirl_hf1"],
          2 => ["Graphics/Pictures/", "ev_vgirl_hg1"],
          3 => ["Graphics/Pictures/", "ev_vgirl_hg2"],
          4 => ["Graphics/Pictures/", "ev_vgirl_hg3"],
          5 => ["Graphics/Pictures/", "ev_vgirl_hg4"],
          6 => ["Graphics/Pictures/", "ev_vgirl_hg5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3775,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 6941,
          :condition => {
            :type => 1,
            :id => 3775,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    136 => {
      :name => "Dragon Pup",
      :condition => {
        :type => 3,
        :id => 12
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_dragonp_h1"],
          2 => ["Graphics/Pictures/", "ev_dragonp_h2"],
          3 => ["Graphics/Pictures/", "ev_dragonp_h3"],
          4 => ["Graphics/Pictures/", "ev_dragonp_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 20
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3012,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4136,
          :condition => {
            :type => 1,
            :id => 3068,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    137 => {
      :name => "Greedy Papi",
      :condition => {
        :type => 3,
        :id => 880
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_dragonp_hb1"],
          2 => ["Graphics/Pictures/", "ev_dragonp_hb2"],
          3 => ["Graphics/Pictures/", "ev_dragonp_hb3"],
          4 => ["Graphics/Pictures/", "ev_dragonp_hb4"],
          5 => ["Graphics/Pictures/", "ev_dragonp_hb5"],
          6 => ["Graphics/Pictures/", "ev_dragonp_hb6"],
          7 => ["Graphics/Pictures/", "ev_dragonp_hb7"],
          8 => ["Graphics/Pictures/", "ev_dragonp_hb8"],
          9 => ["Graphics/Pictures/", "ev_dragonp_hb9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 19
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3880,
          :background => {
            :id => 19
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4137,
          :condition => {
            :type => 1,
            :id => 3068,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    138 => {
      :name => "Grandpapi",
      :condition => {
        :type => 2,
        :id => 776
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_dragonp_hc1"],
          2 => ["Graphics/Pictures/", "ev_dragonp_hc2"],
          3 => ["Graphics/Pictures/", "ev_dragonp_hc3"],
          4 => ["Graphics/Pictures/", "ev_dragonp_hc4"],
          5 => ["Graphics/Pictures/", "ev_dragonp_hc5"],
          6 => ["Graphics/Pictures/", "ev_dragonp_hc6"],
          7 => ["Graphics/Pictures/", "ev_dragonp_hc7"],
          8 => ["Graphics/Pictures/", "ev_dragonp_hc8"],
          9 => ["Graphics/Pictures/", "ev_dragonp_hc9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :condition => {
            :type => 1,
            :id => 3776,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 6946,
          :condition => {
            :type => 1,
            :id => 3776,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    139 => {
      :name => "Rat Girl",
      :condition => {
        :type => 3,
        :id => 13
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_nezumi_hb1"],
          2 => ["Graphics/Pictures/", "ev_nezumi_hc1"],
          3 => ["Graphics/Pictures/", "ev_nezumi_hc2"],
          4 => ["Graphics/Pictures/", "ev_nezumi_hc3"],
          5 => ["Graphics/Pictures/", "ev_nezumi_hc4"],
          6 => ["Graphics/Pictures/", "ev_nezumi_hc5"],
          7 => ["Graphics/Pictures/", "ev_nezumi_hc6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 19
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_nezumi_ha1"],
          2 => ["Graphics/Pictures/", "ev_nezumi_ha2"],
          3 => ["Graphics/Pictures/", "ev_nezumi_ha3"],
          4 => ["Graphics/Pictures/", "ev_nezumi_hb1"],
          5 => ["Graphics/Pictures/", "ev_nezumi_hb2"],
          6 => ["Graphics/Pictures/", "ev_nezumi_hb3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3070,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3013,
          :background => {
            :id => 19
          }
        },
        2 => {
          :name => "Request 1 (Handjob)",
          :common => 4141,
          :condition => {
            :type => 1,
            :id => 3070,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Tailjob)",
          :common => 4142,
          :condition => {
            :type => 1,
            :id => 3070,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Reverse Rape)",
          :common => 4143,
          :condition => {
            :type => 1,
            :id => 3070,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    140 => {
      :name => "Wolf Girl",
      :condition => {
        :type => 3,
        :id => 14
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_okami_h1"],
          2 => ["Graphics/Pictures/", "ev_okami_h2"],
          3 => ["Graphics/Pictures/", "ev_okami_h3"],
          4 => ["Graphics/Pictures/", "ev_okami_h4"],
          5 => ["Graphics/Pictures/", "ev_okami_h5"],
          6 => ["Graphics/Pictures/", "ev_okami_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 19
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3014,
          :background => {
            :id => 19
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4146,
          :condition => {
            :type => 1,
            :id => 3071,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    141 => {
      :name => "Phoenix Girl",
      :condition => {
        :type => 3,
        :id => 15
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_phoenix_hb01"],
          2 => ["Graphics/Pictures/", "ev_phoenix_hb02"],
          3 => ["Graphics/Pictures/", "ev_phoenix_hb03"],
          4 => ["Graphics/Pictures/", "ev_phoenix_hb04"],
          5 => ["Graphics/Pictures/", "ev_phoenix_hb05"],
          6 => ["Graphics/Pictures/", "ev_phoenix_hb06"],
          7 => ["Graphics/Pictures/", "ev_phoenix_hb07"],
          8 => ["Graphics/Pictures/", "ev_phoenix_hb08"],
          9 => ["Graphics/Pictures/", "ev_phoenix_hb09"],
          10 => ["Graphics/Pictures/", "ev_phoenix_hb10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 73
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_phoenix_ha1"],
          2 => ["Graphics/Pictures/", "ev_phoenix_ha2"],
          3 => ["Graphics/Pictures/", "ev_phoenix_ha3"],
          4 => ["Graphics/Pictures/", "ev_phoenix_ha4"],
          5 => ["Graphics/Pictures/", "ev_phoenix_ha5"],
          6 => ["Graphics/Pictures/", "ev_phoenix_ha6"],
          7 => ["Graphics/Pictures/", "ev_phoenix_ha7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :condition => {
            :type => 1,
            :id => 3072,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3015,
          :background => {
            :id => 73
          }
        },
        2 => {
          :name => "Request 1 (Blowjob)",
          :common => 4151,
          :condition => {
            :type => 1,
            :id => 3072,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4152,
          :condition => {
            :type => 1,
            :id => 3072,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    142 => {
      :name => "Phoenix Girl (Adult)",
      :condition => {
        :type => 2,
        :id => 72
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_phoenixc_hc1"],
          2 => ["Graphics/Pictures/", "ev_phoenixc_hc2"],
          3 => ["Graphics/Pictures/", "ev_phoenixc_hc3"],
          4 => ["Graphics/Pictures/", "ev_phoenixc_hc4"],
          5 => ["Graphics/Pictures/", "ev_phoenixc_hc5"],
          6 => ["Graphics/Pictures/", "ev_phoenixc_hc6"],
          7 => ["Graphics/Pictures/", "ev_phoenixc_hc7"],
          8 => ["Graphics/Pictures/", "ev_phoenixc_hc8"],
          9 => ["Graphics/Pictures/", "ev_phoenixc_hc9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :condition => {
            :type => 1,
            :id => 3072,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 7976,
          :condition => {
            :type => 1,
            :id => 3072,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    143 => {
      :name => "Phoenix Girl (Rampage)",
      :condition => {
        :type => 3,
        :id => 952
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_phoenixb_hc1"],
          2 => ["Graphics/Pictures/", "ev_phoenixb_hc2"],
          3 => ["Graphics/Pictures/", "ev_phoenixb_hc3"],
          4 => ["Graphics/Pictures/", "ev_phoenixb_hc4"],
          5 => ["Graphics/Pictures/", "ev_phoenixb_hc5"],
          6 => ["Graphics/Pictures/", "ev_phoenixb_hc6"],
          7 => ["Graphics/Pictures/", "ev_phoenixb_hc7"],
          8 => ["Graphics/Pictures/", "ev_phoenixb_hc8"],
          9 => ["Graphics/Pictures/", "ev_phoenixb_hc9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 44
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3952,
          :background => {
            :id => 44
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 7971,
          :condition => {
            :type => 1,
            :id => 3072,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    144 => {
      :name => "Leech Girl",
      :condition => {
        :type => 3,
        :id => 16
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_hiru_st11"],
          2 => ["Graphics/Pictures/", "ev_hiru_st12"],
          3 => ["Graphics/Pictures/", "ev_hiru_st13"],
          4 => ["Graphics/Pictures/", "ev_hiru_st14"],
          5 => ["Graphics/Pictures/", "ev_hiru_ct01"],
          6 => ["Graphics/Pictures/", "ev_hiru_ct02"],
          7 => ["Graphics/Pictures/", "ev_hiru_ct03"],
          8 => ["Graphics/Pictures/", "ev_hiru_ct04"],
          9 => ["Graphics/Pictures/", "ev_hiru_h1"],
          10 => ["Graphics/Pictures/", "ev_hiru_h2"],
          11 => ["Graphics/Pictures/", "ev_hiru_h3"],
          12 => ["Graphics/Pictures/", "ev_hiru_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1, 5],
          [2, 6],
          [3, 7],
          [4, 8],
          [9],
          [10],
          [11],
          [12],
        ],
          :background => {
            :id => 20
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3016,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Fluid Suck)",
          :common => 4156,
          :condition => {
            :type => 1,
            :id => 3073,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    145 => {
      :name => "Rabbit Girl",
      :condition => {
        :type => 3,
        :id => 17
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_usagi_hb1"],
          2 => ["Graphics/Pictures/", "ev_usagi_hb2"],
          3 => ["Graphics/Pictures/", "ev_usagi_hb3"],
          4 => ["Graphics/Pictures/", "ev_usagi_hb4"],
          5 => ["Graphics/Pictures/", "ev_usagi_hb5"],
          6 => ["Graphics/Pictures/", "ev_usagi_hb6"],
          7 => ["Graphics/Pictures/", "ev_usagi_hb7"],
          8 => ["Graphics/Pictures/", "ev_usagi_hb8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 2
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_usagi_ha1"],
          2 => ["Graphics/Pictures/", "ev_usagi_ha2"],
          3 => ["Graphics/Pictures/", "ev_usagi_ha3"],
          4 => ["Graphics/Pictures/", "ev_usagi_ha4"],
          5 => ["Graphics/Pictures/", "ev_usagi_hc1"],
          6 => ["Graphics/Pictures/", "ev_usagi_hc2"],
          7 => ["Graphics/Pictures/", "ev_usagi_hc3"],
          8 => ["Graphics/Pictures/", "ev_usagi_hc4"],
          9 => ["Graphics/Pictures/", "ev_usagi_hc5"],
          10 => ["Graphics/Pictures/", "ev_usagi_hc6"],
          11 => ["Graphics/Pictures/", "ev_usagi_hc7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
        ],
          :condition => {
            :type => 1,
            :id => 3074,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3017,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Stocking Footjob)",
          :common => 4161,
          :condition => {
            :type => 1,
            :id => 3074,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Bare Footjob)",
          :common => 4162,
          :condition => {
            :type => 1,
            :id => 3074,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Reverse Rape)",
          :common => 4163,
          :condition => {
            :type => 1,
            :id => 3074,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    146 => {
      :name => "Sheep Girl",
      :condition => {
        :type => 3,
        :id => 18
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_hituzi_h01"],
          2 => ["Graphics/Pictures/", "ev_hituzi_h02"],
          3 => ["Graphics/Pictures/", "ev_hituzi_h03"],
          4 => ["Graphics/Pictures/", "ev_hituzi_h04"],
          5 => ["Graphics/Pictures/", "ev_hituzi_h05"],
          6 => ["Graphics/Pictures/", "ev_hituzi_h06"],
          7 => ["Graphics/Pictures/", "ev_hituzi_h07"],
          8 => ["Graphics/Pictures/", "ev_hituzi_h08"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 2
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3018,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Blowjob)",
          :common => 4166,
          :condition => {
            :type => 1,
            :id => 3075,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    147 => {
      :name => "Sully",
      :condition => {
        :type => 3,
        :id => 19
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_syuree_h01"],
          2 => ["Graphics/Pictures/", "ev_syuree_h02"],
          3 => ["Graphics/Pictures/", "ev_syuree_h03"],
          4 => ["Graphics/Pictures/", "ev_syuree_h04"],
          5 => ["Graphics/Pictures/", "ev_syuree_h05"],
          6 => ["Graphics/Pictures/", "ev_syuree_h06"],
          7 => ["Graphics/Pictures/", "ev_syuree_h07"],
          8 => ["Graphics/Pictures/", "ev_syuree_h08"],
          9 => ["Graphics/Pictures/", "ev_syuree_h09"],
          10 => ["Graphics/Pictures/", "ev_syuree_h10"],
          11 => ["Graphics/Pictures/", "ev_syuree_h11"],
          12 => ["Graphics/Pictures/", "ev_syuree_h12"],
          13 => ["Graphics/Pictures/", "ev_syuree_h13"],
          14 => ["Graphics/Pictures/", "ev_syuree_h14"],
          15 => ["Graphics/Pictures/", "ev_syuree_h15"],
          16 => ["Graphics/Pictures/", "ev_syuree_h16"],
          17 => ["Graphics/Pictures/", "ev_syuree_h17"],
          18 => ["Graphics/Pictures/", "ev_syuree_h18"],
          19 => ["Graphics/Pictures/", "ev_syuree_h19"],
          20 => ["Graphics/Pictures/", "ev_syuree_h20"],
          21 => ["Graphics/Pictures/", "ev_syuree_h21"],
          22 => ["Graphics/Pictures/", "ev_syuree_h22"],
          23 => ["Graphics/Pictures/", "ev_syuree_h23"],
          24 => ["Graphics/Pictures/", "ev_syuree_h24"],
          25 => ["Graphics/Pictures/", "ev_syuree_h25"],
          26 => ["Graphics/Pictures/", "ev_syuree_h26"],
          27 => ["Graphics/Pictures/", "ev_syuree_h27"],
          28 => ["Graphics/Pictures/", "ev_syuree_h28"],
          29 => ["Graphics/Pictures/", "ev_syuree_h29"],
          30 => ["Graphics/Pictures/", "ev_syuree_h30"],
          31 => ["Graphics/Pictures/", "ev_syuree_h31"],
          32 => ["Graphics/Pictures/", "ev_syuree_h32"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
          [26],
          [27],
          [28],
          [29],
          [30],
          [31],
          [32],
        ],
          :background => {
            :id => 45
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_syuree_hc01"],
          2 => ["Graphics/Pictures/", "ev_syuree_hc02"],
          3 => ["Graphics/Pictures/", "ev_syuree_hc03"],
          4 => ["Graphics/Pictures/", "ev_syuree_hc04"],
          5 => ["Graphics/Pictures/", "ev_syuree_hc05"],
          6 => ["Graphics/Pictures/", "ev_syuree_hc06"],
          7 => ["Graphics/Pictures/", "ev_syuree_hc07"],
          8 => ["Graphics/Pictures/", "ev_syuree_hc08"],
          9 => ["Graphics/Pictures/", "ev_syuree_hc09"],
          10 => ["Graphics/Pictures/", "ev_syuree_hc10"],
          11 => ["Graphics/Pictures/", "ev_syuree_hc11"],
          12 => ["Graphics/Pictures/", "ev_syuree_hc12"],
          13 => ["Graphics/Pictures/", "ev_syuree_hc13"],
          14 => ["Graphics/Pictures/", "ev_syuree_hc14"],
          15 => ["Graphics/Pictures/", "ev_syuree_hc15"],
          16 => ["Graphics/Pictures/", "ev_syuree_hc16"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
        ],
          :condition => {
            :type => 1,
            :id => 3076,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3019,
          :background => {
            :id => 45
          }
        },
        2 => {
          :name => "Request 1 (Dutiful Washing)",
          :common => 4171,
          :condition => {
            :type => 1,
            :id => 3076,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4172,
          :condition => {
            :type => 1,
            :id => 3076,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    148 => {
      :name => "Jaide",
      :condition => {
        :type => 3,
        :id => 20
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_jeid_h01"],
          2 => ["Graphics/Pictures/", "ev_jeid_h02"],
          3 => ["Graphics/Pictures/", "ev_jeid_h03"],
          4 => ["Graphics/Pictures/", "ev_jeid_h04"],
          5 => ["Graphics/Pictures/", "ev_jeid_h05"],
          6 => ["Graphics/Pictures/", "ev_jeid_h06"],
          7 => ["Graphics/Pictures/", "ev_jeid_h07"],
          8 => ["Graphics/Pictures/", "ev_jeid_h08"],
          9 => ["Graphics/Pictures/", "ev_jeid_h09"],
          10 => ["Graphics/Pictures/", "ev_jeid_h10"],
          11 => ["Graphics/Pictures/", "ev_jeid_h11"],
          12 => ["Graphics/Pictures/", "ev_jeid_h12"],
          13 => ["Graphics/Pictures/", "ev_jeid_h13"],
          14 => ["Graphics/Pictures/", "ev_jeid_h14"],
          15 => ["Graphics/Pictures/", "ev_jeid_h15"],
          16 => ["Graphics/Pictures/", "ev_jeid_h16"],
          17 => ["Graphics/Pictures/", "ev_jeid_h17"],
          18 => ["Graphics/Pictures/", "ev_jeid_h18"],
          19 => ["Graphics/Pictures/", "ev_jeid_h19"],
          20 => ["Graphics/Pictures/", "ev_jeid_h20"],
          21 => ["Graphics/Pictures/", "ev_jeid_h21"],
          22 => ["Graphics/Pictures/", "ev_jeid_h22"],
          23 => ["Graphics/Pictures/", "ev_jeid_h23"],
          24 => ["Graphics/Pictures/", "ev_jeid_h24"],
          25 => ["Graphics/Pictures/", "ev_jeid_h25"],
          26 => ["Graphics/Pictures/", "ev_jeid_h26"],
          27 => ["Graphics/Pictures/", "ev_jeid_h27"],
          28 => ["Graphics/Pictures/", "ev_jeid_h28"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
          [26],
          [27],
          [28],
        ],
          :background => {
            :id => 45
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_jeid_hb01"],
          2 => ["Graphics/Pictures/", "ev_jeid_hb02"],
          3 => ["Graphics/Pictures/", "ev_jeid_hb03"],
          4 => ["Graphics/Pictures/", "ev_jeid_hb04"],
          5 => ["Graphics/Pictures/", "ev_jeid_hb05"],
          6 => ["Graphics/Pictures/", "ev_jeid_hb06"],
          7 => ["Graphics/Pictures/", "ev_jeid_hb07"],
          8 => ["Graphics/Pictures/", "ev_jeid_hb08"],
          9 => ["Graphics/Pictures/", "ev_jeid_hb09"],
          10 => ["Graphics/Pictures/", "ev_jeid_hb10"],
          11 => ["Graphics/Pictures/", "ev_jeid_hb11"],
          12 => ["Graphics/Pictures/", "ev_jeid_hb12"],
          13 => ["Graphics/Pictures/", "ev_jeid_hb13"],
          14 => ["Graphics/Pictures/", "ev_jeid_hb14"],
          15 => ["Graphics/Pictures/", "ev_jeid_hb15"],
          16 => ["Graphics/Pictures/", "ev_jeid_hb16"],
          17 => ["Graphics/Pictures/", "ev_jeid_hb17"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
        ],
          :condition => {
            :type => 1,
            :id => 3077,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3020,
          :background => {
            :id => 45
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4176,
          :condition => {
            :type => 1,
            :id => 3077,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Blowjob)",
          :common => 4177,
          :condition => {
            :type => 1,
            :id => 3077,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    149 => {
      :name => "Shesta",
      :condition => {
        :type => 3,
        :id => 21
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_syesta_h01"],
          2 => ["Graphics/Pictures/", "ev_syesta_h02"],
          3 => ["Graphics/Pictures/", "ev_syesta_h03"],
          4 => ["Graphics/Pictures/", "ev_syesta_h04"],
          5 => ["Graphics/Pictures/", "ev_syesta_h05"],
          6 => ["Graphics/Pictures/", "ev_syesta_h06"],
          7 => ["Graphics/Pictures/", "ev_syesta_h07"],
          8 => ["Graphics/Pictures/", "ev_syesta_h08"],
          9 => ["Graphics/Pictures/", "ev_syesta_h09"],
          10 => ["Graphics/Pictures/", "ev_syesta_h10"],
          11 => ["Graphics/Pictures/", "ev_syesta_h11"],
          12 => ["Graphics/Pictures/", "ev_syesta_h12"],
          13 => ["Graphics/Pictures/", "ev_syesta_h13"],
          14 => ["Graphics/Pictures/", "ev_syesta_h14"],
          15 => ["Graphics/Pictures/", "ev_syesta_h15"],
          16 => ["Graphics/Pictures/", "ev_syesta_h16"],
          17 => ["Graphics/Pictures/", "ev_syesta_h17"],
          18 => ["Graphics/Pictures/", "ev_syesta_h18"],
          19 => ["Graphics/Pictures/", "ev_syesta_h19"],
          20 => ["Graphics/Pictures/", "ev_syesta_h20"],
          21 => ["Graphics/Pictures/", "ev_syesta_h21"],
          22 => ["Graphics/Pictures/", "ev_syesta_h22"],
          23 => ["Graphics/Pictures/", "ev_syesta_h23"],
          24 => ["Graphics/Pictures/", "ev_syesta_h24"],
          25 => ["Graphics/Pictures/", "ev_syesta_h25"],
          26 => ["Graphics/Pictures/", "ev_syesta_h26"],
          27 => ["Graphics/Pictures/", "ev_syesta_h27"],
          28 => ["Graphics/Pictures/", "ev_syesta_h28"],
          29 => ["Graphics/Pictures/", "ev_syesta_h29"],
          30 => ["Graphics/Pictures/", "ev_syesta_h30"],
          31 => ["Graphics/Pictures/", "ev_syesta_h31"],
          32 => ["Graphics/Pictures/", "ev_syesta_h32"],
          33 => ["Graphics/Pictures/", "ev_syesta_h33"],
          34 => ["Graphics/Pictures/", "ev_syesta_h34"],
          35 => ["Graphics/Pictures/", "ev_syesta_h35"],
          36 => ["Graphics/Pictures/", "ev_syesta_h36"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
          [26],
          [27],
          [28],
          [29],
          [30],
          [31],
          [32],
          [33],
          [34],
          [35],
          [36],
        ],
          :background => {
            :id => 45
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3021,
          :background => {
            :id => 45
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Hole)",
          :common => 4181,
          :condition => {
            :type => 1,
            :id => 3078,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    150 => {
      :name => "Orc Girl",
      :condition => {
        :type => 3,
        :id => 23
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_orc_st01"],
          2 => ["Graphics/Pictures/", "ev_orc_ct01"],
          3 => ["Graphics/Pictures/", "ev_orc_ct02"],
          4 => ["Graphics/Pictures/", "ev_orc_ct03"],
          5 => ["Graphics/Pictures/", "ev_orc_h1"],
          6 => ["Graphics/Pictures/", "ev_orc_h2"],
          7 => ["Graphics/Pictures/", "ev_orc_h3"],
          8 => ["Graphics/Pictures/", "ev_orc_h4"],
          9 => ["Graphics/Pictures/", "ev_orc_h5"],
          10 => ["Graphics/Pictures/", "ev_orc_h6"],
          11 => ["Graphics/Pictures/", "ev_orc_h7"],
          12 => ["Graphics/Pictures/", "ev_orc_h8"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [1, 4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
        ],
          :background => {
            :id => 2
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3023,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4191,
          :condition => {
            :type => 1,
            :id => 3080,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    151 => {
      :name => "Bee Girl",
      :condition => {
        :type => 3,
        :id => 24
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_mitubati_h1"],
          2 => ["Graphics/Pictures/", "ev_mitubati_h2"],
          3 => ["Graphics/Pictures/", "ev_mitubati_h3"],
          4 => ["Graphics/Pictures/", "ev_mitubati_h4"],
          5 => ["Graphics/Pictures/", "ev_mitubati_ct01"],
          6 => ["Graphics/Pictures/", "ev_mitubati_ct02"],
          7 => ["Graphics/Pictures/", "ev_mitubati_ct03"],
          8 => ["Graphics/Pictures/", "ev_mitubati_ct04"],
          9 => ["Graphics/Pictures/", "ev_mitubati_ctb01"],
          10 => ["Graphics/Pictures/", "ev_mitubati_ctb02"],
          11 => ["Graphics/Pictures/", "ev_mitubati_ctb03"],
          12 => ["Graphics/Pictures/", "ev_mitubati_ctb04"],
          13 => ["Graphics/Pictures/", "ev_mitubati_hb1"],
          14 => ["Graphics/Pictures/", "ev_mitubati_hb2"],
          15 => ["Graphics/Pictures/", "ev_mitubati_hb3"],
          16 => ["Graphics/Pictures/", "ev_mitubati_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 5],
          [2, 6],
          [2, 7],
          [2, 8],
          [1, 9],
          [2, 10],
          [3, 11],
          [4, 12],
          [13],
          [14],
          [15],
          [16],
        ],
          :background => {
            :id => 3
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3024,
          :background => {
            :id => 3
          }
        },
        2 => {
          :name => "Request 1 (Licking)",
          :common => 4196,
          :condition => {
            :type => 1,
            :id => 3081,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Mating)",
          :common => 4197,
          :condition => {
            :type => 1,
            :id => 3081,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    152 => {
      :name => "Sparrow Girl",
      :condition => {
        :type => 3,
        :id => 25
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_suzume_h1"],
          2 => ["Graphics/Pictures/", "ev_suzume_h2"],
          3 => ["Graphics/Pictures/", "ev_suzume_h3"],
          4 => ["Graphics/Pictures/", "ev_suzume_h4"],
          5 => ["Graphics/Pictures/", "ev_suzume_h5"],
          6 => ["Graphics/Pictures/", "ev_suzume_h6"],
          7 => ["Graphics/Pictures/", "ev_suzume_h7"],
          8 => ["Graphics/Pictures/", "ev_suzume_h8"],
          9 => ["Graphics/Pictures/", "ev_suzume_h9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 3
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3025,
          :background => {
            :id => 3
          }
        },
        2 => {
          :name => "Request 1 (Mating)",
          :common => 4201,
          :condition => {
            :type => 1,
            :id => 3082,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    153 => {
      :name => "Harpy",
      :condition => {
        :type => 3,
        :id => 26
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_hapy_a_ct01"],
          2 => ["Graphics/Pictures/", "ev_hapy_a_ct02"],
          3 => ["Graphics/Pictures/", "ev_hapy_a_ct03"],
          4 => ["Graphics/Pictures/", "ev_hapy_a_h1"],
          5 => ["Graphics/Pictures/", "ev_hapy_a_h2"],
          6 => ["Graphics/Pictures/", "ev_hapy_a_h3"],
          7 => ["Graphics/Pictures/", "ev_hapy_a_h4"],
          8 => ["Graphics/Pictures/", "ev_hapy_a_h5"],
          9 => ["Graphics/Pictures/", "ev_hapy_a_h6"],
          10 => ["Graphics/Pictures/", "ev_hapy_a_h7"],
          11 => ["Graphics/Pictures/", "ev_hapy_a_h8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
        ],
          :background => {
            :id => 25
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3026,
          :background => {
            :id => 25
          }
        },
        2 => {
          :name => "Request 1 (Mating)",
          :common => 4206,
          :condition => {
            :type => 1,
            :id => 3083,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    154 => {
      :name => "Harpy Sisters",
      :condition => {
        :type => 3,
        :id => 27
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_hapy_bc_ct11"],
          2 => ["Graphics/Pictures/", "ev_hapy_bc_ct12"],
          3 => ["Graphics/Pictures/", "ev_hapy_bc_ct13"],
          4 => ["Graphics/Pictures/", "ev_hapy_bc_ct21"],
          5 => ["Graphics/Pictures/", "ev_hapy_bc_ct22"],
          6 => ["Graphics/Pictures/", "ev_hapy_bc_ct23"],
          7 => ["Graphics/Pictures/", "ev_hapy_bc_ha1"],
          8 => ["Graphics/Pictures/", "ev_hapy_bc_ha2"],
          9 => ["Graphics/Pictures/", "ev_hapy_bc_ha3"],
          10 => ["Graphics/Pictures/", "ev_hapy_bc_ha4"],
          11 => ["Graphics/Pictures/", "ev_hapy_bc_hb1"],
          12 => ["Graphics/Pictures/", "ev_hapy_bc_hb2"],
          13 => ["Graphics/Pictures/", "ev_hapy_bc_hb3"],
          14 => ["Graphics/Pictures/", "ev_hapy_bc_hc1"],
          15 => ["Graphics/Pictures/", "ev_hapy_bc_hc2"],
          16 => ["Graphics/Pictures/", "ev_hapy_bc_ct01"],
          17 => ["Graphics/Pictures/", "ev_hapy_bc_ct02"],
          18 => ["Graphics/Pictures/", "ev_hapy_bc_ct03"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [14, 16],
          [15, 17],
          [15, 18],
          [11],
          [12],
          [13],
        ],
          :background => {
            :id => 25
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3027,
          :background => {
            :id => 25
          }
        },
        2 => {
          :name => "Request 1 (Blowjob)",
          :common => 4211,
          :condition => {
            :type => 1,
            :id => 3084,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Big Sister Mating)",
          :common => 4212,
          :condition => {
            :type => 1,
            :id => 3084,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Little Sister Mating)",
          :common => 4213,
          :condition => {
            :type => 1,
            :id => 3084,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    155 => {
      :name => "Queen Harpy",
      :condition => {
        :type => 3,
        :id => 28
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_queenhapy_hb1"],
          2 => ["Graphics/Pictures/", "ev_queenhapy_hb2"],
          3 => ["Graphics/Pictures/", "ev_queenhapy_hb3"],
          4 => ["Graphics/Pictures/", "ev_queenhapy_hb4"],
          5 => ["Graphics/Pictures/", "ev_queenhapy_hb5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 25
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_queenhapy_h1"],
          2 => ["Graphics/Pictures/", "ev_queenhapy_h2"],
          3 => ["Graphics/Pictures/", "ev_queenhapy_h3"],
          4 => ["Graphics/Pictures/", "ev_queenhapy_h4"],
          5 => ["Graphics/Pictures/", "ev_queenhapy_ct01"],
          6 => ["Graphics/Pictures/", "ev_queenhapy_ct02"],
          7 => ["Graphics/Pictures/", "ev_queenhapy_ct03"],
          8 => ["Graphics/Pictures/", "ev_queenhapy_ct04"],
          9 => ["Graphics/Pictures/", "80_queenhapy_st02"],
          10 => ["Graphics/Pictures/", "ev_queenhapy_ct11"],
          11 => ["Graphics/Pictures/", "ev_queenhapy_ct12"],
          12 => ["Graphics/Pictures/", "ev_queenhapy_ct13"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,5],
          [2,6],
          [3,7],
          [4,8],
          [9,10],
          [9,11],
          [9,12],
        ],
          :condition => {
            :type => 1,
            :id => 3323,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3028,
          :background => {
            :id => 25
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5431,
          :condition => {
            :type => 1,
            :id => 3323,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    156 => {
      :name => "High Slug Girl",
      :condition => {
        :type => 3,
        :id => 29
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_highslag_hc01"],
          2 => ["Graphics/Pictures/", "ev_highslag_hc02"],
          3 => ["Graphics/Pictures/", "ev_highslag_hc03"],
          4 => ["Graphics/Pictures/", "ev_highslag_hc04"],
          5 => ["Graphics/Pictures/", "ev_highslag_hb01"],
          6 => ["Graphics/Pictures/", "ev_highslag_hb02"],
          7 => ["Graphics/Pictures/", "ev_highslag_hb03"],
          8 => ["Graphics/Pictures/", "ev_highslag_hb04"],
          9 => ["Graphics/Pictures/", "ev_highslag_hb05"],
          10 => ["Graphics/Pictures/", "ev_highslag_hb06"],
          11 => ["Graphics/Pictures/", "ev_highslag_hb07"],
          12 => ["Graphics/Pictures/", "ev_highslag_hb08"],
          13 => ["Graphics/Pictures/", "ev_highslag_hb09"],
          14 => ["Graphics/Pictures/", "ev_highslag_hb10"],
          15 => ["Graphics/Pictures/", "ev_highslag_ct01"],
          16 => ["Graphics/Pictures/", "ev_highslag_ct02"],
          17 => ["Graphics/Pictures/", "ev_highslag_ct03"],
          18 => ["Graphics/Pictures/", "ev_highslag_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],

          [5],
          [6],
          [7],
          [8],
          [8, 15],
          [9, 16],
          [10, 16],
          [11, 17],
          [12, 17],
          [13, 18],
          [14, 18],
        ],
          :background => {
            :id => 26
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_highslag_ha1"],
          2 => ["Graphics/Pictures/", "ev_highslag_ha2"],
          3 => ["Graphics/Pictures/", "ev_highslag_ha3"],
          4 => ["Graphics/Pictures/", "ev_highslag_hc05"],
          5 => ["Graphics/Pictures/", "ev_highslag_hc06"],
          6 => ["Graphics/Pictures/", "ev_highslag_hc07"],
          7 => ["Graphics/Pictures/", "ev_highslag_hc08"],
          8 => ["Graphics/Pictures/", "ev_highslag_hc09"],
          9 => ["Graphics/Pictures/", "ev_highslag_hc10"],
          10 => ["Graphics/Pictures/", "ev_highslag_hc11"],
          11 => ["Graphics/Pictures/", "ev_highslag_hc12"],
          12 => ["Graphics/Pictures/", "ev_highslag_hc13"],
          13 => ["Graphics/Pictures/", "ev_highslag_hc14"],
          14 => ["Graphics/Pictures/", "ev_highslag_hc15"],
          15 => ["Graphics/Pictures/", "ev_highslag_hc16"],
          16 => ["Graphics/Pictures/", "ev_highslag_hc17"],
          17 => ["Graphics/Pictures/", "ev_highslag_hc18"],
          18 => ["Graphics/Pictures/", "ev_highslag_hc19"],
          19 => ["Graphics/Pictures/", "ev_highslag_hc20"],
          20 => ["Graphics/Pictures/", "ev_highslag_hc21"],
          21 => ["Graphics/Pictures/", "ev_highslag_hc22"],
          22 => ["Graphics/Pictures/", "ev_highslag_hc23"],
          23 => ["Graphics/Pictures/", "ev_highslag_hc24"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
        ],
          :condition => {
            :type => 1,
            :id => 3085,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3029,
          :background => {
            :id => 26
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 4216,
          :condition => {
            :type => 1,
            :id => 3085,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Slimy Body Rub)",
          :common => 4217,
          :condition => {
            :type => 1,
            :id => 3085,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Predation)",
          :common => 4218,
          :condition => {
            :type => 1,
            :id => 3085,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 4 (Reverse Rape)",
          :common => 4219,
          :condition => {
            :type => 1,
            :id => 3085,
            :op => 1,
            :value => 80
          },
          :background => {
            :id => 1
          }
        },
        6 => {
          :name => "Request 5 (Futanari Rape)",
          :common => 4220,
          :condition => {
            :type => 1,
            :id => 3085,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    157 => {
      :name => "Slug Nun",
      :condition => {
        :type => 3,
        :id => 30
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_name_s_ha1"],
          2 => ["Graphics/Pictures/", "ev_name_s_ha2"],
          3 => ["Graphics/Pictures/", "ev_name_s_hb1"],
          4 => ["Graphics/Pictures/", "ev_name_s_hb2"],
          5 => ["Graphics/Pictures/", "ev_name_s_hb3"],
          6 => ["Graphics/Pictures/", "ev_name_s_hb4"],
          7 => ["Graphics/Pictures/", "ev_name_s_hb5"],
          8 => ["Graphics/Pictures/", "ev_name_s_hb6"],
          9 => ["Graphics/Pictures/", "ev_name_s_hb7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 26
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_name_s_hc1"],
          2 => ["Graphics/Pictures/", "ev_name_s_hc2"],
          3 => ["Graphics/Pictures/", "ev_name_s_hc3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :condition => {
            :type => 1,
            :id => 3086,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3030,
          :background => {
            :id => 26
          }
        },
        2 => {
          :name => "Request 1 (Blowjob)",
          :common => 4221,
          :condition => {
            :type => 1,
            :id => 3086,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Paizuri)",
          :common => 4222,
          :condition => {
            :type => 1,
            :id => 3086,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    158 => {
      :name => "Sluggy Stars",
      :condition => {
        :type => 3,
        :id => 31
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_name2_ha01"],
          2 => ["Graphics/Pictures/", "ev_name2_ha02"],
          3 => ["Graphics/Pictures/", "ev_name2_ha03"],
          4 => ["Graphics/Pictures/", "ev_name2_ha04"],
          5 => ["Graphics/Pictures/", "ev_name2_ha05"],
          6 => ["Graphics/Pictures/", "ev_name2_ha06"],
          7 => ["Graphics/Pictures/", "ev_name2_ha07"],
          8 => ["Graphics/Pictures/", "ev_name2_ha08"],
          9 => ["Graphics/Pictures/", "ev_name2_ha09"],
          10 => ["Graphics/Pictures/", "ev_name2_ha10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 74
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_name2_hb01"],
          2 => ["Graphics/Pictures/", "ev_name2_hb02"],
          3 => ["Graphics/Pictures/", "ev_name2_hb03"],
          4 => ["Graphics/Pictures/", "ev_name2_hb04"],
          5 => ["Graphics/Pictures/", "ev_name2_hb05"],
          6 => ["Graphics/Pictures/", "ev_name2_hb06"],
          7 => ["Graphics/Pictures/", "ev_name2_hb07"],
          8 => ["Graphics/Pictures/", "ev_name2_hb08"],
          9 => ["Graphics/Pictures/", "ev_name2_hb09"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :condition => {
            :type => 1,
            :id => 3087,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_name2_hc1"],
          2 => ["Graphics/Pictures/", "ev_name2_hc2"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3031,
          :background => {
            :id => 74
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing)",
          :common => 4226,
          :condition => {
            :type => 1,
            :id => 3087,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Mating)",
          :common => 4227,
          :condition => {
            :type => 1,
            :id => 3087,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Loop Event (Entwined Mating)",
          :common => 5819,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    159 => {
      :name => "Jack O Lantern",
      :condition => {
        :type => 3,
        :id => 32
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_jack_ha01"],
          2 => ["Graphics/Pictures/", "ev_jack_ha02"],
          3 => ["Graphics/Pictures/", "ev_jack_ha03"],
          4 => ["Graphics/Pictures/", "ev_jack_ha04"],
          5 => ["Graphics/Pictures/", "ev_jack_ha05"],
          6 => ["Graphics/Pictures/", "ev_jack_ha06"],
          7 => ["Graphics/Pictures/", "ev_jack_ha07"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 3
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3032,
          :background => {
            :id => 3
          }
        },
        2 => {
          :name => "Request 1 (Handjob)",
          :common => 4231,
          :condition => {
            :type => 1,
            :id => 3088,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    160 => {
      :name => "Roper Girl",
      :condition => {
        :type => 3,
        :id => 33
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_ropa_h1"],
          2 => ["Graphics/Pictures/", "ev_ropa_h2"],
          3 => ["Graphics/Pictures/", "ev_ropa_h3"],
          4 => ["Graphics/Pictures/", "ev_ropa_h4"],
          5 => ["Graphics/Pictures/", "ev_ropa_h5"],
          6 => ["Graphics/Pictures/", "ev_ropa_ct01"],
          7 => ["Graphics/Pictures/", "ev_ropa_ct02"],
          8 => ["Graphics/Pictures/", "ev_ropa_ct03"],
          9 => ["Graphics/Pictures/", "ev_ropa_ct04"],
          10 => ["Graphics/Pictures/", "ev_ropa_hb1"],
          11 => ["Graphics/Pictures/", "ev_ropa_hb2"],
          12 => ["Graphics/Pictures/", "ev_ropa_hb3"],
          13 => ["Graphics/Pictures/", "ev_ropa_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1, 6],
          [2, 7],
          [3, 8],
          [4, 9],
          [5],
          [10],
          [11],
          [12],
          [13],
        ],
          :background => {
            :id => 19
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3033,
          :background => {
            :id => 19
          }
        },
        2 => {
          :name => "Request 1 (Predation)",
          :common => 4236,
          :condition => {
            :type => 1,
            :id => 3089,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Predation...?)",
          :common => 4237,
          :condition => {
            :type => 1,
            :id => 3089,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    161 => {
      :name => "Meda Girl",
      :condition => {
        :type => 3,
        :id => 34
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_meda_h1"],
          2 => ["Graphics/Pictures/", "ev_meda_h2"],
          3 => ["Graphics/Pictures/", "ev_meda_h3"],
          4 => ["Graphics/Pictures/", "ev_meda_h4"],
          5 => ["Graphics/Pictures/", "ev_meda_ct01"],
          6 => ["Graphics/Pictures/", "ev_meda_ct02"],
          7 => ["Graphics/Pictures/", "ev_meda_ct03"],
          8 => ["Graphics/Pictures/", "ev_meda_ct04"],
          9 => ["Graphics/Pictures/", "ev_meda_ha1"],
          10 => ["Graphics/Pictures/", "ev_meda_ha2"],
          11 => ["Graphics/Pictures/", "ev_meda_ha3"],
          12 => ["Graphics/Pictures/", "ev_meda_ha4"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 5],
          [2, 6],
          [3, 7],
          [4, 8],
          [9],
          [10],
          [11],
          [12],
        ],
          :background => {
            :id => 19
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3034,
          :background => {
            :id => 19
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Hole 1)",
          :common => 4241,
          :condition => {
            :type => 1,
            :id => 3090,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Semen Squeezing Hole 2)",
          :common => 4242,
          :condition => {
            :type => 1,
            :id => 3090,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    162 => {
      :name => "Candle Girl",
      :condition => {
        :type => 3,
        :id => 35
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_candle_h1"],
          2 => ["Graphics/Pictures/", "ev_candle_h2"],
          3 => ["Graphics/Pictures/", "ev_candle_h3"],
          4 => ["Graphics/Pictures/", "ev_candle_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 19
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_candle_hb1"],
          2 => ["Graphics/Pictures/", "ev_candle_hb2"],
          3 => ["Graphics/Pictures/", "ev_candle_hb3"],
          4 => ["Graphics/Pictures/", "ev_candle_hc1"],
          5 => ["Graphics/Pictures/", "ev_candle_hc2"],
          6 => ["Graphics/Pictures/", "ev_candle_hc3"],
          7 => ["Graphics/Pictures/", "ev_candle_hc4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :condition => {
            :type => 1,
            :id => 3091,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3035,
          :background => {
            :id => 19
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Wax)",
          :common => 4246,
          :condition => {
            :type => 1,
            :id => 3091,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Wax Paizuri)",
          :common => 4247,
          :condition => {
            :type => 1,
            :id => 3091,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Wax Sandwich)",
          :common => 4248,
          :condition => {
            :type => 1,
            :id => 3091,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    163 => {
      :name => "Eater",
      :condition => {
        :type => 3,
        :id => 36
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_eater_h01"],
          2 => ["Graphics/Pictures/", "ev_eater_h02"],
          3 => ["Graphics/Pictures/", "ev_eater_h03"],
          4 => ["Graphics/Pictures/", "ev_eater_h04"],
          5 => ["Graphics/Pictures/", "ev_eater_h05"],
          6 => ["Graphics/Pictures/", "ev_eater_h06"],
          7 => ["Graphics/Pictures/", "ev_eater_h07"],
          8 => ["Graphics/Pictures/", "ev_eater_h08"],
          9 => ["Graphics/Pictures/", "ev_eater_h09"],
          10 => ["Graphics/Pictures/", "ev_eater_h10"],
          11 => ["Graphics/Pictures/", "ev_eater_h11"],
          12 => ["Graphics/Pictures/", "ev_eater_h12"],
          13 => ["Graphics/Pictures/", "ev_eater_h13"],
          14 => ["Graphics/Pictures/", "ev_eater_h14"],
          15 => ["Graphics/Pictures/", "ev_eater_h15"],
          16 => ["Graphics/Pictures/", "ev_eater_h16"],
          17 => ["Graphics/Pictures/", "ev_eater_h17"],
          18 => ["Graphics/Pictures/", "ev_eater_h18"],
          19 => ["Graphics/Pictures/", "ev_eater_h19"],
          20 => ["Graphics/Pictures/", "ev_eater_h20"],
          21 => ["Graphics/Pictures/", "ev_eater_h21"],
          22 => ["Graphics/Pictures/", "ev_eater_h22"],
          23 => ["Graphics/Pictures/", "ev_eater_h23"],
          24 => ["Graphics/Pictures/", "ev_eater_h24"],
          25 => ["Graphics/Pictures/", "ev_eater_h25"],
          26 => ["Graphics/Pictures/", "ev_eater_h26"],
          27 => ["Graphics/Pictures/", "ev_eater_h27"],
          28 => ["Graphics/Pictures/", "ev_eater_h28"],
          29 => ["Graphics/Pictures/", "ev_eater_h29"],
          30 => ["Graphics/Pictures/", "ev_eater_h30"],
          31 => ["Graphics/Pictures/", "ev_eater_h31"],
          32 => ["Graphics/Pictures/", "ev_eater_h32"],
          33 => ["Graphics/Pictures/", "ev_eater_h33"],
          34 => ["Graphics/Pictures/", "ev_eater_h34"],
          35 => ["Graphics/Pictures/", "ev_eater_h35"],
          36 => ["Graphics/Pictures/", "ev_eater_h36"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
          [26],
          [27],
          [28],
          [29],
          [30],
          [31],
          [32],
          [33],
          [34],
          [35],
          [36],
        ],
          :background => {
            :id => 45
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3036,
          :background => {
            :id => 45
          }
        },
        2 => {
          :name => "Request 1 (Predation)",
          :common => 4251,
          :condition => {
            :type => 1,
            :id => 3092,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    164 => {
      :name => "Riot",
      :condition => {
        :type => 3,
        :id => 37
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_liot_ha01"],
          2 => ["Graphics/Pictures/", "ev_liot_ha02"],
          3 => ["Graphics/Pictures/", "ev_liot_ha03"],
          4 => ["Graphics/Pictures/", "ev_liot_ha04"],
          5 => ["Graphics/Pictures/", "ev_liot_ha05"],
          6 => ["Graphics/Pictures/", "ev_liot_ha06"],
          7 => ["Graphics/Pictures/", "ev_liot_ha07"],
          8 => ["Graphics/Pictures/", "ev_liot_ha08"],
          9 => ["Graphics/Pictures/", "ev_liot_ha09"],
          10 => ["Graphics/Pictures/", "ev_liot_ha10"],
          11 => ["Graphics/Pictures/", "ev_liot_ha11"],
          12 => ["Graphics/Pictures/", "ev_liot_ha12"],
          13 => ["Graphics/Pictures/", "ev_liot_ha13"],
          14 => ["Graphics/Pictures/", "ev_liot_ha14"],
          15 => ["Graphics/Pictures/", "ev_liot_ha15"],
          16 => ["Graphics/Pictures/", "ev_liot_ha16"],
          17 => ["Graphics/Pictures/", "ev_liot_ha17"],
          18 => ["Graphics/Pictures/", "ev_liot_ha18"],
          19 => ["Graphics/Pictures/", "ev_liot_ha19"],
          20 => ["Graphics/Pictures/", "ev_liot_ha20"],
          21 => ["Graphics/Pictures/", "ev_liot_ha21"],
          22 => ["Graphics/Pictures/", "ev_liot_ha22"],
          23 => ["Graphics/Pictures/", "ev_liot_ha23"],
          24 => ["Graphics/Pictures/", "ev_liot_ha24"],
          25 => ["Graphics/Pictures/", "ev_liot_ha25"],
          26 => ["Graphics/Pictures/", "ev_liot_ha26"],
          27 => ["Graphics/Pictures/", "ev_liot_ha27"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
          [26],
          [27],
        ],
          :background => {
            :id => 45
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_liot_hb01"],
          2 => ["Graphics/Pictures/", "ev_liot_hb02"],
          3 => ["Graphics/Pictures/", "ev_liot_hb03"],
          4 => ["Graphics/Pictures/", "ev_liot_hb04"],
          5 => ["Graphics/Pictures/", "ev_liot_hb05"],
          6 => ["Graphics/Pictures/", "ev_liot_hb06"],
          7 => ["Graphics/Pictures/", "ev_liot_hb07"],
          8 => ["Graphics/Pictures/", "ev_liot_hb08"],
          9 => ["Graphics/Pictures/", "ev_liot_hb09"],
          10 => ["Graphics/Pictures/", "ev_liot_hb10"],
          11 => ["Graphics/Pictures/", "ev_liot_hb11"],
          12 => ["Graphics/Pictures/", "ev_liot_hb12"],
          13 => ["Graphics/Pictures/", "ev_liot_hb13"],
          14 => ["Graphics/Pictures/", "ev_liot_hb14"],
          15 => ["Graphics/Pictures/", "ev_liot_hb15"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
        ],
          :condition => {
            :type => 1,
            :id => 3093,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3037,
          :background => {
            :id => 45
          }
        },
        2 => {
          :name => "Request 1 (Mating)",
          :common => 4256,
          :condition => {
            :type => 1,
            :id => 3093,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Onahole)",
          :common => 4257,
          :condition => {
            :type => 1,
            :id => 3093,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    165 => {
      :name => "Luxuru",
      :condition => {
        :type => 3,
        :id => 38
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_luksl_ha1"],
          2 => ["Graphics/Pictures/", "ev_luksl_ha2"],
          3 => ["Graphics/Pictures/", "ev_luksl_ha3"],
          4 => ["Graphics/Pictures/", "ev_luksl_ha4"],
          5 => ["Graphics/Pictures/", "ev_luksl_ha5"],
          6 => ["Graphics/Pictures/", "ev_luksl_ct01"],
          7 => ["Graphics/Pictures/", "ev_luksl_ct02"],
          8 => ["Graphics/Pictures/", "ev_luksl_ct03"],
          9 => ["Graphics/Pictures/", "ev_luksl_ct04"],
          10 => ["Graphics/Pictures/", "ev_luksl_hb1"],
          11 => ["Graphics/Pictures/", "ev_luksl_hb2"],
          12 => ["Graphics/Pictures/", "ev_luksl_hb3"],
          13 => ["Graphics/Pictures/", "ev_luksl_hb4"],
          14 => ["Graphics/Pictures/", "ev_luksl_hb5"],
          15 => ["Graphics/Pictures/", "ev_luksl_hb6"],
          16 => ["Graphics/Pictures/", "ev_luksl_hb7"],
          17 => ["Graphics/Pictures/", "ev_luksl_hb8"],
          18 => ["Graphics/Pictures/", "ev_luksl_hb9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1, 6],
          [2, 7],
          [3, 8],
          [4, 8],
          [5, 9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
        ],
          :background => {
            :id => 45
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3038,
          :background => {
            :id => 45
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Execution)",
          :common => 4261,
          :condition => {
            :type => 1,
            :id => 3094,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Semen Squeezing Execution...?)",
          :common => 4262,
          :condition => {
            :type => 1,
            :id => 3094,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    166 => {
      :name => "Dark Elf Fencer",
      :condition => {
        :type => 3,
        :id => 39
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_delh_a_h1"],
          2 => ["Graphics/Pictures/", "ev_delh_a_h2"],
          3 => ["Graphics/Pictures/", "ev_delh_a_h3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :background => {
            :id => 3
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3039,
          :background => {
            :id => 3
          }
        },
        2 => {
          :name => "Request 1 (Elf Reverse Rape)",
          :common => 4266,
          :condition => {
            :type => 1,
            :id => 3095,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    167 => {
      :name => "Dark Elf Mage",
      :condition => {
        :type => 3,
        :id => 40
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_delh_b_h1a"],
          2 => ["Graphics/Pictures/", "ev_delh_b_h2a"],
          3 => ["Graphics/Pictures/", "ev_delh_b_h3a"],
          4 => ["Graphics/Pictures/", "ev_delh_b_h4a"],
          5 => ["Graphics/Pictures/", "ev_delh_b_h1"],
          6 => ["Graphics/Pictures/", "ev_delh_b_h2"],
          7 => ["Graphics/Pictures/", "ev_delh_b_h3"],
          8 => ["Graphics/Pictures/", "ev_delh_b_h4"],
          9 => ["Graphics/Pictures/", "ev_delh_b_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 3
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3040,
          :background => {
            :id => 3
          }
        },
        2 => {
          :name => "Request 1 (Tentacle Drain 1)",
          :common => 4271,
          :condition => {
            :type => 1,
            :id => 3096,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Tentacle Drain 2)",
          :common => 4272,
          :condition => {
            :type => 1,
            :id => 3096,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    168 => {
      :name => "Fairy",
      :condition => {
        :type => 3,
        :id => 41
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_fairy_st02"],
          2 => ["Graphics/Pictures/", "ev_fairy_ct11"],
          3 => ["Graphics/Pictures/", "ev_fairy_ct12"],
          4 => ["Graphics/Pictures/", "ev_fairy_ct13"],
          5 => ["Graphics/Pictures/", "ev_fairy_ct01"],
          6 => ["Graphics/Pictures/", "ev_fairy_ct02"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [1, 4],
          [1, 5],
          [1, 6],
        ],
          :background => {
            :id => 3
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3041,
          :background => {
            :id => 3
          }
        },
        2 => {
          :name => "Request 1 (Succubus Flower)",
          :common => 4276,
          :condition => {
            :type => 1,
            :id => 3097,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Fairy Hug)",
          :common => 4277,
          :condition => {
            :type => 1,
            :id => 3097,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    169 => {
      :name => "Mini Crab Girl",
      :condition => {
        :type => 3,
        :id => 42
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_minikani_h1"],
          2 => ["Graphics/Pictures/", "ev_minikani_h2"],
          3 => ["Graphics/Pictures/", "ev_minikani_h3"],
          4 => ["Graphics/Pictures/", "ev_minikani_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 14
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3042,
          :background => {
            :id => 14
          }
        },
        2 => {
          :name => "Request 1 (Mini Melty Wash)",
          :common => 4281,
          :condition => {
            :type => 1,
            :id => 3098,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    170 => {
      :name => "Catfish Girl",
      :condition => {
        :type => 3,
        :id => 43
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_namazu_h1"],
          2 => ["Graphics/Pictures/", "ev_namazu_h2"],
          3 => ["Graphics/Pictures/", "ev_namazu_h3"],
          4 => ["Graphics/Pictures/", "ev_namazu_h4"],
          5 => ["Graphics/Pictures/", "ev_namazu_h5"],
          6 => ["Graphics/Pictures/", "ev_namazu_h6"],
          7 => ["Graphics/Pictures/", "ev_namazu_h7"],
          8 => ["Graphics/Pictures/", "ev_namazu_h8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 14
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3043,
          :background => {
            :id => 14
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 4286,
          :condition => {
            :type => 1,
            :id => 3099,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    171 => {
      :name => "Rafflesia Girl",
      :condition => {
        :type => 3,
        :id => 44
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_rahure_st11"],
          2 => ["Graphics/Pictures/", "ev_rahure_st12"],
          3 => ["Graphics/Pictures/", "ev_rahure_st13"],
          4 => ["Graphics/Pictures/", "ev_rahure_st14"],
          5 => ["Graphics/Pictures/", "ev_rahure_ct01"],
          6 => ["Graphics/Pictures/", "ev_rahure_ct02"],
          7 => ["Graphics/Pictures/", "ev_rahure_ct03"],
          8 => ["Graphics/Pictures/", "ev_rahure_ct04"],
          9 => ["Graphics/Pictures/", "ev_rahure_ct11"],
          10 => ["Graphics/Pictures/", "ev_rahure_ct12"],
          11 => ["Graphics/Pictures/", "ev_rahure_ct13"],
          12 => ["Graphics/Pictures/", "ev_rahure_ct14"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1, 5],
          [2, 6],
          [3, 7],
          [4, 8],
          [1, 9],
          [2, 10],
          [3, 11],
          [4, 12],
        ],
          :background => {
            :id => 3
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3044,
          :background => {
            :id => 3
          }
        },
        2 => {
          :name => "Request 1 (Forced Pollination)",
          :common => 4291,
          :condition => {
            :type => 1,
            :id => 3100,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    172 => {
      :name => "Centaur",
      :condition => {
        :type => 3,
        :id => 45
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_cent2_st02"],
          2 => ["Graphics/Pictures/", "ev_cent2_ct01"],
          3 => ["Graphics/Pictures/", "ev_cent2_ct02"],
          4 => ["Graphics/Pictures/", "ev_cent2_ct03"],
          5 => ["Graphics/Pictures/", "ev_cent2_h1"],
          6 => ["Graphics/Pictures/", "ev_cent2_h2"],
          7 => ["Graphics/Pictures/", "ev_cent2_h3"],
          8 => ["Graphics/Pictures/", "ev_cent2_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [1, 4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 2
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3045,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Mating)",
          :common => 4296,
          :condition => {
            :type => 1,
            :id => 3101,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    173 => {
      :name => "Two-Tailed Silver Kitsune",
      :condition => {
        :type => 3,
        :id => 46
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_youko_st02"],
          2 => ["Graphics/Pictures/", "ev_youko_ct01"],
          3 => ["Graphics/Pictures/", "ev_youko_ct02"],
          4 => ["Graphics/Pictures/", "ev_youko_ct03"],
          5 => ["Graphics/Pictures/", "ev_youko_ct04"],
          6 => ["Graphics/Pictures/", "ev_youko_h1"],
          7 => ["Graphics/Pictures/", "ev_youko_h2"],
          8 => ["Graphics/Pictures/", "ev_youko_h3"],
          9 => ["Graphics/Pictures/", "ev_youko_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [1, 4],
          [1, 5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 20
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3046,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Mating)",
          :common => 4301,
          :condition => {
            :type => 1,
            :id => 3102,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    174 => {
      :name => "Two-Tailed Geisha",
      :condition => {
        :type => 3,
        :id => 47
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kamuro_ha1"],
          2 => ["Graphics/Pictures/", "ev_kamuro_ha2"],
          3 => ["Graphics/Pictures/", "ev_kamuro_ha3"],
          4 => ["Graphics/Pictures/", "ev_kamuro_ha4"],
          5 => ["Graphics/Pictures/", "ev_kamuro_ha5"],
          6 => ["Graphics/Pictures/", "ev_kamuro_ha6"],
          7 => ["Graphics/Pictures/", "ev_kamuro_ha7"],
          8 => ["Graphics/Pictures/", "ev_kamuro_hb1"],
          9 => ["Graphics/Pictures/", "ev_kamuro_hb2"],
          10 => ["Graphics/Pictures/", "ev_kamuro_hb3"],
          11 => ["Graphics/Pictures/", "ev_kamuro_hb4"],
          12 => ["Graphics/Pictures/", "ev_kamuro_hb5"],
          13 => ["Graphics/Pictures/", "ev_kamuro_hb6"],
          14 => ["Graphics/Pictures/", "ev_kamuro_hb7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
        ],
          :background => {
            :id => 20
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3047,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Tailjob)",
          :common => 4306,
          :condition => {
            :type => 1,
            :id => 3103,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Blowjob)",
          :common => 4307,
          :condition => {
            :type => 1,
            :id => 3103,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    175 => {
      :name => "Spider Girl",
      :condition => {
        :type => 3,
        :id => 48
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_kumo_st02"],
          2 => ["Graphics/Pictures/", "ev_kumo_ct01"],
          3 => ["Graphics/Pictures/", "ev_kumo_ct02"],
          4 => ["Graphics/Pictures/", "ev_kumo_ct03"],
          5 => ["Graphics/Pictures/", "ev_kumo_ct04"],
          6 => ["Graphics/Pictures/", "ev_kumo_hb1"],
          7 => ["Graphics/Pictures/", "ev_kumo_hb2"],
          8 => ["Graphics/Pictures/", "ev_kumo_hb3"],
          9 => ["Graphics/Pictures/", "ev_kumo_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [1, 4],
          [1, 5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 20
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kumo_ha1"],
          2 => ["Graphics/Pictures/", "ev_kumo_ha2"],
          3 => ["Graphics/Pictures/", "ev_kumo_ha3"],
          4 => ["Graphics/Pictures/", "ev_kumo_ha4"],
          5 => ["Graphics/Pictures/", "ev_kumo_ha5"],
          6 => ["Graphics/Pictures/", "ev_kumo_ha6"],
          7 => ["Graphics/Pictures/", "ev_kumo_hc1"],
          8 => ["Graphics/Pictures/", "ev_kumo_hc2"],
          9 => ["Graphics/Pictures/", "ev_kumo_hc3"],
          10 => ["Graphics/Pictures/", "ev_kumo_hc4"],
          11 => ["Graphics/Pictures/", "ev_kumo_hc5"],
          12 => ["Graphics/Pictures/", "ev_kumo_hc6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
        ],
          :condition => {
            :type => 1,
            :id => 3104,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3048,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Predation)",
          :common => 4311,
          :condition => {
            :type => 1,
            :id => 3104,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Forced Violation 1)",
          :common => 4312,
          :condition => {
            :type => 1,
            :id => 3104,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Forced Violation 2)",
          :common => 4313,
          :condition => {
            :type => 1,
            :id => 3104,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    176 => {
      :name => "Mimic",
      :condition => {
        :type => 3,
        :id => 49
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_mimic_st21"],
          2 => ["Graphics/Pictures/", "ev_mimic_st22"],
          3 => ["Graphics/Pictures/", "ev_mimic_ct01"],
          4 => ["Graphics/Pictures/", "ev_mimic_ct02"],
          5 => ["Graphics/Pictures/", "ev_mimic_ct03"],
          6 => ["Graphics/Pictures/", "ev_mimic_ct11"],
          7 => ["Graphics/Pictures/", "ev_mimic_ct12"],
          8 => ["Graphics/Pictures/", "ev_mimic_ct13"],
          9 => ["Graphics/Pictures/", "ev_mimic_ct14"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1, 3],
          [2, 4],
          [2, 5],
          [1, 6],
          [2, 7],
          [2, 8],
          [2, 9],
        ],
          :background => {
            :id => 20
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3049,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Swallow)",
          :common => 4316,
          :condition => {
            :type => 1,
            :id => 3105,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Blowjob)",
          :common => 4317,
          :condition => {
            :type => 1,
            :id => 3105,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    177 => {
      :name => "Nanabi",
      :condition => {
        :type => 3,
        :id => 50
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_nanabi_st02"],
          2 => ["Graphics/Pictures/", "ev_nanabi_ctb01"],
          3 => ["Graphics/Pictures/", "ev_nanabi_ctb02"],
          4 => ["Graphics/Pictures/", "ev_nanabi_ctb03"],
          5 => ["Graphics/Pictures/", "ev_nanabi_ctb04"],
          6 => ["Graphics/Pictures/", "ev_nanabi_h1"],
          7 => ["Graphics/Pictures/", "ev_nanabi_h2"],
          8 => ["Graphics/Pictures/", "ev_nanabi_h3"],
          9 => ["Graphics/Pictures/", "ev_nanabi_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [1, 4],
          [1, 5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 20
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_nanabi_h5"],
          2 => ["Graphics/Pictures/", "ev_nanabi_h6"],
          3 => ["Graphics/Pictures/", "ev_nanabi_h7"],
          4 => ["Graphics/Pictures/", "ev_nanabi_h8"],
          5 => ["Graphics/Pictures/", "ev_nanabi_h9"],
          6 => ["Graphics/Pictures/", "ev_nanabi_ctc01"],
          7 => ["Graphics/Pictures/", "ev_nanabi_ctc02"],
          8 => ["Graphics/Pictures/", "ev_nanabi_ctc03"],
          9 => ["Graphics/Pictures/", "ev_nanabi_ctc04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2, 6],
          [3, 7],
          [4, 8],
          [5, 9],
        ],
          :condition => {
            :type => 1,
            :id => 3106,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_nanabi_hb1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3050,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Tails)",
          :common => 4321,
          :condition => {
            :type => 1,
            :id => 3106,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4322,
          :condition => {
            :type => 1,
            :id => 3106,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Loop Event (Handjob)",
          :common => 5820,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    178 => {
      :name => "Sea Cucumber Girl",
      :condition => {
        :type => 3,
        :id => 52
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_namako_h1"],
          2 => ["Graphics/Pictures/", "ev_namako_h2"],
          3 => ["Graphics/Pictures/", "ev_namako_h3"],
          4 => ["Graphics/Pictures/", "ev_namako_ct01"],
          5 => ["Graphics/Pictures/", "ev_namako_ct02"],
          6 => ["Graphics/Pictures/", "ev_namako_ct03"],
          7 => ["Graphics/Pictures/", "ev_namako_ct04"],
          8 => ["Graphics/Pictures/", "ev_namako_ha1"],
          9 => ["Graphics/Pictures/", "ev_namako_ha2"],
          10 => ["Graphics/Pictures/", "ev_namako_ha3"],
          11 => ["Graphics/Pictures/", "ev_namako_ha4"],
          12 => ["Graphics/Pictures/", "ev_namako_ha5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1, 4],
          [2, 5],
          [2, 6],
          [3, 7],
          [8],
          [9],
          [10],
          [11],
          [12],
        ],
          :background => {
            :id => 14
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3052,
          :background => {
            :id => 14
          }
        },
        2 => {
          :name => "Request 1 (Sea Cucumber Suck)",
          :common => 4326,
          :condition => {
            :type => 1,
            :id => 3107,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    179 => {
      :name => "Shellfish Girl",
      :condition => {
        :type => 3,
        :id => 53
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kai_h1"],
          2 => ["Graphics/Pictures/", "ev_kai_h2"],
          3 => ["Graphics/Pictures/", "ev_kai_h3"],
          4 => ["Graphics/Pictures/", "ev_kai_h4"],
          5 => ["Graphics/Pictures/", "ev_kai_h5"],
          6 => ["Graphics/Pictures/", "ev_kai_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 14
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kai_hb1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3053,
          :background => {
            :id => 14
          }
        },
        2 => {
          :name => "Request 1 (Love Jail)",
          :common => 4331,
          :condition => {
            :type => 1,
            :id => 3108,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Loop Event (Milking Hug)",
          :common => 5808,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    180 => {
      :name => "Crab Girl",
      :condition => {
        :type => 3,
        :id => 54
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kani_st11"],
          2 => ["Graphics/Pictures/", "ev_kani_st12"],
          3 => ["Graphics/Pictures/", "ev_kani_st13"],
          4 => ["Graphics/Pictures/", "ev_kani_ct01"],
          5 => ["Graphics/Pictures/", "ev_kani_ct02"],
          6 => ["Graphics/Pictures/", "ev_kani_ct03"],
          7 => ["Graphics/Pictures/", "ev_kani_ct11"],
          8 => ["Graphics/Pictures/", "ev_kani_ct12"],
          9 => ["Graphics/Pictures/", "ev_kani_ct13"],
          10 => ["Graphics/Pictures/", "ev_kani_hb1"],
          11 => ["Graphics/Pictures/", "ev_kani_hb2"],
          12 => ["Graphics/Pictures/", "ev_kani_hb3"],
          13 => ["Graphics/Pictures/", "ev_kani_hb4"],
          14 => ["Graphics/Pictures/", "ev_kani_hb5"],
          15 => ["Graphics/Pictures/", "ev_kani_hb6"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 4],
          [2, 5],
          [3, 6],
          [1, 7],
          [2, 8],
          [3, 9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
        ],
          :background => {
            :id => 14
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kani_h1"],
          2 => ["Graphics/Pictures/", "ev_kani_h2"],
          3 => ["Graphics/Pictures/", "ev_kani_ct21"],
          4 => ["Graphics/Pictures/", "ev_kani_ct22"],
          5 => ["Graphics/Pictures/", "ev_kani_ct23"],
          6 => ["Graphics/Pictures/", "ev_kani_ct24"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1, 3],
          [2, 4],
          [2, 5],
          [2, 6],
        ],
          :condition => {
            :type => 1,
            :id => 3109,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3054,
          :background => {
            :id => 14
          }
        },
        2 => {
          :name => "Request 1 (Melty Wash)",
          :common => 4336,
          :condition => {
            :type => 1,
            :id => 3109,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Mating)",
          :common => 4337,
          :condition => {
            :type => 1,
            :id => 3109,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    181 => {
      :name => "Slime Bess",
      :condition => {
        :type => 3,
        :id => 55
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_slimelord_hb1"],
          2 => ["Graphics/Pictures/", "ev_slimelord_hb2"],
          3 => ["Graphics/Pictures/", "ev_slimelord_hb3"],
          4 => ["Graphics/Pictures/", "ev_slimelord_hb4"],
          5 => ["Graphics/Pictures/", "ev_slimelord_hb5"],
          6 => ["Graphics/Pictures/", "ev_slimelord_hb6"],
          7 => ["Graphics/Pictures/", "ev_slimelord_ct01"],
          8 => ["Graphics/Pictures/", "ev_slimelord_ct02"],
          9 => ["Graphics/Pictures/", "ev_slimelord_ct03"],
          10 => ["Graphics/Pictures/", "ev_slimelord_ha1"],
          11 => ["Graphics/Pictures/", "ev_slimelord_ha2"],
          12 => ["Graphics/Pictures/", "ev_slimelord_ha3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [4, 7],
          [5, 8],
          [6, 9],
          [10],
          [11],
          [12],
        ],
          :background => {
            :id => 2
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3055,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Predation)",
          :common => 4341,
          :condition => {
            :type => 1,
            :id => 3110,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Predation...?)",
          :common => 4342,
          :condition => {
            :type => 1,
            :id => 3110,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    182 => {
      :name => "Watermelon Girl",
      :condition => {
        :type => 3,
        :id => 56
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_suika_h1"],
          2 => ["Graphics/Pictures/", "ev_suika_h2"],
          3 => ["Graphics/Pictures/", "ev_suika_h3"],
          4 => ["Graphics/Pictures/", "ev_suika_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 2
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_suika_hb1"],
          2 => ["Graphics/Pictures/", "ev_suika_hb2"],
          3 => ["Graphics/Pictures/", "ev_suika_hb3"],
          4 => ["Graphics/Pictures/", "ev_suika_hc1"],
          5 => ["Graphics/Pictures/", "ev_suika_hc2"],
          6 => ["Graphics/Pictures/", "ev_suika_hc3"],
          7 => ["Graphics/Pictures/", "ev_suika_hc4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :condition => {
            :type => 1,
            :id => 3111,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3056,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Melon)",
          :common => 4346,
          :condition => {
            :type => 1,
            :id => 3111,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Ivy Wrap)",
          :common => 4347,
          :condition => {
            :type => 1,
            :id => 3111,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Watermelon Sandwich)",
          :common => 4348,
          :condition => {
            :type => 1,
            :id => 3111,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    183 => {
      :name => "Pitcher Plant Girl",
      :condition => {
        :type => 3,
        :id => 57
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_utubo_h1"],
          2 => ["Graphics/Pictures/", "ev_utubo_h2"],
          3 => ["Graphics/Pictures/", "ev_utubo_h3"],
          4 => ["Graphics/Pictures/", "ev_utubo_h4"],
          5 => ["Graphics/Pictures/", "ev_utubo_h5"],
          6 => ["Graphics/Pictures/", "ev_utubo_h6"],
          7 => ["Graphics/Pictures/", "ev_utubo_h7"],
          8 => ["Graphics/Pictures/", "ev_utubo_h8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 2
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3057,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Predation)",
          :common => 4351,
          :condition => {
            :type => 1,
            :id => 3112,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Predation...?)",
          :common => 4352,
          :condition => {
            :type => 1,
            :id => 3112,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    184 => {
      :name => "Lamia",
      :condition => {
        :type => 3,
        :id => 58
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_lamia_st02"],
          2 => ["Graphics/Pictures/", "ev_lamia_ct01"],
          3 => ["Graphics/Pictures/", "ev_lamia_ct02"],
          4 => ["Graphics/Pictures/", "ev_lamia_ct03"],
          5 => ["Graphics/Pictures/", "ev_lamia_ct04"],
          6 => ["Graphics/Pictures/", "ev_lamia_ct05"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [1, 4],
          [1, 5],
          [1, 6],
        ],
          :background => {
            :id => 2
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lamia_ha1"],
          2 => ["Graphics/Pictures/", "ev_lamia_ha2"],
          3 => ["Graphics/Pictures/", "ev_lamia_ha3"],
          4 => ["Graphics/Pictures/", "ev_lamia_ha4"],
          5 => ["Graphics/Pictures/", "ev_lamia_ha5"],
          6 => ["Graphics/Pictures/", "ev_lamia_ha6"],
          7 => ["Graphics/Pictures/", "ev_lamia_ha7"],
          8 => ["Graphics/Pictures/", "ev_lamia_ha8"],
          9 => ["Graphics/Pictures/", "ev_lamia_hb1"],
          10 => ["Graphics/Pictures/", "ev_lamia_hb2"],
          11 => ["Graphics/Pictures/", "ev_lamia_hb3"],
          12 => ["Graphics/Pictures/", "ev_lamia_ctb01"],
          13 => ["Graphics/Pictures/", "ev_lamia_ctb02"],
          14 => ["Graphics/Pictures/", "ev_lamia_ctb03"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [9, 12],
          [10, 13],
          [11, 14],
        ],
          :condition => {
            :type => 1,
            :id => 3113,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3058,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Swallowing Whole)",
          :common => 4356,
          :condition => {
            :type => 1,
            :id => 3113,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Coiled Blowjob)",
          :common => 4357,
          :condition => {
            :type => 1,
            :id => 3113,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Reverse Rape)",
          :common => 4358,
          :condition => {
            :type => 1,
            :id => 3113,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    185 => {
      :name => "Seaweed Girl",
      :condition => {
        :type => 3,
        :id => 59
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_wakame_h1"],
          2 => ["Graphics/Pictures/", "ev_wakame_h2"],
          3 => ["Graphics/Pictures/", "ev_wakame_h3"],
          4 => ["Graphics/Pictures/", "ev_wakame_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 14
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_wakame_hb1"],
          2 => ["Graphics/Pictures/", "ev_wakame_hb2"],
          3 => ["Graphics/Pictures/", "ev_wakame_hb3"],
          4 => ["Graphics/Pictures/", "ev_wakame_hc1"],
          5 => ["Graphics/Pictures/", "ev_wakame_hc2"],
          6 => ["Graphics/Pictures/", "ev_wakame_hc3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3114,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3059,
          :background => {
            :id => 14
          }
        },
        2 => {
          :name => "Request 1 (Seaweed Handjob)",
          :common => 4361,
          :condition => {
            :type => 1,
            :id => 3114,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Seaweed Mating)",
          :common => 4362,
          :condition => {
            :type => 1,
            :id => 3114,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Semen-squeezing Seaweed)",
          :common => 4363,
          :condition => {
            :type => 1,
            :id => 3114,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    186 => {
      :name => "Jellyfish Girl",
      :condition => {
        :type => 3,
        :id => 60
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_kurage_st02"],
          2 => ["Graphics/Pictures/", "ev_kurage_ct01"],
          3 => ["Graphics/Pictures/", "ev_kurage_ct02"],
          4 => ["Graphics/Pictures/", "ev_kurage_ct03"],
          5 => ["Graphics/Pictures/", "ev_kurage_ctb01"],
          6 => ["Graphics/Pictures/", "ev_kurage_ctb02"],
          7 => ["Graphics/Pictures/", "ev_kurage_ctb03"],
          8 => ["Graphics/Pictures/", "ev_kurage_ctb04"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [1, 4],
          [1, 5],
          [1, 6],
          [1, 7],
          [1, 8],
        ],
          :background => {
            :id => 53
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3060,
          :background => {
            :id => 53
          }
        },
        2 => {
          :name => "Request 1 (Predation)",
          :common => 4366,
          :condition => {
            :type => 1,
            :id => 3115,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Predation...?)",
          :common => 4367,
          :condition => {
            :type => 1,
            :id => 3115,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    187 => {
      :name => "Sea Anemone Girl",
      :condition => {
        :type => 3,
        :id => 61
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_iso_h1"],
          2 => ["Graphics/Pictures/", "ev_iso_h2"],
          3 => ["Graphics/Pictures/", "ev_iso_h3"],
          4 => ["Graphics/Pictures/", "ev_iso_h4"],
          5 => ["Graphics/Pictures/", "ev_iso_h5"],
          6 => ["Graphics/Pictures/", "ev_iso_h6"],
          7 => ["Graphics/Pictures/", "ev_iso_ct01"],
          8 => ["Graphics/Pictures/", "ev_iso_ct02"],
          9 => ["Graphics/Pictures/", "ev_iso_ct03"],
          10 => ["Graphics/Pictures/", "ev_iso_ct04"],
          11 => ["Graphics/Pictures/", "ev_iso_ctb01"],
          12 => ["Graphics/Pictures/", "ev_iso_ctb02"],
          13 => ["Graphics/Pictures/", "ev_iso_ctb03"],
          14 => ["Graphics/Pictures/", "ev_iso_ctb04"],
          15 => ["Graphics/Pictures/", "ev_iso_hb1"],
          16 => ["Graphics/Pictures/", "ev_iso_hb2"],
          17 => ["Graphics/Pictures/", "ev_iso_hb3"],
          18 => ["Graphics/Pictures/", "ev_iso_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [3, 7],
          [4, 8],
          [5, 9],
          [5, 10],
          [6],
          [6, 11],
          [6, 12],
          [6, 13],
          [6, 14],
          [15],
          [16],
          [17],
          [18],
        ],
          :background => {
            :id => 53
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3061,
          :background => {
            :id => 53
          }
        },
        2 => {
          :name => "Request 1 (Predation)",
          :common => 4371,
          :condition => {
            :type => 1,
            :id => 3116,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Predation...?)",
          :common => 4372,
          :condition => {
            :type => 1,
            :id => 3116,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    188 => {
      :name => "Anglerfish Girl",
      :condition => {
        :type => 3,
        :id => 62
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_ankou_st01"],
          2 => ["Graphics/Pictures/", "ev_ankou_cta01"],
          3 => ["Graphics/Pictures/", "ev_ankou_cta02"],
          4 => ["Graphics/Pictures/", "ev_ankou_cta03"],
          5 => ["Graphics/Pictures/", "ev_ankou_ctb01"],
          6 => ["Graphics/Pictures/", "ev_ankou_ctb02"],
          7 => ["Graphics/Pictures/", "ev_ankou_ctb03"],
          8 => ["Graphics/Pictures/", "ev_ankou_ctb04"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [1, 4],
          [1, 5],
          [1, 6],
          [1, 7],
          [1, 8],
        ],
          :background => {
            :id => 53
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3062,
          :background => {
            :id => 53
          }
        },
        2 => {
          :name => "Request 1 (Absorption)",
          :common => 4376,
          :condition => {
            :type => 1,
            :id => 3117,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    189 => {
      :name => "Meia",
      :condition => {
        :type => 3,
        :id => 63
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_meia_ha1"],
          2 => ["Graphics/Pictures/", "ev_meia_ha2"],
          3 => ["Graphics/Pictures/", "ev_meia_ha3"],
          4 => ["Graphics/Pictures/", "ev_meia_ha4"],
          5 => ["Graphics/Pictures/", "ev_meia_hb1"],
          6 => ["Graphics/Pictures/", "ev_meia_hb2"],
          7 => ["Graphics/Pictures/", "ev_meia_hb3"],
          8 => ["Graphics/Pictures/", "ev_meia_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 53
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3063,
          :background => {
            :id => 53
          }
        },
        2 => {
          :name => "Request 1 (Blowjob)",
          :common => 4381,
          :condition => {
            :type => 1,
            :id => 3118,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4382,
          :condition => {
            :type => 1,
            :id => 3118,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    190 => {
      :name => "Page 17",
      :condition => {
        :type => 3,
        :id => 64
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_page17_h1"],
          2 => ["Graphics/Pictures/", "ev_page17_h2"],
          3 => ["Graphics/Pictures/", "ev_page17_h3"],
          4 => ["Graphics/Pictures/", "ev_page17_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 54
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3064,
          :background => {
            :id => 54
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape 1)",
          :common => 4386,
          :condition => {
            :type => 1,
            :id => 3119,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape 2)",
          :common => 4387,
          :condition => {
            :type => 1,
            :id => 3119,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    191 => {
      :name => "Page 257",
      :condition => {
        :type => 3,
        :id => 65
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_page257_h1"],
          2 => ["Graphics/Pictures/", "ev_page257_ct01"],
          3 => ["Graphics/Pictures/", "ev_page257_ct02"],
          4 => ["Graphics/Pictures/", "ev_page257_ct03"],
          5 => ["Graphics/Pictures/", "ev_page257_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [1, 4],
          [1, 5],
        ],
          :background => {
            :id => 54
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_page257_hb1"],
          2 => ["Graphics/Pictures/", "ev_page257_hb2"],
          3 => ["Graphics/Pictures/", "ev_page257_hb3"],
          4 => ["Graphics/Pictures/", "ev_page257_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3120,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3065,
          :background => {
            :id => 54
          }
        },
        2 => {
          :name => "Request 1 (Handjob)",
          :common => 4391,
          :condition => {
            :type => 1,
            :id => 3120,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4392,
          :condition => {
            :type => 1,
            :id => 3120,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    192 => {
      :name => "Page 65537",
      :condition => {
        :type => 3,
        :id => 66
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_page65537_h1a"],
          2 => ["Graphics/Pictures/", "ev_page65537_h2a"],
          3 => ["Graphics/Pictures/", "ev_page65537_h3a"],
          4 => ["Graphics/Pictures/", "ev_page65537_ct01"],
          5 => ["Graphics/Pictures/", "ev_page65537_ct02"],
          6 => ["Graphics/Pictures/", "ev_page65537_ct03"],
          7 => ["Graphics/Pictures/", "ev_page65537_hb1"],
          8 => ["Graphics/Pictures/", "ev_page65537_hb2"],
          9 => ["Graphics/Pictures/", "ev_page65537_hb3"],
          10 => ["Graphics/Pictures/", "ev_page65537_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 4],
          [2, 5],
          [3, 6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 54
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_page65537_h1b"],
          2 => ["Graphics/Pictures/", "ev_page65537_h2b"],
          3 => ["Graphics/Pictures/", "ev_page65537_h3b"],
          4 => ["Graphics/Pictures/", "ev_page65537_h1c"],
          5 => ["Graphics/Pictures/", "ev_page65537_h2c"],
          6 => ["Graphics/Pictures/", "ev_page65537_h3c"],
          7 => ["Graphics/Pictures/", "ev_page65537_ct01"],
          8 => ["Graphics/Pictures/", "ev_page65537_ct02"],
          9 => ["Graphics/Pictures/", "ev_page65537_ct03"],
          10 => ["Graphics/Pictures/", "ev_page65537_hc1"],
          11 => ["Graphics/Pictures/", "ev_page65537_hc2"],
          12 => ["Graphics/Pictures/", "ev_page65537_hc3"],
          13 => ["Graphics/Pictures/", "ev_page65537_hc4"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 7],
          [2, 8],
          [3, 9],
          [4, 7],
          [5, 8],
          [6, 9],
          [10],
          [11],
          [12],
          [13],
        ],
          :condition => {
            :type => 1,
            :id => 3121,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_page65537_hd1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3066,
          :background => {
            :id => 54
          }
        },
        2 => {
          :name => "Request 1 (Forced Semen Squeeze 1)",
          :common => 4396,
          :condition => {
            :type => 1,
            :id => 3121,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Forced Semen Squeeze 2)",
          :common => 4397,
          :condition => {
            :type => 1,
            :id => 3121,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Forced Semen Squeeze 3)",
          :common => 4398,
          :condition => {
            :type => 1,
            :id => 3121,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 4 (Paizuri)",
          :common => 4399,
          :condition => {
            :type => 1,
            :id => 3121,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        6 => {
          :name => "Loop Event (Book of Temptation)",
          :common => 5822,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    193 => {
      :name => "Sister Lamia",
      :condition => {
        :type => 3,
        :id => 67
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_sisterlamia_h1"],
          2 => ["Graphics/Pictures/", "ev_sisterlamia_h2"],
          3 => ["Graphics/Pictures/", "ev_sisterlamia_h3"],
          4 => ["Graphics/Pictures/", "ev_sisterlamia_ct01"],
          5 => ["Graphics/Pictures/", "ev_sisterlamia_ct02"],
          6 => ["Graphics/Pictures/", "ev_sisterlamia_ct03"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1, 4],
          [2, 5],
          [3, 6],
        ],
          :background => {
            :id => 21
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_sisterlamia_hb1"],
          2 => ["Graphics/Pictures/", "ev_sisterlamia_hb2"],
          3 => ["Graphics/Pictures/", "ev_sisterlamia_hb3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :condition => {
            :type => 1,
            :id => 3122,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_sisterlamia_hd1"],
          2 => ["Graphics/Pictures/", "ev_sisterlamia_hd2"],
          3 => ["Graphics/Pictures/", "ev_sisterlamia_hd3"],
          4 => ["Graphics/Pictures/", "ev_sisterlamia_hd4"],
          5 => ["Graphics/Pictures/", "ev_sisterlamia_he1"],
          6 => ["Graphics/Pictures/", "ev_sisterlamia_he2"],
          7 => ["Graphics/Pictures/", "ev_sisterlamia_he3"],
          8 => ["Graphics/Pictures/", "ev_sisterlamia_he4"],
          9 => ["Graphics/Pictures/", "ev_sisterlamia_hc1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3067,
          :background => {
            :id => 21
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 4401,
          :condition => {
            :type => 1,
            :id => 3122,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Holy Snake's Embrace 1)",
          :common => 4402,
          :condition => {
            :type => 1,
            :id => 3122,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Holy Snake's Embrace 2)",
          :common => 4403,
          :condition => {
            :type => 1,
            :id => 3122,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Loop Event (Sonya Vore)",
          :common => 5790,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        },
        6 => {
          :name => "Loop Event (Divine Punishment)",
          :common => 5826,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    194 => {
      :name => "Succubus Nun",
      :condition => {
        :type => 3,
        :id => 68
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_sisccubus_h01"],
          2 => ["Graphics/Pictures/", "ev_sisccubus_h02"],
          3 => ["Graphics/Pictures/", "ev_sisccubus_h03"],
          4 => ["Graphics/Pictures/", "ev_sisccubus_h04"],
          5 => ["Graphics/Pictures/", "ev_sisccubus_h05"],
          6 => ["Graphics/Pictures/", "ev_sisccubus_h06"],
          7 => ["Graphics/Pictures/", "ev_sisccubus_h07"],
          8 => ["Graphics/Pictures/", "ev_sisccubus_h08"],
          9 => ["Graphics/Pictures/", "ev_sisccubus_h09"],
          10 => ["Graphics/Pictures/", "ev_sisccubus_h10"],
          11 => ["Graphics/Pictures/", "ev_sisccubus_h11"],
          12 => ["Graphics/Pictures/", "ev_sisccubus_h12"],
          13 => ["Graphics/Pictures/", "ev_sisccubus_h13"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
        ],
          :background => {
            :id => 21
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3068,
          :background => {
            :id => 21
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape 1)",
          :common => 4406,
          :condition => {
            :type => 1,
            :id => 3123,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape 2)",
          :common => 4407,
          :condition => {
            :type => 1,
            :id => 3123,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    195 => {
      :name => "Anteater Girl",
      :condition => {
        :type => 3,
        :id => 69
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_arikui_h1"],
          2 => ["Graphics/Pictures/", "ev_arikui_h2"],
          3 => ["Graphics/Pictures/", "ev_arikui_h3"],
          4 => ["Graphics/Pictures/", "ev_arikui_h4"],
          5 => ["Graphics/Pictures/", "ev_arikui_h5"],
          6 => ["Graphics/Pictures/", "ev_arikui_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 21
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_arikui_hb1"],
          2 => ["Graphics/Pictures/", "ev_arikui_hb2"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3069,
          :background => {
            :id => 21
          }
        },
        2 => {
          :name => "Request 1 (Long-Tongue Blowjob)",
          :common => 4411,
          :condition => {
            :type => 1,
            :id => 3124,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Loop Event (Binding Tongue)",
          :common => 5835,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    196 => {
      :name => "Grizzly Bear Girl",
      :condition => {
        :type => 3,
        :id => 70
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_grizzly_h1"],
          2 => ["Graphics/Pictures/", "ev_grizzly_h2"],
          3 => ["Graphics/Pictures/", "ev_grizzly_h3"],
          4 => ["Graphics/Pictures/", "ev_grizzly_h4"],
          5 => ["Graphics/Pictures/", "ev_grizzly_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 21
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3070,
          :background => {
            :id => 21
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4416,
          :condition => {
            :type => 1,
            :id => 3125,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    197 => {
      :name => "XX-7",
      :condition => {
        :type => 3,
        :id => 71
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_XX-7_ha1"],
          2 => ["Graphics/Pictures/", "ev_XX-7_ha2"],
          3 => ["Graphics/Pictures/", "ev_XX-7_ha3"],
          4 => ["Graphics/Pictures/", "ev_XX-7_ha4"],
          5 => ["Graphics/Pictures/", "ev_XX-7_hb1"],
          6 => ["Graphics/Pictures/", "ev_XX-7_hb2"],
          7 => ["Graphics/Pictures/", "ev_XX-7_hb3"],
          8 => ["Graphics/Pictures/", "ev_XX-7_hb4"],
          9 => ["Graphics/Pictures/", "ev_XX-7_hb5"],
          10 => ["Graphics/Pictures/", "ev_XX-7_ct01"],
          11 => ["Graphics/Pictures/", "ev_XX-7_ct02"],
          12 => ["Graphics/Pictures/", "ev_XX-7_ct03"],
          13 => ["Graphics/Pictures/", "ev_XX-7_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1, 10],
          [1, 11],
          [1, 12],
          [1, 13],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 46
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3071,
          :background => {
            :id => 46
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Tentacle 1)",
          :common => 4421,
          :condition => {
            :type => 1,
            :id => 3126,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Semen Squeezing Tentacle 2)",
          :common => 4422,
          :condition => {
            :type => 1,
            :id => 3126,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    198 => {
      :name => "Little Bug",
      :condition => {
        :type => 3,
        :id => 72
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_littlebug_ha01"],
          2 => ["Graphics/Pictures/", "ev_littlebug_ha02"],
          3 => ["Graphics/Pictures/", "ev_littlebug_ha03"],
          4 => ["Graphics/Pictures/", "ev_littlebug_ha04"],
          5 => ["Graphics/Pictures/", "ev_littlebug_ha05"],
          6 => ["Graphics/Pictures/", "ev_littlebug_ha06"],
          7 => ["Graphics/Pictures/", "ev_littlebug_ha07"],
          8 => ["Graphics/Pictures/", "ev_littlebug_ha08"],
          9 => ["Graphics/Pictures/", "ev_littlebug_ha09"],
          10 => ["Graphics/Pictures/", "ev_littlebug_ha10"],
          11 => ["Graphics/Pictures/", "ev_littlebug_ha11"],
          12 => ["Graphics/Pictures/", "ev_littlebug_ha12"],
          13 => ["Graphics/Pictures/", "ev_littlebug_ha13"],
          14 => ["Graphics/Pictures/", "ev_littlebug_ha14"],
          15 => ["Graphics/Pictures/", "ev_littlebug_ha15"],
          16 => ["Graphics/Pictures/", "ev_littlebug_ha16"],
          17 => ["Graphics/Pictures/", "ev_littlebug_ha17"],
          18 => ["Graphics/Pictures/", "ev_littlebug_ha18"],
          19 => ["Graphics/Pictures/", "ev_littlebug_ha19"],
          20 => ["Graphics/Pictures/", "ev_littlebug_ha20"],
          21 => ["Graphics/Pictures/", "ev_littlebug_ha21"],
          22 => ["Graphics/Pictures/", "ev_littlebug_ha22"],
          23 => ["Graphics/Pictures/", "ev_littlebug_ha23"],
          24 => ["Graphics/Pictures/", "ev_littlebug_ha24"],
          25 => ["Graphics/Pictures/", "ev_littlebug_ha25"],
          26 => ["Graphics/Pictures/", "ev_littlebug_ha26"],
          27 => ["Graphics/Pictures/", "ev_littlebug_ha27"],
          28 => ["Graphics/Pictures/", "ev_littlebug_ha28"],
          29 => ["Graphics/Pictures/", "ev_littlebug_ha29"],
          30 => ["Graphics/Pictures/", "ev_littlebug_ha30"],
          31 => ["Graphics/Pictures/", "ev_littlebug_ha31"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
          [26],
          [27],
          [28],
          [29],
          [30],
          [31],
        ],
          :background => {
            :id => 46
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_littlebug_hb01"],
          2 => ["Graphics/Pictures/", "ev_littlebug_hb02"],
          3 => ["Graphics/Pictures/", "ev_littlebug_hb03"],
          4 => ["Graphics/Pictures/", "ev_littlebug_hb04"],
          5 => ["Graphics/Pictures/", "ev_littlebug_hb05"],
          6 => ["Graphics/Pictures/", "ev_littlebug_hb06"],
          7 => ["Graphics/Pictures/", "ev_littlebug_hb07"],
          8 => ["Graphics/Pictures/", "ev_littlebug_hb08"],
          9 => ["Graphics/Pictures/", "ev_littlebug_hb09"],
          10 => ["Graphics/Pictures/", "ev_littlebug_hb10"],
          11 => ["Graphics/Pictures/", "ev_littlebug_hb11"],
          12 => ["Graphics/Pictures/", "ev_littlebug_hb12"],
          13 => ["Graphics/Pictures/", "ev_littlebug_hb13"],
          14 => ["Graphics/Pictures/", "ev_littlebug_hb14"],
          15 => ["Graphics/Pictures/", "ev_littlebug_hb15"],
          16 => ["Graphics/Pictures/", "ev_littlebug_hb16"],
          17 => ["Graphics/Pictures/", "ev_littlebug_hb17"],
          18 => ["Graphics/Pictures/", "ev_littlebug_hb18"],
          19 => ["Graphics/Pictures/", "ev_littlebug_hb19"],
          20 => ["Graphics/Pictures/", "ev_littlebug_hb20"],
          21 => ["Graphics/Pictures/", "ev_littlebug_hb21"],
          22 => ["Graphics/Pictures/", "ev_littlebug_hb22"],
          23 => ["Graphics/Pictures/", "ev_littlebug_hb23"],
          24 => ["Graphics/Pictures/", "ev_littlebug_hb24"],
          25 => ["Graphics/Pictures/", "ev_littlebug_hb25"],
          26 => ["Graphics/Pictures/", "ev_littlebug_hb26"],
          27 => ["Graphics/Pictures/", "ev_littlebug_hb27"],
          28 => ["Graphics/Pictures/", "ev_littlebug_hb28"],
          29 => ["Graphics/Pictures/", "ev_littlebug_hb29"],
          30 => ["Graphics/Pictures/", "ev_littlebug_hb30"],
          31 => ["Graphics/Pictures/", "ev_littlebug_hb31"],
          32 => ["Graphics/Pictures/", "ev_littlebug_hb32"],
          33 => ["Graphics/Pictures/", "ev_littlebug_hb33"],
          34 => ["Graphics/Pictures/", "ev_littlebug_hb34"],
          35 => ["Graphics/Pictures/", "ev_littlebug_hb35"],
          36 => ["Graphics/Pictures/", "ev_littlebug_hb36"],
          37 => ["Graphics/Pictures/", "ev_littlebug_hb37"],
          38 => ["Graphics/Pictures/", "ev_littlebug_hb39"],
          39 => ["Graphics/Pictures/", "ev_littlebug_hb40"],
          40 => ["Graphics/Pictures/", "ev_littlebug_hb41"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
          [26],
          [27],
          [28],
          [29],
          [30],
          [31],
          [32],
          [33],
          [34],
          [35],
          [36],
          [37],
          [38],
          [39],
          [40],
        ],
          :condition => {
            :type => 1,
            :id => 3127,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3072,
          :background => {
            :id => 46
          }
        },
        2 => {
          :name => "Request 1 (Mating)",
          :common => 4426,
          :condition => {
            :type => 1,
            :id => 3127,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Blowjob)",
          :common => 4427,
          :condition => {
            :type => 1,
            :id => 3127,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    199 => {
      :name => "Canceroid",
      :condition => {
        :type => 3,
        :id => 73
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kaniloid_h1"],
          2 => ["Graphics/Pictures/", "ev_kaniloid_h2"],
          3 => ["Graphics/Pictures/", "ev_kaniloid_h3"],
          4 => ["Graphics/Pictures/", "ev_kaniloid_h4"],
          5 => ["Graphics/Pictures/", "ev_kaniloid_h5"],
          6 => ["Graphics/Pictures/", "ev_kaniloid_h6"],
          7 => ["Graphics/Pictures/", "ev_kaniloid_h7"],
          8 => ["Graphics/Pictures/", "ev_kaniloid_h8"],
          9 => ["Graphics/Pictures/", "ev_kaniloid_h9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 46
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3073,
          :background => {
            :id => 46
          }
        },
        2 => {
          :name => "Request 1 (Predation)",
          :common => 4431,
          :condition => {
            :type => 1,
            :id => 3128,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Predation...?)",
          :common => 4432,
          :condition => {
            :type => 1,
            :id => 3128,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    200 => {
      :name => "Ghost Girl",
      :condition => {
        :type => 3,
        :id => 75
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_ghost_h1"],
          2 => ["Graphics/Pictures/", "ev_ghost_h2"],
          3 => ["Graphics/Pictures/", "ev_ghost_h3"],
          4 => ["Graphics/Pictures/", "ev_ghost_h4"],
          5 => ["Graphics/Pictures/", "ev_ghost_ct01"],
          6 => ["Graphics/Pictures/", "ev_ghost_ct02"],
          7 => ["Graphics/Pictures/", "ev_ghost_ct03"],
          8 => ["Graphics/Pictures/", "ev_ghost_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1, 5],
          [2, 6],
          [3, 7],
          [4, 8],
        ],
          :background => {
            :id => 55
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3075,
          :background => {
            :id => 55
          }
        },
        2 => {
          :name => "Request 1 (Ghost Rape 1)",
          :common => 4441,
          :condition => {
            :type => 1,
            :id => 3130,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Ghost Rape 2)",
          :common => 4442,
          :condition => {
            :type => 1,
            :id => 3130,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    201 => {
      :name => "Cursed Doll",
      :condition => {
        :type => 3,
        :id => 76
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_doll_hb1"],
          2 => ["Graphics/Pictures/", "ev_doll_hb2"],
          3 => ["Graphics/Pictures/", "ev_doll_hb3"],
          4 => ["Graphics/Pictures/", "ev_doll_ha1"],
          5 => ["Graphics/Pictures/", "ev_doll_ha2"],
          6 => ["Graphics/Pictures/", "ev_doll_ha3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 55
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_doll_hc01"],
          2 => ["Graphics/Pictures/", "ev_doll_hc02"],
          3 => ["Graphics/Pictures/", "ev_doll_hc03"],
          4 => ["Graphics/Pictures/", "ev_doll_hc04"],
          5 => ["Graphics/Pictures/", "ev_doll_hc05"],
          6 => ["Graphics/Pictures/", "ev_doll_hc06"],
          7 => ["Graphics/Pictures/", "ev_doll_hc07"],
          8 => ["Graphics/Pictures/", "ev_doll_hc08"],
          9 => ["Graphics/Pictures/", "ev_doll_hc09"],
          10 => ["Graphics/Pictures/", "ev_doll_hc10"],
          11 => ["Graphics/Pictures/", "ev_doll_hc11"],
          12 => ["Graphics/Pictures/", "ev_doll_hc12"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
        ],
          :condition => {
            :type => 1,
            :id => 3131,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3076,
          :background => {
            :id => 55
          }
        },
        2 => {
          :name => "Request 1 (Soul Sucking Hair)",
          :common => 4446,
          :condition => {
            :type => 1,
            :id => 3131,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4447,
          :condition => {
            :type => 1,
            :id => 3131,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Fool Around)",
          :common => 4448,
          :condition => {
            :type => 1,
            :id => 3131,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    202 => {
      :name => "Zombie Swordsman",
      :condition => {
        :type => 3,
        :id => 77
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_zonbe_h0"],
          2 => ["Graphics/Pictures/", "ev_zonbe_h1"],
          3 => ["Graphics/Pictures/", "ev_zonbe_h2"],
          4 => ["Graphics/Pictures/", "ev_zonbe_h3"],
          5 => ["Graphics/Pictures/", "ev_zonbe_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 55
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3077,
          :background => {
            :id => 55
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4456,
          :condition => {
            :type => 1,
            :id => 3132,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    203 => {
      :name => "Zombies",
      :condition => {
        :type => 3,
        :id => 78
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_zonbes_h1"],
          2 => ["Graphics/Pictures/", "ev_zonbes_h2"],
          3 => ["Graphics/Pictures/", "ev_zonbes_h3"],
          4 => ["Graphics/Pictures/", "ev_zonbes_h4"],
          5 => ["Graphics/Pictures/", "ev_zonbes_h5"],
          6 => ["Graphics/Pictures/", "ev_zonbes_h6"],
          7 => ["Graphics/Pictures/", "ev_zonbes_h7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 55
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3078,
          :background => {
            :id => 55
          }
        },
        2 => {
          :name => "Request 1 (Gangrape)",
          :common => 4461,
          :condition => {
            :type => 1,
            :id => 3133,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    204 => {
      :name => "Elf",
      :condition => {
        :type => 3,
        :id => 84
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_elf_h1"],
          2 => ["Graphics/Pictures/", "ev_elf_h2"],
          3 => ["Graphics/Pictures/", "ev_elf_h3"],
          4 => ["Graphics/Pictures/", "ev_elf_h4"],
          5 => ["Graphics/Pictures/", "ev_elf_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 3
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3084,
          :background => {
            :id => 3
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4476,
          :condition => {
            :type => 1,
            :id => 3136,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    205 => {
      :name => "Brownies",
      :condition => {
        :type => 3,
        :id => 85
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_braunys_h01"],
          2 => ["Graphics/Pictures/", "ev_braunys_h02"],
          3 => ["Graphics/Pictures/", "ev_braunys_h03"],
          4 => ["Graphics/Pictures/", "ev_braunys_h04"],
          5 => ["Graphics/Pictures/", "ev_braunys_h05"],
          6 => ["Graphics/Pictures/", "ev_braunys_h06"],
          7 => ["Graphics/Pictures/", "ev_braunys_h07"],
          8 => ["Graphics/Pictures/", "ev_braunys_h08"],
          9 => ["Graphics/Pictures/", "ev_braunys_h09"],
          10 => ["Graphics/Pictures/", "ev_braunys_h10"],
          11 => ["Graphics/Pictures/", "ev_braunys_h11"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
        ],
          :background => {
            :id => 3
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3085,
          :background => {
            :id => 3
          }
        },
        2 => {
          :name => "Request 1 (Double Blowjob)",
          :common => 4481,
          :condition => {
            :type => 1,
            :id => 3137,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    206 => {
      :name => "Twin Fairies",
      :condition => {
        :type => 3,
        :id => 86
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_tfairy_st02"],
          2 => ["Graphics/Pictures/", "ev_tfairy_ct01"],
          3 => ["Graphics/Pictures/", "ev_tfairy_ct02"],
          4 => ["Graphics/Pictures/", "ev_tfairy_ct03"],
          5 => ["Graphics/Pictures/", "ev_tfairy_ct11"],
          6 => ["Graphics/Pictures/", "ev_tfairy_ct12"],
          7 => ["Graphics/Pictures/", "ev_tfairy_ct13"],
          8 => ["Graphics/Pictures/", "ev_tfairy_ct21"],
          9 => ["Graphics/Pictures/", "ev_tfairy_ct22"],
          10 => ["Graphics/Pictures/", "ev_tfairy_ct23"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [1, 4],
          [1, 5],
          [1, 6],
          [1, 7],
          [1, 8],
          [1, 9],
          [1, 10],
        ],
          :background => {
            :id => 3
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3086,
          :background => {
            :id => 3
          }
        },
        2 => {
          :name => "Request 1 (Twin Fairy Hug)",
          :common => 4486,
          :condition => {
            :type => 1,
            :id => 3138,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    207 => {
      :name => "Fairies",
      :condition => {
        :type => 3,
        :id => 87
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_fairys_h1"],
          2 => ["Graphics/Pictures/", "ev_fairys_h2"],
          3 => ["Graphics/Pictures/", "ev_fairys_h3"],
          4 => ["Graphics/Pictures/", "ev_fairys_h4"],
          5 => ["Graphics/Pictures/", "ev_fairys_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 3
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3087,
          :background => {
            :id => 3
          }
        },
        2 => {
          :name => "Request 1 (Group Tickle)",
          :common => 4491,
          :condition => {
            :type => 1,
            :id => 3139,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    208 => {
      :name => "Tarantula Girl",
      :condition => {
        :type => 3,
        :id => 95
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_taran_h1"],
          2 => ["Graphics/Pictures/", "ev_taran_h2"],
          3 => ["Graphics/Pictures/", "ev_taran_h3"],
          4 => ["Graphics/Pictures/", "ev_taran_h4"],
          5 => ["Graphics/Pictures/", "ev_taran_h5"],
          6 => ["Graphics/Pictures/", "ev_taran_ct01"],
          7 => ["Graphics/Pictures/", "ev_taran_ct02"],
          8 => ["Graphics/Pictures/", "ev_taran_ct03"],
          9 => ["Graphics/Pictures/", "ev_taran_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [2, 6],
          [3, 7],
          [4, 8],
          [5, 9],
        ],
          :background => {
            :id => 6
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3095,
          :background => {
            :id => 6
          }
        },
        2 => {
          :name => "Request 1 (Tarantula Rape 1)",
          :common => 4496,
          :condition => {
            :type => 1,
            :id => 3140,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Tarantula Rape 2)",
          :common => 4497,
          :condition => {
            :type => 1,
            :id => 3140,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    209 => {
      :name => "Minotauros",
      :condition => {
        :type => 3,
        :id => 96
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_mino_st01"],
          2 => ["Graphics/Pictures/", "ev_mino_ct11"],
          3 => ["Graphics/Pictures/", "ev_mino_ct12"],
          4 => ["Graphics/Pictures/", "ev_mino_ct13"],
          5 => ["Graphics/Pictures/", "ev_mino_h1"],
          6 => ["Graphics/Pictures/", "ev_mino_h2"],
          7 => ["Graphics/Pictures/", "ev_mino_h3"],
          8 => ["Graphics/Pictures/", "ev_mino_ct01"],
          9 => ["Graphics/Pictures/", "ev_mino_ct02"],
          10 => ["Graphics/Pictures/", "ev_mino_ct03"],
          11 => ["Graphics/Pictures/", "ev_mino_ct04"],
          12 => ["Graphics/Pictures/", "ev_mino_ct05"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [1, 4],
          [5],
          [5, 8],
          [6, 9],
          [6, 10],
          [7, 11],
          [7, 12],
        ],
          :background => {
            :id => 6
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3096,
          :background => {
            :id => 6
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 4501,
          :condition => {
            :type => 1,
            :id => 3141,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    210 => {
      :name => "Bandersnatch Girl",
      :condition => {
        :type => 3,
        :id => 97
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_bander_hb1"],
          2 => ["Graphics/Pictures/", "ev_bander_hb2"],
          3 => ["Graphics/Pictures/", "ev_bander_hb3"],
          4 => ["Graphics/Pictures/", "ev_bander_hb4"],
          5 => ["Graphics/Pictures/", "ev_bander_ha1"],
          6 => ["Graphics/Pictures/", "ev_bander_ha2"],
          7 => ["Graphics/Pictures/", "ev_bander_ha3"],
          8 => ["Graphics/Pictures/", "ev_bander_ha4"],
          9 => ["Graphics/Pictures/", "ev_bander_ct01"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [5, 9],
          [6, 9],
          [7, 9],
          [8, 9],
        ],
          :background => {
            :id => 6
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_bander_hc1"],
          2 => ["Graphics/Pictures/", "ev_bander_hc2"],
          3 => ["Graphics/Pictures/", "ev_bander_hc3"],
          4 => ["Graphics/Pictures/", "ev_bander_hc4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3142,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3097,
          :background => {
            :id => 6
          }
        },
        2 => {
          :name => "Request 1 (Handjob)",
          :common => 4506,
          :condition => {
            :type => 1,
            :id => 3142,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Soul Sucking Paizuri)",
          :common => 4507,
          :condition => {
            :type => 1,
            :id => 3142,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Semen Squeezing Paizuri)",
          :common => 4508,
          :condition => {
            :type => 1,
            :id => 3142,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    211 => {
      :name => "Eva",
      :condition => {
        :type => 3,
        :id => 98
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_eva_hb1"],
          2 => ["Graphics/Pictures/", "ev_eva_hb2"],
          3 => ["Graphics/Pictures/", "ev_eva_hb3"],
          4 => ["Graphics/Pictures/", "ev_eva_hb4"],
          5 => ["Graphics/Pictures/", "ev_eva_hb5"],
          6 => ["Graphics/Pictures/", "ev_eva_hb6"],
          7 => ["Graphics/Pictures/", "ev_eva_ha1"],
          8 => ["Graphics/Pictures/", "ev_eva_ha2"],
          9 => ["Graphics/Pictures/", "ev_eva_ha3"],
          10 => ["Graphics/Pictures/", "ev_eva_ha4"],
          11 => ["Graphics/Pictures/", "ev_eva_ha5"],
          12 => ["Graphics/Pictures/", "ev_eva_ha6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
        ],
          :background => {
            :id => 7
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_eva_st02"],
          2 => ["Graphics/Pictures/", "ev_eva_ct01"],
          3 => ["Graphics/Pictures/", "ev_eva_ct02"],
          4 => ["Graphics/Pictures/", "ev_eva_ct03"],
          5 => ["Graphics/Pictures/", "ev_eva_ct04"],
          6 => ["Graphics/Pictures/", "ev_eva_ct11"],
          7 => ["Graphics/Pictures/", "ev_eva_ct12"],
          8 => ["Graphics/Pictures/", "ev_eva_ct13"],
          9 => ["Graphics/Pictures/", "ev_eva_ct14"],
          10 => ["Graphics/Pictures/", "ev_eva_ct21"],
          11 => ["Graphics/Pictures/", "ev_eva_ct22"],
          12 => ["Graphics/Pictures/", "ev_eva_ct23"],
          13 => ["Graphics/Pictures/", "ev_eva_ct24"],
          14 => ["Graphics/Pictures/", "ev_eva_ct31"],
          15 => ["Graphics/Pictures/", "ev_eva_ct32"],
          16 => ["Graphics/Pictures/", "ev_eva_ct33"],
          17 => ["Graphics/Pictures/", "ev_eva_ct34"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [1, 4],
          [1, 5],
          [1, 6],
          [1, 7],
          [1, 8],
          [1, 9],
          [1, 10],
          [1, 11],
          [1, 12],
          [1, 13],
          [1, 14],
          [1, 15],
          [1, 16],
          [1, 17],
        ],
          :condition => {
            :type => 1,
            :id => 3143,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_eva_hc1"],
          2 => ["Graphics/Pictures/", "ev_eva_hc2"],
          3 => ["Graphics/Pictures/", "ev_eva_hc3"],
          4 => ["Graphics/Pictures/", "ev_eva_hc4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3098,
          :background => {
            :id => 7
          }
        },
        2 => {
          :name => "Request 1 (Energy Drain)",
          :common => 4511,
          :condition => {
            :type => 1,
            :id => 3143,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Succubus Paizuri)",
          :common => 4512,
          :condition => {
            :type => 1,
            :id => 3143,
            :op => 1,
            :value => 20
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Succubus Blowjob)",
          :common => 4513,
          :condition => {
            :type => 1,
            :id => 3143,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 4 (Succubus Armpit)",
          :common => 4514,
          :condition => {
            :type => 1,
            :id => 3143,
            :op => 1,
            :value => 40
          },
          :background => {
            :id => 1
          }
        },
        6 => {
          :name => "Request 5 (Succubus Footjob)",
          :common => 4515,
          :condition => {
            :type => 1,
            :id => 3143,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        7 => {
          :name => "Request 6 (Face-Sitting Milking)",
          :common => 4516,
          :condition => {
            :type => 1,
            :id => 3143,
            :op => 1,
            :value => 70
          },
          :background => {
            :id => 1
          }
        },
        8 => {
          :name => "Request 7 (Face-Sitting Tail Sucking)",
          :common => 4517,
          :condition => {
            :type => 1,
            :id => 3143,
            :op => 1,
            :value => 80
          },
          :background => {
            :id => 1
          }
        },
        9 => {
          :name => "Request 8 (Succubus Vagina)",
          :common => 4518,
          :condition => {
            :type => 1,
            :id => 3143,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        10 => {
          :name => "Loop Event (Blowjob)",
          :common => 5792,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    212 => {
      :name => "Queen Eva",
      :condition => {
        :type => 3,
        :id => 696
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_evaq_h01"],
          2 => ["Graphics/Pictures/", "ev_evaq_h02"],
          3 => ["Graphics/Pictures/", "ev_evaq_h03"],
          4 => ["Graphics/Pictures/", "ev_evaq_h04"],
          5 => ["Graphics/Pictures/", "ev_evaq_h05"],
          6 => ["Graphics/Pictures/", "ev_evaq_h06"],
          7 => ["Graphics/Pictures/", "ev_evaq_h07"],
          8 => ["Graphics/Pictures/", "ev_evaq_h08"],
          9 => ["Graphics/Pictures/", "ev_evaq_h09"],
          10 => ["Graphics/Pictures/", "ev_evaq_h10"],
          11 => ["Graphics/Pictures/", "ev_evaq_hb01"],
          12 => ["Graphics/Pictures/", "ev_evaq_hb02"],
          13 => ["Graphics/Pictures/", "ev_evaq_hb03"],
          14 => ["Graphics/Pictures/", "ev_evaq_hb04"],
          15 => ["Graphics/Pictures/", "ev_evaq_hb05"],
          16 => ["Graphics/Pictures/", "ev_evaq_hb06"],
          17 => ["Graphics/Pictures/", "ev_evaq_hb07"],
          18 => ["Graphics/Pictures/", "ev_evaq_hb08"],
          19 => ["Graphics/Pictures/", "ev_evaq_hb09"],
          20 => ["Graphics/Pictures/", "ev_evaq_hb10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
        ],
          :background => {
            :id => 61
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3696,
          :background => {
            :id => 61
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 6536,
          :condition => {
            :type => 1,
            :id => 3611,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    213 => {
      :name => "Sables",
      :condition => {
        :type => 3,
        :id => 99
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_saboresu_st02"],
          2 => ["Graphics/Pictures/", "ev_saboresu_ct01"],
          3 => ["Graphics/Pictures/", "ev_saboresu_ct02"],
          4 => ["Graphics/Pictures/", "ev_saboresu_ct03"],
          5 => ["Graphics/Pictures/", "ev_saboresu_h1"],
          6 => ["Graphics/Pictures/", "ev_saboresu_h2"],
          7 => ["Graphics/Pictures/", "ev_saboresu_h3"],
          8 => ["Graphics/Pictures/", "ev_saboresu_h4"],
          9 => ["Graphics/Pictures/", "ev_saboresu_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [1, 4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 7
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3099,
          :background => {
            :id => 7
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Hole)",
          :common => 4521,
          :condition => {
            :type => 1,
            :id => 3144,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    214 => {
      :name => "Centipede Girl",
      :condition => {
        :type => 3,
        :id => 100
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_mukade_h1"],
          2 => ["Graphics/Pictures/", "ev_mukade_h2"],
          3 => ["Graphics/Pictures/", "ev_mukade_ct01"],
          4 => ["Graphics/Pictures/", "ev_mukade_ct02"],
          5 => ["Graphics/Pictures/", "ev_mukade_h3"],
          6 => ["Graphics/Pictures/", "ev_mukade_h4"],
          7 => ["Graphics/Pictures/", "ev_mukade_h5"],
          8 => ["Graphics/Pictures/", "ev_mukade_ct03"],
          9 => ["Graphics/Pictures/", "ev_mukade_ct04"],
          10 => ["Graphics/Pictures/", "ev_mukade_ct05"],
          11 => ["Graphics/Pictures/", "ev_mukade_ct06"],
          12 => ["Graphics/Pictures/", "ev_mukade_hb1"],
          13 => ["Graphics/Pictures/", "ev_mukade_hb2"],
          14 => ["Graphics/Pictures/", "ev_mukade_hb3"],
          15 => ["Graphics/Pictures/", "ev_mukade_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1, 3],
          [2, 4],
          [5],
          [5, 8],
          [6, 9],
          [7, 10],
          [7, 11],
          [12],
          [13],
          [14],
          [15],
        ],
          :background => {
            :id => 19
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3100,
          :background => {
            :id => 19
          }
        },
        2 => {
          :name => "Request 1 (Mating)",
          :common => 4526,
          :condition => {
            :type => 1,
            :id => 3145,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    215 => {
      :name => "Scorpion Girl",
      :condition => {
        :type => 3,
        :id => 101
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_sasori_h1"],
          2 => ["Graphics/Pictures/", "ev_sasori_h2"],
          3 => ["Graphics/Pictures/", "ev_sasori_h3"],
          4 => ["Graphics/Pictures/", "ev_sasori_h4"],
          5 => ["Graphics/Pictures/", "ev_sasori_ct01"],
          6 => ["Graphics/Pictures/", "ev_sasori_ct02"],
          7 => ["Graphics/Pictures/", "ev_sasori_ct03"],
          8 => ["Graphics/Pictures/", "ev_sasori_ct04"],
          9 => ["Graphics/Pictures/", "ev_sasori_hb1"],
          10 => ["Graphics/Pictures/", "ev_sasori_hb2"],
          11 => ["Graphics/Pictures/", "ev_sasori_hb3"],
          12 => ["Graphics/Pictures/", "ev_sasori_hb4"],
          13 => ["Graphics/Pictures/", "ev_sasori_hb5"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 5],
          [2, 6],
          [3, 7],
          [4, 8],
          [9],
          [10],
          [11],
          [12],
          [13],
        ],
          :background => {
            :id => 11
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3101,
          :background => {
            :id => 11
          }
        },
        2 => {
          :name => "Request 1 (Petra Scorpio 1)",
          :common => 4531,
          :condition => {
            :type => 1,
            :id => 3146,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Petra Scorpio 2)",
          :common => 4532,
          :condition => {
            :type => 1,
            :id => 3146,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    216 => {
      :name => "Cactus Girl",
      :condition => {
        :type => 3,
        :id => 102
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_saboten_h1"],
          2 => ["Graphics/Pictures/", "ev_saboten_h2"],
          3 => ["Graphics/Pictures/", "ev_saboten_h3"],
          4 => ["Graphics/Pictures/", "ev_saboten_h4"],
          5 => ["Graphics/Pictures/", "ev_saboten_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 11
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3102,
          :background => {
            :id => 11
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Hole)",
          :common => 4536,
          :condition => {
            :type => 1,
            :id => 3147,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    217 => {
      :name => "Ostrich Girl",
      :condition => {
        :type => 3,
        :id => 103
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_datyou_h1"],
          2 => ["Graphics/Pictures/", "ev_datyou_h2"],
          3 => ["Graphics/Pictures/", "ev_datyou_h3"],
          4 => ["Graphics/Pictures/", "ev_datyou_h4"],
          5 => ["Graphics/Pictures/", "ev_datyou_h5"],
          6 => ["Graphics/Pictures/", "ev_datyou_h6"],
          7 => ["Graphics/Pictures/", "ev_datyou_h7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 11
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3103,
          :background => {
            :id => 11
          }
        },
        2 => {
          :name => "Request 1 (Mating)",
          :common => 4541,
          :condition => {
            :type => 1,
            :id => 3148,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    218 => {
      :name => "Lamp Genie",
      :condition => {
        :type => 3,
        :id => 104
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lamp_h1"],
          2 => ["Graphics/Pictures/", "ev_lamp_h2"],
          3 => ["Graphics/Pictures/", "ev_lamp_h3"],
          4 => ["Graphics/Pictures/", "ev_lamp_h4"],
          5 => ["Graphics/Pictures/", "ev_lamp_h5"],
          6 => ["Graphics/Pictures/", "ev_lamp_h6"],
          7 => ["Graphics/Pictures/", "ev_lamp_h7"],
          8 => ["Graphics/Pictures/", "ev_lamp_ct01"],
          9 => ["Graphics/Pictures/", "ev_lamp_ct02"],
          10 => ["Graphics/Pictures/", "ev_lamp_ct03"],
          11 => ["Graphics/Pictures/", "ev_lamp_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7, 8],
          [7, 9],
          [7, 10],
          [7, 11],
        ],
          :background => {
            :id => 11
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3104,
          :background => {
            :id => 11
          }
        },
        2 => {
          :name => "Request 1 (Predation)",
          :common => 4546,
          :condition => {
            :type => 1,
            :id => 3149,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Predation...?)",
          :common => 4547,
          :condition => {
            :type => 1,
            :id => 3149,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    219 => {
      :name => "Mummy Girl",
      :condition => {
        :type => 3,
        :id => 105
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_mummy_st11"],
          2 => ["Graphics/Pictures/", "ev_mummy_st12"],
          3 => ["Graphics/Pictures/", "ev_mummy_h1"],
          4 => ["Graphics/Pictures/", "ev_mummy_h2"],
          5 => ["Graphics/Pictures/", "ev_mummy_h3"],
          6 => ["Graphics/Pictures/", "ev_mummy_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 57
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3105,
          :background => {
            :id => 57
          }
        },
        2 => {
          :name => "Request 1 (Mummy Handjob 1)",
          :common => 4551,
          :condition => {
            :type => 1,
            :id => 3150,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Mummy Handjob 2)",
          :common => 4552,
          :condition => {
            :type => 1,
            :id => 3150,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    220 => {
      :name => "Cobra Girl",
      :condition => {
        :type => 3,
        :id => 106
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kobura_h1"],
          2 => ["Graphics/Pictures/", "ev_kobura_h2"],
          3 => ["Graphics/Pictures/", "ev_kobura_h3"],
          4 => ["Graphics/Pictures/", "ev_kobura_h4"],
          5 => ["Graphics/Pictures/", "ev_kobura_h5"],
          6 => ["Graphics/Pictures/", "ev_kobura_ct01"],
          7 => ["Graphics/Pictures/", "ev_kobura_ct02"],
          8 => ["Graphics/Pictures/", "ev_kobura_ct03"],
          9 => ["Graphics/Pictures/", "ev_kobura_ct04"],
          10 => ["Graphics/Pictures/", "ev_kobura_hb1"],
          11 => ["Graphics/Pictures/", "ev_kobura_hb2"],
          12 => ["Graphics/Pictures/", "ev_kobura_hb3"],
          13 => ["Graphics/Pictures/", "ev_kobura_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2, 6],
          [3, 7],
          [4, 8],
          [5, 9],
          [10],
          [11],
          [12],
          [13],
        ],
          :background => {
            :id => 57
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kobura_hc1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3106,
          :background => {
            :id => 57
          }
        },
        2 => {
          :name => "Request 1 (Mating 1)",
          :common => 4556,
          :condition => {
            :type => 1,
            :id => 3151,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Mating 2)",
          :common => 4557,
          :condition => {
            :type => 1,
            :id => 3151,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Loop Event (Predation)",
          :common => 5811,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    221 => {
      :name => "Nefertiti Lamias",
      :condition => {
        :type => 3,
        :id => 107
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lamias_ha1"],
          2 => ["Graphics/Pictures/", "ev_lamias_ha2"],
          3 => ["Graphics/Pictures/", "ev_lamias_ha3"],
          4 => ["Graphics/Pictures/", "ev_lamias_ha4"],
          5 => ["Graphics/Pictures/", "ev_lamias_hb1"],
          6 => ["Graphics/Pictures/", "ev_lamias_hb2"],
          7 => ["Graphics/Pictures/", "ev_lamias_hb3"],
          8 => ["Graphics/Pictures/", "ev_lamias_hb4"],
          9 => ["Graphics/Pictures/", "ev_lamias_hb5"],
          10 => ["Graphics/Pictures/", "ev_lamias_hc1"],
          11 => ["Graphics/Pictures/", "ev_lamias_hc2"],
          12 => ["Graphics/Pictures/", "ev_lamias_hc3"],
          13 => ["Graphics/Pictures/", "ev_lamias_hd1"],
          14 => ["Graphics/Pictures/", "ev_lamias_hd2"],
          15 => ["Graphics/Pictures/", "ev_lamias_hd3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
        ],
          :background => {
            :id => 57
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3107,
          :background => {
            :id => 57
          }
        },
        2 => {
          :name => "Request 1 (Eldest Sister Reverse Rape)",
          :common => 4561,
          :condition => {
            :type => 1,
            :id => 3152,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Second Sister Reverse Rape)",
          :common => 4562,
          :condition => {
            :type => 1,
            :id => 3152,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Third Sister Reverse Rape)",
          :common => 4563,
          :condition => {
            :type => 1,
            :id => 3152,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 4 (Youngest Sister Reverse Rape)",
          :common => 4564,
          :condition => {
            :type => 1,
            :id => 3152,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    222 => {
      :name => "Sphinx",
      :condition => {
        :type => 3,
        :id => 108
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_sphinx_h1"],
          2 => ["Graphics/Pictures/", "ev_sphinx_h2"],
          3 => ["Graphics/Pictures/", "ev_sphinx_h3"],
          4 => ["Graphics/Pictures/", "ev_sphinx_h4"],
          5 => ["Graphics/Pictures/", "ev_sphinx_ct01"],
          6 => ["Graphics/Pictures/", "ev_sphinx_ct02"],
          7 => ["Graphics/Pictures/", "ev_sphinx_ct03"],
          8 => ["Graphics/Pictures/", "ev_sphinx_cta01"],
          9 => ["Graphics/Pictures/", "ev_sphinx_cta02"],
          10 => ["Graphics/Pictures/", "ev_sphinx_cta03"],
          11 => ["Graphics/Pictures/", "ev_sphinx_cta04"],
          12 => ["Graphics/Pictures/", "ev_sphinx_cta05"],
          13 => ["Graphics/Pictures/", "ev_sphinx_hb1"],
          14 => ["Graphics/Pictures/", "ev_sphinx_hb2"],
          15 => ["Graphics/Pictures/", "ev_sphinx_hb3"],
          16 => ["Graphics/Pictures/", "ev_sphinx_hb4"],
          17 => ["Graphics/Pictures/", "ev_sphinx_hb5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1, 5],
          [2, 6],
          [3, 7],
          [4],
          [4, 8],
          [4, 9],
          [4, 10],
          [4, 11],
          [4, 12],
          [13],
          [14],
          [15],
          [16],
          [17],
        ],
          :background => {
            :id => 58
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_sphinx_hc1"],
          2 => ["Graphics/Pictures/", "ev_sphinx_hd1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3108,
          :background => {
            :id => 58
          }
        },
        2 => {
          :name => "Request 1 (Predation)",
          :common => 4566,
          :condition => {
            :type => 1,
            :id => 3153,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Predation...?)",
          :common => 4567,
          :condition => {
            :type => 1,
            :id => 3153,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Loop Event (Reverse Rape)",
          :common => 5828,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        },
        5 => {
          :name => "Loop Event (Kiss of Death)",
          :common => 5842,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    223 => {
      :name => "Alligator Girl",
      :condition => {
        :type => 3,
        :id => 111
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_wani_h01"],
          2 => ["Graphics/Pictures/", "ev_wani_h02"],
          3 => ["Graphics/Pictures/", "ev_wani_h03"],
          4 => ["Graphics/Pictures/", "ev_wani_h04"],
          5 => ["Graphics/Pictures/", "ev_wani_h05"],
          6 => ["Graphics/Pictures/", "ev_wani_h06"],
          7 => ["Graphics/Pictures/", "ev_wani_h07"],
          8 => ["Graphics/Pictures/", "ev_wani_h08"],
          9 => ["Graphics/Pictures/", "ev_wani_h09"],
          10 => ["Graphics/Pictures/", "ev_wani_h10"],
          11 => ["Graphics/Pictures/", "ev_wani_h11"],
          12 => ["Graphics/Pictures/", "ev_wani_h12"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
        ],
          :background => {
            :id => 60
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3111,
          :background => {
            :id => 60
          }
        },
        2 => {
          :name => "Request 1 (Predation)",
          :common => 4571,
          :condition => {
            :type => 1,
            :id => 3154,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Predation...?)",
          :common => 4572,
          :condition => {
            :type => 1,
            :id => 3154,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    224 => {
      :name => "Saki",
      :condition => {
        :type => 3,
        :id => 112
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_saki_ha01"],
          2 => ["Graphics/Pictures/", "ev_saki_ha02"],
          3 => ["Graphics/Pictures/", "ev_saki_ha03"],
          4 => ["Graphics/Pictures/", "ev_saki_ha04"],
          5 => ["Graphics/Pictures/", "ev_saki_ha05"],
          6 => ["Graphics/Pictures/", "ev_saki_ha06"],
          7 => ["Graphics/Pictures/", "ev_saki_ha07"],
          8 => ["Graphics/Pictures/", "ev_saki_ha08"],
          9 => ["Graphics/Pictures/", "ev_saki_ha09"],
          10 => ["Graphics/Pictures/", "ev_saki_ha10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 61
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_saki_hb01"],
          2 => ["Graphics/Pictures/", "ev_saki_hb02"],
          3 => ["Graphics/Pictures/", "ev_saki_hb03"],
          4 => ["Graphics/Pictures/", "ev_saki_hb04"],
          5 => ["Graphics/Pictures/", "ev_saki_hb05"],
          6 => ["Graphics/Pictures/", "ev_saki_hb06"],
          7 => ["Graphics/Pictures/", "ev_saki_hb07"],
          8 => ["Graphics/Pictures/", "ev_saki_hb08"],
          9 => ["Graphics/Pictures/", "ev_saki_hb09"],
          10 => ["Graphics/Pictures/", "ev_saki_hb10"],
          11 => ["Graphics/Pictures/", "ev_saki_hb11"],
          12 => ["Graphics/Pictures/", "ev_saki_hc01"],
          13 => ["Graphics/Pictures/", "ev_saki_hc02"],
          14 => ["Graphics/Pictures/", "ev_saki_hc03"],
          15 => ["Graphics/Pictures/", "ev_saki_hc04"],
          16 => ["Graphics/Pictures/", "ev_saki_hc05"],
          17 => ["Graphics/Pictures/", "ev_saki_hc06"],
          18 => ["Graphics/Pictures/", "ev_saki_hc07"],
          19 => ["Graphics/Pictures/", "ev_saki_hc08"],
          20 => ["Graphics/Pictures/", "ev_saki_hc09"],
          21 => ["Graphics/Pictures/", "ev_saki_hc10"],
          22 => ["Graphics/Pictures/", "ev_saki_hd1"],
          23 => ["Graphics/Pictures/", "ev_saki_hd2"],
          24 => ["Graphics/Pictures/", "ev_saki_hd3"],
          25 => ["Graphics/Pictures/", "ev_saki_hd4"],
          26 => ["Graphics/Pictures/", "ev_saki_he1"],
          27 => ["Graphics/Pictures/", "ev_saki_he2"],
          28 => ["Graphics/Pictures/", "ev_saki_he3"],
          29 => ["Graphics/Pictures/", "ev_saki_he4"],
          30 => ["Graphics/Pictures/", "ev_saki_he5"],
          31 => ["Graphics/Pictures/", "ev_saki_he6"],
          32 => ["Graphics/Pictures/", "ev_saki_he7"],
          33 => ["Graphics/Pictures/", "ev_saki_he8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
          [26],
          [27],
          [28],
          [29],
          [30],
          [31],
          [32],
          [33],
        ],
          :condition => {
            :type => 1,
            :id => 3155,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3112,
          :background => {
            :id => 61
          }
        },
        2 => {
          :name => "Request 1 (No Touching!)",
          :common => 4576,
          :condition => {
            :type => 1,
            :id => 3155,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (No Stripping!)",
          :common => 4577,
          :condition => {
            :type => 1,
            :id => 3155,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (SEX OK!!)",
          :common => 4578,
          :condition => {
            :type => 1,
            :id => 3155,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Night Live:Secret",
          :common => 319,
          :condition => {
            :type => 7,
            :id => 527
          },
          :background => {
            :id => 61
          }
        },
        6 => {
          :name => "Night Live:Serious",
          :common => 320,
          :condition => {
            :type => 7,
            :id => 527
          },
          :background => {
            :id => 61
          }
        },
        7 => {
          :name => "Night Live:Performance",
          :common => 321,
          :condition => {
            :type => 7,
            :id => 527
          },
          :background => {
            :id => 61
          }
        }
      }
    },
    225 => {
      :name => "Devil Fighter",
      :condition => {
        :type => 3,
        :id => 113
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_d_fighter_hb1"],
          2 => ["Graphics/Pictures/", "ev_d_fighter_hb2"],
          3 => ["Graphics/Pictures/", "ev_d_fighter_hb3"],
          4 => ["Graphics/Pictures/", "ev_d_fighter_hb4"],
          5 => ["Graphics/Pictures/", "ev_d_fighter_hb5"],
          6 => ["Graphics/Pictures/", "ev_d_fighter_hb6"],
          7 => ["Graphics/Pictures/", "ev_d_fighter_hb7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 7
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_d_fighter_ha01"],
          2 => ["Graphics/Pictures/", "ev_d_fighter_ha02"],
          3 => ["Graphics/Pictures/", "ev_d_fighter_ha03"],
          4 => ["Graphics/Pictures/", "ev_d_fighter_ha04"],
          5 => ["Graphics/Pictures/", "ev_d_fighter_ha05"],
          6 => ["Graphics/Pictures/", "ev_d_fighter_ha06"],
          7 => ["Graphics/Pictures/", "ev_d_fighter_ha07"],
          8 => ["Graphics/Pictures/", "ev_d_fighter_ha08"],
          9 => ["Graphics/Pictures/", "ev_d_fighter_ha09"],
          10 => ["Graphics/Pictures/", "ev_d_fighter_ha10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :condition => {
            :type => 1,
            :id => 3156,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3113,
          :background => {
            :id => 7
          }
        },
        2 => {
          :name => "Request 1 (Blowjob)",
          :common => 4581,
          :condition => {
            :type => 1,
            :id => 3156,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4582,
          :condition => {
            :type => 1,
            :id => 3156,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    226 => {
      :name => "Oogumo",
      :condition => {
        :type => 3,
        :id => 114
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_oogumo_st02"],
          2 => ["Graphics/Pictures/", "ev_oogumo_ct01"],
          3 => ["Graphics/Pictures/", "ev_oogumo_ct02"],
          4 => ["Graphics/Pictures/", "ev_oogumo_ct03"],
          5 => ["Graphics/Pictures/", "ev_oogumo_h01"],
          6 => ["Graphics/Pictures/", "ev_oogumo_h02"],
          7 => ["Graphics/Pictures/", "ev_oogumo_h03"],
          8 => ["Graphics/Pictures/", "ev_oogumo_h04"],
          9 => ["Graphics/Pictures/", "ev_oogumo_h05"],
          10 => ["Graphics/Pictures/", "ev_oogumo_h06"],
          11 => ["Graphics/Pictures/", "ev_oogumo_h07"],
          12 => ["Graphics/Pictures/", "ev_oogumo_h08"],
          13 => ["Graphics/Pictures/", "ev_oogumo_h09"],
          14 => ["Graphics/Pictures/", "ev_oogumo_h10"],
          15 => ["Graphics/Pictures/", "ev_oogumo_h11"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [1, 4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
        ],
          :background => {
            :id => 7
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3114,
          :background => {
            :id => 7
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Oviduct)",
          :common => 4586,
          :condition => {
            :type => 1,
            :id => 3157,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    227 => {
      :name => "Suck Vore",
      :condition => {
        :type => 3,
        :id => 115
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_suckvore_h1"],
          2 => ["Graphics/Pictures/", "ev_suckvore_h2"],
          3 => ["Graphics/Pictures/", "ev_suckvore_h3"],
          4 => ["Graphics/Pictures/", "ev_suckvore_h4"],
          5 => ["Graphics/Pictures/", "ev_suckvore_h5"],
          6 => ["Graphics/Pictures/", "ev_suckvore_h6"],
          7 => ["Graphics/Pictures/", "ev_suckvore_h7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 62
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_suckvore_hb1"],
          2 => ["Graphics/Pictures/", "ev_suckvore_hb2"],
          3 => ["Graphics/Pictures/", "ev_suckvore_hb3"],
          4 => ["Graphics/Pictures/", "ev_suckvore_hb4"],
          5 => ["Graphics/Pictures/", "ev_suckvore_hb5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 1,
            :id => 3158,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_suckvore_hc1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3115,
          :background => {
            :id => 62
          }
        },
        2 => {
          :name => "Request 1 (Full Body Tentacle Rub 1)",
          :common => 4591,
          :condition => {
            :type => 1,
            :id => 3158,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Full Body Tentacle Rub 2)",
          :common => 4592,
          :condition => {
            :type => 1,
            :id => 3158,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Tentacle Squeeze)",
          :common => 4593,
          :condition => {
            :type => 1,
            :id => 3158,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Loop Event (Wedding Ceremony)",
          :common => 5829,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    228 => {
      :name => "Iron Maiden",
      :condition => {
        :type => 3,
        :id => 116
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_ironmaiden_st11"],
          2 => ["Graphics/Pictures/", "ev_ironmaiden_st21"],
          3 => ["Graphics/Pictures/", "ev_ironmaiden_h1"],
          4 => ["Graphics/Pictures/", "ev_ironmaiden_h2"],
          5 => ["Graphics/Pictures/", "ev_ironmaiden_h3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 62
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_ironmaiden_hb1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3116,
          :background => {
            :id => 62
          }
        },
        2 => {
          :name => "Request 1 (Death by Pleasure)",
          :common => 4596,
          :condition => {
            :type => 1,
            :id => 3159,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Death by Pleasure...?)",
          :common => 4597,
          :condition => {
            :type => 1,
            :id => 3159,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Loop Event (Cross-dressing Begging)",
          :common => 5807,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    229 => {
      :name => "Worm Villager",
      :condition => {
        :type => 3,
        :id => 117
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_wormv_h1"],
          2 => ["Graphics/Pictures/", "ev_wormv_h2"],
          3 => ["Graphics/Pictures/", "ev_wormv_h3"],
          4 => ["Graphics/Pictures/", "ev_wormv_h6"],
          5 => ["Graphics/Pictures/", "ev_wormv_h7"],
          6 => ["Graphics/Pictures/", "ev_wormv_h8"],
          7 => ["Graphics/Pictures/", "ev_wormv_h9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 62
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_wormv_h1"],
          2 => ["Graphics/Pictures/", "ev_wormv_h4"],
          3 => ["Graphics/Pictures/", "ev_wormv_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :condition => {
            :type => 1,
            :id => 3160,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3117,
          :background => {
            :id => 62
          }
        },
        2 => {
          :name => "Request 1 (Semen Sucking Tentacle)",
          :common => 4601,
          :condition => {
            :type => 1,
            :id => 3160,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    230 => {
      :name => "Ustrel",
      :condition => {
        :type => 3,
        :id => 118
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_ustrel_h1"],
          2 => ["Graphics/Pictures/", "ev_ustrel_h2"],
          3 => ["Graphics/Pictures/", "ev_ustrel_h3"],
          4 => ["Graphics/Pictures/", "ev_ustrel_h4"],
          5 => ["Graphics/Pictures/", "ev_ustrel_h5"],
          6 => ["Graphics/Pictures/", "ev_ustrel_h6"],
          7 => ["Graphics/Pictures/", "ev_ustrel_h7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 62
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3118,
          :background => {
            :id => 62
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Hole)",
          :common => 4606,
          :condition => {
            :type => 1,
            :id => 3161,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Semen Squeezing Hole...?)",
          :common => 4607,
          :condition => {
            :type => 1,
            :id => 3161,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    231 => {
      :name => "Honey Pot",
      :condition => {
        :type => 3,
        :id => 119
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_mitutubo_ha1"],
          2 => ["Graphics/Pictures/", "ev_mitutubo_ha2"],
          3 => ["Graphics/Pictures/", "ev_mitutubo_ha3"],
          4 => ["Graphics/Pictures/", "ev_mitutubo_ha4"],
          5 => ["Graphics/Pictures/", "ev_mitutubo_ha5"],
          6 => ["Graphics/Pictures/", "ev_mitutubo_hb1"],
          7 => ["Graphics/Pictures/", "ev_mitutubo_hb2"],
          8 => ["Graphics/Pictures/", "ev_mitutubo_hb3"],
          9 => ["Graphics/Pictures/", "ev_mitutubo_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 62
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3119,
          :background => {
            :id => 62
          }
        },
        2 => {
          :name => "Request 1 (Mating)",
          :common => 4611,
          :condition => {
            :type => 1,
            :id => 3162,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    232 => {
      :name => "Lily",
      :condition => {
        :type => 3,
        :id => 120
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lily_h01"],
          2 => ["Graphics/Pictures/", "ev_lily_h06"],
          3 => ["Graphics/Pictures/", "ev_lily_h07"],
          4 => ["Graphics/Pictures/", "ev_lily_h08"],
          5 => ["Graphics/Pictures/", "ev_lily_h09"],
          6 => ["Graphics/Pictures/", "ev_lily_h10"],
          7 => ["Graphics/Pictures/", "ev_lily_h11"],
          8 => ["Graphics/Pictures/", "ev_lily_h12"],
          9 => ["Graphics/Pictures/", "ev_lily_h13"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 63
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lily_h01"],
          2 => ["Graphics/Pictures/", "ev_lily_h02"],
          3 => ["Graphics/Pictures/", "ev_lily_h03"],
          4 => ["Graphics/Pictures/", "ev_lily_h04"],
          5 => ["Graphics/Pictures/", "ev_lily_h05"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 1,
            :id => 3163,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3120,
          :background => {
            :id => 63
          }
        },
        2 => {
          :name => "Request 1 (Worm Touch)",
          :common => 4616,
          :condition => {
            :type => 1,
            :id => 3163,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Anal Drain)",
          :common => 4617,
          :condition => {
            :type => 1,
            :id => 3163,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Semen Sucking Tentacle)",
          :common => 4618,
          :condition => {
            :type => 1,
            :id => 3163,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    233 => {
      :name => "Jealous Lily",
      :condition => {
        :type => 3,
        :id => 914
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lily_hb1"],
          2 => ["Graphics/Pictures/", "ev_lily_hb2"],
          3 => ["Graphics/Pictures/", "ev_lily_hb3"],
          4 => ["Graphics/Pictures/", "ev_lily_hb4"],
          5 => ["Graphics/Pictures/", "ev_lily_hb5"],
          6 => ["Graphics/Pictures/", "ev_lily_hb6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 63
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3914,
          :background => {
            :id => 63
          }
        },
        2 => {
          :name => "Begging 1 (Tentacle Death by Squeeze)",
          :common => 4619,
          :condition => {
            :type => 1,
            :id => 3163,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    234 => {
      :name => "Small Oni",
      :condition => {
        :type => 3,
        :id => 121
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kooni_h01"],
          2 => ["Graphics/Pictures/", "ev_kooni_h02"],
          3 => ["Graphics/Pictures/", "ev_kooni_h03"],
          4 => ["Graphics/Pictures/", "ev_kooni_h04"],
          5 => ["Graphics/Pictures/", "ev_kooni_h05"],
          6 => ["Graphics/Pictures/", "ev_kooni_h06"],
          7 => ["Graphics/Pictures/", "ev_kooni_h07"],
          8 => ["Graphics/Pictures/", "ev_kooni_h08"],
          9 => ["Graphics/Pictures/", "ev_kooni_h09"],
          10 => ["Graphics/Pictures/", "ev_kooni_h10"],
          11 => ["Graphics/Pictures/", "ev_kooni_h11"],
          12 => ["Graphics/Pictures/", "ev_kooni_h12"],
          13 => ["Graphics/Pictures/", "ev_kooni_h13"],
          14 => ["Graphics/Pictures/", "ev_kooni_h14"],
          15 => ["Graphics/Pictures/", "ev_kooni_h15"],
          16 => ["Graphics/Pictures/", "ev_kooni_h16"],
          17 => ["Graphics/Pictures/", "ev_kooni_h17"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
        ],
          :background => {
            :id => 64
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kooni_hb1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3121,
          :background => {
            :id => 64
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4621,
          :condition => {
            :type => 1,
            :id => 3164,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Loop Event (Swimsuit Reverse Rape)",
          :common => 5812,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    235 => {
      :name => "Onahole Girl",
      :condition => {
        :type => 3,
        :id => 122
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_onaho_ha1"],
          2 => ["Graphics/Pictures/", "ev_onaho_ha2"],
          3 => ["Graphics/Pictures/", "ev_onaho_ha3"],
          4 => ["Graphics/Pictures/", "ev_onaho_ha4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 64
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3122,
          :background => {
            :id => 64
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Onahole)",
          :common => 4626,
          :condition => {
            :type => 1,
            :id => 3165,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    236 => {
      :name => "Naccubus",
      :condition => {
        :type => 3,
        :id => 123
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_narcubus_hd1"],
          2 => ["Graphics/Pictures/", "ev_narcubus_hd2"],
          3 => ["Graphics/Pictures/", "ev_narcubus_ha1"],
          4 => ["Graphics/Pictures/", "ev_narcubus_ha2"],
          5 => ["Graphics/Pictures/", "ev_narcubus_ha3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 64
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_narcubus_hb1"],
          2 => ["Graphics/Pictures/", "ev_narcubus_hb2"],
          3 => ["Graphics/Pictures/", "ev_narcubus_hb3"],
          4 => ["Graphics/Pictures/", "ev_narcubus_hb4"],
          5 => ["Graphics/Pictures/", "ev_narcubus_hc1"],
          6 => ["Graphics/Pictures/", "ev_narcubus_hc2"],
          7 => ["Graphics/Pictures/", "ev_narcubus_hc3"],
          8 => ["Graphics/Pictures/", "ev_narcubus_hc4"],
          9 => ["Graphics/Pictures/", "ev_narcubus_hc5"],
          10 => ["Graphics/Pictures/", "ev_narcubus_hc6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :condition => {
            :type => 1,
            :id => 3166,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3123,
          :background => {
            :id => 64
          }
        },
        2 => {
          :name => "Request 1 (Stepping Reaction Check)",
          :common => 4631,
          :condition => {
            :type => 1,
            :id => 3166,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Tail Semen Ejection Test)",
          :common => 4632,
          :condition => {
            :type => 1,
            :id => 3166,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Reverse Rape)",
          :common => 4633,
          :condition => {
            :type => 1,
            :id => 3166,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    237 => {
      :name => "Lucia",
      :condition => {
        :type => 3,
        :id => 124
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lusia_ha1"],
          2 => ["Graphics/Pictures/", "ev_lusia_ha2"],
          3 => ["Graphics/Pictures/", "ev_lusia_ha3"],
          4 => ["Graphics/Pictures/", "ev_lusia_ha4"],
          5 => ["Graphics/Pictures/", "ev_lusia_ha5"],
          6 => ["Graphics/Pictures/", "ev_lusia_hb1"],
          7 => ["Graphics/Pictures/", "ev_lusia_hb2"],
          8 => ["Graphics/Pictures/", "ev_lusia_hb3"],
          9 => ["Graphics/Pictures/", "ev_lusia_hb4"],
          10 => ["Graphics/Pictures/", "ev_lusia_ct01"],
          11 => ["Graphics/Pictures/", "ev_lusia_ct02"],
          12 => ["Graphics/Pictures/", "ev_lusia_ct03"],
          13 => ["Graphics/Pictures/", "ev_lusia_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [6, 10],
          [7, 11],
          [7, 12],
          [8, 12],
          [9, 13],
        ],
          :background => {
            :id => 64
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3124,
          :background => {
            :id => 64
          }
        },
        2 => {
          :name => "Request 1 (Predation)",
          :common => 4636,
          :condition => {
            :type => 1,
            :id => 3167,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Soul Draining Blowjob)",
          :common => 4637,
          :condition => {
            :type => 1,
            :id => 3167,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Predation...?)",
          :common => 4638,
          :condition => {
            :type => 1,
            :id => 3167,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    238 => {
      :name => "Jealous Lucia",
      :condition => {
        :type => 2,
        :id => 837
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lusia_hc1"],
          2 => ["Graphics/Pictures/", "ev_lusia_hc2"],
          3 => ["Graphics/Pictures/", "ev_lusia_hc3"],
          4 => ["Graphics/Pictures/", "ev_lusia_hc4"],
          5 => ["Graphics/Pictures/", "ev_lusia_hc5"],
          6 => ["Graphics/Pictures/", "ev_lusia_hc6"],
          7 => ["Graphics/Pictures/", "ev_lusia_hc7"],
          8 => ["Graphics/Pictures/", "ev_lusia_hc8"],
          9 => ["Graphics/Pictures/", "ev_lusia_hc9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 63
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3999,
      :condition => {
        :type => 3,
        :id => 999
      },
          :background => {
            :id => 63
          }
        },
        2 => {
          :name => "Request 1 (Tentacle Energy Drain)",
          :common => 4639,
          :condition => {
            :type => 1,
            :id => 3167,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    239 => {
      :name => "Dodomeki",
      :condition => {
        :type => 3,
        :id => 125
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_dodome_st02"],
          2 => ["Graphics/Pictures/", "ev_dodome_ct01"],
          3 => ["Graphics/Pictures/", "ev_dodome_ct02"],
          4 => ["Graphics/Pictures/", "ev_dodome_ct03"],
          5 => ["Graphics/Pictures/", "ev_dodome_h1"],
          6 => ["Graphics/Pictures/", "ev_dodome_h2"],
          7 => ["Graphics/Pictures/", "ev_dodome_h3"],
          8 => ["Graphics/Pictures/", "ev_dodome_h4"],
          9 => ["Graphics/Pictures/", "ev_dodome_h5"],
          10 => ["Graphics/Pictures/", "ev_dodome_h6"],
          11 => ["Graphics/Pictures/", "ev_dodome_h7"],
          12 => ["Graphics/Pictures/", "ev_dodome_h8"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [1, 4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
        ],
          :background => {
            :id => 7
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3125,
          :background => {
            :id => 7
          }
        },
        2 => {
          :name => "Request 1 (Blowjob)",
          :common => 4641,
          :condition => {
            :type => 1,
            :id => 3168,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    240 => {
      :name => "Lizard Thief A",
      :condition => {
        :type => 3,
        :id => 126
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lizardthief_ha01"],
          2 => ["Graphics/Pictures/", "ev_lizardthief_ha02"],
          3 => ["Graphics/Pictures/", "ev_lizardthief_ha03"],
          4 => ["Graphics/Pictures/", "ev_lizardthief_ha04"],
          5 => ["Graphics/Pictures/", "ev_lizardthief_ha05"],
          6 => ["Graphics/Pictures/", "ev_lizardthief_ha06"],
          7 => ["Graphics/Pictures/", "ev_lizardthief_ha07"],
          8 => ["Graphics/Pictures/", "ev_lizardthief_ha08"],
          9 => ["Graphics/Pictures/", "ev_lizardthief_ha09"],
          10 => ["Graphics/Pictures/", "ev_lizardthief_ha10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 19
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3126,
          :background => {
            :id => 19
          }
        },
        2 => {
          :name => "Request 1 (Blowjob)",
          :common => 4646,
          :condition => {
            :type => 1,
            :id => 3169,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    241 => {
      :name => "Lizard Thief B",
      :condition => {
        :type => 3,
        :id => 127
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lizardthief_hb1"],
          2 => ["Graphics/Pictures/", "ev_lizardthief_hb2"],
          3 => ["Graphics/Pictures/", "ev_lizardthief_hb3"],
          4 => ["Graphics/Pictures/", "ev_lizardthief_hb4"],
          5 => ["Graphics/Pictures/", "ev_lizardthief_hb5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 19
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3127,
          :background => {
            :id => 19
          }
        },
        2 => {
          :name => "Request 1 (Handjob)",
          :common => 4651,
          :condition => {
            :type => 1,
            :id => 3170,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    242 => {
      :name => "Lizard Boss",
      :condition => {
        :type => 3,
        :id => 128
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lizardboss_ha1"],
          2 => ["Graphics/Pictures/", "ev_lizardboss_ha2"],
          3 => ["Graphics/Pictures/", "ev_lizardboss_ha3"],
          4 => ["Graphics/Pictures/", "ev_lizardboss_ha4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 19
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lizardboss_hb1"],
          2 => ["Graphics/Pictures/", "ev_lizardboss_hb2"],
          3 => ["Graphics/Pictures/", "ev_lizardboss_hb3"],
          4 => ["Graphics/Pictures/", "ev_lizardboss_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3171,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lizardboss_hc1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3128,
          :background => {
            :id => 19
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4656,
          :condition => {
            :type => 1,
            :id => 3171,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Loop Event (Reverse Rape)",
          :common => 5834,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    243 => {
      :name => "Mirage Girl",
      :condition => {
        :type => 3,
        :id => 129
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_sinkiro_h1"],
          2 => ["Graphics/Pictures/", "ev_sinkiro_h2"],
          3 => ["Graphics/Pictures/", "ev_sinkiro_h3"],
          4 => ["Graphics/Pictures/", "ev_sinkiro_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 12
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3129,
          :background => {
            :id => 12
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 4661,
          :condition => {
            :type => 1,
            :id => 3172,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    244 => {
      :name => "Antlion Girl",
      :condition => {
        :type => 3,
        :id => 130
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_arizigoku_h1"],
          2 => ["Graphics/Pictures/", "ev_arizigoku_h2"],
          3 => ["Graphics/Pictures/", "ev_arizigoku_h3"],
          4 => ["Graphics/Pictures/", "ev_arizigoku_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 12
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3130,
          :background => {
            :id => 12
          }
        },
        2 => {
          :name => "Request 1 (Fluid Squeezing)",
          :common => 4666,
          :condition => {
            :type => 1,
            :id => 3173,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Fluid Squeezing...?)",
          :common => 4667,
          :condition => {
            :type => 1,
            :id => 3173,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    245 => {
      :name => "Sandworm Girl",
      :condition => {
        :type => 3,
        :id => 131
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_sandw_h1"],
          2 => ["Graphics/Pictures/", "ev_sandw_h2"],
          3 => ["Graphics/Pictures/", "ev_sandw_h3"],
          4 => ["Graphics/Pictures/", "ev_sandw_h4"],
          5 => ["Graphics/Pictures/", "ev_sandw_h5"],
          6 => ["Graphics/Pictures/", "ev_sandw_ct01"],
          7 => ["Graphics/Pictures/", "ev_sandw_ct02"],
          8 => ["Graphics/Pictures/", "ev_sandw_ct03"],
          9 => ["Graphics/Pictures/", "ev_sandw_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [3, 6],
          [4, 7],
          [5, 8],
          [5, 9],
        ],
          :background => {
            :id => 12
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3131,
          :background => {
            :id => 12
          }
        },
        2 => {
          :name => "Request 1 (Whole Body Sucking 1)",
          :common => 4671,
          :condition => {
            :type => 1,
            :id => 3174,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Whole Body Sucking 2)",
          :common => 4672,
          :condition => {
            :type => 1,
            :id => 3174,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    246 => {
      :name => "Desert Scylla",
      :condition => {
        :type => 3,
        :id => 132
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_d_scylla_ha01"],
          2 => ["Graphics/Pictures/", "ev_d_scylla_ha02"],
          3 => ["Graphics/Pictures/", "ev_d_scylla_ha03"],
          4 => ["Graphics/Pictures/", "ev_d_scylla_ha04"],
          5 => ["Graphics/Pictures/", "ev_d_scylla_ha05"],
          6 => ["Graphics/Pictures/", "ev_d_scylla_ha06"],
          7 => ["Graphics/Pictures/", "ev_d_scylla_ha07"],
          8 => ["Graphics/Pictures/", "ev_d_scylla_ha08"],
          9 => ["Graphics/Pictures/", "ev_d_scylla_ha09"],
          10 => ["Graphics/Pictures/", "ev_d_scylla_ha10"],
          11 => ["Graphics/Pictures/", "ev_d_scylla_ha11"],
          12 => ["Graphics/Pictures/", "ev_d_scylla_ha12"],
          13 => ["Graphics/Pictures/", "ev_d_scylla_ha13"],
          14 => ["Graphics/Pictures/", "ev_d_scylla_ha14"],
          15 => ["Graphics/Pictures/", "ev_d_scylla_ha15"],
          16 => ["Graphics/Pictures/", "ev_d_scylla_ha16"],
          17 => ["Graphics/Pictures/", "ev_d_scylla_ha17"],
          18 => ["Graphics/Pictures/", "ev_d_scylla_ha18"],
          19 => ["Graphics/Pictures/", "ev_d_scylla_ha19"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
        ],
          :background => {
            :id => 12
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3132,
          :background => {
            :id => 12
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Hole)",
          :common => 4676,
          :condition => {
            :type => 1,
            :id => 3175,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    247 => {
      :name => "Vitae",
      :condition => {
        :type => 3,
        :id => 134
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_vitae_st02"],
          2 => ["Graphics/Pictures/", "ev_vitae_ct11"],
          3 => ["Graphics/Pictures/", "ev_vitae_ct12"],
          4 => ["Graphics/Pictures/", "ev_vitae_ct13"],
          5 => ["Graphics/Pictures/", "ev_vitae_ct14"],
          6 => ["Graphics/Pictures/", "ev_vitae_ct15"],
          7 => ["Graphics/Pictures/", "ev_vitae_h01"],
          8 => ["Graphics/Pictures/", "ev_vitae_h02"],
          9 => ["Graphics/Pictures/", "ev_vitae_h03"],
          10 => ["Graphics/Pictures/", "ev_vitae_h04"],
          11 => ["Graphics/Pictures/", "ev_vitae_h05"],
          12 => ["Graphics/Pictures/", "ev_vitae_h06"],
          13 => ["Graphics/Pictures/", "ev_vitae_h07"],
          14 => ["Graphics/Pictures/", "ev_vitae_h08"],
          15 => ["Graphics/Pictures/", "ev_vitae_h09"],
          16 => ["Graphics/Pictures/", "ev_vitae_h10"],
          17 => ["Graphics/Pictures/", "ev_vitae_h11"],
          18 => ["Graphics/Pictures/", "ev_vitae_h12"],
          19 => ["Graphics/Pictures/", "ev_vitae_h13"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [1, 4],
          [1, 5],
          [1, 6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
        ],
          :background => {
            :id => 45
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_vitae_st02"],
          2 => ["Graphics/Pictures/", "ev_vitae_ct01"],
          3 => ["Graphics/Pictures/", "ev_vitae_ct02"],
          4 => ["Graphics/Pictures/", "ev_vitae_ct03"],
          5 => ["Graphics/Pictures/", "ev_vitae_ct04"],
          6 => ["Graphics/Pictures/", "ev_vitae_ct05"],
          7 => ["Graphics/Pictures/", "ev_vitae_ct06"],
        },
        # 表示パターンの指定
        :draw => [
          [1, 2],
          [1, 3],
          [1, 4],
          [1, 5],
          [1, 6],
          [1, 7],
        ],
          :condition => {
            :type => 1,
            :id => 3176,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3134,
          :background => {
            :id => 45
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Palm)",
          :common => 4681,
          :condition => {
            :type => 1,
            :id => 3176,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Deepthroat)",
          :common => 4682,
          :condition => {
            :type => 1,
            :id => 3176,
            :op => 1,
            :value => 20
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Cowgirl 1)",
          :common => 4683,
          :condition => {
            :type => 1,
            :id => 3176,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 4 (Cowgirl 2)",
          :common => 4684,
          :condition => {
            :type => 1,
            :id => 3176,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    248 => {
      :name => "Vetala",
      :condition => {
        :type => 3,
        :id => 135
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_vetala_ha01"],
          2 => ["Graphics/Pictures/", "ev_vetala_ha02"],
          3 => ["Graphics/Pictures/", "ev_vetala_ha03"],
          4 => ["Graphics/Pictures/", "ev_vetala_ha04"],
          5 => ["Graphics/Pictures/", "ev_vetala_ha05"],
          6 => ["Graphics/Pictures/", "ev_vetala_ha06"],
          7 => ["Graphics/Pictures/", "ev_vetala_ha07"],
          8 => ["Graphics/Pictures/", "ev_vetala_ha08"],
          9 => ["Graphics/Pictures/", "ev_vetala_ha09"],
          10 => ["Graphics/Pictures/", "ev_vetala_ha10"],
          11 => ["Graphics/Pictures/", "ev_vetala_ha11"],
          12 => ["Graphics/Pictures/", "ev_vetala_ha12"],
          13 => ["Graphics/Pictures/", "ev_vetala_ha13"],
          14 => ["Graphics/Pictures/", "ev_vetala_ha14"],
          15 => ["Graphics/Pictures/", "ev_vetala_ha15"],
          16 => ["Graphics/Pictures/", "ev_vetala_ha16"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
        ],
          :background => {
            :id => 45
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_vetala_hc01"],
          2 => ["Graphics/Pictures/", "ev_vetala_hc02"],
          3 => ["Graphics/Pictures/", "ev_vetala_hc03"],
          4 => ["Graphics/Pictures/", "ev_vetala_hc04"],
          5 => ["Graphics/Pictures/", "ev_vetala_hc05"],
          6 => ["Graphics/Pictures/", "ev_vetala_hc06"],
          7 => ["Graphics/Pictures/", "ev_vetala_hc07"],
          8 => ["Graphics/Pictures/", "ev_vetala_hc08"],
          9 => ["Graphics/Pictures/", "ev_vetala_hc09"],
          10 => ["Graphics/Pictures/", "ev_vetala_hc10"],
          11 => ["Graphics/Pictures/", "ev_vetala_hc11"],
          12 => ["Graphics/Pictures/", "ev_vetala_hc12"],
          13 => ["Graphics/Pictures/", "ev_vetala_hc13"],
          14 => ["Graphics/Pictures/", "ev_vetala_hc14"],
          15 => ["Graphics/Pictures/", "ev_vetala_hc15"],
          16 => ["Graphics/Pictures/", "ev_vetala_hc16"],
          17 => ["Graphics/Pictures/", "ev_vetala_hc17"],
          18 => ["Graphics/Pictures/", "ev_vetala_hc18"],
          19 => ["Graphics/Pictures/", "ev_vetala_hc19"],
          20 => ["Graphics/Pictures/", "ev_vetala_hc20"],
          21 => ["Graphics/Pictures/", "ev_vetala_hc21"],
          22 => ["Graphics/Pictures/", "ev_vetala_hc22"],
          23 => ["Graphics/Pictures/", "ev_vetala_hc23"],
          24 => ["Graphics/Pictures/", "ev_vetala_hc24"],
          25 => ["Graphics/Pictures/", "ev_vetala_hc25"],
          26 => ["Graphics/Pictures/", "ev_vetala_hc26"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
          [26],
        ],
          :condition => {
            :type => 1,
            :id => 3177,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3135,
          :background => {
            :id => 45
          }
        },
        2 => {
          :name => "Request 1 (Predation)",
          :common => 4686,
          :condition => {
            :type => 1,
            :id => 3177,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Paizuri)",
          :common => 4687,
          :condition => {
            :type => 1,
            :id => 3177,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    249 => {
      :name => "Valto",
      :condition => {
        :type => 3,
        :id => 136
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_valt_ha01"],
          2 => ["Graphics/Pictures/", "ev_valt_ha02"],
          3 => ["Graphics/Pictures/", "ev_valt_ha03"],
          4 => ["Graphics/Pictures/", "ev_valt_ha04"],
          5 => ["Graphics/Pictures/", "ev_valt_ha05"],
          6 => ["Graphics/Pictures/", "ev_valt_ha06"],
          7 => ["Graphics/Pictures/", "ev_valt_ha07"],
          8 => ["Graphics/Pictures/", "ev_valt_ha08"],
          9 => ["Graphics/Pictures/", "ev_valt_ha09"],
          10 => ["Graphics/Pictures/", "ev_valt_ha10"],
          11 => ["Graphics/Pictures/", "ev_valt_ha11"],
          12 => ["Graphics/Pictures/", "ev_valt_ha12"],
          13 => ["Graphics/Pictures/", "ev_valt_ha13"],
          14 => ["Graphics/Pictures/", "ev_valt_ha14"],
          15 => ["Graphics/Pictures/", "ev_valt_ha15"],
          16 => ["Graphics/Pictures/", "ev_valt_ha16"],
          17 => ["Graphics/Pictures/", "ev_valt_ha17"],
          18 => ["Graphics/Pictures/", "ev_valt_ha18"],
          19 => ["Graphics/Pictures/", "ev_valt_ha19"],
          20 => ["Graphics/Pictures/", "ev_valt_ha20"],
          21 => ["Graphics/Pictures/", "ev_valt_ha21"],
          22 => ["Graphics/Pictures/", "ev_valt_ha22"],
          23 => ["Graphics/Pictures/", "ev_valt_ha23"],
          24 => ["Graphics/Pictures/", "ev_valt_ha24"],
          25 => ["Graphics/Pictures/", "ev_valt_ha25"],
          26 => ["Graphics/Pictures/", "ev_valt_ha26"],
          27 => ["Graphics/Pictures/", "ev_valt_ha27"],
          28 => ["Graphics/Pictures/", "ev_valt_ha28"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
          [26],
          [27],
          [28],
        ],
          :background => {
            :id => 45
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_valt_hb01"],
          2 => ["Graphics/Pictures/", "ev_valt_hb02"],
          3 => ["Graphics/Pictures/", "ev_valt_hb03"],
          4 => ["Graphics/Pictures/", "ev_valt_hb04"],
          5 => ["Graphics/Pictures/", "ev_valt_hb05"],
          6 => ["Graphics/Pictures/", "ev_valt_hb06"],
          7 => ["Graphics/Pictures/", "ev_valt_hb07"],
          8 => ["Graphics/Pictures/", "ev_valt_hb08"],
          9 => ["Graphics/Pictures/", "ev_valt_hb09"],
          10 => ["Graphics/Pictures/", "ev_valt_hb10"],
          11 => ["Graphics/Pictures/", "ev_valt_hb11"],
          12 => ["Graphics/Pictures/", "ev_valt_hb12"],
          13 => ["Graphics/Pictures/", "ev_valt_hb13"],
          14 => ["Graphics/Pictures/", "ev_valt_hb14"],
          15 => ["Graphics/Pictures/", "ev_valt_hb15"],
          16 => ["Graphics/Pictures/", "ev_valt_hb16"],
          17 => ["Graphics/Pictures/", "ev_valt_hb17"],
          18 => ["Graphics/Pictures/", "ev_valt_hb18"],
          19 => ["Graphics/Pictures/", "ev_valt_hb19"],
          20 => ["Graphics/Pictures/", "ev_valt_hb20"],
          21 => ["Graphics/Pictures/", "ev_valt_hb21"],
          22 => ["Graphics/Pictures/", "ev_valt_hb22"],
          23 => ["Graphics/Pictures/", "ev_valt_hb23"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
        ],
          :condition => {
            :type => 1,
            :id => 3178,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3136,
          :background => {
            :id => 45
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Machine)",
          :common => 4691,
          :condition => {
            :type => 1,
            :id => 3178,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Blowjob)",
          :common => 4692,
          :condition => {
            :type => 1,
            :id => 3178,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    250 => {
      :name => "Shinifa",
      :condition => {
        :type => 3,
        :id => 137
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_sinifa_ha01"],
          2 => ["Graphics/Pictures/", "ev_sinifa_ha02"],
          3 => ["Graphics/Pictures/", "ev_sinifa_ha03"],
          4 => ["Graphics/Pictures/", "ev_sinifa_ha04"],
          5 => ["Graphics/Pictures/", "ev_sinifa_ha05"],
          6 => ["Graphics/Pictures/", "ev_sinifa_ha06"],
          7 => ["Graphics/Pictures/", "ev_sinifa_ha07"],
          8 => ["Graphics/Pictures/", "ev_sinifa_ha08"],
          9 => ["Graphics/Pictures/", "ev_sinifa_ha09"],
          10 => ["Graphics/Pictures/", "ev_sinifa_ha10"],
          11 => ["Graphics/Pictures/", "ev_sinifa_ha11"],
          12 => ["Graphics/Pictures/", "ev_sinifa_ha12"],
          13 => ["Graphics/Pictures/", "ev_sinifa_ha13"],
          14 => ["Graphics/Pictures/", "ev_sinifa_ha14"],
          15 => ["Graphics/Pictures/", "ev_sinifa_ha15"],
          16 => ["Graphics/Pictures/", "ev_sinifa_ha16"],
          17 => ["Graphics/Pictures/", "ev_sinifa_ha17"],
          18 => ["Graphics/Pictures/", "ev_sinifa_ha18"],
          19 => ["Graphics/Pictures/", "ev_sinifa_ha19"],
          20 => ["Graphics/Pictures/", "ev_sinifa_ha20"],
          21 => ["Graphics/Pictures/", "ev_sinifa_ha21"],
          22 => ["Graphics/Pictures/", "ev_sinifa_ha22"],
          23 => ["Graphics/Pictures/", "ev_sinifa_ha23"],
          24 => ["Graphics/Pictures/", "ev_sinifa_ha24"],
          25 => ["Graphics/Pictures/", "ev_sinifa_ha25"],
          26 => ["Graphics/Pictures/", "ev_sinifa_ha26"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
          [26],
        ],
          :background => {
            :id => 45
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3137,
          :background => {
            :id => 45
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Hole)",
          :common => 4696,
          :condition => {
            :type => 1,
            :id => 3179,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    251 => {
      :name => "Shadow Girl",
      :condition => {
        :type => 3,
        :id => 138
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_shadow_h1"],
          2 => ["Graphics/Pictures/", "ev_shadow_h2"],
          3 => ["Graphics/Pictures/", "ev_shadow_h3"],
          4 => ["Graphics/Pictures/", "ev_shadow_h4"],
          5 => ["Graphics/Pictures/", "ev_shadow_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 27
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3138,
          :background => {
            :id => 27
          }
        },
        2 => {
          :name => "Request 1 (Assimilating Handjob)",
          :common => 4701,
          :condition => {
            :type => 1,
            :id => 3180,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Assimilating Handjob...?)",
          :common => 4702,
          :condition => {
            :type => 1,
            :id => 3180,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    252 => {
      :name => "Paintgeist",
      :condition => {
        :type => 3,
        :id => 139
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_gaistvine_st11"],
          2 => ["Graphics/Pictures/", "80_gaistvine_st12"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
        ],
          :background => {
            :id => 27
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_gaistvine_ha1"],
          2 => ["Graphics/Pictures/", "ev_gaistvine_ha2"],
          3 => ["Graphics/Pictures/", "ev_gaistvine_hb1"],
          4 => ["Graphics/Pictures/", "ev_gaistvine_hb2"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3139,
          :background => {
            :id => 27
          }
        },
        2 => {
          :name => "Request 1 (Ensnaring Handjob)",
          :common => 4706,
          :condition => {
            :type => 1,
            :id => 3181,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Loop Event (Confined Cowgirl)",
          :common => 5843,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    253 => {
      :name => "Chimera Homunculus",
      :condition => {
        :type => 3,
        :id => 140
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_c_homunculus_h1"],
          2 => ["Graphics/Pictures/", "ev_c_homunculus_h2"],
          3 => ["Graphics/Pictures/", "ev_c_homunculus_h3"],
          4 => ["Graphics/Pictures/", "ev_c_homunculus_h4"],
          5 => ["Graphics/Pictures/", "ev_c_homunculus_h5"],
          6 => ["Graphics/Pictures/", "ev_c_homunculus_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 27
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3140,
          :background => {
            :id => 27
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Tentacle 1)",
          :common => 4711,
          :condition => {
            :type => 1,
            :id => 3182,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Semen Squeezing Tentacle 2)",
          :common => 4712,
          :condition => {
            :type => 1,
            :id => 3182,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    254 => {
      :name => "Neo Iron Maiden",
      :condition => {
        :type => 3,
        :id => 141
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_ironmaiden_k_st01"],
          2 => ["Graphics/Pictures/", "ev_ironmaiden_k_st02"],
          3 => ["Graphics/Pictures/", "ev_ironmaiden_k_h1"],
          4 => ["Graphics/Pictures/", "ev_ironmaiden_k_h2"],
          5 => ["Graphics/Pictures/", "ev_ironmaiden_k_h3"],
          6 => ["Graphics/Pictures/", "ev_ironmaiden_k_h4"],
          7 => ["Graphics/Pictures/", "ev_ironmaiden_k_h5"],
          8 => ["Graphics/Pictures/", "ev_ironmaiden_k_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 27
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3141,
          :background => {
            :id => 27
          }
        },
        2 => {
          :name => "Request 1 (Death by Pleasure)",
          :common => 4716,
          :condition => {
            :type => 1,
            :id => 3183,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    255 => {
      :name => "Junk Doll Girl",
      :condition => {
        :type => 3,
        :id => 142
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_junkdoll_ha01"],
          2 => ["Graphics/Pictures/", "ev_junkdoll_ha02"],
          3 => ["Graphics/Pictures/", "ev_junkdoll_ha03"],
          4 => ["Graphics/Pictures/", "ev_junkdoll_ha04"],
          5 => ["Graphics/Pictures/", "ev_junkdoll_ha05"],
          6 => ["Graphics/Pictures/", "ev_junkdoll_ha06"],
          7 => ["Graphics/Pictures/", "ev_junkdoll_ha07"],
          8 => ["Graphics/Pictures/", "ev_junkdoll_ha08"],
          9 => ["Graphics/Pictures/", "ev_junkdoll_ha09"],
          10 => ["Graphics/Pictures/", "ev_junkdoll_ha10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 27
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_junkdoll_hb1"],
          2 => ["Graphics/Pictures/", "ev_junkdoll_hb2"],
          3 => ["Graphics/Pictures/", "ev_junkdoll_hb3"],
          4 => ["Graphics/Pictures/", "ev_junkdoll_hc1"],
          5 => ["Graphics/Pictures/", "ev_junkdoll_hc2"],
          6 => ["Graphics/Pictures/", "ev_junkdoll_hc3"],
          7 => ["Graphics/Pictures/", "ev_junkdoll_hc4"],
          8 => ["Graphics/Pictures/", "ev_junkdoll_hc5"],
          9 => ["Graphics/Pictures/", "ev_junkdoll_hc6"],
          10 => ["Graphics/Pictures/", "ev_junkdoll_hc7"],
          11 => ["Graphics/Pictures/", "ev_junkdoll_hc8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
        ],
          :condition => {
            :type => 1,
            :id => 3184,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_junkdoll_hd1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3142,
          :background => {
            :id => 27
          }
        },
        2 => {
          :name => "Request 1 (Gangrape)",
          :common => 4721,
          :condition => {
            :type => 1,
            :id => 3184,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Handjob)",
          :common => 4722,
          :condition => {
            :type => 1,
            :id => 3184,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Reverse Rape)",
          :common => 4723,
          :condition => {
            :type => 1,
            :id => 3184,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Loop Event (Junk Reverse Rape)",
          :common => 5806,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    256 => {
      :name => "Radio",
      :condition => {
        :type => 2,
        :id => 185
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_radio_h01"],
          2 => ["Graphics/Pictures/", "ev_radio_h02"],
          3 => ["Graphics/Pictures/", "ev_radio_h03"],
          4 => ["Graphics/Pictures/", "ev_radio_h04"],
          5 => ["Graphics/Pictures/", "ev_radio_h05"],
          6 => ["Graphics/Pictures/", "ev_radio_h06"],
          7 => ["Graphics/Pictures/", "ev_radio_h07"],
          8 => ["Graphics/Pictures/", "ev_radio_h08"],
          9 => ["Graphics/Pictures/", "ev_radio_h09"],
          10 => ["Graphics/Pictures/", "ev_radio_h10"],
          11 => ["Graphics/Pictures/", "ev_radio_h11"],
          12 => ["Graphics/Pictures/", "ev_radio_h12"],
          13 => ["Graphics/Pictures/", "ev_radio_h13"],
          14 => ["Graphics/Pictures/", "ev_radio_h14"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
        ],
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Onahole)",
          :common => 4726,
          :condition => {
            :type => 1,
            :id => 3185,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :name => "Event (Laboratory Milking)",
          :common => 4439,
          :condition => {
            :type => 1,
            :id => 1143,
            :op => 1,
            :value => 4
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    353 => {
      :name => "Mushroom Girl",
      :condition => {
        :type => 3,
        :id => 151
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kinoko_h1"],
          2 => ["Graphics/Pictures/", "ev_kinoko_h2"],
          3 => ["Graphics/Pictures/", "ev_kinoko_h3"],
          4 => ["Graphics/Pictures/", "ev_kinoko_h4"],
          5 => ["Graphics/Pictures/", "ev_kinoko_h5"],
          6 => ["Graphics/Pictures/", "ev_kinoko_h6"],
          7 => ["Graphics/Pictures/", "ev_kinoko_h7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 8
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3151,
          :background => {
            :id => 8
          }
        },
        2 => {
          :name => "Request 1 (Seedbed)",
          :common => 4766,
          :condition => {
            :type => 1,
            :id => 3191,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    354 => {
      :name => "Novistador Girl",
      :condition => {
        :type => 3,
        :id => 152
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_nobisutam_hb1"],
          2 => ["Graphics/Pictures/", "ev_nobisutam_hb2"],
          3 => ["Graphics/Pictures/", "ev_nobisutam_hb3"],
          4 => ["Graphics/Pictures/", "ev_nobisutam_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 8
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_nobisutam_st02"],
          2 => ["Graphics/Pictures/", "ev_nobisutam_ct01"],
          3 => ["Graphics/Pictures/", "ev_nobisutam_ct02"],
          4 => ["Graphics/Pictures/", "ev_nobisutam_ct03"],
          5 => ["Graphics/Pictures/", "ev_nobisutam_ct04"],
          6 => ["Graphics/Pictures/", "ev_nobisutam_ct05"],
          7 => ["Graphics/Pictures/", "ev_nobisutam_ct06"],
          8 => ["Graphics/Pictures/", "ev_nobisutam_ct11"],
          9 => ["Graphics/Pictures/", "ev_nobisutam_ha1"],
          10 => ["Graphics/Pictures/", "ev_nobisutam_ha2"],
          11 => ["Graphics/Pictures/", "ev_nobisutam_ha3"],
          12 => ["Graphics/Pictures/", "ev_nobisutam_ha4"],
          13 => ["Graphics/Pictures/", "ev_nobisutam_ha5"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
          [1,6],
          [1,7],
          [1,8],
          [9],
          [10],
          [11],
          [12],
          [13],
        ],
          :condition => {
            :type => 1,
            :id => 3192,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3152,
          :background => {
            :id => 8
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 4771,
          :condition => {
            :type => 1,
            :id => 3192,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Group Paizuri)",
          :common => 4772,
          :condition => {
            :type => 1,
            :id => 3192,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    355 => {
      :name => "Urscylla",
      :condition => {
        :type => 3,
        :id => 153
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_u_scylla_h01"],
          2 => ["Graphics/Pictures/", "ev_u_scylla_h02"],
          3 => ["Graphics/Pictures/", "ev_u_scylla_h03"],
          4 => ["Graphics/Pictures/", "ev_u_scylla_h04"],
          5 => ["Graphics/Pictures/", "ev_u_scylla_h05"],
          6 => ["Graphics/Pictures/", "ev_u_scylla_h06"],
          7 => ["Graphics/Pictures/", "ev_u_scylla_h07"],
          8 => ["Graphics/Pictures/", "ev_u_scylla_h08"],
          9 => ["Graphics/Pictures/", "ev_u_scylla_h09"],
          10 => ["Graphics/Pictures/", "ev_u_scylla_h10"],
          11 => ["Graphics/Pictures/", "ev_u_scylla_h11"],
          12 => ["Graphics/Pictures/", "ev_u_scylla_h12"],
          13 => ["Graphics/Pictures/", "ev_u_scylla_h13"],
          14 => ["Graphics/Pictures/", "ev_u_scylla_h14"],
          15 => ["Graphics/Pictures/", "ev_u_scylla_h15"],
          16 => ["Graphics/Pictures/", "ev_u_scylla_h16"],
          17 => ["Graphics/Pictures/", "ev_u_scylla_h17"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
        ],
          :background => {
            :id => 8
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3153,
          :background => {
            :id => 8
          }
        },
        2 => {
          :name => "Request 1 (Handjob)",
          :common => 4776,
          :condition => {
            :type => 1,
            :id => 3193,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    356 => {
      :name => "Fusuma",
      :condition => {
        :type => 3,
        :id => 154
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_husuma_h1"],
          2 => ["Graphics/Pictures/", "ev_husuma_h2"],
          3 => ["Graphics/Pictures/", "ev_husuma_h3"],
          4 => ["Graphics/Pictures/", "ev_husuma_h4"],
          5 => ["Graphics/Pictures/", "ev_husuma_h5"],
          6 => ["Graphics/Pictures/", "ev_husuma_h6"],
          7 => ["Graphics/Pictures/", "ev_husuma_h7"],
          8 => ["Graphics/Pictures/", "ev_husuma_h8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 2
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3154,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Melty Wrap)",
          :common => 4781,
          :condition => {
            :type => 1,
            :id => 3194,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Melty Wrap...?)",
          :common => 4782,
          :condition => {
            :type => 1,
            :id => 3194,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    357 => {
      :name => "Mermaid",
      :condition => {
        :type => 3,
        :id => 155
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_mermaid_h1"],
          2 => ["Graphics/Pictures/", "ev_mermaid_h2"],
          3 => ["Graphics/Pictures/", "ev_mermaid_h3"],
          4 => ["Graphics/Pictures/", "ev_mermaid_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 43
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3155,
          :background => {
            :id => 43
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 4786,
          :condition => {
            :type => 1,
            :id => 3195,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    358 => {
      :name => "Mermaid Merchant",
      :condition => {
        :type => 3,
        :id => 156
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_s_mermaid_h1"],
          2 => ["Graphics/Pictures/", "ev_s_mermaid_h2"],
          3 => ["Graphics/Pictures/", "ev_s_mermaid_h3"],
          4 => ["Graphics/Pictures/", "ev_s_mermaid_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 43
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3156,
          :background => {
            :id => 43
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 4791,
          :condition => {
            :type => 1,
            :id => 3196,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    359 => {
      :name => "Mermaid Pirate",
      :condition => {
        :type => 3,
        :id => 157
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_k_mermaid_h1"],
          2 => ["Graphics/Pictures/", "ev_k_mermaid_h2"],
          3 => ["Graphics/Pictures/", "ev_k_mermaid_h3"],
          4 => ["Graphics/Pictures/", "ev_k_mermaid_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 43
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_k_mermaid_hb1"],
          2 => ["Graphics/Pictures/", "ev_k_mermaid_hb2"],
          3 => ["Graphics/Pictures/", "ev_k_mermaid_hb3"],
          4 => ["Graphics/Pictures/", "ev_k_mermaid_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3197,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3157,
          :background => {
            :id => 43
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 4796,
          :condition => {
            :type => 1,
            :id => 3197,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4797,
          :condition => {
            :type => 1,
            :id => 3197,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    360 => {
      :name => "Ittan-Momen",
      :condition => {
        :type => 3,
        :id => 158
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_ittanmomen_h1"],
          2 => ["Graphics/Pictures/", "ev_ittanmomen_h2"],
          3 => ["Graphics/Pictures/", "ev_ittanmomen_h3"],
          4 => ["Graphics/Pictures/", "ev_ittanmomen_h4"],
          5 => ["Graphics/Pictures/", "ev_ittanmomen_h5"],
          6 => ["Graphics/Pictures/", "ev_ittanmomen_h6"],
          7 => ["Graphics/Pictures/", "ev_ittanmomen_h7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 43
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3158,
          :background => {
            :id => 43
          }
        },
        2 => {
          :name => "Request 1 (Body Wrap)",
          :common => 4801,
          :condition => {
            :type => 1,
            :id => 3198,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    361 => {
      :name => "Dagon",
      :condition => {
        :type => 3,
        :id => 161
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_dagon_h1"],
          2 => ["Graphics/Pictures/", "ev_dagon_h2"],
          3 => ["Graphics/Pictures/", "ev_dagon_h3"],
          4 => ["Graphics/Pictures/", "ev_dagon_h4"],
          5 => ["Graphics/Pictures/", "ev_dagon_h5"],
          6 => ["Graphics/Pictures/", "ev_dagon_h6"],
          7 => ["Graphics/Pictures/", "ev_dagon_ct01"],
          8 => ["Graphics/Pictures/", "ev_dagon_ct01a"],
          9 => ["Graphics/Pictures/", "ev_dagon_ct02"],
          10 => ["Graphics/Pictures/", "ev_dagon_ct03"],
          11 => ["Graphics/Pictures/", "ev_dagon_ct04"],
          12 => ["Graphics/Pictures/", "ev_dagon_ct05"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [3,7],
          [3,8],
          [3,9],
          [4,10],
          [5,11],
          [6,12],
        ],
          :background => {
            :id => 22
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3161,
          :background => {
            :id => 22
          }
        },
        2 => {
          :name => "Request 1 (Forcible Semen Squeeze)",
          :common => 4806,
          :condition => {
            :type => 1,
            :id => 3199,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    362 => {
      :name => "Hitodama Girl",
      :condition => {
        :type => 3,
        :id => 162
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_hitodama_hc1"],
          2 => ["Graphics/Pictures/", "ev_hitodama_hc2"],
          3 => ["Graphics/Pictures/", "ev_hitodama_hc3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :background => {
            :id => 22
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_hitodama_ha1"],
          2 => ["Graphics/Pictures/", "ev_hitodama_ha2"],
          3 => ["Graphics/Pictures/", "ev_hitodama_ha3"],
          4 => ["Graphics/Pictures/", "ev_hitodama_ha4"],
          5 => ["Graphics/Pictures/", "ev_hitodama_hb1"],
          6 => ["Graphics/Pictures/", "ev_hitodama_hb2"],
          7 => ["Graphics/Pictures/", "ev_hitodama_hb3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :condition => {
            :type => 1,
            :id => 3200,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3162,
          :background => {
            :id => 22
          }
        },
        2 => {
          :name => "Request 1 (Lightning)",
          :common => 4811,
          :condition => {
            :type => 1,
            :id => 3200,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Soul Wrapping)",
          :common => 4812,
          :condition => {
            :type => 1,
            :id => 3200,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Reverse Rape)",
          :common => 4813,
          :condition => {
            :type => 1,
            :id => 3200,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    363 => {
      :name => "Ashel",
      :condition => {
        :type => 3,
        :id => 163
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_ashel_ha1"],
          2 => ["Graphics/Pictures/", "ev_ashel_ha2"],
          3 => ["Graphics/Pictures/", "ev_ashel_ha3"],
          4 => ["Graphics/Pictures/", "ev_ashel_ha4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 22
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_ashel_hb1"],
          2 => ["Graphics/Pictures/", "ev_ashel_hb2"],
          3 => ["Graphics/Pictures/", "ev_ashel_hb3"],
          4 => ["Graphics/Pictures/", "ev_ashel_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3201,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3163,
          :background => {
            :id => 22
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 4816,
          :condition => {
            :type => 1,
            :id => 3201,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4817,
          :condition => {
            :type => 1,
            :id => 3201,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    364 => {
      :name => "Bonnie",
      :condition => {
        :type => 3,
        :id => 164
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_bonny_hb1"],
          2 => ["Graphics/Pictures/", "ev_bonny_hb2"],
          3 => ["Graphics/Pictures/", "ev_bonny_hb3"],
          4 => ["Graphics/Pictures/", "ev_bonny_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 22
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_bonny_ha1"],
          2 => ["Graphics/Pictures/", "ev_bonny_ha2"],
          3 => ["Graphics/Pictures/", "ev_bonny_ha3"],
          4 => ["Graphics/Pictures/", "ev_bonny_ha4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3202,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3164,
          :background => {
            :id => 22
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 4821,
          :condition => {
            :type => 1,
            :id => 3202,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4822,
          :condition => {
            :type => 1,
            :id => 3202,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    365 => {
      :name => "Seahorse Marine",
      :condition => {
        :type => 3,
        :id => 165
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_tatunoko_k_h1"],
          2 => ["Graphics/Pictures/", "ev_tatunoko_k_h2"],
          3 => ["Graphics/Pictures/", "ev_tatunoko_k_h3"],
          4 => ["Graphics/Pictures/", "ev_tatunoko_k_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 28
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_tatunoko_k_hb1"],
          2 => ["Graphics/Pictures/", "ev_tatunoko_k_hb2"],
          3 => ["Graphics/Pictures/", "ev_tatunoko_k_hb3"],
          4 => ["Graphics/Pictures/", "ev_tatunoko_k_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3203,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3165,
          :background => {
            :id => 28
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 4826,
          :condition => {
            :type => 1,
            :id => 3203,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4827,
          :condition => {
            :type => 1,
            :id => 3203,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    366 => {
      :name => "Sea Slug Marine",
      :condition => {
        :type => 3,
        :id => 166
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_umiusi_k_h1"],
          2 => ["Graphics/Pictures/", "ev_umiusi_k_h2"],
          3 => ["Graphics/Pictures/", "ev_umiusi_k_h3"],
          4 => ["Graphics/Pictures/", "ev_umiusi_k_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 28
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_umiusi_k_hb1"],
          2 => ["Graphics/Pictures/", "ev_umiusi_k_hb2"],
          3 => ["Graphics/Pictures/", "ev_umiusi_k_hb3"],
          4 => ["Graphics/Pictures/", "ev_umiusi_k_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3204,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3166,
          :background => {
            :id => 28
          }
        },
        2 => {
          :name => "Request 1 (Soft Body Handjob)",
          :common => 4831,
          :condition => {
            :type => 1,
            :id => 3204,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4832,
          :condition => {
            :type => 1,
            :id => 3204,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    367 => {
      :name => "Leviathan",
      :condition => {
        :type => 3,
        :id => 167
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_levia_h1"],
          2 => ["Graphics/Pictures/", "ev_levia_h2"],
          3 => ["Graphics/Pictures/", "ev_levia_h3"],
          4 => ["Graphics/Pictures/", "ev_levia_h4"],
          5 => ["Graphics/Pictures/", "ev_levia_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 28
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_levia_hb1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3167,
          :background => {
            :id => 28
          }
        },
        2 => {
          :name => "Request 1 (Vaginal Swallow)",
          :common => 4836,
          :condition => {
            :type => 1,
            :id => 3205,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Vaginal Swallow...?)",
          :common => 4837,
          :condition => {
            :type => 1,
            :id => 3205,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Loop Event (Narwhal Squabble)",
          :common => 5814,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    368 => {
      :name => "Frog Girls",
      :condition => {
        :type => 3,
        :id => 168
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kaeru_ha1"],
          2 => ["Graphics/Pictures/", "ev_kaeru_ha2"],
          3 => ["Graphics/Pictures/", "ev_kaeru_ha3"],
          4 => ["Graphics/Pictures/", "ev_kaeru_ha4"],
          5 => ["Graphics/Pictures/", "ev_kaeru_ha5"],
          6 => ["Graphics/Pictures/", "ev_kaeru_ha6"],
          7 => ["Graphics/Pictures/", "ev_kaeru_ha7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 2
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kaeru_hc1"],
          2 => ["Graphics/Pictures/", "ev_kaeru_hc2"],
          3 => ["Graphics/Pictures/", "ev_kaeru_hc3"],
          4 => ["Graphics/Pictures/", "ev_kaeru_hb0"],
          5 => ["Graphics/Pictures/", "ev_kaeru_hb1"],
          6 => ["Graphics/Pictures/", "ev_kaeru_hb2"],
          7 => ["Graphics/Pictures/", "ev_kaeru_hb3"],
          8 => ["Graphics/Pictures/", "ev_kaeru_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :condition => {
            :type => 1,
            :id => 3206,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3168,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Groin Licking)",
          :common => 4841,
          :condition => {
            :type => 1,
            :id => 3206,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Group Groin Licking)",
          :common => 4842,
          :condition => {
            :type => 1,
            :id => 3206,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Group Mating)",
          :common => 4843,
          :condition => {
            :type => 1,
            :id => 3206,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    369 => {
      :name => "Kentauros",
      :condition => {
        :type => 3,
        :id => 170
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_centa_h1"],
          2 => ["Graphics/Pictures/", "ev_centa_h2"],
          3 => ["Graphics/Pictures/", "ev_centa_ct01"],
          4 => ["Graphics/Pictures/", "ev_centa_ct02"],
          5 => ["Graphics/Pictures/", "ev_centa_ct03"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,3],
          [2,4],
          [2,5],
        ],
          :background => {
            :id => 2
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3170,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Centaur Rape)",
          :common => 4846,
          :condition => {
            :type => 1,
            :id => 3207,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    370 => {
      :name => "Alraune",
      :condition => {
        :type => 3,
        :id => 171
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alraune_h1"],
          2 => ["Graphics/Pictures/", "ev_alraune_h2"],
          3 => ["Graphics/Pictures/", "ev_alraune_h3"],
          4 => ["Graphics/Pictures/", "ev_alraune_h4"],
          5 => ["Graphics/Pictures/", "ev_alraune_h5"],
          6 => ["Graphics/Pictures/", "ev_alraune_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 2
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_alraune_st02"],
          2 => ["Graphics/Pictures/", "ev_alraune_ct01"],
          3 => ["Graphics/Pictures/", "ev_alraune_ct02"],
          4 => ["Graphics/Pictures/", "ev_alraune_ct03"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
        ],
          :condition => {
            :type => 1,
            :id => 3208,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3171,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4851,
          :condition => {
            :type => 1,
            :id => 3208,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    371 => {
      :name => "Okiku-Mushi",
      :condition => {
        :type => 3,
        :id => 172
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_okikumusi_ha1"],
          2 => ["Graphics/Pictures/", "ev_okikumusi_ha2"],
          3 => ["Graphics/Pictures/", "ev_okikumusi_ha3"],
          4 => ["Graphics/Pictures/", "ev_okikumusi_ha4"],
          5 => ["Graphics/Pictures/", "ev_okikumusi_ha5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 21
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_okikumusi_hb1"],
          2 => ["Graphics/Pictures/", "ev_okikumusi_hb2"],
          3 => ["Graphics/Pictures/", "ev_okikumusi_hb3"],
          4 => ["Graphics/Pictures/", "ev_okikumusi_hb4"],
          5 => ["Graphics/Pictures/", "ev_okikumusi_hb5"],
          6 => ["Graphics/Pictures/", "ev_okikumusi_hb6"],
          7 => ["Graphics/Pictures/", "ev_okikumusi_ct01"],
          8 => ["Graphics/Pictures/", "ev_okikumusi_ct02"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [3,7],
          [4,7],
          [5,8],
          [6,8],
        ],
          :condition => {
            :type => 1,
            :id => 3209,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3172,
          :background => {
            :id => 21
          }
        },
        2 => {
          :name => "Request 1 (Sticky Thread)",
          :common => 4856,
          :condition => {
            :type => 1,
            :id => 3209,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Mating)",
          :common => 4857,
          :condition => {
            :type => 1,
            :id => 3209,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    372 => {
      :name => "Spirit Girl",
      :condition => {
        :type => 3,
        :id => 173
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_ghost2_hb1"],
          2 => ["Graphics/Pictures/", "ev_ghost2_hb2"],
          3 => ["Graphics/Pictures/", "ev_ghost2_hb3"],
          4 => ["Graphics/Pictures/", "ev_ghost2_hb4"],
          5 => ["Graphics/Pictures/", "ev_ghost2_hb5"],
          6 => ["Graphics/Pictures/", "ev_ghost2_hb6"],
          7 => ["Graphics/Pictures/", "ev_ghost2_hb7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 21
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_ghost2_ha1"],
          2 => ["Graphics/Pictures/", "ev_ghost2_ha2"],
          3 => ["Graphics/Pictures/", "ev_ghost2_ha3"],
          4 => ["Graphics/Pictures/", "ev_ghost2_ha4"],
          5 => ["Graphics/Pictures/", "ev_ghost2_ha5"],
          6 => ["Graphics/Pictures/", "ev_ghost2_ha6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3210,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3173,
          :background => {
            :id => 21
          }
        },
        2 => {
          :name => "Request 1 (Blowjob)",
          :common => 4861,
          :condition => {
            :type => 1,
            :id => 3210,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Paizuri Blowjob)",
          :common => 4862,
          :condition => {
            :type => 1,
            :id => 3210,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    373 => {
      :name => "Boxed Girl",
      :condition => {
        :type => 3,
        :id => 174
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_hakoiri_ha01"],
          2 => ["Graphics/Pictures/", "ev_hakoiri_ha02"],
          3 => ["Graphics/Pictures/", "ev_hakoiri_ha03"],
          4 => ["Graphics/Pictures/", "ev_hakoiri_ha04"],
          5 => ["Graphics/Pictures/", "ev_hakoiri_ha05"],
          6 => ["Graphics/Pictures/", "ev_hakoiri_ha06"],
          7 => ["Graphics/Pictures/", "ev_hakoiri_ha07"],
          8 => ["Graphics/Pictures/", "ev_hakoiri_ha08"],
          9 => ["Graphics/Pictures/", "ev_hakoiri_ha09"],
          10 => ["Graphics/Pictures/", "ev_hakoiri_ha10"],
          11 => ["Graphics/Pictures/", "ev_hakoiri_ha11"],
          12 => ["Graphics/Pictures/", "ev_hakoiri_ha12"],
          13 => ["Graphics/Pictures/", "ev_hakoiri_ha13"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
        ],
          :background => {
            :id => 21
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3174,
          :background => {
            :id => 21
          }
        },
        2 => {
          :name => "Request 1 (Keyhole Challenge)",
          :common => 4866,
          :condition => {
            :type => 1,
            :id => 3211,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    374 => {
      :name => "Dullahan",
      :condition => {
        :type => 3,
        :id => 175
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_durahan_h1"],
          2 => ["Graphics/Pictures/", "ev_durahan_h2"],
          3 => ["Graphics/Pictures/", "ev_durahan_h3"],
          4 => ["Graphics/Pictures/", "ev_durahan_h4"],
          5 => ["Graphics/Pictures/", "ev_durahan_h5"],
          6 => ["Graphics/Pictures/", "ev_durahan_h6"],
          7 => ["Graphics/Pictures/", "ev_durahan_h7"],
          8 => ["Graphics/Pictures/", "ev_durahan_h8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 65
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3175,
          :background => {
            :id => 65
          }
        },
        2 => {
          :name => "Request 1 (Restraining Hair Blowjob)",
          :common => 4871,
          :condition => {
            :type => 1,
            :id => 3212,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    375 => {
      :name => "Cerberus",
      :condition => {
        :type => 3,
        :id => 176
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_kerberos_st01"],
          2 => ["Graphics/Pictures/", "ev_kerberos_ct01"],
          3 => ["Graphics/Pictures/", "ev_kerberos_ct02"],
          4 => ["Graphics/Pictures/", "ev_kerberos_ct03"],
          5 => ["Graphics/Pictures/", "ev_kerberos_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
        ],
          :background => {
            :id => 65
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3176,
          :background => {
            :id => 65
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4876,
          :condition => {
            :type => 1,
            :id => 3213,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    376 => {
      :name => "Nure-Onna",
      :condition => {
        :type => 3,
        :id => 179
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_nureonnna_h1"],
          2 => ["Graphics/Pictures/", "ev_nureonnna_h2"],
          3 => ["Graphics/Pictures/", "ev_nureonnna_h3"],
          4 => ["Graphics/Pictures/", "ev_nureonnna_h4"],
          5 => ["Graphics/Pictures/", "ev_nureonnna_h5"],
          6 => ["Graphics/Pictures/", "ev_nureonnna_h6"],
          7 => ["Graphics/Pictures/", "ev_nureonnna_h7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 20
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3179,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Swallow)",
          :common => 4881,
          :condition => {
            :type => 1,
            :id => 3214,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Swallow...?)",
          :common => 4882,
          :condition => {
            :type => 1,
            :id => 3214,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    377 => {
      :name => "High Minotauros",
      :condition => {
        :type => 3,
        :id => 180
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_h_mino_hb1"],
          2 => ["Graphics/Pictures/", "ev_h_mino_hb2"],
          3 => ["Graphics/Pictures/", "ev_h_mino_hb3"],
          4 => ["Graphics/Pictures/", "ev_h_mino_hb4"],
          5 => ["Graphics/Pictures/", "ev_h_mino_hb5"],
          6 => ["Graphics/Pictures/", "ev_h_mino_hb6"],
          7 => ["Graphics/Pictures/", "ev_h_mino_hb7"],
          8 => ["Graphics/Pictures/", "ev_h_mino_hb8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 29
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_h_mino_ha1"],
          2 => ["Graphics/Pictures/", "ev_h_mino_ha2"],
          3 => ["Graphics/Pictures/", "ev_h_mino_ha3"],
          4 => ["Graphics/Pictures/", "ev_h_mino_ha4"],
          5 => ["Graphics/Pictures/", "ev_h_mino_ha5"],
          6 => ["Graphics/Pictures/", "ev_h_mino_ha6"],
          7 => ["Graphics/Pictures/", "ev_h_mino_ha7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :condition => {
            :type => 1,
            :id => 3215,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_h_mino_hc1"],
          2 => ["Graphics/Pictures/", "ev_h_mino_hc2"],
          3 => ["Graphics/Pictures/", "ev_h_mino_hc3"],
          4 => ["Graphics/Pictures/", "ev_h_mino_hc4"],
          5 => ["Graphics/Pictures/", "ev_h_mino_hc5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3180,
          :background => {
            :id => 29
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4886,
          :condition => {
            :type => 1,
            :id => 3215,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Nursing Handjob)",
          :common => 4887,
          :condition => {
            :type => 1,
            :id => 3215,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Loop Event (Paizuri Lesson)",
          :common => 5841,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    378 => {
      :name => "Misstauros",
      :condition => {
        :type => 3,
        :id => 181
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_m_mino_ha01"],
          2 => ["Graphics/Pictures/", "ev_m_mino_ha02"],
          3 => ["Graphics/Pictures/", "ev_m_mino_ha03"],
          4 => ["Graphics/Pictures/", "ev_m_mino_ha04"],
          5 => ["Graphics/Pictures/", "ev_m_mino_ha05"],
          6 => ["Graphics/Pictures/", "ev_m_mino_ha06"],
          7 => ["Graphics/Pictures/", "ev_m_mino_ha07"],
          8 => ["Graphics/Pictures/", "ev_m_mino_ha08"],
          9 => ["Graphics/Pictures/", "ev_m_mino_ha09"],
          10 => ["Graphics/Pictures/", "ev_m_mino_ha10"],
          11 => ["Graphics/Pictures/", "ev_m_mino_ha11"],
          12 => ["Graphics/Pictures/", "ev_m_mino_ha12"],
          13 => ["Graphics/Pictures/", "ev_m_mino_ha13"],
          14 => ["Graphics/Pictures/", "ev_m_mino_ha14"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
        ],
          :background => {
            :id => 29
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_m_mino_hb01"],
          2 => ["Graphics/Pictures/", "ev_m_mino_hb02"],
          3 => ["Graphics/Pictures/", "ev_m_mino_hb03"],
          4 => ["Graphics/Pictures/", "ev_m_mino_hb04"],
          5 => ["Graphics/Pictures/", "ev_m_mino_hb05"],
          6 => ["Graphics/Pictures/", "ev_m_mino_hb06"],
          7 => ["Graphics/Pictures/", "ev_m_mino_hb07"],
          8 => ["Graphics/Pictures/", "ev_m_mino_hb08"],
          9 => ["Graphics/Pictures/", "ev_m_mino_hb09"],
          10 => ["Graphics/Pictures/", "ev_m_mino_hb10"],
          11 => ["Graphics/Pictures/", "ev_m_mino_hb11"],
          12 => ["Graphics/Pictures/", "ev_m_mino_hb12"],
          13 => ["Graphics/Pictures/", "ev_m_mino_hb13"],
          14 => ["Graphics/Pictures/", "ev_m_mino_hb14"],
          15 => ["Graphics/Pictures/", "ev_m_mino_hb15"],
          16 => ["Graphics/Pictures/", "ev_m_mino_hb16"],
          17 => ["Graphics/Pictures/", "ev_m_mino_hb17"],
          18 => ["Graphics/Pictures/", "ev_m_mino_hb18"],
          19 => ["Graphics/Pictures/", "ev_m_mino_hb19"],
          20 => ["Graphics/Pictures/", "ev_m_mino_hb20"],
          21 => ["Graphics/Pictures/", "ev_m_mino_hb21"],
          22 => ["Graphics/Pictures/", "ev_m_mino_hb22"],
          23 => ["Graphics/Pictures/", "ev_m_mino_hb23"],
          24 => ["Graphics/Pictures/", "ev_m_mino_hb24"],
          25 => ["Graphics/Pictures/", "ev_m_mino_hb25"],
          26 => ["Graphics/Pictures/", "ev_m_mino_hb26"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
          [26],
        ],
          :condition => {
            :type => 1,
            :id => 3216,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3181,
          :background => {
            :id => 29
          }
        },
        2 => {
          :name => "Request 1 (Milking Blowjob)",
          :common => 4891,
          :condition => {
            :type => 1,
            :id => 3216,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4892,
          :condition => {
            :type => 1,
            :id => 3216,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    379 => {
      :name => "Genitauros",
      :condition => {
        :type => 3,
        :id => 182
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_zinitauros_h1"],
          2 => ["Graphics/Pictures/", "ev_zinitauros_h2"],
          3 => ["Graphics/Pictures/", "ev_zinitauros_h3"],
          4 => ["Graphics/Pictures/", "ev_zinitauros_h4"],
          5 => ["Graphics/Pictures/", "ev_zinitauros_h5"],
          6 => ["Graphics/Pictures/", "ev_zinitauros_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 29
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3182,
          :background => {
            :id => 29
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4896,
          :condition => {
            :type => 1,
            :id => 3217,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    380 => {
      :name => "Cow Demon Queen",
      :condition => {
        :type => 3,
        :id => 184
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_nyumaou_h1"],
          2 => ["Graphics/Pictures/", "ev_nyumaou_h2"],
          3 => ["Graphics/Pictures/", "ev_nyumaou_h3"],
          4 => ["Graphics/Pictures/", "ev_nyumaou_h4"],
          5 => ["Graphics/Pictures/", "ev_nyumaou_h5"],
          6 => ["Graphics/Pictures/", "ev_nyumaou_h6"],
          7 => ["Graphics/Pictures/", "ev_nyumaou_h7"],
          8 => ["Graphics/Pictures/", "ev_nyumaou_h8"],
          9 => ["Graphics/Pictures/", "ev_nyumaou_h9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 29
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_nyumaou_hb1"],
          2 => ["Graphics/Pictures/", "ev_nyumaou_hb2"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3184,
          :background => {
            :id => 29
          }
        },
        2 => {
          :name => "Request 1 (Body Wrapping Paizuri)",
          :common => 4901,
          :condition => {
            :type => 1,
            :id => 3218,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Loop Event (Breast Crushing)",
          :common => 5821,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    381 => {
      :name => "Angry Minotaur King",
      :condition => {
        :type => 3,
        :id => 915
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_nyumaou_hc1"],
          2 => ["Graphics/Pictures/", "ev_nyumaou_hc2"],
          3 => ["Graphics/Pictures/", "ev_nyumaou_hc3"],
          4 => ["Graphics/Pictures/", "ev_nyumaou_hc4"],
          5 => ["Graphics/Pictures/", "ev_nyumaou_hc5"],
          6 => ["Graphics/Pictures/", "ev_nyumaou_hc6"],
          7 => ["Graphics/Pictures/", "ev_nyumaou_hc7"],
          8 => ["Graphics/Pictures/", "ev_nyumaou_hc8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 17
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3915,
          :background => {
            :id => 17
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4902,
          :condition => {
            :type => 1,
            :id => 3218,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    382 => {
      :name => "Kunoichi Elf",
      :condition => {
        :type => 3,
        :id => 185
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_kunoitielf_st02"],
          2 => ["Graphics/Pictures/", "ev_kunoitielf_ct01"],
          3 => ["Graphics/Pictures/", "ev_kunoitielf_ct02"],
          4 => ["Graphics/Pictures/", "ev_kunoitielf_ct03"],
          5 => ["Graphics/Pictures/", "ev_kunoitielf_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
        ],
          :background => {
            :id => 8
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3185,
          :background => {
            :id => 8
          }
        },
        2 => {
          :name => "Request 1 (Pussy Exhaustion)",
          :common => 4906,
          :condition => {
            :type => 1,
            :id => 3219,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Pussy Exhaustion...?)",
          :common => 4907,
          :condition => {
            :type => 1,
            :id => 3219,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    383 => {
      :name => "Samurai Elf",
      :condition => {
        :type => 3,
        :id => 186
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_samuraielf_st02"],
          2 => ["Graphics/Pictures/", "ev_samuraielf_ct01"],
          3 => ["Graphics/Pictures/", "ev_samuraielf_ct02"],
          4 => ["Graphics/Pictures/", "ev_samuraielf_ct03"],
          5 => ["Graphics/Pictures/", "ev_samuraielf_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
        ],
          :background => {
            :id => 8
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3186,
          :background => {
            :id => 8
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4911,
          :condition => {
            :type => 1,
            :id => 3220,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    384 => {
      :name => "Yuki-Onna",
      :condition => {
        :type => 3,
        :id => 187
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_yukionna_h1"],
          2 => ["Graphics/Pictures/", "ev_yukionna_h2"],
          3 => ["Graphics/Pictures/", "ev_yukionna_h3"],
          4 => ["Graphics/Pictures/", "ev_yukionna_h4"],
          5 => ["Graphics/Pictures/", "ev_yukionna_h5"],
          6 => ["Graphics/Pictures/", "ev_yukionna_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 8
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_yukionna_hb1"],
          2 => ["Graphics/Pictures/", "ev_yukionna_ct01"],
          3 => ["Graphics/Pictures/", "ev_yukionna_ct02"],
          4 => ["Graphics/Pictures/", "ev_yukionna_ct03"],
          5 => ["Graphics/Pictures/", "ev_yukionna_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
        ],
          :condition => {
            :type => 1,
            :id => 3221,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3187,
          :background => {
            :id => 8
          }
        },
        2 => {
          :name => "Request 1 (Semen Sucking Embrace)",
          :common => 4916,
          :condition => {
            :type => 1,
            :id => 3221,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4917,
          :condition => {
            :type => 1,
            :id => 3221,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    385 => {
      :name => "Nekomata",
      :condition => {
        :type => 3,
        :id => 188
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_nekomata_h1"],
          2 => ["Graphics/Pictures/", "ev_nekomata_h2"],
          3 => ["Graphics/Pictures/", "ev_nekomata_h3"],
          4 => ["Graphics/Pictures/", "ev_nekomata_h4"],
          5 => ["Graphics/Pictures/", "ev_nekomata_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 2
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3188,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4921,
          :condition => {
            :type => 1,
            :id => 3222,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    386 => {
      :name => "Akaname",
      :condition => {
        :type => 3,
        :id => 189
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_akaname_h1"],
          2 => ["Graphics/Pictures/", "ev_akaname_h2"],
          3 => ["Graphics/Pictures/", "ev_akaname_h3"],
          4 => ["Graphics/Pictures/", "ev_akaname_h4"],
          5 => ["Graphics/Pictures/", "ev_akaname_h5"],
          6 => ["Graphics/Pictures/", "ev_akaname_h6"],
          7 => ["Graphics/Pictures/", "ev_akaname_h7"],
          8 => ["Graphics/Pictures/", "ev_akaname_h8"],
          9 => ["Graphics/Pictures/", "ev_akaname_h9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 2
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_akaname_st02"],
          2 => ["Graphics/Pictures/", "ev_akaname_ct01"],
          3 => ["Graphics/Pictures/", "ev_akaname_ct02"],
          4 => ["Graphics/Pictures/", "ev_akaname_ct11"],
          5 => ["Graphics/Pictures/", "ev_akaname_ct12"],
          6 => ["Graphics/Pictures/", "ev_akaname_ct21"],
          7 => ["Graphics/Pictures/", "ev_akaname_ct22"],
          8 => ["Graphics/Pictures/", "ev_akaname_ct31"],
          9 => ["Graphics/Pictures/", "ev_akaname_ct32"],
          10 => ["Graphics/Pictures/", "ev_akaname_ct41"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
          [1,6],
          [1,7],
          [1,8],
          [1,9],
          [1,10],
        ],
          :condition => {
            :type => 1,
            :id => 3223,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3189,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Akaname Licking Kiss)",
          :common => 4926,
          :condition => {
            :type => 1,
            :id => 3223,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Akaname Squeeze)",
          :common => 4927,
          :condition => {
            :type => 1,
            :id => 3223,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Akaname Entangling)",
          :common => 4928,
          :condition => {
            :type => 1,
            :id => 3223,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 4 (Akaname Sucking)",
          :common => 4929,
          :condition => {
            :type => 1,
            :id => 3223,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        6 => {
          :name => "Request 5 (Akaname Triple Entanglement)",
          :common => 4930,
          :condition => {
            :type => 1,
            :id => 3223,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        7 => {
          :name => "Request 6 (Akaname Tongue Garden)",
          :common => 4931,
          :condition => {
            :type => 1,
            :id => 3223,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    387 => {
      :name => "Kappa",
      :condition => {
        :type => 3,
        :id => 190
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kappa_ha1"],
          2 => ["Graphics/Pictures/", "ev_kappa_ha2"],
          3 => ["Graphics/Pictures/", "ev_kappa_ha3"],
          4 => ["Graphics/Pictures/", "ev_kappa_ha4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 2
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kappa_hb1"],
          2 => ["Graphics/Pictures/", "ev_kappa_hb2"],
          3 => ["Graphics/Pictures/", "ev_kappa_hb3"],
          4 => ["Graphics/Pictures/", "ev_kappa_hb4"],
          5 => ["Graphics/Pictures/", "ev_kappa_hb5"],
          6 => ["Graphics/Pictures/", "ev_kappa_hb6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3224,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3190,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Anal Torture)",
          :common => 4936,
          :condition => {
            :type => 1,
            :id => 3224,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4937,
          :condition => {
            :type => 1,
            :id => 3224,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    388 => {
      :name => "Futakuchi Girl",
      :condition => {
        :type => 3,
        :id => 191
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_hutakuti_hb1"],
          2 => ["Graphics/Pictures/", "ev_hutakuti_hb2"],
          3 => ["Graphics/Pictures/", "ev_hutakuti_hb3"],
          4 => ["Graphics/Pictures/", "ev_hutakuti_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 2
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_hutakuti_ha1"],
          2 => ["Graphics/Pictures/", "ev_hutakuti_ha2"],
          3 => ["Graphics/Pictures/", "ev_hutakuti_ha3"],
          4 => ["Graphics/Pictures/", "ev_hutakuti_ha4"],
          5 => ["Graphics/Pictures/", "ev_hutakuti_ha5"],
          6 => ["Graphics/Pictures/", "ev_hutakuti_hc1"],
          7 => ["Graphics/Pictures/", "ev_hutakuti_hc2"],
          8 => ["Graphics/Pictures/", "ev_hutakuti_hc3"],
          9 => ["Graphics/Pictures/", "ev_hutakuti_hc4"],
          10 => ["Graphics/Pictures/", "ev_hutakuti_hc5"],
          11 => ["Graphics/Pictures/", "ev_hutakuti_ct01"],
          12 => ["Graphics/Pictures/", "ev_hutakuti_ct02"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [8,11],
          [9,12],
          [10,12],
        ],
          :condition => {
            :type => 1,
            :id => 3225,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3191,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Back-Mouth Blowjob)",
          :common => 4941,
          :condition => {
            :type => 1,
            :id => 3225,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Front-Mouth Blowjob)",
          :common => 4942,
          :condition => {
            :type => 1,
            :id => 3225,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Straddling)",
          :common => 4943,
          :condition => {
            :type => 1,
            :id => 3225,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 4 (Reverse Rape)",
          :common => 4944,
          :condition => {
            :type => 1,
            :id => 3225,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    389 => {
      :name => "Shirohebi",
      :condition => {
        :type => 3,
        :id => 192
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_sirohebisama_hb1"],
          2 => ["Graphics/Pictures/", "ev_sirohebisama_hb2"],
          3 => ["Graphics/Pictures/", "ev_sirohebisama_hb3"],
          4 => ["Graphics/Pictures/", "ev_sirohebisama_hb4"],
          5 => ["Graphics/Pictures/", "ev_sirohebisama_hb5"],
          6 => ["Graphics/Pictures/", "ev_sirohebisama_hb6"],
          7 => ["Graphics/Pictures/", "ev_sirohebisama_hb7"],
          8 => ["Graphics/Pictures/", "ev_sirohebisama_hb8"],
          9 => ["Graphics/Pictures/", "ev_sirohebisama_hb9"],
          10 => ["Graphics/Pictures/", "ev_sirohebisama_ct01"],
          11 => ["Graphics/Pictures/", "ev_sirohebisama_ct02"],
          12 => ["Graphics/Pictures/", "ev_sirohebisama_ct03"],
          13 => ["Graphics/Pictures/", "ev_sirohebisama_ct04"],
          14 => ["Graphics/Pictures/", "ev_sirohebisama_ct05"],
          15 => ["Graphics/Pictures/", "ev_sirohebisama_ct06"],
          16 => ["Graphics/Pictures/", "ev_sirohebisama_ct07"],
          17 => ["Graphics/Pictures/", "ev_sirohebisama_ct08"],
          18 => ["Graphics/Pictures/", "ev_sirohebisama_ct09"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,10],
          [2,11],
          [3,12],
          [4,13],
          [5,14],
          [6,15],
          [7,16],
          [8,17],
          [9,18],
        ],
          :background => {
            :id => 66
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_sirohebisama_ha1"],
          2 => ["Graphics/Pictures/", "ev_sirohebisama_ha1s"],
          3 => ["Graphics/Pictures/", "ev_sirohebisama_ha2"],
          4 => ["Graphics/Pictures/", "ev_sirohebisama_ha3"],
          5 => ["Graphics/Pictures/", "ev_sirohebisama_ha4"],
          6 => ["Graphics/Pictures/", "ev_sirohebisama_ha5"],
          7 => ["Graphics/Pictures/", "ev_sirohebisama_ha6"],
          8 => ["Graphics/Pictures/", "ev_sirohebisama_ha7"],
          9 => ["Graphics/Pictures/", "ev_sirohebisama_ha8"],
          10 => ["Graphics/Pictures/", "ev_sirohebisama_ha9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :condition => {
            :type => 1,
            :id => 3226,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3192,
          :background => {
            :id => 66
          }
        },
        2 => {
          :name => "Request 1 (Tailjob)",
          :common => 4946,
          :condition => {
            :type => 1,
            :id => 3226,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4947,
          :condition => {
            :type => 1,
            :id => 3226,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    390 => {
      :name => "Miko Lamia",
      :condition => {
        :type => 3,
        :id => 193
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_mikolamia_hb1"],
          2 => ["Graphics/Pictures/", "ev_mikolamia_hb2"],
          3 => ["Graphics/Pictures/", "ev_mikolamia_hb3"],
          4 => ["Graphics/Pictures/", "ev_mikolamia_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 20
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_mikolamia_ha1"],
          2 => ["Graphics/Pictures/", "ev_mikolamia_ha2"],
          3 => ["Graphics/Pictures/", "ev_mikolamia_ha3"],
          4 => ["Graphics/Pictures/", "ev_mikolamia_ha4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3227,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_mikolamia_hc1"],
          2 => ["Graphics/Pictures/", "ev_mikolamia_hc2"],
          3 => ["Graphics/Pictures/", "ev_mikolamia_hc3"],
          4 => ["Graphics/Pictures/", "ev_mikolamia_hc4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3193,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Ninety Inch Tongue Wrap)",
          :common => 4951,
          :condition => {
            :type => 1,
            :id => 3227,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4952,
          :condition => {
            :type => 1,
            :id => 3227,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Loop Event (Bound Paizuri)",
          :common => 5844,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    391 => {
      :name => "Miko Arachne",
      :condition => {
        :type => 3,
        :id => 194
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_mikoarachne_hb1"],
          2 => ["Graphics/Pictures/", "ev_mikoarachne_hb2"],
          3 => ["Graphics/Pictures/", "ev_mikoarachne_hb3"],
          4 => ["Graphics/Pictures/", "ev_mikoarachne_hb4"],
          5 => ["Graphics/Pictures/", "ev_mikoarachne_hb5"],
          6 => ["Graphics/Pictures/", "ev_mikoarachne_hb6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 20
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_mikoarachne_ha1"],
          2 => ["Graphics/Pictures/", "ev_mikoarachne_ha2"],
          3 => ["Graphics/Pictures/", "ev_mikoarachne_ha3"],
          4 => ["Graphics/Pictures/", "ev_mikoarachne_ha4"],
          5 => ["Graphics/Pictures/", "ev_mikoarachne_ha5"],
          6 => ["Graphics/Pictures/", "ev_mikoarachne_ha6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3228,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3194,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4956,
          :condition => {
            :type => 1,
            :id => 3228,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    392 => {
      :name => "Kejourou",
      :condition => {
        :type => 3,
        :id => 195
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kezyorou_ha1"],
          2 => ["Graphics/Pictures/", "ev_kezyorou_ha2"],
          3 => ["Graphics/Pictures/", "ev_kezyorou_ha3"],
          4 => ["Graphics/Pictures/", "ev_kezyorou_ha4"],
          5 => ["Graphics/Pictures/", "ev_kezyorou_ha5"],
          6 => ["Graphics/Pictures/", "ev_kezyorou_ha6"],
          7 => ["Graphics/Pictures/", "ev_kezyorou_ha7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 20
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kezyorou_hb1"],
          2 => ["Graphics/Pictures/", "ev_kezyorou_hb2"],
          3 => ["Graphics/Pictures/", "ev_kezyorou_hb3"],
          4 => ["Graphics/Pictures/", "ev_kezyorou_hb4"],
          5 => ["Graphics/Pictures/", "ev_kezyorou_hb5"],
          6 => ["Graphics/Pictures/", "ev_kezyorou_hb6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3229,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3195,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Restrained Hairjob)",
          :common => 4961,
          :condition => {
            :type => 1,
            :id => 3229,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 4962,
          :condition => {
            :type => 1,
            :id => 3229,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    393 => {
      :name => "Yamata no Orochi",
      :condition => {
        :type => 3,
        :id => 196
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_yamatanooroti_h01"],
          2 => ["Graphics/Pictures/", "ev_yamatanooroti_h02"],
          3 => ["Graphics/Pictures/", "ev_yamatanooroti_h03"],
          4 => ["Graphics/Pictures/", "ev_yamatanooroti_h04"],
          5 => ["Graphics/Pictures/", "ev_yamatanooroti_h05"],
          6 => ["Graphics/Pictures/", "ev_yamatanooroti_h06"],
          7 => ["Graphics/Pictures/", "ev_yamatanooroti_h07"],
          8 => ["Graphics/Pictures/", "ev_yamatanooroti_h08"],
          9 => ["Graphics/Pictures/", "ev_yamatanooroti_h09"],
          10 => ["Graphics/Pictures/", "ev_yamatanooroti_h10"],
          11 => ["Graphics/Pictures/", "ev_yamatanooroti_h11"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
        ],
          :background => {
            :id => 20
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_yamatanooroti_hb1"],
          2 => ["Graphics/Pictures/", "ev_yamatanooroti_hb2"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3196,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Whole Body Licking)",
          :common => 4966,
          :condition => {
            :type => 1,
            :id => 3230,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Loop Event (Full Body Licking Predation)",
          :common => 5831,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    394 => {
      :name => "Magical Butterfly",
      :condition => {
        :type => 3,
        :id => 197
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_m_batterfly_hb1"],
          2 => ["Graphics/Pictures/", "ev_m_batterfly_hb2"],
          3 => ["Graphics/Pictures/", "ev_m_batterfly_hb3"],
          4 => ["Graphics/Pictures/", "ev_m_batterfly_hb4"],
          5 => ["Graphics/Pictures/", "ev_m_batterfly_hb5"],
          6 => ["Graphics/Pictures/", "ev_m_batterfly_hb6"],
          7 => ["Graphics/Pictures/", "ev_m_batterfly_hb7"],
          8 => ["Graphics/Pictures/", "ev_m_batterfly_hb8"],
          9 => ["Graphics/Pictures/", "ev_m_batterfly_hb9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 37
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_m_batterfly_ha01"],
          2 => ["Graphics/Pictures/", "ev_m_batterfly_ha02"],
          3 => ["Graphics/Pictures/", "ev_m_batterfly_ha03"],
          4 => ["Graphics/Pictures/", "ev_m_batterfly_ha04"],
          5 => ["Graphics/Pictures/", "ev_m_batterfly_ha05"],
          6 => ["Graphics/Pictures/", "ev_m_batterfly_ha06"],
          7 => ["Graphics/Pictures/", "ev_m_batterfly_ha07"],
          8 => ["Graphics/Pictures/", "ev_m_batterfly_ha08"],
          9 => ["Graphics/Pictures/", "ev_m_batterfly_ha09"],
          10 => ["Graphics/Pictures/", "ev_m_batterfly_ha10"],
          11 => ["Graphics/Pictures/", "ev_m_batterfly_ha11"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
        ],
          :condition => {
            :type => 1,
            :id => 3231,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3197,
          :background => {
            :id => 37
          }
        },
        2 => {
          :name => "Request 1 (Group Toy)",
          :common => 4971,
          :condition => {
            :type => 1,
            :id => 3231,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Butterfly Honeysuck)",
          :common => 4972,
          :condition => {
            :type => 1,
            :id => 3231,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    395 => {
      :name => "Magical Dragonfly",
      :condition => {
        :type => 3,
        :id => 198
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_m_batterfly_hb1"],
          2 => ["Graphics/Pictures/", "ev_m_batterfly_hb2"],
          3 => ["Graphics/Pictures/", "ev_m_batterfly_hb3"],
          4 => ["Graphics/Pictures/", "ev_m_batterfly_hb4"],
          5 => ["Graphics/Pictures/", "ev_m_batterfly_hb5"],
          6 => ["Graphics/Pictures/", "ev_m_batterfly_hb6"],
          7 => ["Graphics/Pictures/", "ev_m_batterfly_hb7"],
          8 => ["Graphics/Pictures/", "ev_m_batterfly_hb8"],
          9 => ["Graphics/Pictures/", "ev_m_batterfly_hb9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 37
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_m_dragonfly_h01"],
          2 => ["Graphics/Pictures/", "ev_m_dragonfly_h02"],
          3 => ["Graphics/Pictures/", "ev_m_dragonfly_h03"],
          4 => ["Graphics/Pictures/", "ev_m_dragonfly_h04"],
          5 => ["Graphics/Pictures/", "ev_m_dragonfly_h05"],
          6 => ["Graphics/Pictures/", "ev_m_dragonfly_h06"],
          7 => ["Graphics/Pictures/", "ev_m_dragonfly_h07"],
          8 => ["Graphics/Pictures/", "ev_m_dragonfly_h08"],
          9 => ["Graphics/Pictures/", "ev_m_dragonfly_h09"],
          10 => ["Graphics/Pictures/", "ev_m_dragonfly_h10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :condition => {
            :type => 1,
            :id => 3231,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3198,
          :background => {
            :id => 37
          }
        },
        2 => {
          :name => "Request 1 (Group Toy)",
          :common => 4971,
          :condition => {
            :type => 1,
            :id => 3231,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Dragonfly Mating)",
          :common => 4973,
          :condition => {
            :type => 1,
            :id => 3231,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    396 => {
      :name => "Magical Ladybug",
      :condition => {
        :type => 3,
        :id => 199
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_m_batterfly_hb1"],
          2 => ["Graphics/Pictures/", "ev_m_batterfly_hb2"],
          3 => ["Graphics/Pictures/", "ev_m_batterfly_hb3"],
          4 => ["Graphics/Pictures/", "ev_m_batterfly_hb4"],
          5 => ["Graphics/Pictures/", "ev_m_batterfly_hb5"],
          6 => ["Graphics/Pictures/", "ev_m_batterfly_hb6"],
          7 => ["Graphics/Pictures/", "ev_m_batterfly_hb7"],
          8 => ["Graphics/Pictures/", "ev_m_batterfly_hb8"],
          9 => ["Graphics/Pictures/", "ev_m_batterfly_hb9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 37
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_m_tento_h1"],
          2 => ["Graphics/Pictures/", "ev_m_tento_h2"],
          3 => ["Graphics/Pictures/", "ev_m_tento_h3"],
          4 => ["Graphics/Pictures/", "ev_m_tento_h4"],
          5 => ["Graphics/Pictures/", "ev_m_tento_h5"],
          6 => ["Graphics/Pictures/", "ev_m_tento_h6"],
          7 => ["Graphics/Pictures/", "ev_m_tento_h7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :condition => {
            :type => 1,
            :id => 3231,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3199,
          :background => {
            :id => 37
          }
        },
        2 => {
          :name => "Request 1 (Group Toy)",
          :common => 4971,
          :condition => {
            :type => 1,
            :id => 3231,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Ladybug Reverse Rape)",
          :common => 4974,
          :condition => {
            :type => 1,
            :id => 3231,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    397 => {
      :name => "Magical Pixie",
      :condition => {
        :type => 3,
        :id => 200
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_m_fairy_hb1"],
          2 => ["Graphics/Pictures/", "ev_m_fairy_hb2"],
          3 => ["Graphics/Pictures/", "ev_m_fairy_hb3"],
          4 => ["Graphics/Pictures/", "ev_m_fairy_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 37
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_m_fairy_ha1"],
          2 => ["Graphics/Pictures/", "ev_m_fairy_ha2"],
          3 => ["Graphics/Pictures/", "ev_m_fairy_ha3"],
          4 => ["Graphics/Pictures/", "ev_m_fairy_ha4"],
          5 => ["Graphics/Pictures/", "ev_m_fairy_ha5"],
          6 => ["Graphics/Pictures/", "ev_m_fairy_ha6"],
          7 => ["Graphics/Pictures/", "ev_m_fairy_ha7"],
          8 => ["Graphics/Pictures/", "ev_m_fairy_ha8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :condition => {
            :type => 1,
            :id => 3232,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3200,
          :background => {
            :id => 37
          }
        },
        2 => {
          :name => "Request 1 (Group Toy)",
          :common => 4976,
          :condition => {
            :type => 1,
            :id => 3232,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Pixie Reverse Rape)",
          :common => 4977,
          :condition => {
            :type => 1,
            :id => 3232,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    398 => {
      :name => "Magical Elf",
      :condition => {
        :type => 3,
        :id => 201
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_m_fairy_hb1"],
          2 => ["Graphics/Pictures/", "ev_m_fairy_hb2"],
          3 => ["Graphics/Pictures/", "ev_m_fairy_hb3"],
          4 => ["Graphics/Pictures/", "ev_m_fairy_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 37
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_m_elf_h01"],
          2 => ["Graphics/Pictures/", "ev_m_elf_h02"],
          3 => ["Graphics/Pictures/", "ev_m_elf_h03"],
          4 => ["Graphics/Pictures/", "ev_m_elf_h04"],
          5 => ["Graphics/Pictures/", "ev_m_elf_h05"],
          6 => ["Graphics/Pictures/", "ev_m_elf_h06"],
          7 => ["Graphics/Pictures/", "ev_m_elf_h07"],
          8 => ["Graphics/Pictures/", "ev_m_elf_h08"],
          9 => ["Graphics/Pictures/", "ev_m_elf_h09"],
          10 => ["Graphics/Pictures/", "ev_m_elf_h10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :condition => {
            :type => 1,
            :id => 3232,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3201,
          :background => {
            :id => 37
          }
        },
        2 => {
          :name => "Request 1 (Group Toy)",
          :common => 4976,
          :condition => {
            :type => 1,
            :id => 3232,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Elf Reverse Rape)",
          :common => 4978,
          :condition => {
            :type => 1,
            :id => 3232,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    399 => {
      :name => "Magical Succubus",
      :condition => {
        :type => 3,
        :id => 202
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_m_fairy_hb1"],
          2 => ["Graphics/Pictures/", "ev_m_fairy_hb2"],
          3 => ["Graphics/Pictures/", "ev_m_fairy_hb3"],
          4 => ["Graphics/Pictures/", "ev_m_fairy_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 37
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_m_succubus_h1"],
          2 => ["Graphics/Pictures/", "ev_m_succubus_h2"],
          3 => ["Graphics/Pictures/", "ev_m_succubus_h3"],
          4 => ["Graphics/Pictures/", "ev_m_succubus_h4"],
          5 => ["Graphics/Pictures/", "ev_m_succubus_h5"],
          6 => ["Graphics/Pictures/", "ev_m_succubus_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3232,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3202,
          :background => {
            :id => 37
          }
        },
        2 => {
          :name => "Request 1 (Group Toy)",
          :common => 4976,
          :condition => {
            :type => 1,
            :id => 3232,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Succubus Reverse Rape)",
          :common => 4979,
          :condition => {
            :type => 1,
            :id => 3232,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    402 => {
      :name => "Mantis Girl",
      :condition => {
        :type => 3,
        :id => 204
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kamakiri_ha1"],
          2 => ["Graphics/Pictures/", "ev_kamakiri_ha2"],
          3 => ["Graphics/Pictures/", "ev_kamakiri_ha3"],
          4 => ["Graphics/Pictures/", "ev_kamakiri_ha4"],
          5 => ["Graphics/Pictures/", "ev_kamakiri_ha5"],
          6 => ["Graphics/Pictures/", "ev_kamakiri_hb1"],
          7 => ["Graphics/Pictures/", "ev_kamakiri_hb2"],
          8 => ["Graphics/Pictures/", "ev_kamakiri_hb3"],
          9 => ["Graphics/Pictures/", "ev_kamakiri_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 2
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kamakiri_hc1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3204,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 4986,
          :condition => {
            :type => 1,
            :id => 3234,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Loop Event (Oviduct Predation)",
          :common => 5810,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    403 => {
      :name => "Silkworm Girl",
      :condition => {
        :type => 3,
        :id => 205
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kaiko_h01"],
          2 => ["Graphics/Pictures/", "ev_kaiko_h11"],
          3 => ["Graphics/Pictures/", "ev_kaiko_h12"],
          4 => ["Graphics/Pictures/", "ev_kaiko_h13"],
          5 => ["Graphics/Pictures/", "ev_kaiko_h14"],
          6 => ["Graphics/Pictures/", "ev_kaiko_h15"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 2
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kaiko_h01"],
          2 => ["Graphics/Pictures/", "ev_kaiko_h21"],
          3 => ["Graphics/Pictures/", "ev_kaiko_h22"],
          4 => ["Graphics/Pictures/", "ev_kaiko_h23"],
          5 => ["Graphics/Pictures/", "ev_kaiko_h24"],
          6 => ["Graphics/Pictures/", "ev_kaiko_h25"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3235,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kaiko_hb1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3205,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Cocoon)",
          :common => 4991,
          :condition => {
            :type => 1,
            :id => 3235,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Loop Event (Restrained Lime)",
          :common => 5809,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    404 => {
      :name => "Alra Arum",
      :condition => {
        :type => 3,
        :id => 206
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_a_alm_h1a"],
          2 => ["Graphics/Pictures/", "ev_a_alm_h2a"],
          3 => ["Graphics/Pictures/", "ev_a_alm_h3a"],
          4 => ["Graphics/Pictures/", "ev_a_alm_h1"],
          5 => ["Graphics/Pictures/", "ev_a_alm_h2"],
          6 => ["Graphics/Pictures/", "ev_a_alm_h3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 4
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_a_alm_st01"],
          2 => ["Graphics/Pictures/", "ev_a_alm_ct01"],
          3 => ["Graphics/Pictures/", "ev_a_alm_ct02"],
          4 => ["Graphics/Pictures/", "ev_a_alm_ct03"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
        ],
          :condition => {
            :type => 1,
            :id => 3236,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3206,
          :background => {
            :id => 4
          }
        },
        2 => {
          :name => "Request 1 (Monster Flower Hug)",
          :common => 4996,
          :condition => {
            :type => 1,
            :id => 3236,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    405 => {
      :name => "Alra Rooty",
      :condition => {
        :type => 3,
        :id => 207
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_a_looty_h1a"],
          2 => ["Graphics/Pictures/", "ev_a_looty_h2a"],
          3 => ["Graphics/Pictures/", "ev_a_looty_h3a"],
          4 => ["Graphics/Pictures/", "ev_a_looty_h1"],
          5 => ["Graphics/Pictures/", "ev_a_looty_h2"],
          6 => ["Graphics/Pictures/", "ev_a_looty_h3"],
          7 => ["Graphics/Pictures/", "ev_a_looty_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 4
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3207,
          :background => {
            :id => 4
          }
        },
        2 => {
          :name => "Request 1 (Rooty Draw)",
          :common => 4997,
          :condition => {
            :type => 1,
            :id => 3236,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Rooty Draw...?)",
          :common => 4998,
          :condition => {
            :type => 1,
            :id => 3236,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    406 => {
      :name => "Alra Vore",
      :condition => {
        :type => 3,
        :id => 208
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_a_vore_h1a"],
          2 => ["Graphics/Pictures/", "ev_a_vore_h2a"],
          3 => ["Graphics/Pictures/", "ev_a_vore_h3a"],
          4 => ["Graphics/Pictures/", "ev_a_vore_h1"],
          5 => ["Graphics/Pictures/", "ev_a_vore_h2"],
          6 => ["Graphics/Pictures/", "ev_a_vore_h3"],
          7 => ["Graphics/Pictures/", "ev_a_vore_h4"],
          8 => ["Graphics/Pictures/", "ev_a_vore_ct11"],
          9 => ["Graphics/Pictures/", "ev_a_vore_ct12"],
          10 => ["Graphics/Pictures/", "ev_a_vore_ct13"],
          11 => ["Graphics/Pictures/", "ev_a_vore_ct14"],
          12 => ["Graphics/Pictures/", "ev_a_vore_ct15"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7,8],
          [7,9],
          [7,10],
          [7,11],
          [7,12],
        ],
          :background => {
            :id => 4
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_a_vore_h2a"],
          2 => ["Graphics/Pictures/", "ev_a_vore_ct01"],
          3 => ["Graphics/Pictures/", "ev_a_vore_ct02"],
          4 => ["Graphics/Pictures/", "ev_a_vore_ct03"],
          5 => ["Graphics/Pictures/", "ev_a_vore_ct04"],
          6 => ["Graphics/Pictures/", "ev_a_vore_ct05"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
          [1,6],
        ],
          :condition => {
            :type => 1,
            :id => 3237,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3208,
          :background => {
            :id => 4
          }
        },
        2 => {
          :name => "Request 1 (Plant Vore)",
          :common => 5001,
          :condition => {
            :type => 1,
            :id => 3237,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    407 => {
      :name => "Alra Parasol",
      :condition => {
        :type => 3,
        :id => 209
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_a_parasol_h1a"],
          2 => ["Graphics/Pictures/", "ev_a_parasol_h2a"],
          3 => ["Graphics/Pictures/", "ev_a_parasol_h1"],
          4 => ["Graphics/Pictures/", "ev_a_parasol_h2"],
          5 => ["Graphics/Pictures/", "ev_a_parasol_h3"],
          6 => ["Graphics/Pictures/", "ev_a_parasol_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 4
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3209,
          :background => {
            :id => 4
          }
        },
        2 => {
          :name => "Request 1 (Seedbed Embrace)",
          :common => 5002,
          :condition => {
            :type => 1,
            :id => 3237,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    408 => {
      :name => "Alra Prison",
      :condition => {
        :type => 3,
        :id => 210
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_a_prison_h1"],
          2 => ["Graphics/Pictures/", "ev_a_prison_ct01"],
          3 => ["Graphics/Pictures/", "ev_a_prison_ct02"],
          4 => ["Graphics/Pictures/", "ev_a_prison_ct03"],
          5 => ["Graphics/Pictures/", "ev_a_prison_ct04"],
          6 => ["Graphics/Pictures/", "ev_a_prison_ct05"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
          [1,6],
        ],
          :background => {
            :id => 4
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3210,
          :background => {
            :id => 4
          }
        },
        2 => {
          :name => "Request 1 (Flower Prison)",
          :common => 5003,
          :condition => {
            :type => 1,
            :id => 3237,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    409 => {
      :name => "Alra Shroom",
      :condition => {
        :type => 3,
        :id => 211
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_a_mash_ha1"],
          2 => ["Graphics/Pictures/", "ev_a_mash_ha2"],
          3 => ["Graphics/Pictures/", "ev_a_mash_hb1"],
          4 => ["Graphics/Pictures/", "ev_a_mash_hb2"],
          5 => ["Graphics/Pictures/", "ev_a_mash_hb3"],
          6 => ["Graphics/Pictures/", "ev_a_mash_hb4"],
          7 => ["Graphics/Pictures/", "ev_a_mash_hb5"],
          8 => ["Graphics/Pictures/", "ev_a_mash_hb6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 4
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3211,
          :background => {
            :id => 4
          }
        },
        2 => {
          :name => "Request 1 (Mushroom Seedbed)",
          :common => 5004,
          :condition => {
            :type => 1,
            :id => 3237,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    410 => {
      :name => "Dorothy",
      :condition => {
        :type => 3,
        :id => 212
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_dorothy_h1"],
          2 => ["Graphics/Pictures/", "ev_dorothy_h2"],
          3 => ["Graphics/Pictures/", "ev_dorothy_h3"],
          4 => ["Graphics/Pictures/", "ev_dorothy_h4"],
          5 => ["Graphics/Pictures/", "ev_dorothy_h5"],
          6 => ["Graphics/Pictures/", "ev_dorothy_h6"],
          7 => ["Graphics/Pictures/", "ev_dorothy_ct01"],
          8 => ["Graphics/Pictures/", "ev_dorothy_ct02"],
          9 => ["Graphics/Pictures/", "ev_dorothy_ct03"],
          10 => ["Graphics/Pictures/", "ev_dorothy_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [3,7],
          [4,8],
          [5,9],
          [6,10],
        ],
          :background => {
            :id => 4
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3212,
          :background => {
            :id => 4
          }
        },
        2 => {
          :name => "Request 1 (Philia Melt)",
          :common => 5006,
          :condition => {
            :type => 1,
            :id => 3238,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Philia Melt...?)",
          :common => 5007,
          :condition => {
            :type => 1,
            :id => 3238,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    411 => {
      :name => "Raffia",
      :condition => {
        :type => 3,
        :id => 213
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_rafi_h1"],
          2 => ["Graphics/Pictures/", "ev_rafi_h2"],
          3 => ["Graphics/Pictures/", "ev_rafi_h3"],
          4 => ["Graphics/Pictures/", "ev_rafi_h4"],
          5 => ["Graphics/Pictures/", "ev_rafi_h5"],
          6 => ["Graphics/Pictures/", "ev_rafi_h6"],
          7 => ["Graphics/Pictures/", "ev_rafi_ct01"],
          8 => ["Graphics/Pictures/", "ev_rafi_ct02"],
          9 => ["Graphics/Pictures/", "ev_rafi_ct03"],
          10 => ["Graphics/Pictures/", "ev_rafi_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [4,7],
          [5,8],
          [6,9],
          [6,10],
        ],
          :background => {
            :id => 4
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3213,
          :background => {
            :id => 4
          }
        },
        2 => {
          :name => "Request 1 (Intoxicating Pitcher)",
          :common => 5011,
          :condition => {
            :type => 1,
            :id => 3239,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Intoxicating Pitcher...?)",
          :common => 5012,
          :condition => {
            :type => 1,
            :id => 3239,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    412 => {
      :name => "Deana",
      :condition => {
        :type => 3,
        :id => 214
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_dina_h1"],
          2 => ["Graphics/Pictures/", "ev_dina_h2"],
          3 => ["Graphics/Pictures/", "ev_dina_h3"],
          4 => ["Graphics/Pictures/", "ev_dina_h4"],
          5 => ["Graphics/Pictures/", "ev_dina_h5"],
          6 => ["Graphics/Pictures/", "ev_dina_h6"],
          7 => ["Graphics/Pictures/", "ev_dina_ct01"],
          8 => ["Graphics/Pictures/", "ev_dina_ct02"],
          9 => ["Graphics/Pictures/", "ev_dina_ct03"],
          10 => ["Graphics/Pictures/", "ev_dina_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2,7],
          [3,8],
          [4,9],
          [5,10],
          [6],
        ],
          :background => {
            :id => 4
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3214,
          :background => {
            :id => 4
          }
        },
        2 => {
          :name => "Request 1 (Philia Melt)",
          :common => 5016,
          :condition => {
            :type => 1,
            :id => 3240,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Philia Melt...?)",
          :common => 5017,
          :condition => {
            :type => 1,
            :id => 3240,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    413 => {
      :name => "Alra Priestess",
      :condition => {
        :type => 3,
        :id => 215
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_a_emp_ha1a"],
          2 => ["Graphics/Pictures/", "ev_a_emp_ha2a"],
          3 => ["Graphics/Pictures/", "ev_a_emp_ha3a"],
          4 => ["Graphics/Pictures/", "ev_a_emp_ha1"],
          5 => ["Graphics/Pictures/", "ev_a_emp_ha2"],
          6 => ["Graphics/Pictures/", "ev_a_emp_ha3"],
          7 => ["Graphics/Pictures/", "ev_a_emp_ha4"],
          8 => ["Graphics/Pictures/", "ev_a_emp_hb1a"],
          9 => ["Graphics/Pictures/", "ev_a_emp_hb2a"],
          10 => ["Graphics/Pictures/", "ev_a_emp_hb3a"],
          11 => ["Graphics/Pictures/", "ev_a_emp_hb4a"],
          12 => ["Graphics/Pictures/", "ev_a_emp_hb1"],
          13 => ["Graphics/Pictures/", "ev_a_emp_hb2"],
          14 => ["Graphics/Pictures/", "ev_a_emp_hb3"],
          15 => ["Graphics/Pictures/", "ev_a_emp_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
        ],
          :background => {
            :id => 4
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3215,
          :background => {
            :id => 4
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Ivy)",
          :common => 5021,
          :condition => {
            :type => 1,
            :id => 3241,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Semen Sucking Flower)",
          :common => 5022,
          :condition => {
            :type => 1,
            :id => 3241,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    414 => {
      :name => "Alra Priestess (Queen)",
      :condition => {
        :type => 2,
        :id => 242
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_a_emp_hc01"],
          2 => ["Graphics/Pictures/", "ev_a_emp_hc02"],
          3 => ["Graphics/Pictures/", "ev_a_emp_hc03"],
          4 => ["Graphics/Pictures/", "ev_a_emp_hc04"],
          5 => ["Graphics/Pictures/", "ev_a_emp_hc05"],
          6 => ["Graphics/Pictures/", "ev_a_emp_hc06"],
          7 => ["Graphics/Pictures/", "ev_a_emp_hc07"],
          8 => ["Graphics/Pictures/", "ev_a_emp_hc08"],
          9 => ["Graphics/Pictures/", "ev_a_emp_hc09"],
          10 => ["Graphics/Pictures/", "ev_a_emp_hc10"],
          11 => ["Graphics/Pictures/", "ev_a_emp_hc11"],
          12 => ["Graphics/Pictures/", "ev_a_emp_hc12"],
          13 => ["Graphics/Pictures/", "ev_a_emp_hc13"],
          14 => ["Graphics/Pictures/", "ev_a_emp_hc14"],
          15 => ["Graphics/Pictures/", "ev_a_emp_hc15"],
          16 => ["Graphics/Pictures/", "ev_a_emp_hc16"],
          17 => ["Graphics/Pictures/", "ev_a_emp_hc17"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
        ],
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Semen Squeezing Flower)",
          :common => 5023,
          :condition => {
            :type => 1,
            :id => 3242,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :name => "Request 2 (Flowery Diaper)",
          :common => 5024,
          :condition => {
            :type => 1,
            :id => 3242,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 3 (Reverse Rape)",
          :common => 5025,
          :condition => {
            :type => 1,
            :id => 3242,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    415 => {
      :name => "Moth Girl",
      :condition => {
        :type => 3,
        :id => 216
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_moss_h1"],
          2 => ["Graphics/Pictures/", "ev_moss_h2"],
          3 => ["Graphics/Pictures/", "ev_moss_h3"],
          4 => ["Graphics/Pictures/", "ev_moss_h4"],
          5 => ["Graphics/Pictures/", "ev_moss_ct01"],
          6 => ["Graphics/Pictures/", "ev_moss_ct02"],
          7 => ["Graphics/Pictures/", "ev_moss_ct03"],
        },
        # 表示パターンの指定
        :draw => [
          [1,5],
          [2,6],
          [2,7],
          [3,7],
          [4,7],
        ],
          :background => {
            :id => 9
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3216,
          :background => {
            :id => 9
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5026,
          :condition => {
            :type => 1,
            :id => 3243,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    416 => {
      :name => "Mosquito Girl",
      :condition => {
        :type => 3,
        :id => 217
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_mosquito_h1"],
          2 => ["Graphics/Pictures/", "ev_mosquito_h2"],
          3 => ["Graphics/Pictures/", "ev_mosquito_h3"],
          4 => ["Graphics/Pictures/", "ev_mosquito_h4"],
          5 => ["Graphics/Pictures/", "ev_mosquito_ct01"],
          6 => ["Graphics/Pictures/", "ev_mosquito_ct02"],
          7 => ["Graphics/Pictures/", "ev_mosquito_ct03"],
        },
        # 表示パターンの指定
        :draw => [
          [1,5],
          [2,6],
          [3,6],
          [4,7],
        ],
          :background => {
            :id => 9
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3217,
          :background => {
            :id => 9
          }
        },
        2 => {
          :name => "Request 1 (Mosquito Drain)",
          :common => 5027,
          :condition => {
            :type => 1,
            :id => 3243,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    417 => {
      :name => "Caterpillar Girl",
      :condition => {
        :type => 3,
        :id => 218
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_imomusi_h1a"],
          2 => ["Graphics/Pictures/", "ev_imomusi_h2a"],
          3 => ["Graphics/Pictures/", "ev_imomusi_h1"],
          4 => ["Graphics/Pictures/", "ev_imomusi_h2"],
          5 => ["Graphics/Pictures/", "ev_imomusi_h3"],
          6 => ["Graphics/Pictures/", "ev_imomusi_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 9
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3218,
          :background => {
            :id => 9
          }
        },
        2 => {
          :name => "Request 1 (Sticky Silk)",
          :common => 5028,
          :condition => {
            :type => 1,
            :id => 3243,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    418 => {
      :name => "Hornet Girl",
      :condition => {
        :type => 3,
        :id => 219
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_suzumebati_st01"],
          2 => ["Graphics/Pictures/", "ev_suzumebati_ct01"],
          3 => ["Graphics/Pictures/", "ev_suzumebati_ct02"],
          4 => ["Graphics/Pictures/", "ev_suzumebati_ct03"],
          5 => ["Graphics/Pictures/", "ev_suzumebati_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
        ],
          :background => {
            :id => 75
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3219,
          :background => {
            :id => 75
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5031,
          :condition => {
            :type => 1,
            :id => 3244,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    419 => {
      :name => "Queen Bee",
      :condition => {
        :type => 3,
        :id => 220
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_queenbee_st02"],
          2 => ["Graphics/Pictures/", "ev_queenbee_ct01"],
          3 => ["Graphics/Pictures/", "ev_queenbee_ct02"],
          4 => ["Graphics/Pictures/", "ev_queenbee_ct03"],
          5 => ["Graphics/Pictures/", "ev_queenbee_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
        ],
          :background => {
            :id => 9
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3220,
          :background => {
            :id => 9
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5036,
          :condition => {
            :type => 1,
            :id => 3245,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    420 => {
      :name => "Jelly Girl",
      :condition => {
        :type => 3,
        :id => 225
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_jelly_h1"],
          2 => ["Graphics/Pictures/", "ev_jelly_h2"],
          3 => ["Graphics/Pictures/", "ev_jelly_h3"],
          4 => ["Graphics/Pictures/", "ev_jelly_h4"],
          5 => ["Graphics/Pictures/", "ev_jelly_h5"],
          6 => ["Graphics/Pictures/", "ev_jelly_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 20
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3225,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Jelly Heaven)",
          :common => 5041,
          :condition => {
            :type => 1,
            :id => 3246,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    421 => {
      :name => "Blob Girl",
      :condition => {
        :type => 3,
        :id => 226
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_blob_h1"],
          2 => ["Graphics/Pictures/", "ev_blob_h2"],
          3 => ["Graphics/Pictures/", "ev_blob_h3"],
          4 => ["Graphics/Pictures/", "ev_blob_h4"],
          5 => ["Graphics/Pictures/", "ev_blob_h5"],
          6 => ["Graphics/Pictures/", "ev_blob_h6"],
          7 => ["Graphics/Pictures/", "ev_blob_h7"],
          8 => ["Graphics/Pictures/", "ev_blob_h8"],
          9 => ["Graphics/Pictures/", "ev_blob_h9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 20
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3226,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Predation)",
          :common => 5046,
          :condition => {
            :type => 1,
            :id => 3247,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Predation...?)",
          :common => 5047,
          :condition => {
            :type => 1,
            :id => 3247,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    422 => {
      :name => "Slimies",
      :condition => {
        :type => 3,
        :id => 227
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_slimes_ha1"],
          2 => ["Graphics/Pictures/", "ev_slimes_ha2"],
          3 => ["Graphics/Pictures/", "ev_slimes_ha3"],
          4 => ["Graphics/Pictures/", "ev_slimes_hb1"],
          5 => ["Graphics/Pictures/", "ev_slimes_hb2"],
          6 => ["Graphics/Pictures/", "ev_slimes_hb3"],
          7 => ["Graphics/Pictures/", "ev_slimes_hc1"],
          8 => ["Graphics/Pictures/", "ev_slimes_hc2"],
          9 => ["Graphics/Pictures/", "ev_slimes_hc3"],
          10 => ["Graphics/Pictures/", "ev_slimes_hd1"],
          11 => ["Graphics/Pictures/", "ev_slimes_hd2"],
          12 => ["Graphics/Pictures/", "ev_slimes_hd3"],
          13 => ["Graphics/Pictures/", "ev_slime_green_h1"],
          14 => ["Graphics/Pictures/", "ev_slime_green_h2"],
          15 => ["Graphics/Pictures/", "ev_slime_green_h3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
        ],
          :background => {
            :id => 20
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3227,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Green Ecstasy)",
          :common => 5051,
          :condition => {
            :type => 1,
            :id => 3248,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Special Heaven)",
          :common => 5052,
          :condition => {
            :type => 1,
            :id => 3248,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    423 => {
      :name => "Ant Girls",
      :condition => {
        :type => 3,
        :id => 233
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_ant_st11"],
          2 => ["Graphics/Pictures/", "ev_ant_ct01"],
          3 => ["Graphics/Pictures/", "ev_ant_ct02"],
          4 => ["Graphics/Pictures/", "ev_ant_ct03"],
          5 => ["Graphics/Pictures/", "ev_ant_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
        ],
          :background => {
            :id => 30
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3233,
          :background => {
            :id => 30
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5056,
          :condition => {
            :type => 1,
            :id => 3249,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    424 => {
      :name => "Automata Girl",
      :condition => {
        :type => 3,
        :id => 234
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_artm_ha1"],
          2 => ["Graphics/Pictures/", "ev_artm_ha2"],
          3 => ["Graphics/Pictures/", "ev_artm_ha3"],
          4 => ["Graphics/Pictures/", "ev_artm_hb1"],
          5 => ["Graphics/Pictures/", "ev_artm_hb2"],
          6 => ["Graphics/Pictures/", "ev_artm_hb3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 30
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_artm_st01"],
          2 => ["Graphics/Pictures/", "ev_artm_ct01"],
          3 => ["Graphics/Pictures/", "ev_artm_ct02"],
          4 => ["Graphics/Pictures/", "ev_artm_ct11"],
          5 => ["Graphics/Pictures/", "ev_artm_ct12"],
          6 => ["Graphics/Pictures/", "ev_artm_ct13"],
          7 => ["Graphics/Pictures/", "ev_artm_ct14"],
          8 => ["Graphics/Pictures/", "ev_artm_hc1"],
          9 => ["Graphics/Pictures/", "ev_artm_hc2"],
          10 => ["Graphics/Pictures/", "ev_artm_hc3"],
          11 => ["Graphics/Pictures/", "ev_artm_hc4"],
          12 => ["Graphics/Pictures/", "ev_artm_hc5"],
          13 => ["Graphics/Pictures/", "ev_artm_hc6"],
          14 => ["Graphics/Pictures/", "ev_artm_hc7"],
          15 => ["Graphics/Pictures/", "ev_artm_hc8"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
          [1,6],
          [1,7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
        ],
          :condition => {
            :type => 1,
            :id => 3250,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3234,
          :background => {
            :id => 30
          }
        },
        2 => {
          :name => "Request 1 (Bubble Service)",
          :common => 5061,
          :condition => {
            :type => 1,
            :id => 3250,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5062,
          :condition => {
            :type => 1,
            :id => 3250,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Reverse Rape Mk2)",
          :common => 5063,
          :condition => {
            :type => 1,
            :id => 3250,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    425 => {
      :name => "Paizuri Doll",
      :condition => {
        :type => 3,
        :id => 235
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_paizuridoll_h1"],
          2 => ["Graphics/Pictures/", "ev_paizuridoll_h2"],
          3 => ["Graphics/Pictures/", "ev_paizuridoll_h3"],
          4 => ["Graphics/Pictures/", "ev_paizuridoll_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 30
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_paizuridoll_hb1"],
          2 => ["Graphics/Pictures/", "ev_paizuridoll_hb2"],
          3 => ["Graphics/Pictures/", "ev_paizuridoll_hb3"],
          4 => ["Graphics/Pictures/", "ev_paizuridoll_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3251,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3235,
          :background => {
            :id => 30
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 5066,
          :condition => {
            :type => 1,
            :id => 3251,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Paizuri w/Swimsuit)",
          :common => 5067,
          :condition => {
            :type => 1,
            :id => 3251,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    426 => {
      :name => "Scylla",
      :condition => {
        :type => 3,
        :id => 236
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_scylla_h0"],
          2 => ["Graphics/Pictures/", "ev_scylla_h1"],
          3 => ["Graphics/Pictures/", "ev_scylla_h2"],
          4 => ["Graphics/Pictures/", "ev_scylla_h3"],
          5 => ["Graphics/Pictures/", "ev_scylla_h4"],
          6 => ["Graphics/Pictures/", "ev_scylla_h5"],
          7 => ["Graphics/Pictures/", "ev_scylla_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 2
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3236,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5071,
          :condition => {
            :type => 1,
            :id => 3252,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    427 => {
      :name => "Medusa",
      :condition => {
        :type => 3,
        :id => 237
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_medusa_h1"],
          2 => ["Graphics/Pictures/", "ev_medusa_h2"],
          3 => ["Graphics/Pictures/", "ev_medusa_h3"],
          4 => ["Graphics/Pictures/", "ev_medusa_h4"],
          5 => ["Graphics/Pictures/", "ev_medusa_h5"],
          6 => ["Graphics/Pictures/", "ev_medusa_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 2
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_medusa_hb1"],
          2 => ["Graphics/Pictures/", "ev_medusa_hb2"],
          3 => ["Graphics/Pictures/", "ev_medusa_hb3"],
          4 => ["Graphics/Pictures/", "ev_medusa_hb4"],
          5 => ["Graphics/Pictures/", "ev_medusa_hb5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3237,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Lewd Snake's Hair)",
          :common => 5076,
          :condition => {
            :type => 1,
            :id => 3253,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Loop Event (Cowgirl)",
          :common => 5816,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    428 => {
      :name => "Butterfly Girl",
      :condition => {
        :type => 3,
        :id => 238
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_ageha_ha1"],
          2 => ["Graphics/Pictures/", "ev_ageha_ha2"],
          3 => ["Graphics/Pictures/", "ev_ageha_ha3"],
          4 => ["Graphics/Pictures/", "ev_ageha_ha4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 2
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3238,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Urethral Sucking)",
          :common => 5081,
          :condition => {
            :type => 1,
            :id => 3254,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    429 => {
      :name => "Brom Girl",
      :condition => {
        :type => 3,
        :id => 239
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_blom_h1"],
          2 => ["Graphics/Pictures/", "ev_blom_h2"],
          3 => ["Graphics/Pictures/", "ev_blom_h3"],
          4 => ["Graphics/Pictures/", "ev_blom_h4"],
          5 => ["Graphics/Pictures/", "ev_blom_h5"],
          6 => ["Graphics/Pictures/", "ev_blom_h6"],
          7 => ["Graphics/Pictures/", "ev_blom_h7"],
          8 => ["Graphics/Pictures/", "ev_blom_h8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 13
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_blom_st02"],
          2 => ["Graphics/Pictures/", "ev_blom_ct01"],
          3 => ["Graphics/Pictures/", "ev_blom_ct02"],
          4 => ["Graphics/Pictures/", "ev_blom_ct03"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
        ],
          :condition => {
            :type => 1,
            :id => 3255,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3239,
          :background => {
            :id => 13
          }
        },
        2 => {
          :name => "Request 1 (Poison Slime Teasing)",
          :common => 5086,
          :condition => {
            :type => 1,
            :id => 3255,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Poison Slime Wrap)",
          :common => 5087,
          :condition => {
            :type => 1,
            :id => 3255,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    430 => {
      :name => "Warmer",
      :condition => {
        :type => 3,
        :id => 240
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_warmer_ha1"],
          2 => ["Graphics/Pictures/", "ev_warmer_ha2"],
          3 => ["Graphics/Pictures/", "ev_warmer_ha3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :background => {
            :id => 13
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_warmer_hb1"],
          2 => ["Graphics/Pictures/", "ev_warmer_hb2"],
          3 => ["Graphics/Pictures/", "ev_warmer_hb3"],
          4 => ["Graphics/Pictures/", "ev_warmer_hb4"],
          5 => ["Graphics/Pictures/", "ev_warmer_hb5"],
          6 => ["Graphics/Pictures/", "ev_warmer_hb6"],
          7 => ["Graphics/Pictures/", "ev_warmer_hb7"],
          8 => ["Graphics/Pictures/", "ev_warmer_hb8"],
          9 => ["Graphics/Pictures/", "ev_warmer_hb9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :condition => {
            :type => 1,
            :id => 3256,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3240,
          :background => {
            :id => 13
          }
        },
        2 => {
          :name => "Request 1 (Vaginal Asphyxiation)",
          :common => 5091,
          :condition => {
            :type => 1,
            :id => 3256,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Vaginal Asphyxiation...?)",
          :common => 5092,
          :condition => {
            :type => 1,
            :id => 3256,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Reverse Rape)",
          :common => 5093,
          :condition => {
            :type => 1,
            :id => 3256,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    431 => {
      :name => "Ghouls",
      :condition => {
        :type => 3,
        :id => 241
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_gool_h1"],
          2 => ["Graphics/Pictures/", "ev_gool_h2"],
          3 => ["Graphics/Pictures/", "ev_gool_h3"],
          4 => ["Graphics/Pictures/", "ev_gool_h4"],
          5 => ["Graphics/Pictures/", "ev_gool_h5"],
          6 => ["Graphics/Pictures/", "ev_gool_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 13
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3241,
          :background => {
            :id => 13
          }
        },
        2 => {
          :name => "Request 1 (Gangrape)",
          :common => 5096,
          :condition => {
            :type => 1,
            :id => 3257,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Gangrape...?)",
          :common => 5097,
          :condition => {
            :type => 1,
            :id => 3257,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    432 => {
      :name => "Fake Jelly",
      :condition => {
        :type => 3,
        :id => 244
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_fakejelly_h1"],
          2 => ["Graphics/Pictures/", "ev_fakejelly_h2"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
        ],
          :background => {
            :id => 14
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_fakejelly_ct01"],
          2 => ["Graphics/Pictures/", "ev_fakejelly_ct02"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3244,
          :background => {
            :id => 14
          }
        },
        2 => {
          :name => "Request 1 (Soft Body Rape)",
          :common => 5101,
          :condition => {
            :type => 1,
            :id => 3258,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Loop Event (Blowjob)",
          :common => 5840,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    433 => {
      :name => "Wing Harpy",
      :condition => {
        :type => 3,
        :id => 245
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_w_hapy_h1"],
          2 => ["Graphics/Pictures/", "ev_w_hapy_h2"],
          3 => ["Graphics/Pictures/", "ev_w_hapy_h3"],
          4 => ["Graphics/Pictures/", "ev_w_hapy_h4"],
          5 => ["Graphics/Pictures/", "ev_w_hapy_h5"],
          6 => ["Graphics/Pictures/", "ev_w_hapy_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 10
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_w_hapy_ha1"],
          2 => ["Graphics/Pictures/", "ev_w_hapy_ha2"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
        ],
          :condition => {
            :type => 1,
            :id => 3259,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3245,
          :background => {
            :id => 10
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5106,
          :condition => {
            :type => 1,
            :id => 3259,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Paizuri)",
          :common => 5107,
          :condition => {
            :type => 1,
            :id => 3259,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    434 => {
      :name => "Harpy Knight",
      :condition => {
        :type => 3,
        :id => 246
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_k_hapy_h1"],
          2 => ["Graphics/Pictures/", "ev_k_hapy_h2"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
        ],
          :background => {
            :id => 10
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_k_hapy_hb1"],
          2 => ["Graphics/Pictures/", "ev_k_hapy_hb2"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
        ],
          :condition => {
            :type => 1,
            :id => 3260,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3246,
          :background => {
            :id => 10
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5111,
          :condition => {
            :type => 1,
            :id => 3260,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Blowjob)",
          :common => 5112,
          :condition => {
            :type => 1,
            :id => 3260,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    435 => {
      :name => "Mud Golem Girl",
      :condition => {
        :type => 3,
        :id => 247
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_madgolem_st01"],
          2 => ["Graphics/Pictures/", "ev_madgolem_ct01"],
          3 => ["Graphics/Pictures/", "ev_madgolem_ct02"],
          4 => ["Graphics/Pictures/", "ev_madgolem_ct03"],
          5 => ["Graphics/Pictures/", "ev_madgolem_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
        ],
          :background => {
            :id => 10
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3247,
          :background => {
            :id => 10
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Mud)",
          :common => 5116,
          :condition => {
            :type => 1,
            :id => 3261,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    436 => {
      :name => "Golem Girl",
      :condition => {
        :type => 3,
        :id => 248
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_golem_h1"],
          2 => ["Graphics/Pictures/", "ev_golem_h2"],
          3 => ["Graphics/Pictures/", "ev_golem_h3"],
          4 => ["Graphics/Pictures/", "ev_golem_h4"],
          5 => ["Graphics/Pictures/", "ev_golem_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 10
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3248,
          :background => {
            :id => 10
          }
        },
        2 => {
          :name => "Request 1 (Power Supply)",
          :common => 5121,
          :condition => {
            :type => 1,
            :id => 3262,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    437 => {
      :name => "Flower Mantis Girl",
      :condition => {
        :type => 3,
        :id => 249
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_h_kamakiri_hb1"],
          2 => ["Graphics/Pictures/", "ev_h_kamakiri_hb2"],
          3 => ["Graphics/Pictures/", "ev_h_kamakiri_hb3"],
          4 => ["Graphics/Pictures/", "ev_h_kamakiri_hb4"],
          5 => ["Graphics/Pictures/", "ev_h_kamakiri_hb5"],
          6 => ["Graphics/Pictures/", "ev_h_kamakiri_hb6"],
          7 => ["Graphics/Pictures/", "ev_h_kamakiri_hb7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 2
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_h_kamakiri_ha1"],
          2 => ["Graphics/Pictures/", "ev_h_kamakiri_ha2"],
          3 => ["Graphics/Pictures/", "ev_h_kamakiri_ha3"],
          4 => ["Graphics/Pictures/", "ev_h_kamakiri_ha4"],
          5 => ["Graphics/Pictures/", "ev_h_kamakiri_ha5"],
          6 => ["Graphics/Pictures/", "ev_h_kamakiri_ha6"],
          7 => ["Graphics/Pictures/", "ev_h_kamakiri_ha7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :condition => {
            :type => 1,
            :id => 3263,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3249,
          :background => {
            :id => 2
          }
        },
        2 => {
          :name => "Request 1 (Footjob)",
          :common => 5126,
          :condition => {
            :type => 1,
            :id => 3263,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5127,
          :condition => {
            :type => 1,
            :id => 3263,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    438 => {
      :name => "Black Golem",
      :condition => {
        :type => 3,
        :id => 250
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_bgolem_h1"],
          2 => ["Graphics/Pictures/", "ev_bgolem_h2"],
          3 => ["Graphics/Pictures/", "ev_bgolem_h3"],
          4 => ["Graphics/Pictures/", "ev_bgolem_h4"],
          5 => ["Graphics/Pictures/", "ev_bgolem_h5"],
          6 => ["Graphics/Pictures/", "ev_bgolem_h6"],
          7 => ["Graphics/Pictures/", "ev_bgolem_h7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 31
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_bgolem_st01"],
          2 => ["Graphics/Pictures/", "ev_bgolem_ct01"],
          3 => ["Graphics/Pictures/", "ev_bgolem_ct02"],
          4 => ["Graphics/Pictures/", "ev_bgolem_ct03"],
          5 => ["Graphics/Pictures/", "ev_bgolem_ct04"],
          6 => ["Graphics/Pictures/", "ev_bgolem_ct05"],
          7 => ["Graphics/Pictures/", "ev_bgolem_ct06"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
          [1,6],
          [1,7],
        ],
          :condition => {
            :type => 1,
            :id => 3264,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3250,
          :background => {
            :id => 31
          }
        },
        2 => {
          :name => "Request 1 (Swallow)",
          :common => 5131,
          :condition => {
            :type => 1,
            :id => 3264,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Absorption)",
          :common => 5132,
          :condition => {
            :type => 1,
            :id => 3264,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Absorption...?)",
          :common => 5133,
          :condition => {
            :type => 1,
            :id => 3264,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    439 => {
      :name => "Feral Kitsune",
      :condition => {
        :type => 3,
        :id => 251
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kitunezyu_h1"],
          2 => ["Graphics/Pictures/", "ev_kitunezyu_h2"],
          3 => ["Graphics/Pictures/", "ev_kitunezyu_h3"],
          4 => ["Graphics/Pictures/", "ev_kitunezyu_h4"],
          5 => ["Graphics/Pictures/", "ev_kitunezyu_ct01"],
          6 => ["Graphics/Pictures/", "ev_kitunezyu_ct02"],
          7 => ["Graphics/Pictures/", "ev_kitunezyu_ct03"],
          8 => ["Graphics/Pictures/", "ev_kitunezyu_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,5],
          [2,6],
          [3,7],
          [4,8],
        ],
          :background => {
            :id => 31
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3251,
          :background => {
            :id => 31
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5136,
          :condition => {
            :type => 1,
            :id => 3265,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    440 => {
      :name => "Three-Tailed Kunoichi",
      :condition => {
        :type => 3,
        :id => 252
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kunoitisanbi_hb1"],
          2 => ["Graphics/Pictures/", "ev_kunoitisanbi_hb2"],
          3 => ["Graphics/Pictures/", "ev_kunoitisanbi_hb3"],
          4 => ["Graphics/Pictures/", "ev_kunoitisanbi_hb4"],
          5 => ["Graphics/Pictures/", "ev_kunoitisanbi_hb5"],
          6 => ["Graphics/Pictures/", "ev_kunoitisanbi_hb6"],
          7 => ["Graphics/Pictures/", "ev_kunoitisanbi_hb7"],
          8 => ["Graphics/Pictures/", "ev_kunoitisanbi_hb8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 31
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kunoitisanbi_ha1"],
          2 => ["Graphics/Pictures/", "ev_kunoitisanbi_ha2"],
          3 => ["Graphics/Pictures/", "ev_kunoitisanbi_ha3"],
          4 => ["Graphics/Pictures/", "ev_kunoitisanbi_ha4"],
          5 => ["Graphics/Pictures/", "ev_kunoitisanbi_ha5"],
          6 => ["Graphics/Pictures/", "ev_kunoitisanbi_ha6"],
          7 => ["Graphics/Pictures/", "ev_kunoitisanbi_ha7"],
          8 => ["Graphics/Pictures/", "ev_kunoitisanbi_ha8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :condition => {
            :type => 1,
            :id => 3266,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3252,
          :background => {
            :id => 31
          }
        },
        2 => {
          :name => "Request 1 (Intercrural)",
          :common => 5141,
          :condition => {
            :type => 1,
            :id => 3266,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5142,
          :condition => {
            :type => 1,
            :id => 3266,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    441 => {
      :name => "Four-Tailed Samurai",
      :condition => {
        :type => 3,
        :id => 253
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_mononohuyonbi_hb1"],
          2 => ["Graphics/Pictures/", "ev_mononohuyonbi_hb2"],
          3 => ["Graphics/Pictures/", "ev_mononohuyonbi_hb3"],
          4 => ["Graphics/Pictures/", "ev_mononohuyonbi_hb4"],
          5 => ["Graphics/Pictures/", "ev_mononohuyonbi_hb5"],
          6 => ["Graphics/Pictures/", "ev_mononohuyonbi_hb6"],
          7 => ["Graphics/Pictures/", "ev_mononohuyonbi_hb7"],
          8 => ["Graphics/Pictures/", "ev_mononohuyonbi_hb8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 31
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_mononohuyonbi_ha1"],
          2 => ["Graphics/Pictures/", "ev_mononohuyonbi_ha2"],
          3 => ["Graphics/Pictures/", "ev_mononohuyonbi_ha3"],
          4 => ["Graphics/Pictures/", "ev_mononohuyonbi_ha4"],
          5 => ["Graphics/Pictures/", "ev_mononohuyonbi_ha5"],
          6 => ["Graphics/Pictures/", "ev_mononohuyonbi_ha6"],
          7 => ["Graphics/Pictures/", "ev_mononohuyonbi_ha7"],
          8 => ["Graphics/Pictures/", "ev_mononohuyonbi_ha8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :condition => {
            :type => 1,
            :id => 3267,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3253,
          :background => {
            :id => 31
          }
        },
        2 => {
          :name => "Request 1 (Tickling Tail)",
          :common => 5146,
          :condition => {
            :type => 1,
            :id => 3267,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5147,
          :condition => {
            :type => 1,
            :id => 3267,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    442 => {
      :name => "Queen Ant",
      :condition => {
        :type => 3,
        :id => 254
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_queenant_st01"],
          2 => ["Graphics/Pictures/", "ev_queenant_ct01"],
          3 => ["Graphics/Pictures/", "ev_queenant_ct02"],
          4 => ["Graphics/Pictures/", "ev_queenant_ct03"],
          5 => ["Graphics/Pictures/", "ev_queenant_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
        ],
          :background => {
            :id => 31
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3254,
          :background => {
            :id => 31
          }
        },
        2 => {
          :name => "Request 1 (Queen's Stud)",
          :common => 5151,
          :condition => {
            :type => 1,
            :id => 3268,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    443 => {
      :name => "Lava Girl",
      :condition => {
        :type => 3,
        :id => 256
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_yougan_h1"],
          2 => ["Graphics/Pictures/", "ev_yougan_h2"],
          3 => ["Graphics/Pictures/", "ev_yougan_h3"],
          4 => ["Graphics/Pictures/", "ev_yougan_h4"],
          5 => ["Graphics/Pictures/", "ev_yougan_h5"],
          6 => ["Graphics/Pictures/", "ev_yougan_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 16
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3256,
          :background => {
            :id => 16
          }
        },
        2 => {
          :name => "Request 1 (Magma Bath)",
          :common => 5156,
          :condition => {
            :type => 1,
            :id => 3269,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    444 => {
      :name => "Demon Lamia",
      :condition => {
        :type => 3,
        :id => 257
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lamiad_h1"],
          2 => ["Graphics/Pictures/", "ev_lamiad_h2"],
          3 => ["Graphics/Pictures/", "ev_lamiad_h3"],
          4 => ["Graphics/Pictures/", "ev_lamiad_h4"],
          5 => ["Graphics/Pictures/", "ev_lamiad_h5"],
          6 => ["Graphics/Pictures/", "ev_lamiad_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 16
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_lamiad_st02"],
          2 => ["Graphics/Pictures/", "ev_lamiad_ct01"],
          3 => ["Graphics/Pictures/", "ev_lamiad_ct02"],
          4 => ["Graphics/Pictures/", "ev_lamiad_ct03"],
          5 => ["Graphics/Pictures/", "ev_lamiad_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
        ],
          :condition => {
            :type => 1,
            :id => 3270,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3257,
          :background => {
            :id => 16
          }
        },
        2 => {
          :name => "Request 1 (Tailjob)",
          :common => 5161,
          :condition => {
            :type => 1,
            :id => 3270,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5162,
          :condition => {
            :type => 1,
            :id => 3270,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    445 => {
      :name => "Demon Scylla",
      :condition => {
        :type => 3,
        :id => 258
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_scyllad_hb1"],
          2 => ["Graphics/Pictures/", "ev_scyllad_hb2"],
          3 => ["Graphics/Pictures/", "ev_scyllad_hb3"],
          4 => ["Graphics/Pictures/", "ev_scyllad_hb4"],
          5 => ["Graphics/Pictures/", "ev_scyllad_hb5"],
          6 => ["Graphics/Pictures/", "ev_scyllad_hb6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 16
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_scyllad_st02"],
          2 => ["Graphics/Pictures/", "ev_scyllad_ct01"],
          3 => ["Graphics/Pictures/", "ev_scyllad_ct02"],
          4 => ["Graphics/Pictures/", "ev_scyllad_ha1"],
          5 => ["Graphics/Pictures/", "ev_scyllad_ha2"],
          6 => ["Graphics/Pictures/", "ev_scyllad_ha3"],
          7 => ["Graphics/Pictures/", "ev_scyllad_ha4"],
          8 => ["Graphics/Pictures/", "ev_scyllad_ha5"],
          9 => ["Graphics/Pictures/", "ev_scyllad_ha6"],
          10 => ["Graphics/Pictures/", "ev_scyllad_ha7"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :condition => {
            :type => 1,
            :id => 3271,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3258,
          :background => {
            :id => 16
          }
        },
        2 => {
          :name => "Request 1 (Urethral Teasing)",
          :common => 5166,
          :condition => {
            :type => 1,
            :id => 3271,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Tentacle Caress)",
          :common => 5167,
          :condition => {
            :type => 1,
            :id => 3271,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Reverse Rape)",
          :common => 5168,
          :condition => {
            :type => 1,
            :id => 3271,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    446 => {
      :name => "Siren",
      :condition => {
        :type => 3,
        :id => 259
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_seiren_st02"],
          2 => ["Graphics/Pictures/", "ev_seiren_ct01"],
          3 => ["Graphics/Pictures/", "ev_seiren_ct02"],
          4 => ["Graphics/Pictures/", "ev_seiren_ct03"],
          5 => ["Graphics/Pictures/", "ev_seiren_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 43
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3259,
          :background => {
            :id => 43
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5171,
          :condition => {
            :type => 1,
            :id => 3272,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    447 => {
      :name => "Coral Girl",
      :condition => {
        :type => 3,
        :id => 260
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_sango_h1"],
          2 => ["Graphics/Pictures/", "ev_sango_h2"],
          3 => ["Graphics/Pictures/", "ev_sango_h3"],
          4 => ["Graphics/Pictures/", "ev_sango_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 67
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3260,
          :background => {
            :id => 67
          }
        },
        2 => {
          :name => "Request 1 (Absorption)",
          :common => 5176,
          :condition => {
            :type => 1,
            :id => 3273,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Absorption...?)",
          :common => 5177,
          :condition => {
            :type => 1,
            :id => 3273,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    448 => {
      :name => "Starfish Girl",
      :condition => {
        :type => 3,
        :id => 261
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_hitode_ha1"],
          2 => ["Graphics/Pictures/", "ev_hitode_ha2"],
          3 => ["Graphics/Pictures/", "ev_hitode_ha3"],
          4 => ["Graphics/Pictures/", "ev_hitode_ha4"],
          5 => ["Graphics/Pictures/", "ev_hitode_ha5"],
          6 => ["Graphics/Pictures/", "ev_hitode_ha6"],
          7 => ["Graphics/Pictures/", "ev_hitode_ct01"],
          8 => ["Graphics/Pictures/", "ev_hitode_ct02"],
          9 => ["Graphics/Pictures/", "ev_hitode_ct03"],
          10 => ["Graphics/Pictures/", "ev_hitode_ct04"],
          11 => ["Graphics/Pictures/", "ev_hitode_hb1"],
          12 => ["Graphics/Pictures/", "ev_hitode_hb2"],
          13 => ["Graphics/Pictures/", "ev_hitode_hb3"],
          14 => ["Graphics/Pictures/", "ev_hitode_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [3,7],
          [4,8],
          [5,9],
          [6,10],
          [11],
          [12],
          [13],
          [14],
        ],
          :background => {
            :id => 67
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3261,
          :background => {
            :id => 67
          }
        },
        2 => {
          :name => "Request 1 (Swallow)",
          :common => 5181,
          :condition => {
            :type => 1,
            :id => 3274,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Swallow...?)",
          :common => 5182,
          :condition => {
            :type => 1,
            :id => 3274,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    449 => {
      :name => "Beelzebub A",
      :condition => {
        :type => 3,
        :id => 262
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_beelzebub_h31"],
          2 => ["Graphics/Pictures/", "ev_beelzebub_h32"],
          3 => ["Graphics/Pictures/", "ev_beelzebub_h33"],
          4 => ["Graphics/Pictures/", "ev_beelzebub_h34"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 67
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_beelzebub_h01"],
          2 => ["Graphics/Pictures/", "ev_beelzebub_h02"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
        ],
          :condition => {
            :type => 1,
            :id => 3275,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_beelzebub_hb1"],
          2 => ["Graphics/Pictures/", "ev_beelzebub_hb2"],
          3 => ["Graphics/Pictures/", "ev_beelzebub_hc1"],
          4 => ["Graphics/Pictures/", "ev_beelzebub_hc2"],
          5 => ["Graphics/Pictures/", "ev_beelzebub_hc3"],
          6 => ["Graphics/Pictures/", "ev_beelzebub_hd1"],
          7 => ["Graphics/Pictures/", "ev_beelzebub_hd2"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3262,
          :background => {
            :id => 67
          }
        },
        2 => {
          :name => "Request 1 (Monster Fly Embrace)",
          :common => 5186,
          :condition => {
            :type => 1,
            :id => 3275,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5187,
          :condition => {
            :type => 1,
            :id => 3275,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Loop Event (Gang Rape)",
          :common => 5797,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    450 => {
      :name => "Beelzebub B",
      :condition => {
        :type => 3,
        :id => 263
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_beelzebub_h31"],
          2 => ["Graphics/Pictures/", "ev_beelzebub_h32"],
          3 => ["Graphics/Pictures/", "ev_beelzebub_h33"],
          4 => ["Graphics/Pictures/", "ev_beelzebub_h34"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 67
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_beelzebub_h11"],
          2 => ["Graphics/Pictures/", "ev_beelzebub_h12"],
          3 => ["Graphics/Pictures/", "ev_beelzebub_h41"],
          4 => ["Graphics/Pictures/", "ev_beelzebub_h42"],
          5 => ["Graphics/Pictures/", "ev_beelzebub_h43"],
          6 => ["Graphics/Pictures/", "ev_beelzebub_h44"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3276,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3263,
          :background => {
            :id => 67
          }
        },
        2 => {
          :name => "Request 1 (Monster Fly Embrace)",
          :common => 5191,
          :condition => {
            :type => 1,
            :id => 3276,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Serial Milking)",
          :common => 5192,
          :condition => {
            :type => 1,
            :id => 3276,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    451 => {
      :name => "Beelzebub C",
      :condition => {
        :type => 3,
        :id => 264
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_beelzebub_h31"],
          2 => ["Graphics/Pictures/", "ev_beelzebub_h32"],
          3 => ["Graphics/Pictures/", "ev_beelzebub_h33"],
          4 => ["Graphics/Pictures/", "ev_beelzebub_h34"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 67
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_beelzebub_h21"],
          2 => ["Graphics/Pictures/", "ev_beelzebub_h22"],
          3 => ["Graphics/Pictures/", "ev_beelzebub_h51"],
          4 => ["Graphics/Pictures/", "ev_beelzebub_h52"],
          5 => ["Graphics/Pictures/", "ev_beelzebub_h53"],
          6 => ["Graphics/Pictures/", "ev_beelzebub_h54"],
          7 => ["Graphics/Pictures/", "ev_beelzebub_h55"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :condition => {
            :type => 1,
            :id => 3277,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3264,
          :background => {
            :id => 67
          }
        },
        2 => {
          :name => "Request 1 (Monster Fly Embrace 1)",
          :common => 5196,
          :condition => {
            :type => 1,
            :id => 3277,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Monster Fly Embrace 2)",
          :common => 5197,
          :condition => {
            :type => 1,
            :id => 3277,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    452 => {
      :name => "Arch Jelly",
      :condition => {
        :type => 3,
        :id => 265
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_arkjelly_h1"],
          2 => ["Graphics/Pictures/", "ev_arkjelly_h2"],
          3 => ["Graphics/Pictures/", "ev_arkjelly_h3"],
          4 => ["Graphics/Pictures/", "ev_arkjelly_h4"],
          5 => ["Graphics/Pictures/", "ev_arkjelly_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 53
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3265,
          :background => {
            :id => 53
          }
        },
        2 => {
          :name => "Request 1 (Semen Sucking Restraint)",
          :common => 5201,
          :condition => {
            :type => 1,
            :id => 3278,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    453 => {
      :name => "Elder Scylla",
      :condition => {
        :type => 3,
        :id => 266
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_e_scyulla_hb1"],
          2 => ["Graphics/Pictures/", "ev_e_scyulla_hb2"],
          3 => ["Graphics/Pictures/", "ev_e_scyulla_hb3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :background => {
            :id => 53
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_e_scylla_st02"],
          2 => ["Graphics/Pictures/", "ev_e_scyulla_ct01"],
          3 => ["Graphics/Pictures/", "ev_e_scyulla_ct02"],
          4 => ["Graphics/Pictures/", "ev_e_scyulla_ct03"],
          5 => ["Graphics/Pictures/", "ev_e_scyulla_ct11"],
          6 => ["Graphics/Pictures/", "ev_e_scyulla_ct12"],
          7 => ["Graphics/Pictures/", "ev_e_scyulla_ha1"],
          8 => ["Graphics/Pictures/", "ev_e_scyulla_ha2"],
          9 => ["Graphics/Pictures/", "ev_e_scyulla_ha3"],
          10 => ["Graphics/Pictures/", "ev_e_scyulla_ha4"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
          [1,6],
          [7],
          [8],
          [9],
          [10],
        ],
          :condition => {
            :type => 1,
            :id => 3279,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3266,
          :background => {
            :id => 53
          }
        },
        2 => {
          :name => "Request 1 (Tentacle Blowjob)",
          :common => 5206,
          :condition => {
            :type => 1,
            :id => 3279,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Tentacle Caress)",
          :common => 5207,
          :condition => {
            :type => 1,
            :id => 3279,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Reverse Rape)",
          :common => 5208,
          :condition => {
            :type => 1,
            :id => 3279,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    454 => {
      :name => "Kraken",
      :condition => {
        :type => 2,
        :id => 329
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kraken_h1"],
          2 => ["Graphics/Pictures/", "ev_kraken_h2"],
          3 => ["Graphics/Pictures/", "ev_kraken_h2a"],
          4 => ["Graphics/Pictures/", "ev_kraken_h3"],
          5 => ["Graphics/Pictures/", "ev_kraken_h3a"],
          6 => ["Graphics/Pictures/", "ev_kraken_h4"],
          7 => ["Graphics/Pictures/", "ev_kraken_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Bound Anal Raid)",
          :common => 5461,
          :condition => {
            :type => 1,
            :id => 3329,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    455 => {
      :name => "Poseidoness",
      :condition => {
        :type => 3,
        :id => 267
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_poseidones_hb1"],
          2 => ["Graphics/Pictures/", "ev_poseidones_hb2"],
          3 => ["Graphics/Pictures/", "ev_poseidones_hb3"],
          4 => ["Graphics/Pictures/", "ev_poseidones_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 53
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_poseidones_ha1"],
          2 => ["Graphics/Pictures/", "ev_poseidones_ha2"],
          3 => ["Graphics/Pictures/", "ev_poseidones_ct01"],
          4 => ["Graphics/Pictures/", "ev_poseidones_ct02"],
          5 => ["Graphics/Pictures/", "ev_poseidones_ct03"],
          6 => ["Graphics/Pictures/", "ev_poseidones_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [2,3],
          [2,4],
          [2,5],
          [2,6],
        ],
          :condition => {
            :type => 1,
            :id => 3280,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3267,
          :background => {
            :id => 53
          }
        },
        2 => {
          :name => "Request 1 (Bound Anal Raid)",
          :common => 5211,
          :condition => {
            :type => 1,
            :id => 3280,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    456 => {
      :name => "Succubus Harem",
      :condition => {
        :type => 3,
        :id => 268
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_succubuses_hb01"],
          2 => ["Graphics/Pictures/", "ev_succubuses_hb02"],
          3 => ["Graphics/Pictures/", "ev_succubuses_hb03"],
          4 => ["Graphics/Pictures/", "ev_succubuses_hb04"],
          5 => ["Graphics/Pictures/", "ev_succubuses_hb05"],
          6 => ["Graphics/Pictures/", "ev_succubuses_hb06"],
          7 => ["Graphics/Pictures/", "ev_succubuses_hb07"],
          8 => ["Graphics/Pictures/", "ev_succubuses_hb08"],
          9 => ["Graphics/Pictures/", "ev_succubuses_hb09"],
          10 => ["Graphics/Pictures/", "ev_succubuses_hb10"],
          11 => ["Graphics/Pictures/", "ev_succubuses_hb11"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
        ],
          :background => {
            :id => 32
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_succubuses_ha01"],
          2 => ["Graphics/Pictures/", "ev_succubuses_ha02"],
          3 => ["Graphics/Pictures/", "ev_succubuses_ha03"],
          4 => ["Graphics/Pictures/", "ev_succubuses_ha04"],
          5 => ["Graphics/Pictures/", "ev_succubuses_ha05"],
          6 => ["Graphics/Pictures/", "ev_succubuses_ha06"],
          7 => ["Graphics/Pictures/", "ev_succubuses_ha07"],
          8 => ["Graphics/Pictures/", "ev_succubuses_ha08"],
          9 => ["Graphics/Pictures/", "ev_succubuses_ha09"],
          10 => ["Graphics/Pictures/", "ev_succubuses_ha10"],
          11 => ["Graphics/Pictures/", "ev_succubuses_ha11"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
        ],
          :condition => {
            :type => 1,
            :id => 3281,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3268,
          :background => {
            :id => 32
          }
        },
        2 => {
          :name => "Request 1 (Group Blowjob)",
          :common => 5216,
          :condition => {
            :type => 1,
            :id => 3281,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Group Reverse Rape)",
          :common => 5217,
          :condition => {
            :type => 1,
            :id => 3281,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    457 => {
      :name => "Maidcubus",
      :condition => {
        :type => 3,
        :id => 272
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_maycubbus_hb1"],
          2 => ["Graphics/Pictures/", "ev_maycubbus_hb2"],
          3 => ["Graphics/Pictures/", "ev_maycubbus_hb3"],
          4 => ["Graphics/Pictures/", "ev_maycubbus_hb4"],
          5 => ["Graphics/Pictures/", "ev_maycubbus_hb5"],
          6 => ["Graphics/Pictures/", "ev_maycubbus_hb6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 32
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_maycubbus_ha1"],
          2 => ["Graphics/Pictures/", "ev_maycubbus_ha2"],
          3 => ["Graphics/Pictures/", "ev_maycubbus_ha3"],
          4 => ["Graphics/Pictures/", "ev_maycubbus_ha4"],
          5 => ["Graphics/Pictures/", "ev_maycubbus_ha5"],
          6 => ["Graphics/Pictures/", "ev_maycubbus_ha6"],
          7 => ["Graphics/Pictures/", "ev_maycubbus_hc1"],
          8 => ["Graphics/Pictures/", "ev_maycubbus_hc2"],
          9 => ["Graphics/Pictures/", "ev_maycubbus_hc3"],
          10 => ["Graphics/Pictures/", "ev_maycubbus_hc4"],
          11 => ["Graphics/Pictures/", "ev_maycubbus_hd1"],
          12 => ["Graphics/Pictures/", "ev_maycubbus_hd2"],
          13 => ["Graphics/Pictures/", "ev_maycubbus_hd3"],
          14 => ["Graphics/Pictures/", "ev_maycubbus_hd4"],
          15 => ["Graphics/Pictures/", "ev_maycubbus_hd5"],
          16 => ["Graphics/Pictures/", "ev_maycubbus_he1"],
          17 => ["Graphics/Pictures/", "ev_maycubbus_he2"],
          18 => ["Graphics/Pictures/", "ev_maycubbus_he3"],
          19 => ["Graphics/Pictures/", "ev_maycubbus_he4"],
          20 => ["Graphics/Pictures/", "ev_maycubbus_hf1"],
          21 => ["Graphics/Pictures/", "ev_maycubbus_hf2"],
          22 => ["Graphics/Pictures/", "ev_maycubbus_hf3"],
          23 => ["Graphics/Pictures/", "ev_maycubbus_hf4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
        ],
          :condition => {
            :type => 1,
            :id => 3282,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3272,
          :background => {
            :id => 32
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeezing Vacuum)",
          :common => 5221,
          :condition => {
            :type => 1,
            :id => 3282,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Semen Wringing Napkin)",
          :common => 5222,
          :condition => {
            :type => 1,
            :id => 3282,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Semen Sucking Tail)",
          :common => 5223,
          :condition => {
            :type => 1,
            :id => 3282,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 4 (Paizuri)",
          :common => 5224,
          :condition => {
            :type => 1,
            :id => 3282,
            :op => 1,
            :value => 70
          },
          :background => {
            :id => 1
          }
        },
        6 => {
          :name => "Request 5 (Reverse Rape)",
          :common => 5225,
          :condition => {
            :type => 1,
            :id => 3282,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    458 => {
      :name => "Maccubus",
      :condition => {
        :type => 3,
        :id => 273
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_maccubus_h00"],
          2 => ["Graphics/Pictures/", "ev_maccubus_h01"],
          3 => ["Graphics/Pictures/", "ev_maccubus_h02"],
          4 => ["Graphics/Pictures/", "ev_maccubus_h03"],
          5 => ["Graphics/Pictures/", "ev_maccubus_h04"],
          6 => ["Graphics/Pictures/", "ev_maccubus_h05"],
          7 => ["Graphics/Pictures/", "ev_maccubus_h06"],
          8 => ["Graphics/Pictures/", "ev_maccubus_h07"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 38
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_maccubus_st02"],
          2 => ["Graphics/Pictures/", "ev_maccubus_ct01"],
          3 => ["Graphics/Pictures/", "ev_maccubus_ct02"],
          4 => ["Graphics/Pictures/", "ev_maccubus_ct11"],
          5 => ["Graphics/Pictures/", "ev_maccubus_ct12"],
          6 => ["Graphics/Pictures/", "ev_maccubus_ct21"],
          7 => ["Graphics/Pictures/", "ev_maccubus_ct22"],
          8 => ["Graphics/Pictures/", "ev_maccubus_ct31"],
          9 => ["Graphics/Pictures/", "ev_maccubus_ct32"],
          10 => ["Graphics/Pictures/", "ev_maccubus_h10"],
          11 => ["Graphics/Pictures/", "ev_maccubus_h11"],
          12 => ["Graphics/Pictures/", "ev_maccubus_h12"],
          13 => ["Graphics/Pictures/", "ev_maccubus_h13"],
          14 => ["Graphics/Pictures/", "ev_maccubus_h14"],
          15 => ["Graphics/Pictures/", "ev_maccubus_h15"],
          16 => ["Graphics/Pictures/", "ev_maccubus_h16"],
          17 => ["Graphics/Pictures/", "ev_maccubus_h17"],
          18 => ["Graphics/Pictures/", "ev_maccubus_h21"],
          19 => ["Graphics/Pictures/", "ev_maccubus_h22"],
          20 => ["Graphics/Pictures/", "ev_maccubus_h31"],
          21 => ["Graphics/Pictures/", "ev_maccubus_h32"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
          [1,6],
          [1,7],
          [1,8],
          [1,9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
        ],
          :condition => {
            :type => 1,
            :id => 3283,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3273,
          :background => {
            :id => 38
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 5226,
          :condition => {
            :type => 1,
            :id => 3283,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Blowjob)",
          :common => 5227,
          :condition => {
            :type => 1,
            :id => 3283,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Reverse Rape)",
          :common => 5228,
          :condition => {
            :type => 1,
            :id => 3283,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    459 => {
      :name => "Mincubus",
      :condition => {
        :type => 3,
        :id => 274
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_minccubus_hb01"],
          2 => ["Graphics/Pictures/", "ev_minccubus_hb02"],
          3 => ["Graphics/Pictures/", "ev_minccubus_hb03"],
          4 => ["Graphics/Pictures/", "ev_minccubus_hb04"],
          5 => ["Graphics/Pictures/", "ev_minccubus_hb05"],
          6 => ["Graphics/Pictures/", "ev_minccubus_hb06"],
          7 => ["Graphics/Pictures/", "ev_minccubus_hb07"],
          8 => ["Graphics/Pictures/", "ev_minccubus_hb08"],
          9 => ["Graphics/Pictures/", "ev_minccubus_hb09"],
          10 => ["Graphics/Pictures/", "ev_minccubus_hb10"],
          11 => ["Graphics/Pictures/", "ev_minccubus_hb11"],
          12 => ["Graphics/Pictures/", "ev_minccubus_hb12"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
        ],
          :background => {
            :id => 32
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_minccubus_st02"],
          2 => ["Graphics/Pictures/", "ev_minccubus_ct01"],
          3 => ["Graphics/Pictures/", "ev_minccubus_ct02"],
          4 => ["Graphics/Pictures/", "ev_minccubus_ct11"],
          5 => ["Graphics/Pictures/", "ev_minccubus_ct12"],
          6 => ["Graphics/Pictures/", "ev_minccubus_ct21"],
          7 => ["Graphics/Pictures/", "ev_minccubus_ct22"],
          8 => ["Graphics/Pictures/", "ev_minccubus_ha1"],
          9 => ["Graphics/Pictures/", "ev_minccubus_ha2"],
          10 => ["Graphics/Pictures/", "ev_minccubus_ha3"],
          11 => ["Graphics/Pictures/", "ev_minccubus_ha4"],
          12 => ["Graphics/Pictures/", "ev_minccubus_hc1"],
          13 => ["Graphics/Pictures/", "ev_minccubus_hc2"],
          14 => ["Graphics/Pictures/", "ev_minccubus_hc3"],
          15 => ["Graphics/Pictures/", "ev_minccubus_hc4"],
          16 => ["Graphics/Pictures/", "ev_minccubus_hc5"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
          [1,6],
          [1,7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
        ],
          :condition => {
            :type => 1,
            :id => 3284,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3274,
          :background => {
            :id => 32
          }
        },
        2 => {
          :name => "Request 1 (Sock Stroke)",
          :common => 5231,
          :condition => {
            :type => 1,
            :id => 3284,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Panty Stroke)",
          :common => 5232,
          :condition => {
            :type => 1,
            :id => 3284,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Silky Hairjob)",
          :common => 5233,
          :condition => {
            :type => 1,
            :id => 3284,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 4 (Wet Blowjob)",
          :common => 5234,
          :condition => {
            :type => 1,
            :id => 3284,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    460 => {
      :name => "Renkubus",
      :condition => {
        :type => 3,
        :id => 275
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_renccubus_h1"],
          2 => ["Graphics/Pictures/", "ev_renccubus_h2"],
          3 => ["Graphics/Pictures/", "ev_renccubus_h3"],
          4 => ["Graphics/Pictures/", "ev_renccubus_h4"],
          5 => ["Graphics/Pictures/", "ev_renccubus_h5"],
          6 => ["Graphics/Pictures/", "ev_renccubus_h6"],
          7 => ["Graphics/Pictures/", "ev_renccubus_h7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 38
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_renccubus_st02"],
          2 => ["Graphics/Pictures/", "ev_renccubus_ct01"],
          3 => ["Graphics/Pictures/", "ev_renccubus_ct02"],
          4 => ["Graphics/Pictures/", "ev_renccubus_ct03"],
          5 => ["Graphics/Pictures/", "ev_renccubus_ct11"],
          6 => ["Graphics/Pictures/", "ev_renccubus_ct12"],
          7 => ["Graphics/Pictures/", "ev_renccubus_ct13"],
          8 => ["Graphics/Pictures/", "ev_renccubus_ct21"],
          9 => ["Graphics/Pictures/", "ev_renccubus_ct22"],
          10 => ["Graphics/Pictures/", "ev_renccubus_ct23"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
          [1,6],
          [1,7],
          [1,8],
          [1,9],
          [1,10],
        ],
          :condition => {
            :type => 1,
            :id => 3285,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_renccubus_hb1"],
          2 => ["Graphics/Pictures/", "ev_renccubus_hb2"],
          3 => ["Graphics/Pictures/", "ev_renccubus_hb3"],
          4 => ["Graphics/Pictures/", "ev_renccubus_hb4"],
          5 => ["Graphics/Pictures/", "ev_renccubus_hb5"],
          6 => ["Graphics/Pictures/", "ev_renccubus_hb6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3275,
          :background => {
            :id => 38
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5236,
          :condition => {
            :type => 1,
            :id => 3285,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Loop Event (Blowjob)",
          :common => 5825,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    461 => {
      :name => "Succubus Witch",
      :condition => {
        :type => 3,
        :id => 298
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_witchs_he1"],
          2 => ["Graphics/Pictures/", "ev_witchs_he2"],
          3 => ["Graphics/Pictures/", "ev_witchs_he3"],
          4 => ["Graphics/Pictures/", "ev_witchs_he4"],
          5 => ["Graphics/Pictures/", "ev_witchs_he5"],
          6 => ["Graphics/Pictures/", "ev_witchs_ct11"],
          7 => ["Graphics/Pictures/", "ev_witchs_ct12"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,6],
          [2],
          [3],
          [4],
          [5],
          [5,7],
        ],
          :background => {
            :id => 13
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_witchs_ha01"],
          2 => ["Graphics/Pictures/", "ev_witchs_ha02"],
          3 => ["Graphics/Pictures/", "ev_witchs_ha03"],
          4 => ["Graphics/Pictures/", "ev_witchs_ha04"],
          5 => ["Graphics/Pictures/", "ev_witchs_ha05"],
          6 => ["Graphics/Pictures/", "ev_witchs_ha06"],
          7 => ["Graphics/Pictures/", "ev_witchs_ha07"],
          8 => ["Graphics/Pictures/", "ev_witchs_ha08"],
          9 => ["Graphics/Pictures/", "ev_witchs_ha09"],
          10 => ["Graphics/Pictures/", "ev_witchs_ha10"],
          11 => ["Graphics/Pictures/", "ev_witchs_hb1"],
          12 => ["Graphics/Pictures/", "ev_witchs_hb2"],
          13 => ["Graphics/Pictures/", "ev_witchs_hb3"],
          14 => ["Graphics/Pictures/", "ev_witchs_hb4"],
          15 => ["Graphics/Pictures/", "ev_witchs_hb5"],
          16 => ["Graphics/Pictures/", "ev_witchs_hc1"],
          17 => ["Graphics/Pictures/", "ev_witchs_hc2"],
          18 => ["Graphics/Pictures/", "ev_witchs_hc3"],
          19 => ["Graphics/Pictures/", "ev_witchs_hc4"],
          20 => ["Graphics/Pictures/", "ev_witchs_ct01"],
          21 => ["Graphics/Pictures/", "ev_witchs_ct02"],
          22 => ["Graphics/Pictures/", "ev_witchs_ct03"],
          23 => ["Graphics/Pictures/", "ev_witchs_ct04"],
          24 => ["Graphics/Pictures/", "ev_witchs_hg1"],
          25 => ["Graphics/Pictures/", "ev_witchs_hg2"],
          26 => ["Graphics/Pictures/", "ev_witchs_hg3"],
          27 => ["Graphics/Pictures/", "ev_witchs_ct21"],
          28 => ["Graphics/Pictures/", "ev_witchs_ct22"],
          29 => ["Graphics/Pictures/", "ev_witchs_ct23"],
          30 => ["Graphics/Pictures/", "ev_witchs_ct24"],
          31 => ["Graphics/Pictures/", "ev_witchs_hd1"],
          32 => ["Graphics/Pictures/", "ev_witchs_hd2"],
          33 => ["Graphics/Pictures/", "ev_witchs_hd3"],
          34 => ["Graphics/Pictures/", "ev_witchs_hd4"],
          35 => ["Graphics/Pictures/", "ev_witchs_hd5"],
          36 => ["Graphics/Pictures/", "ev_witchs_hd6"],
          37 => ["Graphics/Pictures/", "ev_witchs_hf1"],
          38 => ["Graphics/Pictures/", "ev_witchs_hf2"],
          39 => ["Graphics/Pictures/", "ev_witchs_hf3"],
          40 => ["Graphics/Pictures/", "ev_witchs_hh1"],
          41 => ["Graphics/Pictures/", "ev_witchs_hh2"],
          42 => ["Graphics/Pictures/", "ev_witchs_hh3"],
          43 => ["Graphics/Pictures/", "ev_witchs_hh4"],
          44 => ["Graphics/Pictures/", "ev_witchs_hi1"],
          45 => ["Graphics/Pictures/", "ev_witchs_hi2"],
          46 => ["Graphics/Pictures/", "ev_witchs_hi3"],
          47 => ["Graphics/Pictures/", "ev_witchs_hi4"],
          48 => ["Graphics/Pictures/", "ev_witchs_hj1"],
          49 => ["Graphics/Pictures/", "ev_witchs_hj2"],
          50 => ["Graphics/Pictures/", "ev_witchs_hj3"],
          51 => ["Graphics/Pictures/", "ev_witchs_hk1"],
          52 => ["Graphics/Pictures/", "ev_witchs_hk2"],
          53 => ["Graphics/Pictures/", "ev_witchs_hk3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [16,20],
          [17,21],
          [18,22],
          [19,23],
          [24,27],
          [25,28],
          [26,29],
          [26,30],
          [31],
          [32],
          [33],
          [34],
          [35],
          [36],
          [37],
          [38],
          [39],
          [40],
          [41],
          [42],
          [43],
          [44],
          [45],
          [46],
          [47],
          [48],
          [49],
          [50],
          [51],
          [52],
          [53],
        ],
          :condition => {
            :type => 1,
            :id => 3286,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3298,
          :background => {
            :id => 13
          }
        },
        2 => {
          :name => "Request 1 (Melting Kiss)",
          :common => 5241,
          :condition => {
            :type => 1,
            :id => 3286,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Puff Puff)",
          :common => 5242,
          :condition => {
            :type => 1,
            :id => 3286,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Hat of Pleasure)",
          :common => 5243,
          :condition => {
            :type => 1,
            :id => 3286,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 4 (Tail Drain)",
          :common => 5244,
          :condition => {
            :type => 1,
            :id => 3286,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        6 => {
          :name => "Request 5 (Footjob)",
          :common => 5245,
          :condition => {
            :type => 1,
            :id => 3286,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        7 => {
          :name => "Request 6 (Blowjob)",
          :common => 5246,
          :condition => {
            :type => 1,
            :id => 3286,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        8 => {
          :name => "Request 7 (Milking Breasts)",
          :common => 5247,
          :condition => {
            :type => 1,
            :id => 3286,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        9 => {
          :name => "Request 8 (Minimum Phantasm: Heaven)",
          :common => 5248,
          :condition => {
            :type => 1,
            :id => 3286,
            :op => 1,
            :value => 70
          },
          :background => {
            :id => 1
          }
        },
        10 => {
          :name => "Request 9 (Minimum Phantasm: Hell)",
          :common => 5249,
          :condition => {
            :type => 1,
            :id => 3286,
            :op => 1,
            :value => 70
          },
          :background => {
            :id => 1
          }
        },
        11 => {
          :name => "Request 10 (Unbirth)",
          :common => 5250,
          :condition => {
            :type => 1,
            :id => 3286,
            :op => 1,
            :value => 70
          },
          :background => {
            :id => 1
          }
        },
        12 => {
          :name => "Request 11 (Energy Drain)",
          :common => 5251,
          :condition => {
            :type => 1,
            :id => 3286,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    462 => {
      :name => "Lustful Witch Succubus",
      :condition => {
        :type => 3,
        :id => 918
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_witchs2_ha1"],
          2 => ["Graphics/Pictures/", "ev_witchs2_ha2"],
          3 => ["Graphics/Pictures/", "ev_witchs2_ha3"],
          4 => ["Graphics/Pictures/", "ev_witchs2_ha4"],
          5 => ["Graphics/Pictures/", "ev_witchs2_ha5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 13
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_witchs2_hb1"],
          2 => ["Graphics/Pictures/", "ev_witchs2_hb2"],
          3 => ["Graphics/Pictures/", "ev_witchs2_hb3"],
          4 => ["Graphics/Pictures/", "ev_witchs2_hb4"],
          5 => ["Graphics/Pictures/", "ev_witchs2_hb5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 1,
            :id => 3286,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3918,
          :background => {
            :id => 13
          }
        },
        2 => {
          :name => "Request 1 (Energy Drain)",
          :common => 5252,
          :condition => {
            :type => 1,
            :id => 3286,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        12 => {
          :name => "Request 2 (Naked Energy Drain)",
          :common => 5253,
          :condition => {
            :type => 1,
            :id => 3286,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    463 => {
      :name => "Succubus",
      :condition => {
        :type => 3,
        :id => 276
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_succubus_hd1"],
          2 => ["Graphics/Pictures/", "ev_succubus_hd2"],
          3 => ["Graphics/Pictures/", "ev_succubus_hd3"],
          4 => ["Graphics/Pictures/", "ev_succubus_hd4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 39
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_succubus_ha1"],
          2 => ["Graphics/Pictures/", "ev_succubus_ha2"],
          3 => ["Graphics/Pictures/", "ev_succubus_ha3"],
          4 => ["Graphics/Pictures/", "ev_succubus_ha4"],
          5 => ["Graphics/Pictures/", "ev_succubus_ha5"],
          6 => ["Graphics/Pictures/", "ev_succubus_ha6"],
          7 => ["Graphics/Pictures/", "ev_succubus_hb1"],
          8 => ["Graphics/Pictures/", "ev_succubus_hb2"],
          9 => ["Graphics/Pictures/", "ev_succubus_hb3"],
          10 => ["Graphics/Pictures/", "ev_succubus_hb4"],
          11 => ["Graphics/Pictures/", "ev_succubus_hb5"],
          12 => ["Graphics/Pictures/", "ev_succubus_hb6"],
          13 => ["Graphics/Pictures/", "ev_succubus_hc1"],
          14 => ["Graphics/Pictures/", "ev_succubus_hc2"],
          15 => ["Graphics/Pictures/", "ev_succubus_hc3"],
          16 => ["Graphics/Pictures/", "ev_succubus_hc4"],
          17 => ["Graphics/Pictures/", "ev_succubus_hc5"],
          18 => ["Graphics/Pictures/", "ev_succubus_hc6"],
          19 => ["Graphics/Pictures/", "ev_succubus_hc7"],
          20 => ["Graphics/Pictures/", "ev_succubus_hc8"],
          21 => ["Graphics/Pictures/", "ev_succubus_hc9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
        ],
          :condition => {
            :type => 1,
            :id => 3287,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3276,
          :background => {
            :id => 39
          }
        },
        2 => {
          :name => "Request 1 (Tail Drain)",
          :common => 5256,
          :condition => {
            :type => 1,
            :id => 3287,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Breast Squeeze)",
          :common => 5257,
          :condition => {
            :type => 1,
            :id => 3287,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Hecto Deep Blowjob)",
          :common => 5258,
          :condition => {
            :type => 1,
            :id => 3287,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 4 (Energy Drain)",
          :common => 5259,
          :condition => {
            :type => 1,
            :id => 3287,
            :op => 1,
            :value => 70
          },
          :background => {
            :id => 1
          }
        },
        6 => {
          :name => "Request 5 (Infinite Pussy)",
          :common => 5260,
          :condition => {
            :type => 1,
            :id => 3287,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    464 => {
      :name => "Natasha",
      :condition => {
        :type => 3,
        :id => 277
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_d_succubus_hc1"],
          2 => ["Graphics/Pictures/", "ev_d_succubus_hc2"],
          3 => ["Graphics/Pictures/", "ev_d_succubus_hc3"],
          4 => ["Graphics/Pictures/", "ev_d_succubus_hb1"],
          5 => ["Graphics/Pictures/", "ev_d_succubus_hb2"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 39
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_d_succubus_hd1"],
          2 => ["Graphics/Pictures/", "ev_d_succubus_hd2"],
          3 => ["Graphics/Pictures/", "ev_d_succubus_hd3"],
          4 => ["Graphics/Pictures/", "ev_d_succubus_hd4"],
          5 => ["Graphics/Pictures/", "ev_d_succubus_hd5"],
          6 => ["Graphics/Pictures/", "ev_d_succubus_he1"],
          7 => ["Graphics/Pictures/", "ev_d_succubus_he2"],
          8 => ["Graphics/Pictures/", "ev_d_succubus_he3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3277,
          :background => {
            :id => 39
          }
        },
        2 => {
          :name => "Request 1 (Semen Sucking Tail)",
          :common => 5261,
          :condition => {
            :type => 1,
            :id => 3288,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Semen Sucking Tail...?)",
          :common => 5262,
          :condition => {
            :type => 1,
            :id => 3288,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Loop Event (Handjob)",
          :common => 5800,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        },
        5 => {
          :name => "Loop Event (Voyeur+Tail Drain)",
          :common => 5801,
          :fadeout => 1,
          map: [83, 16, 53],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 0
          }
        }
      }
    },
    465 => {
      :name => "Scylla Maid",
      :condition => {
        :type => 3,
        :id => 278
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_maidscyulla_h01"],
          2 => ["Graphics/Pictures/", "ev_maidscyulla_h02"],
          3 => ["Graphics/Pictures/", "ev_maidscyulla_h03"],
          4 => ["Graphics/Pictures/", "ev_maidscyulla_h04"],
          5 => ["Graphics/Pictures/", "ev_maidscyulla_h05"],
          6 => ["Graphics/Pictures/", "ev_maidscyulla_h06"],
          7 => ["Graphics/Pictures/", "ev_maidscyulla_h07"],
          8 => ["Graphics/Pictures/", "ev_maidscyulla_h08"],
          9 => ["Graphics/Pictures/", "ev_maidscyulla_h09"],
          10 => ["Graphics/Pictures/", "ev_maidscyulla_h10"],
          11 => ["Graphics/Pictures/", "ev_maidscyulla_ct01"],
          12 => ["Graphics/Pictures/", "ev_maidscyulla_ct02"],
          13 => ["Graphics/Pictures/", "ev_maidscyulla_ct03"],
          14 => ["Graphics/Pictures/", "ev_maidscyulla_ct11"],
          15 => ["Graphics/Pictures/", "ev_maidscyulla_ct12"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [4,14],
          [5,15],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [9,11],
          [9,12],
          [9,13],
          [10],
        ],
          :background => {
            :id => 33
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_maidscyulla_h04"],
          2 => ["Graphics/Pictures/", "ev_maidscyulla_ct01"],
          3 => ["Graphics/Pictures/", "ev_maidscyulla_ct02"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
        ],
          :condition => {
            :type => 1,
            :id => 3289,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3278,
          :background => {
            :id => 33
          }
        },
        2 => {
          :name => "Request 1 (Swallow)",
          :common => 5266,
          :condition => {
            :type => 1,
            :id => 3289,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Swallow...?)",
          :common => 5267,
          :condition => {
            :type => 1,
            :id => 3289,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    466 => {
      :name => "Emily",
      :condition => {
        :type => 3,
        :id => 296
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_emily_h1"],
          2 => ["Graphics/Pictures/", "ev_emily_h2"],
          3 => ["Graphics/Pictures/", "ev_emily_h3"],
          4 => ["Graphics/Pictures/", "ev_emily_h4"],
          5 => ["Graphics/Pictures/", "ev_emily_ct01"],
          6 => ["Graphics/Pictures/", "ev_emily_ct02"],
          7 => ["Graphics/Pictures/", "ev_emily_ct03"],
          8 => ["Graphics/Pictures/", "ev_emily_ct04"],
          9 => ["Graphics/Pictures/", "ev_emily_ct05"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,5],
          [2,6],
          [3,7],
          [3,8],
          [4,9],
        ],
          :background => {
            :id => 13
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_emily_h5"],
          2 => ["Graphics/Pictures/", "ev_emily_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
        ],
          :condition => {
            :type => 1,
            :id => 3294,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3296,
          :background => {
            :id => 13
          }
        },
        2 => {
          :name => "Request 1 (Twin Tail Hug)",
          :common => 5291,
          :condition => {
            :type => 1,
            :id => 3294,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Lethal Tentacle Play)",
          :common => 5292,
          :condition => {
            :type => 1,
            :id => 3294,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Lethal Tentacle Play...?)",
          :common => 5293,
          :condition => {
            :type => 1,
            :id => 3294,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    467 => {
      :name => "Cassandra (Young)",
      :condition => {
        :type => 3,
        :id => 297
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cassandra_hd1"],
          2 => ["Graphics/Pictures/", "ev_cassandra_hd2"],
          3 => ["Graphics/Pictures/", "ev_cassandra_hd3"],
          4 => ["Graphics/Pictures/", "ev_cassandra_he1"],
          5 => ["Graphics/Pictures/", "ev_cassandra_he2"],
          6 => ["Graphics/Pictures/", "ev_cassandra_he3"],
          7 => ["Graphics/Pictures/", "ev_cassandra_he4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 13
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cassandra_hh1"],
          2 => ["Graphics/Pictures/", "ev_cassandra_hh2"],
          3 => ["Graphics/Pictures/", "ev_cassandra_hh3"],
          4 => ["Graphics/Pictures/", "ev_cassandra_hh4"],
          5 => ["Graphics/Pictures/", "ev_cassandra_hh5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3297,
          :background => {
            :id => 13
          }
        },
        2 => {
          :name => "Request 1 (Sticky Symphony)",
          :common => 5296,
          :condition => {
            :type => 1,
            :id => 3295,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Loop Event (Sticky Flesh Sucking)",
          :common => 5798,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    468 => {
      :name => "Cassandra (Adult)",
      :condition => {
        :type => 3,
        :id => 498
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cassandra_hb1"],
          2 => ["Graphics/Pictures/", "ev_cassandra_hb2"],
          3 => ["Graphics/Pictures/", "ev_cassandra_hb3"],
          4 => ["Graphics/Pictures/", "ev_cassandra_hb4"],
          5 => ["Graphics/Pictures/", "ev_cassandra_hb5"],
          6 => ["Graphics/Pictures/", "ev_cassandra_ct01"],
          7 => ["Graphics/Pictures/", "ev_cassandra_ct02"],
          8 => ["Graphics/Pictures/", "ev_cassandra_ct03"],
          9 => ["Graphics/Pictures/", "ev_cassandra_hc1"],
          10 => ["Graphics/Pictures/", "ev_cassandra_hc2"],
          11 => ["Graphics/Pictures/", "ev_cassandra_hc3"],
          12 => ["Graphics/Pictures/", "ev_cassandra_hc4"],
          13 => ["Graphics/Pictures/", "ev_cassandra_hc5"],
          14 => ["Graphics/Pictures/", "ev_cassandra_hc6"],
          15 => ["Graphics/Pictures/", "ev_cassandra_ha1"],
          16 => ["Graphics/Pictures/", "ev_cassandra_ha2"],
        },
        # 表示パターンの指定
        :draw => [
          [15],
          [16],
          [1],
          [2],
          [3],
          [3,6],
          [4,7],
          [5,8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
        ],
          :background => {
            :id => 13
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cassandra_hf1"],
          2 => ["Graphics/Pictures/", "ev_cassandra_hg1"],
          3 => ["Graphics/Pictures/", "ev_cassandra_hg2"],
          4 => ["Graphics/Pictures/", "ev_cassandra_hg3"],
          5 => ["Graphics/Pictures/", "ev_cassandra_hg4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3498,
          :background => {
            :id => 13
          }
        },
        2 => {
          :name => "Request 1 (Digesting Flesh)",
          :common => 5297,
          :condition => {
            :type => 1,
            :id => 3295,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Digesting Embrace)",
          :common => 5298,
          :condition => {
            :type => 1,
            :id => 3295,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Loop Event (Sticky Flesh Predation)",
          :common => 5799,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    469 => {
      :name => "Gluttonous Cassandra",
      :condition => {
        :type => 3,
        :id => 916
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cassandray_ha1"],
          2 => ["Graphics/Pictures/", "ev_cassandray_ha2"],
          3 => ["Graphics/Pictures/", "ev_cassandray_ha3"],
          4 => ["Graphics/Pictures/", "ev_cassandray_ha4"],
          5 => ["Graphics/Pictures/", "ev_cassandray_ha5"],
          6 => ["Graphics/Pictures/", "ev_cassandray_ha6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 68
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3916,
          :background => {
            :id => 68
          }
        },
        2 => {
          :name => "Request 1 (Digestive Flesh)",
          :common => 7716,
          :condition => {
            :type => 1,
            :id => 3295,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    470 => {
      :name => "Monster Lord Cassandra",
      :condition => {
        :type => 2,
        :id => 834
      },
      :cg => {
        1 => {
          :regist => {
            1 => ["Graphics/Pictures/", "ev_cassandra_hi1"],
          },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Request 1 (Assimilation Drain)",
          :common => 5851,
          :condition => {
            :type => 1,
            :id => 3834,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    471 => {
      :name => "Madame Insect",
      :condition => {
        :type => 3,
        :id => 279
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_madaminsect_h1"],
          2 => ["Graphics/Pictures/", "ev_madaminsect_h2"],
          3 => ["Graphics/Pictures/", "ev_madaminsect_h3"],
          4 => ["Graphics/Pictures/", "ev_madaminsect_h4"],
          5 => ["Graphics/Pictures/", "ev_madaminsect_ct01"],
          6 => ["Graphics/Pictures/", "ev_madaminsect_ct02"],
          7 => ["Graphics/Pictures/", "ev_madaminsect_ct03"],
          8 => ["Graphics/Pictures/", "ev_madaminsect_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,5],
          [2,6],
          [3,7],
          [4,8],
        ],
          :background => {
            :id => 68
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_madaminsect_hb1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3279,
          :background => {
            :id => 68
          }
        },
        2 => {
          :name => "Request 1 (Fluid Sucking)",
          :common => 5271,
          :condition => {
            :type => 1,
            :id => 3290,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Fluid Sucking...?)",
          :common => 5272,
          :condition => {
            :type => 1,
            :id => 3290,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Loop Event (Hakunen Reverse Rape)",
          :common => 5793,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    472 => {
      :name => "Madame Umbrella",
      :condition => {
        :type => 3,
        :id => 280
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_madamumbrella_h01"],
          2 => ["Graphics/Pictures/", "ev_madamumbrella_h02"],
          3 => ["Graphics/Pictures/", "ev_madamumbrella_h03"],
          4 => ["Graphics/Pictures/", "ev_madamumbrella_h04"],
          5 => ["Graphics/Pictures/", "ev_madamumbrella_h05"],
          6 => ["Graphics/Pictures/", "ev_madamumbrella_h06"],
          7 => ["Graphics/Pictures/", "ev_madamumbrella_h07"],
          8 => ["Graphics/Pictures/", "ev_madamumbrella_h08"],
          9 => ["Graphics/Pictures/", "ev_madamumbrella_h09"],
          10 => ["Graphics/Pictures/", "ev_madamumbrella_h10"],
          11 => ["Graphics/Pictures/", "ev_madamumbrella_h11"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
        ],
          :background => {
            :id => 68
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3280,
          :background => {
            :id => 68
          }
        },
        2 => {
          :name => "Request 1 (Anal Teasing Tentacle)",
          :common => 5276,
          :condition => {
            :type => 1,
            :id => 3291,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    473 => {
      :name => "Aradia",
      :condition => {
        :type => 3,
        :id => 281
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_aradia_hb1"],
          2 => ["Graphics/Pictures/", "ev_aradia_hb2"],
          3 => ["Graphics/Pictures/", "ev_aradia_hb3"],
          4 => ["Graphics/Pictures/", "ev_aradia_hb4"],
          5 => ["Graphics/Pictures/", "ev_aradia_hb5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 68
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_aradia_ha1"],
          2 => ["Graphics/Pictures/", "ev_aradia_ha2"],
          3 => ["Graphics/Pictures/", "ev_aradia_ha3"],
          4 => ["Graphics/Pictures/", "ev_aradia_ha4"],
          5 => ["Graphics/Pictures/", "ev_aradia_ha5"],
          6 => ["Graphics/Pictures/", "ev_aradia_hc1"],
          7 => ["Graphics/Pictures/", "ev_aradia_hc2"],
          8 => ["Graphics/Pictures/", "ev_aradia_hc3"],
          9 => ["Graphics/Pictures/", "ev_aradia_hc4"],
          10 => ["Graphics/Pictures/", "ev_aradia_hc5"],
          11 => ["Graphics/Pictures/", "ev_aradia_hd1"],
          12 => ["Graphics/Pictures/", "ev_aradia_hd2"],
          13 => ["Graphics/Pictures/", "ev_aradia_hd3"],
          14 => ["Graphics/Pictures/", "ev_aradia_hd4"],
          15 => ["Graphics/Pictures/", "ev_aradia_hd5"],
          16 => ["Graphics/Pictures/", "ev_aradia_hd6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
        ],
          :condition => {
            :type => 1,
            :id => 3292,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_aradia_he1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3281,
          :background => {
            :id => 68
          }
        },
        2 => {
          :name => "Request 1 (Nipple Fuck)",
          :common => 5281,
          :condition => {
            :type => 1,
            :id => 3292,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Paizuri)",
          :common => 5282,
          :condition => {
            :type => 1,
            :id => 3292,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Busty Press)",
          :common => 5283,
          :condition => {
            :type => 1,
            :id => 3292,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Loop Event (Breast Dimension)",
          :common => 5795,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    474 => {
      :name => "Candy",
      :condition => {
        :type => 3,
        :id => 282
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_candy_hb01"],
          2 => ["Graphics/Pictures/", "ev_candy_hb02"],
          3 => ["Graphics/Pictures/", "ev_candy_hb03"],
          4 => ["Graphics/Pictures/", "ev_candy_hb04"],
          5 => ["Graphics/Pictures/", "ev_candy_hb05"],
          6 => ["Graphics/Pictures/", "ev_candy_hb06"],
          7 => ["Graphics/Pictures/", "ev_candy_hb07"],
          8 => ["Graphics/Pictures/", "ev_candy_hb08"],
          9 => ["Graphics/Pictures/", "ev_candy_hb09"],
          10 => ["Graphics/Pictures/", "ev_candy_hb10"],
          11 => ["Graphics/Pictures/", "ev_candy_hb11"],
          12 => ["Graphics/Pictures/", "ev_candy_hb12"],
          13 => ["Graphics/Pictures/", "ev_candy_hb13"],
          14 => ["Graphics/Pictures/", "ev_candy_hb14"],
          15 => ["Graphics/Pictures/", "ev_candy_hb15"],
          16 => ["Graphics/Pictures/", "ev_candy_hb16"],
          17 => ["Graphics/Pictures/", "ev_candy_hb17"],
          18 => ["Graphics/Pictures/", "ev_candy_hb18"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
        ],
          :background => {
            :id => 68
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_candy_ha01"],
          2 => ["Graphics/Pictures/", "ev_candy_ha02"],
          3 => ["Graphics/Pictures/", "ev_candy_ha03"],
          4 => ["Graphics/Pictures/", "ev_candy_ha04"],
          5 => ["Graphics/Pictures/", "ev_candy_ha05"],
          6 => ["Graphics/Pictures/", "ev_candy_ha06"],
          7 => ["Graphics/Pictures/", "ev_candy_ha07"],
          8 => ["Graphics/Pictures/", "ev_candy_ha08"],
          9 => ["Graphics/Pictures/", "ev_candy_ha09"],
          10 => ["Graphics/Pictures/", "ev_candy_ha10"],
          11 => ["Graphics/Pictures/", "ev_candy_ha11"],
          12 => ["Graphics/Pictures/", "ev_candy_ha12"],
          13 => ["Graphics/Pictures/", "ev_candy_ha13"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
        ],
          :condition => {
            :type => 1,
            :id => 3293,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3282,
          :background => {
            :id => 68
          }
        },
        2 => {
          :name => "Request 1 (Lick and Swallow)",
          :common => 5286,
          :condition => {
            :type => 1,
            :id => 3293,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Lick and Swallow...?)",
          :common => 5287,
          :condition => {
            :type => 1,
            :id => 3293,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Whole Body Licking)",
          :common => 5288,
          :condition => {
            :type => 1,
            :id => 3293,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    475 => {
      :name => "Basilisk",
      :condition => {
        :type => 3,
        :id => 283
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_basilisk_st02"],
          2 => ["Graphics/Pictures/", "ev_basilisk_ct01"],
          3 => ["Graphics/Pictures/", "ev_basilisk_ct02"],
          4 => ["Graphics/Pictures/", "ev_basilisk_ct03"],
          5 => ["Graphics/Pictures/", "ev_basilisk_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 17
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3283,
          :background => {
            :id => 17
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5301,
          :condition => {
            :type => 1,
            :id => 3297,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    476 => {
      :name => "Dragon Girl",
      :condition => {
        :type => 3,
        :id => 284
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_dragon_h1"],
          2 => ["Graphics/Pictures/", "ev_dragon_h2"],
          3 => ["Graphics/Pictures/", "ev_dragon_h3"],
          4 => ["Graphics/Pictures/", "ev_dragon_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 17
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3284,
          :background => {
            :id => 17
          }
        },
        2 => {
          :name => "Request 1 (Swallow)",
          :common => 5306,
          :condition => {
            :type => 1,
            :id => 3298,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Swallow...?)",
          :common => 5307,
          :condition => {
            :type => 1,
            :id => 3298,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    477 => {
      :name => "Gelatinous Cube Girl",
      :condition => {
        :type => 3,
        :id => 287
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_gelatinous_hb1"],
          2 => ["Graphics/Pictures/", "ev_gelatinous_hb2"],
          3 => ["Graphics/Pictures/", "ev_gelatinous_hb3"],
          4 => ["Graphics/Pictures/", "ev_gelatinous_hb4"],
          5 => ["Graphics/Pictures/", "ev_gelatinous_hb5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 9
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_gelatinous_st11"],
          2 => ["Graphics/Pictures/", "ev_gelatinous_ct01"],
          3 => ["Graphics/Pictures/", "ev_gelatinous_ct02"],
          4 => ["Graphics/Pictures/", "ev_gelatinous_ct03"],
          5 => ["Graphics/Pictures/", "ev_gelatinous_ct04"],
          6 => ["Graphics/Pictures/", "ev_gelatinous_ha1"],
          7 => ["Graphics/Pictures/", "ev_gelatinous_ha2"],
          8 => ["Graphics/Pictures/", "ev_gelatinous_ha3"],
          9 => ["Graphics/Pictures/", "ev_gelatinous_ha4"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
          [6],
          [7],
          [8],
          [9],
        ],
          :condition => {
            :type => 1,
            :id => 3299,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3287,
          :background => {
            :id => 9
          }
        },
        2 => {
          :name => "Request 1 (Predation)",
          :common => 5311,
          :condition => {
            :type => 1,
            :id => 3299,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5312,
          :condition => {
            :type => 1,
            :id => 3299,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    478 => {
      :name => "Youki",
      :condition => {
        :type => 3,
        :id => 288
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_youki_ha1"],
          2 => ["Graphics/Pictures/", "ev_youki_ha2"],
          3 => ["Graphics/Pictures/", "ev_youki_ha3"],
          4 => ["Graphics/Pictures/", "ev_youki_ha4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 9
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_youki_hb1"],
          2 => ["Graphics/Pictures/", "ev_youki_hb2"],
          3 => ["Graphics/Pictures/", "ev_youki_hb3"],
          4 => ["Graphics/Pictures/", "ev_youki_hb4"],
          5 => ["Graphics/Pictures/", "ev_youki_hb5"],
          6 => ["Graphics/Pictures/", "ev_youki_hb6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3300,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_youki_hc1"],
          2 => ["Graphics/Pictures/", "ev_youki_hc2"],
          3 => ["Graphics/Pictures/", "ev_youki_hc3"],
          4 => ["Graphics/Pictures/", "ev_youki_hd1"],
          5 => ["Graphics/Pictures/", "ev_youki_hd2"],
          6 => ["Graphics/Pictures/", "ev_youki_hd3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3288,
          :background => {
            :id => 9
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 5316,
          :condition => {
            :type => 1,
            :id => 3300,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5317,
          :condition => {
            :type => 1,
            :id => 3300,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Loop Event (Reverse Rape)",
          :common => 5832,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        },
        5 => {
          :name => "Loop Event (Hakunen Reverse Rape)",
          :common => 5833,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    479 => {
      :name => "Tiger Girl",
      :condition => {
        :type => 3,
        :id => 289
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_tora_h1"],
          2 => ["Graphics/Pictures/", "ev_tora_h2"],
          3 => ["Graphics/Pictures/", "ev_tora_h3"],
          4 => ["Graphics/Pictures/", "ev_tora_h4"],
          5 => ["Graphics/Pictures/", "ev_tora_ct01"],
          6 => ["Graphics/Pictures/", "ev_tora_ct02"],
          7 => ["Graphics/Pictures/", "ev_tora_ct03"],
          8 => ["Graphics/Pictures/", "ev_tora_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,5],
          [2,6],
          [3,7],
          [4,8],
        ],
          :background => {
            :id => 9
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3289,
          :background => {
            :id => 9
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5321,
          :condition => {
            :type => 1,
            :id => 3301,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    480 => {
      :name => "Vampire",
      :condition => {
        :type => 3,
        :id => 290
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_vampire_h1"],
          2 => ["Graphics/Pictures/", "ev_vampire_h2"],
          3 => ["Graphics/Pictures/", "ev_vampire_h3"],
          4 => ["Graphics/Pictures/", "ev_vampire_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 11
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3290,
          :background => {
            :id => 11
          }
        },
        2 => {
          :name => "Request 1 (Bloodsucking)",
          :common => 5326,
          :condition => {
            :type => 1,
            :id => 3302,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Bloodsucking...?)",
          :common => 5327,
          :condition => {
            :type => 1,
            :id => 3302,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    481 => {
      :name => "Jellaila",
      :condition => {
        :type => 3,
        :id => 291
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_jeraira_h1"],
          2 => ["Graphics/Pictures/", "ev_jeraira_h2"],
          3 => ["Graphics/Pictures/", "ev_jeraira_h3"],
          4 => ["Graphics/Pictures/", "ev_jeraira_h4"],
          5 => ["Graphics/Pictures/", "ev_jeraira_h5"],
          6 => ["Graphics/Pictures/", "ev_jeraira_h6"],
          7 => ["Graphics/Pictures/", "ev_jeraira_h7"],
          8 => ["Graphics/Pictures/", "ev_jeraira_h8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 45
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3291,
          :background => {
            :id => 45
          }
        },
        2 => {
          :name => "Request 1 (Semen Sucking Harpstrings)",
          :common => 5331,
          :condition => {
            :type => 1,
            :id => 3303,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    482 => {
      :name => "Ribo-Ribo",
      :condition => {
        :type => 3,
        :id => 292
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_libolibo_h1"],
          2 => ["Graphics/Pictures/", "ev_libolibo_h2"],
          3 => ["Graphics/Pictures/", "ev_libolibo_h3"],
          4 => ["Graphics/Pictures/", "ev_libolibo_h4"],
          5 => ["Graphics/Pictures/", "ev_libolibo_ct01"],
          6 => ["Graphics/Pictures/", "ev_libolibo_ct02"],
          7 => ["Graphics/Pictures/", "ev_libolibo_ct03"],
          8 => ["Graphics/Pictures/", "ev_libolibo_ct04"],
          9 => ["Graphics/Pictures/", "ev_libolibo_ct05"],
          10 => ["Graphics/Pictures/", "ev_libolibo_ct06"],
          11 => ["Graphics/Pictures/", "ev_libolibo_ct07"],
          12 => ["Graphics/Pictures/", "ev_libolibo_ct08"],
          13 => ["Graphics/Pictures/", "ev_libolibo_ct09"],
          14 => ["Graphics/Pictures/", "ev_libolibo_ct10"],
          15 => ["Graphics/Pictures/", "ev_libolibo_ct11"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [2,5],
          [2,6],
          [3,7],
          [3,8],
          [3,9],
          [3,10],
          [4,11],
          [4,12],
          [4,13],
          [4,14],
          [4,15],
        ],
          :background => {
            :id => 45
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3292,
          :background => {
            :id => 45
          }
        },
        2 => {
          :name => "Request 1 (Restrained Semen Squeezing)",
          :common => 5336,
          :condition => {
            :type => 1,
            :id => 3304,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    483 => {
      :name => "Amphil",
      :condition => {
        :type => 3,
        :id => 293
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_anfill_ha01"],
          2 => ["Graphics/Pictures/", "ev_anfill_ha02"],
          3 => ["Graphics/Pictures/", "ev_anfill_ha03"],
          4 => ["Graphics/Pictures/", "ev_anfill_ha04"],
          5 => ["Graphics/Pictures/", "ev_anfill_ha05"],
          6 => ["Graphics/Pictures/", "ev_anfill_ha06"],
          7 => ["Graphics/Pictures/", "ev_anfill_ha07"],
          8 => ["Graphics/Pictures/", "ev_anfill_ha08"],
          9 => ["Graphics/Pictures/", "ev_anfill_ha09"],
          10 => ["Graphics/Pictures/", "ev_anfill_ha10"],
          11 => ["Graphics/Pictures/", "ev_anfill_ha11"],
          12 => ["Graphics/Pictures/", "ev_anfill_ha12"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
        ],
          :background => {
            :id => 45
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3293,
          :background => {
            :id => 45
          }
        },
        2 => {
          :name => "Request 1 (Tentacle Job)",
          :common => 5341,
          :condition => {
            :type => 1,
            :id => 3305,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    484 => {
      :name => "Twinkell",
      :condition => {
        :type => 3,
        :id => 294
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_twinkel_ha01"],
          2 => ["Graphics/Pictures/", "ev_twinkel_ha02"],
          3 => ["Graphics/Pictures/", "ev_twinkel_ha03"],
          4 => ["Graphics/Pictures/", "ev_twinkel_ha04"],
          5 => ["Graphics/Pictures/", "ev_twinkel_ha05"],
          6 => ["Graphics/Pictures/", "ev_twinkel_ha06"],
          7 => ["Graphics/Pictures/", "ev_twinkel_ha07"],
          8 => ["Graphics/Pictures/", "ev_twinkel_ha08"],
          9 => ["Graphics/Pictures/", "ev_twinkel_ha09"],
          10 => ["Graphics/Pictures/", "ev_twinkel_ha10"],
          11 => ["Graphics/Pictures/", "ev_twinkel_ha11"],
          12 => ["Graphics/Pictures/", "ev_twinkel_ha12"],
          13 => ["Graphics/Pictures/", "ev_twinkel_ha13"],
          14 => ["Graphics/Pictures/", "ev_twinkel_ha14"],
          15 => ["Graphics/Pictures/", "ev_twinkel_ha15"],
          16 => ["Graphics/Pictures/", "ev_twinkel_ha16"],
          17 => ["Graphics/Pictures/", "ev_twinkel_ha17"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
        ],
          :background => {
            :id => 45
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3294,
          :background => {
            :id => 45
          }
        },
        2 => {
          :name => "Request 1 (Alternating Reverse Rape)",
          :common => 5346,
          :condition => {
            :type => 1,
            :id => 3306,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    485 => {
      :name => "Lilith & Lilim",
      :condition => {
        :type => 3,
        :id => 295
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lilith_ha0"],
          2 => ["Graphics/Pictures/", "ev_lilith_ha1"],
          3 => ["Graphics/Pictures/", "ev_lilith_ha2"],
          4 => ["Graphics/Pictures/", "ev_lilith_ha3"],
          5 => ["Graphics/Pictures/", "ev_lilith_ha4"],
          6 => ["Graphics/Pictures/", "ev_lilith_hb1"],
          7 => ["Graphics/Pictures/", "ev_lilith_hb2"],
          8 => ["Graphics/Pictures/", "ev_lilith_hb3"],
          9 => ["Graphics/Pictures/", "ev_lilith_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 39
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_lilith_hc1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3295,
          :background => {
            :id => 39
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5521,
          :condition => {
            :type => 1,
            :id => 3307,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Loop Event (Slippery Thighjob)",
          :common => 5815,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    486 => {
      :name => "Sea Anemone Girl",
      :condition => {
        :type => 3,
        :id => 299
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_seaanemone_h1"],
          2 => ["Graphics/Pictures/", "ev_seaanemone_h2"],
          3 => ["Graphics/Pictures/", "ev_seaanemone_h3"],
          4 => ["Graphics/Pictures/", "ev_seaanemone_h4"],
          5 => ["Graphics/Pictures/", "ev_seaanemone_h5"],
          6 => ["Graphics/Pictures/", "ev_seaanemone_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 43
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3299,
          :background => {
            :id => 43
          }
        },
        2 => {
          :name => "Request 1 (Semen Squeeze Movement)",
          :common => 5351,
          :condition => {
            :type => 1,
            :id => 3307,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    487 => {
      :name => "Sea Dragon Girl",
      :condition => {
        :type => 3,
        :id => 300
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_suiryu_h01"],
          2 => ["Graphics/Pictures/", "ev_suiryu_h02"],
          3 => ["Graphics/Pictures/", "ev_suiryu_h03"],
          4 => ["Graphics/Pictures/", "ev_suiryu_h04"],
          5 => ["Graphics/Pictures/", "ev_suiryu_h05"],
          6 => ["Graphics/Pictures/", "ev_suiryu_h06"],
          7 => ["Graphics/Pictures/", "ev_suiryu_h07"],
          8 => ["Graphics/Pictures/", "ev_suiryu_h08"],
          9 => ["Graphics/Pictures/", "ev_suiryu_h09"],
          10 => ["Graphics/Pictures/", "ev_suiryu_h10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 43
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3300,
          :background => {
            :id => 43
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5356,
          :condition => {
            :type => 1,
            :id => 3308,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    488 => {
      :name => "Manta Girl",
      :condition => {
        :type => 3,
        :id => 301
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_manta_h1"],
          2 => ["Graphics/Pictures/", "ev_manta_h2"],
          3 => ["Graphics/Pictures/", "ev_manta_h3"],
          4 => ["Graphics/Pictures/", "ev_manta_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 43
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_manta_hb1"],
          2 => ["Graphics/Pictures/", "ev_manta_hb2"],
          3 => ["Graphics/Pictures/", "ev_manta_hb3"],
          4 => ["Graphics/Pictures/", "ev_manta_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3301,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3301,
          :background => {
            :id => 43
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 5361,
          :condition => {
            :type => 1,
            :id => 3309,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5362,
          :condition => {
            :type => 1,
            :id => 3309,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    489 => {
      :name => "Narwhal Girl",
      :condition => {
        :type => 3,
        :id => 302
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_ikkaku_h1"],
          2 => ["Graphics/Pictures/", "ev_ikkaku_h2"],
          3 => ["Graphics/Pictures/", "ev_ikkaku_h3"],
          4 => ["Graphics/Pictures/", "ev_ikkaku_h4"],
          5 => ["Graphics/Pictures/", "ev_ikkaku_h5"],
          6 => ["Graphics/Pictures/", "ev_ikkaku_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 43
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_ikkaku_hb1"],
          2 => ["Graphics/Pictures/", "ev_ikkaku_hc1"],
          3 => ["Graphics/Pictures/", "ev_ikkaku_hc2"],
          4 => ["Graphics/Pictures/", "ev_ikkaku_hc3"],
          5 => ["Graphics/Pictures/", "ev_ikkaku_hc4"],
          6 => ["Graphics/Pictures/", "ev_ikkaku_hc5"],
          7 => ["Graphics/Pictures/", "ev_ikkaku_hc6"],
          8 => ["Graphics/Pictures/", "ev_levia_hb1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3302,
          :background => {
            :id => 43
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5366,
          :condition => {
            :type => 1,
            :id => 3310,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Loop Event (Swallow)",
          :common => 5805,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        },
        4 => {
          :name => "Loop Event (Narwhal Squabble)",
          :common => 5814,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    490 => {
      :name => "Trick Fairy",
      :condition => {
        :type => 3,
        :id => 303
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_trickfairy_h1"],
          2 => ["Graphics/Pictures/", "ev_trickfairy_h2"],
          3 => ["Graphics/Pictures/", "ev_trickfairy_h3"],
          4 => ["Graphics/Pictures/", "ev_trickfairy_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 5
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3303,
          :background => {
            :id => 5
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5371,
          :condition => {
            :type => 1,
            :id => 3311,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    491 => {
      :name => "Elf Amazoness",
      :condition => {
        :type => 3,
        :id => 304
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_amazoneself_h1"],
          2 => ["Graphics/Pictures/", "ev_amazoneself_h2"],
          3 => ["Graphics/Pictures/", "ev_amazoneself_h3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :background => {
            :id => 5
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3304,
          :background => {
            :id => 5
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5376,
          :condition => {
            :type => 1,
            :id => 3312,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    492 => {
      :name => "Carbuncle Girl",
      :condition => {
        :type => 3,
        :id => 305
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_carbuncle_h1"],
          2 => ["Graphics/Pictures/", "ev_carbuncle_h2"],
          3 => ["Graphics/Pictures/", "ev_carbuncle_h3"],
          4 => ["Graphics/Pictures/", "ev_carbuncle_h4"],
          5 => ["Graphics/Pictures/", "ev_carbuncle_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 5
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3305,
          :background => {
            :id => 5
          }
        },
        2 => {
          :name => "Request 1 (Semen Sucking Tail)",
          :common => 5381,
          :condition => {
            :type => 1,
            :id => 3313,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    493 => {
      :name => "Gigantic Girl",
      :condition => {
        :type => 3,
        :id => 306
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_gigantic_hb1"],
          2 => ["Graphics/Pictures/", "ev_gigantic_hb2"],
          3 => ["Graphics/Pictures/", "ev_gigantic_hb3"],
          4 => ["Graphics/Pictures/", "ev_gigantic_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 5
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_gigantic_ha1"],
          2 => ["Graphics/Pictures/", "ev_gigantic_ha2"],
          3 => ["Graphics/Pictures/", "ev_gigantic_ha3"],
          4 => ["Graphics/Pictures/", "ev_gigantic_ha4"],
          5 => ["Graphics/Pictures/", "ev_gigantic_ha5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 1,
            :id => 3314,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3306,
          :background => {
            :id => 5
          }
        },
        2 => {
          :name => "Request 1 (Gigantic Paizuri)",
          :common => 5386,
          :condition => {
            :type => 1,
            :id => 3314,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Full Body Intercourse)",
          :common => 5387,
          :condition => {
            :type => 1,
            :id => 3314,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    494 => {
      :name => "Queen Fairy",
      :condition => {
        :type => 3,
        :id => 307
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_queenfairy_st02"],
          2 => ["Graphics/Pictures/", "ev_queenfairy_ct01"],
          3 => ["Graphics/Pictures/", "ev_queenfairy_ct02"],
          4 => ["Graphics/Pictures/", "ev_queenfairy_ct11"],
          5 => ["Graphics/Pictures/", "ev_queenfairy_ct12"],
          6 => ["Graphics/Pictures/", "ev_queenfairy_ct31"],
          7 => ["Graphics/Pictures/", "ev_queenfairy_ct32"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
          [1,6],
          [1,7],
        ],
          :background => {
            :id => 35
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_queenfairy_st02"],
          2 => ["Graphics/Pictures/", "ev_queenfairy_ct21"],
          3 => ["Graphics/Pictures/", "ev_queenfairy_ct22"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
        ],
          :condition => {
            :type => 1,
            :id => 3315,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3307,
          :background => {
            :id => 35
          }
        },
        2 => {
          :name => "Request 1 (Plant Teasing)",
          :common => 5391,
          :condition => {
            :type => 1,
            :id => 3315,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    495 => {
      :name => "Queen Elf",
      :condition => {
        :type => 3,
        :id => 308
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_queenelf_st02"],
          2 => ["Graphics/Pictures/", "ev_queenelf_ct01"],
          3 => ["Graphics/Pictures/", "ev_queenelf_ct02"],
          4 => ["Graphics/Pictures/", "ev_queenelf_ct03"],
          5 => ["Graphics/Pictures/", "ev_queenelf_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
        ],
          :background => {
            :id => 5
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3308,
          :background => {
            :id => 5
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5396,
          :condition => {
            :type => 1,
            :id => 3316,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    496 => {
      :name => "Forest Alraune",
      :condition => {
        :type => 3,
        :id => 309
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_f_alraune_h01"],
          2 => ["Graphics/Pictures/", "ev_f_alraune_h02"],
          3 => ["Graphics/Pictures/", "ev_f_alraune_h03"],
          4 => ["Graphics/Pictures/", "ev_f_alraune_h04"],
          5 => ["Graphics/Pictures/", "ev_f_alraune_h05"],
          6 => ["Graphics/Pictures/", "ev_f_alraune_h06"],
          7 => ["Graphics/Pictures/", "ev_f_alraune_h07"],
          8 => ["Graphics/Pictures/", "ev_f_alraune_h08"],
          9 => ["Graphics/Pictures/", "ev_f_alraune_h09"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 5
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3309,
          :background => {
            :id => 5
          }
        },
        2 => {
          :name => "Request 1 (Semen Sucking Flower)",
          :common => 5401,
          :condition => {
            :type => 1,
            :id => 3317,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    497 => {
      :name => "Forest Dryad",
      :condition => {
        :type => 3,
        :id => 310
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_f_dryad_h01"],
          2 => ["Graphics/Pictures/", "ev_f_dryad_h02"],
          3 => ["Graphics/Pictures/", "ev_f_dryad_h03"],
          4 => ["Graphics/Pictures/", "ev_f_dryad_h04"],
          5 => ["Graphics/Pictures/", "ev_f_dryad_h05"],
          6 => ["Graphics/Pictures/", "ev_f_dryad_h06"],
          7 => ["Graphics/Pictures/", "ev_f_dryad_h07"],
          8 => ["Graphics/Pictures/", "ev_f_dryad_h08"],
          9 => ["Graphics/Pictures/", "ev_f_dryad_h09"],
          10 => ["Graphics/Pictures/", "ev_f_dryad_h10"],
          11 => ["Graphics/Pictures/", "ev_f_dryad_h11"],
          12 => ["Graphics/Pictures/", "ev_f_dryad_h12"],
          13 => ["Graphics/Pictures/", "ev_f_dryad_h13"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
        ],
          :background => {
            :id => 5
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3310,
          :background => {
            :id => 5
          }
        },
        2 => {
          :name => "Request 1 (Semen Sucking Ivy)",
          :common => 5406,
          :condition => {
            :type => 1,
            :id => 3318,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    498 => {
      :name => "Walraune",
      :condition => {
        :type => 3,
        :id => 311
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_walraune_h1"],
          2 => ["Graphics/Pictures/", "ev_walraune_h2"],
          3 => ["Graphics/Pictures/", "ev_walraune_h3"],
          4 => ["Graphics/Pictures/", "ev_walraune_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 5
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3311,
          :background => {
            :id => 5
          }
        },
        2 => {
          :name => "Request 1 (Restrained Blowjob)",
          :common => 5411,
          :condition => {
            :type => 1,
            :id => 3319,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    499 => {
      :name => "Dryad",
      :condition => {
        :type => 3,
        :id => 312
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_dryad_hb1"],
          2 => ["Graphics/Pictures/", "ev_dryad_hb2"],
          3 => ["Graphics/Pictures/", "ev_dryad_hb3"],
          4 => ["Graphics/Pictures/", "ev_dryad_hb4"],
          5 => ["Graphics/Pictures/", "ev_dryad_hb5"],
          6 => ["Graphics/Pictures/", "ev_dryad_hb6"],
          7 => ["Graphics/Pictures/", "ev_dryad_hb7"],
          8 => ["Graphics/Pictures/", "ev_dryad_hb8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 5
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_dryad_ha1"],
          2 => ["Graphics/Pictures/", "ev_dryad_ha2"],
          3 => ["Graphics/Pictures/", "ev_dryad_ha3"],
          4 => ["Graphics/Pictures/", "ev_dryad_ha4"],
          5 => ["Graphics/Pictures/", "ev_dryad_ha5"],
          6 => ["Graphics/Pictures/", "ev_dryad_ha6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3320,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3312,
          :background => {
            :id => 5
          }
        },
        2 => {
          :name => "Request 1 (Arc Hip Heaven)",
          :common => 5416,
          :condition => {
            :type => 1,
            :id => 3320,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    500 => {
      :name => "Dark Dryad",
      :condition => {
        :type => 3,
        :id => 313
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_dryad_hc1"],
          2 => ["Graphics/Pictures/", "ev_dryad_hc2"],
          3 => ["Graphics/Pictures/", "ev_dryad_hc3"],
          4 => ["Graphics/Pictures/", "ev_dryad_hc4"],
          5 => ["Graphics/Pictures/", "ev_dryad_hc5"],
          6 => ["Graphics/Pictures/", "ev_dryad_hc6"],
          7 => ["Graphics/Pictures/", "ev_dryad_hc7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 5
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3313,
          :background => {
            :id => 5
          }
        },
        2 => {
          :name => "Request 1 (Bloom of the Tree)",
          :common => 5421,
          :condition => {
            :type => 1,
            :id => 3321,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Bloom of the Tree...?)",
          :common => 5422,
          :condition => {
            :type => 1,
            :id => 3321,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    501 => {
      :name => "Queen Alraune",
      :condition => {
        :type => 3,
        :id => 314
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_queenalraune_h1"],
          2 => ["Graphics/Pictures/", "ev_queenalraune_h2"],
          3 => ["Graphics/Pictures/", "ev_queenalraune_h3"],
          4 => ["Graphics/Pictures/", "ev_queenalraune_h4"],
          5 => ["Graphics/Pictures/", "ev_queenalraune_h5"],
          6 => ["Graphics/Pictures/", "ev_queenalraune_h6"],
          7 => ["Graphics/Pictures/", "ev_queenalraune_h7"],
          8 => ["Graphics/Pictures/", "ev_queenalraune_h8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 5
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3314,
          :background => {
            :id => 5
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5426,
          :condition => {
            :type => 1,
            :id => 3322,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    502 => {
      :name => "Mermaid Knight",
      :condition => {
        :type => 3,
        :id => 316
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_knight_mermaid_ha01"],
          2 => ["Graphics/Pictures/", "ev_knight_mermaid_ha02"],
          3 => ["Graphics/Pictures/", "ev_knight_mermaid_ha03"],
          4 => ["Graphics/Pictures/", "ev_knight_mermaid_ha04"],
          5 => ["Graphics/Pictures/", "ev_knight_mermaid_ha05"],
          6 => ["Graphics/Pictures/", "ev_knight_mermaid_ha06"],
          7 => ["Graphics/Pictures/", "ev_knight_mermaid_ha07"],
          8 => ["Graphics/Pictures/", "ev_knight_mermaid_ha08"],
          9 => ["Graphics/Pictures/", "ev_knight_mermaid_ha09"],
          10 => ["Graphics/Pictures/", "ev_knight_mermaid_ha10"],
          11 => ["Graphics/Pictures/", "ev_knight_mermaid_ha11"],
          12 => ["Graphics/Pictures/", "ev_knight_mermaid_ha12"],
          13 => ["Graphics/Pictures/", "ev_knight_mermaid_ha13"],
          14 => ["Graphics/Pictures/", "ev_knight_mermaid_ha14"],
          15 => ["Graphics/Pictures/", "ev_knight_mermaid_ha15"],
          16 => ["Graphics/Pictures/", "ev_knight_mermaid_ha16"],
          17 => ["Graphics/Pictures/", "ev_knight_mermaid_ha17"],
          18 => ["Graphics/Pictures/", "ev_knight_mermaid_hb1"],
          19 => ["Graphics/Pictures/", "ev_knight_mermaid_hb2"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
        ],
          :background => {
            :id => 20
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3316,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Blowjob)",
          :common => 5436,
          :condition => {
            :type => 1,
            :id => 3324,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    503 => {
      :name => "Mermaid General",
      :condition => {
        :type => 3,
        :id => 317
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_g_mermaid_hb1"],
          2 => ["Graphics/Pictures/", "ev_g_mermaid_hb2"],
          3 => ["Graphics/Pictures/", "ev_g_mermaid_hb3"],
          4 => ["Graphics/Pictures/", "ev_g_mermaid_hb4"],
          5 => ["Graphics/Pictures/", "ev_g_mermaid_ct01"],
          6 => ["Graphics/Pictures/", "ev_g_mermaid_ct02"],
          7 => ["Graphics/Pictures/", "ev_g_mermaid_ct03"],
          8 => ["Graphics/Pictures/", "ev_g_mermaid_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1,5],
          [2,6],
          [3,7],
          [4,8],
        ],
          :background => {
            :id => 20
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_g_mermaid_ha1"],
          2 => ["Graphics/Pictures/", "ev_g_mermaid_ha2"],
          3 => ["Graphics/Pictures/", "ev_g_mermaid_ha3"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
        ],
          :condition => {
            :type => 1,
            :id => 3325,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3317,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (General's Paizuri)",
          :common => 5441,
          :condition => {
            :type => 1,
            :id => 3325,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (General's Rape)",
          :common => 5442,
          :condition => {
            :type => 1,
            :id => 3325,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    504 => {
      :name => "Lorelei",
      :condition => {
        :type => 3,
        :id => 318
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_loreley_h1"],
          2 => ["Graphics/Pictures/", "ev_loreley_h2"],
          3 => ["Graphics/Pictures/", "ev_loreley_h3"],
          4 => ["Graphics/Pictures/", "ev_loreley_h4"],
          5 => ["Graphics/Pictures/", "ev_loreley_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 20
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3318,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Full Body Bubble Wash)",
          :common => 5446,
          :condition => {
            :type => 1,
            :id => 3326,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5447,
          :condition => {
            :type => 1,
            :id => 3326,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    505 => {
      :name => "El",
      :condition => {
        :type => 3,
        :id => 319
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_ningyohime_h1"],
          2 => ["Graphics/Pictures/", "ev_ningyohime_h2"],
          3 => ["Graphics/Pictures/", "ev_ningyohime_h3"],
          4 => ["Graphics/Pictures/", "ev_ningyohime_h4"],
          5 => ["Graphics/Pictures/", "ev_ningyohime_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 34
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3319,
          :background => {
            :id => 34
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5451,
          :condition => {
            :type => 1,
            :id => 3327,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    506 => {
      :name => "Queen Mermaid",
      :condition => {
        :type => 3,
        :id => 320
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_queenmermaid_ha1"],
          2 => ["Graphics/Pictures/", "ev_queenmermaid_ha2"],
          3 => ["Graphics/Pictures/", "ev_queenmermaid_ha3"],
          4 => ["Graphics/Pictures/", "ev_queenmermaid_ct01"],
          5 => ["Graphics/Pictures/", "ev_queenmermaid_ct02"],
          6 => ["Graphics/Pictures/", "ev_queenmermaid_ct03"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,4],
          [2,5],
          [3,6],
        ],
          :background => {
            :id => 20
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_queenmermaid_hb1"],
          2 => ["Graphics/Pictures/", "ev_queenmermaid_hb2"],
          3 => ["Graphics/Pictures/", "ev_queenmermaid_hb3"],
          4 => ["Graphics/Pictures/", "ev_queenmermaid_hb4"],
          5 => ["Graphics/Pictures/", "ev_queenmermaid_ct11"],
          6 => ["Graphics/Pictures/", "ev_queenmermaid_ct12"],
          7 => ["Graphics/Pictures/", "ev_queenmermaid_ct13"],
          8 => ["Graphics/Pictures/", "ev_queenmermaid_ct14"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,5],
          [2,6],
          [3,7],
          [4,8],
        ],
          :condition => {
            :type => 1,
            :id => 3328,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_queenmermaid_hc1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3320,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Mating Lesson)",
          :common => 5456,
          :condition => {
            :type => 1,
            :id => 3328,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5457,
          :condition => {
            :type => 1,
            :id => 3328,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Loop Event (Spanking)",
          :common => 5823,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    507 => {
      :name => "Arachnes",
      :condition => {
        :type => 3,
        :id => 321
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_arachnes_hb01"],
          2 => ["Graphics/Pictures/", "ev_arachnes_hb02"],
          3 => ["Graphics/Pictures/", "ev_arachnes_hb03"],
          4 => ["Graphics/Pictures/", "ev_arachnes_hb04"],
          5 => ["Graphics/Pictures/", "ev_arachnes_hb05"],
          6 => ["Graphics/Pictures/", "ev_arachnes_hb06"],
          7 => ["Graphics/Pictures/", "ev_arachnes_hb07"],
          8 => ["Graphics/Pictures/", "ev_arachnes_hb08"],
          9 => ["Graphics/Pictures/", "ev_arachnes_hb09"],
          10 => ["Graphics/Pictures/", "ev_arachnes_hb10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 8
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_arachnes_ha01"],
          2 => ["Graphics/Pictures/", "ev_arachnes_ha02"],
          3 => ["Graphics/Pictures/", "ev_arachnes_ha03"],
          4 => ["Graphics/Pictures/", "ev_arachnes_ha04"],
          5 => ["Graphics/Pictures/", "ev_arachnes_ha05"],
          6 => ["Graphics/Pictures/", "ev_arachnes_ha06"],
          7 => ["Graphics/Pictures/", "ev_arachnes_ha07"],
          8 => ["Graphics/Pictures/", "ev_arachnes_ha08"],
          9 => ["Graphics/Pictures/", "ev_arachnes_ha09"],
          10 => ["Graphics/Pictures/", "ev_arachnes_ha10"],
          11 => ["Graphics/Pictures/", "ev_arachnes_ct01"],
          12 => ["Graphics/Pictures/", "ev_arachnes_ct02"],
          13 => ["Graphics/Pictures/", "ev_arachnes_ct03"],
          14 => ["Graphics/Pictures/", "ev_arachnes_ct04"],
          15 => ["Graphics/Pictures/", "ev_arachnes_ct05"],
          16 => ["Graphics/Pictures/", "ev_arachnes_ct06"],
          17 => ["Graphics/Pictures/", "ev_arachnes_ct07"],
          18 => ["Graphics/Pictures/", "ev_arachnes_ct08"],
          19 => ["Graphics/Pictures/", "ev_arachnes_ct09"],
          20 => ["Graphics/Pictures/", "ev_arachnes_ct10"],
        },
        # 表示パターンの指定
        :draw => [
          [1,11],
          [2,12],
          [3,13],
          [4,14],
          [5,15],
          [6,16],
          [7,17],
          [8,18],
          [9,19],
          [10,20],
        ],
          :condition => {
            :type => 1,
            :id => 3330,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3321,
          :background => {
            :id => 8
          }
        },
        2 => {
          :name => "Request 1 (Body Wrapping Violation)",
          :common => 5466,
          :condition => {
            :type => 1,
            :id => 3330,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5467,
          :condition => {
            :type => 1,
            :id => 3330,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    508 => {
      :name => "Tsuchigumo",
      :condition => {
        :type => 3,
        :id => 324
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_tutigumo_h1"],
          2 => ["Graphics/Pictures/", "ev_tutigumo_h2"],
          3 => ["Graphics/Pictures/", "ev_tutigumo_h3"],
          4 => ["Graphics/Pictures/", "ev_tutigumo_h4"],
          5 => ["Graphics/Pictures/", "ev_tutigumo_h5"],
          6 => ["Graphics/Pictures/", "ev_tutigumo_h6"],
          7 => ["Graphics/Pictures/", "ev_tutigumo_h7"],
          8 => ["Graphics/Pictures/", "ev_tutigumo_h8"],
          9 => ["Graphics/Pictures/", "ev_tutigumo_h9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 8
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_tutigumo_st11"],
          2 => ["Graphics/Pictures/", "ev_tutigumo_ct01"],
          3 => ["Graphics/Pictures/", "ev_tutigumo_ct02"],
          4 => ["Graphics/Pictures/", "ev_tutigumo_ct03"],
          5 => ["Graphics/Pictures/", "ev_tutigumo_ct04"],
          6 => ["Graphics/Pictures/", "ev_tutigumo_ct11"],
          7 => ["Graphics/Pictures/", "ev_tutigumo_ct12"],
          8 => ["Graphics/Pictures/", "ev_tutigumo_ct13"],
          9 => ["Graphics/Pictures/", "ev_tutigumo_ct21"],
          10 => ["Graphics/Pictures/", "ev_tutigumo_ct22"],
          11 => ["Graphics/Pictures/", "ev_tutigumo_ct23"],
          12 => ["Graphics/Pictures/", "ev_tutigumo_ct24"],
          13 => ["Graphics/Pictures/", "ev_tutigumo_ct25"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
          [1,6],
          [1,7],
          [1,8],
          [1,9],
          [1,10],
          [1,11],
          [1,12],
          [1,13],
        ],
          :condition => {
            :type => 1,
            :id => 3331,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3324,
          :background => {
            :id => 8
          }
        },
        2 => {
          :name => "Request 1 (Silky Blowjob)",
          :common => 5471,
          :condition => {
            :type => 1,
            :id => 3331,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Pinching Monster Breasts)",
          :common => 5472,
          :condition => {
            :type => 1,
            :id => 3331,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Silky Frolic)",
          :common => 5473,
          :condition => {
            :type => 1,
            :id => 3331,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 4 (Male Slurping Vagina)",
          :common => 5474,
          :condition => {
            :type => 1,
            :id => 3331,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    509 => {
      :name => "Arachne Lord",
      :condition => {
        :type => 3,
        :id => 325
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alakneload_hb1"],
          2 => ["Graphics/Pictures/", "ev_alakneload_hb2"],
          3 => ["Graphics/Pictures/", "ev_alakneload_hb3"],
          4 => ["Graphics/Pictures/", "ev_alakneload_hb4"],
          5 => ["Graphics/Pictures/", "ev_alakneload_hb5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 8
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_alakneload_ha1"],
          2 => ["Graphics/Pictures/", "ev_alakneload_ha2"],
          3 => ["Graphics/Pictures/", "ev_alakneload_ha3"],
          4 => ["Graphics/Pictures/", "ev_alakneload_ha4"],
          5 => ["Graphics/Pictures/", "ev_alakneload_ha5"],
          6 => ["Graphics/Pictures/", "ev_alakneload_ha6"],
          7 => ["Graphics/Pictures/", "ev_alakneload_ha7"],
          8 => ["Graphics/Pictures/", "ev_alakneload_ha8"],
          9 => ["Graphics/Pictures/", "ev_alakneload_hc1"],
          10 => ["Graphics/Pictures/", "ev_alakneload_hc2"],
          11 => ["Graphics/Pictures/", "ev_alakneload_hc3"],
          12 => ["Graphics/Pictures/", "ev_alakneload_ct01"],
          13 => ["Graphics/Pictures/", "ev_alakneload_ct02"],
          14 => ["Graphics/Pictures/", "ev_alakneload_ct03"],
          15 => ["Graphics/Pictures/", "ev_alakneload_ct04"],
          16 => ["Graphics/Pictures/", "ev_alakneload_ct05"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [9,12],
          [10,13],
          [10,14],
          [11,15],
          [11,16],
        ],
          :condition => {
            :type => 1,
            :id => 3332,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3325,
          :background => {
            :id => 8
          }
        },
        2 => {
          :name => "Request 1 (Arachne Web)",
          :common => 5476,
          :condition => {
            :type => 1,
            :id => 3332,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Nipple Fuck)",
          :common => 5477,
          :condition => {
            :type => 1,
            :id => 3332,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Reverse Rape)",
          :common => 5478,
          :condition => {
            :type => 1,
            :id => 3332,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    510 => {
      :name => "Atlach-Nacha",
      :condition => {
        :type => 3,
        :id => 326
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_atlach_h01"],
          2 => ["Graphics/Pictures/", "ev_atlach_h02"],
          3 => ["Graphics/Pictures/", "ev_atlach_h03"],
          4 => ["Graphics/Pictures/", "ev_atlach_h04"],
          5 => ["Graphics/Pictures/", "ev_atlach_h05"],
          6 => ["Graphics/Pictures/", "ev_atlach_h06"],
          7 => ["Graphics/Pictures/", "ev_atlach_h07"],
          8 => ["Graphics/Pictures/", "ev_atlach_h08"],
          9 => ["Graphics/Pictures/", "ev_atlach_h09"],
          10 => ["Graphics/Pictures/", "ev_atlach_h10"],
          11 => ["Graphics/Pictures/", "ev_atlach_ct01"],
          12 => ["Graphics/Pictures/", "ev_atlach_ct02"],
          13 => ["Graphics/Pictures/", "ev_atlach_ct03"],
          14 => ["Graphics/Pictures/", "ev_atlach_ct04"],
          15 => ["Graphics/Pictures/", "ev_atlach_ct05"],
          16 => ["Graphics/Pictures/", "ev_atlach_ct06"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2,11],
          [3,12],
          [4,12],
          [5,13],
          [6,13],
          [7,14],
          [8,14],
          [9,15],
          [10,16],
        ],
          :background => {
            :id => 8
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3326,
          :background => {
            :id => 8
          }
        },
        2 => {
          :name => "Request 1 (Fluid Sucking)",
          :common => 5481,
          :condition => {
            :type => 1,
            :id => 3333,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Fluid Sucking...?)",
          :common => 5482,
          :condition => {
            :type => 1,
            :id => 3333,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    511 => {
      :name => "Spider Princess",
      :condition => {
        :type => 3,
        :id => 327
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kumonomiko_hb01"],
          2 => ["Graphics/Pictures/", "ev_kumonomiko_hb02"],
          3 => ["Graphics/Pictures/", "ev_kumonomiko_hb03"],
          4 => ["Graphics/Pictures/", "ev_kumonomiko_hb04"],
          5 => ["Graphics/Pictures/", "ev_kumonomiko_hb05"],
          6 => ["Graphics/Pictures/", "ev_kumonomiko_hb06"],
          7 => ["Graphics/Pictures/", "ev_kumonomiko_hb07"],
          8 => ["Graphics/Pictures/", "ev_kumonomiko_hb08"],
          9 => ["Graphics/Pictures/", "ev_kumonomiko_hb09"],
          10 => ["Graphics/Pictures/", "ev_kumonomiko_hb10"],
          11 => ["Graphics/Pictures/", "ev_kumonomiko_ct01"],
          12 => ["Graphics/Pictures/", "ev_kumonomiko_ct02"],
          13 => ["Graphics/Pictures/", "ev_kumonomiko_ct03"],
          14 => ["Graphics/Pictures/", "ev_kumonomiko_ct04"],
          15 => ["Graphics/Pictures/", "ev_kumonomiko_ct05"],
          16 => ["Graphics/Pictures/", "ev_kumonomiko_ct06"],
          17 => ["Graphics/Pictures/", "ev_kumonomiko_ct07"],
          18 => ["Graphics/Pictures/", "ev_kumonomiko_ct08"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,11],
          [2,12],
          [2,13],
          [3,14],
          [4,15],
          [5,16],
          [6,17],
          [7,18],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 8
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kumonomiko_ha1"],
          2 => ["Graphics/Pictures/", "ev_kumonomiko_ha2"],
          3 => ["Graphics/Pictures/", "ev_kumonomiko_ha3"],
          4 => ["Graphics/Pictures/", "ev_kumonomiko_ha4"],
          5 => ["Graphics/Pictures/", "ev_kumonomiko_ha5"],
          6 => ["Graphics/Pictures/", "ev_kumonomiko_ha6"],
          7 => ["Graphics/Pictures/", "ev_kumonomiko_ha7"],
          8 => ["Graphics/Pictures/", "ev_kumonomiko_ha8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :condition => {
            :type => 1,
            :id => 3334,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3327,
          :background => {
            :id => 8
          }
        },
        2 => {
          :name => "Request 1 (Arachne Thread)",
          :common => 5486,
          :condition => {
            :type => 1,
            :id => 3334,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Arachne Repro)",
          :common => 5487,
          :condition => {
            :type => 1,
            :id => 3334,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Arachne Repro...?)",
          :common => 5488,
          :condition => {
            :type => 1,
            :id => 3334,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    512 => {
      :name => "Conquista",
      :condition => {
        :type => 3,
        :id => 328
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_conquista_ha01"],
          2 => ["Graphics/Pictures/", "ev_conquista_ha02"],
          3 => ["Graphics/Pictures/", "ev_conquista_ha03"],
          4 => ["Graphics/Pictures/", "ev_conquista_ha04"],
          5 => ["Graphics/Pictures/", "ev_conquista_ha05"],
          6 => ["Graphics/Pictures/", "ev_conquista_ha06"],
          7 => ["Graphics/Pictures/", "ev_conquista_ha07"],
          8 => ["Graphics/Pictures/", "ev_conquista_ha08"],
          9 => ["Graphics/Pictures/", "ev_conquista_ha09"],
          10 => ["Graphics/Pictures/", "ev_conquista_ha10"],
          11 => ["Graphics/Pictures/", "ev_conquista_ha11"],
          12 => ["Graphics/Pictures/", "ev_conquista_ha12"],
          13 => ["Graphics/Pictures/", "ev_conquista_ha13"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
        ],
          :background => {
            :id => 40
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_conquista_hb01"],
          2 => ["Graphics/Pictures/", "ev_conquista_hb02"],
          3 => ["Graphics/Pictures/", "ev_conquista_hb03"],
          4 => ["Graphics/Pictures/", "ev_conquista_hb04"],
          5 => ["Graphics/Pictures/", "ev_conquista_hb05"],
          6 => ["Graphics/Pictures/", "ev_conquista_hb06"],
          7 => ["Graphics/Pictures/", "ev_conquista_hb07"],
          8 => ["Graphics/Pictures/", "ev_conquista_hb08"],
          9 => ["Graphics/Pictures/", "ev_conquista_hb09"],
          10 => ["Graphics/Pictures/", "ev_conquista_hb10"],
          11 => ["Graphics/Pictures/", "ev_conquista_hb11"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
        ],
          :condition => {
            :type => 1,
            :id => 3335,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3328,
          :background => {
            :id => 40
          }
        },
        2 => {
          :name => "Request 1 (Mantle Drain)",
          :common => 5491,
          :condition => {
            :type => 1,
            :id => 3335,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Mantle Drain...?)",
          :common => 5492,
          :condition => {
            :type => 1,
            :id => 3335,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Reverse Rape)",
          :common => 5493,
          :condition => {
            :type => 1,
            :id => 3335,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    513 => {
      :name => "Vendetta",
      :condition => {
        :type => 3,
        :id => 329
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_vendetta_hb1"],
          2 => ["Graphics/Pictures/", "ev_vendetta_hb2"],
          3 => ["Graphics/Pictures/", "ev_vendetta_hb3"],
          4 => ["Graphics/Pictures/", "ev_vendetta_hb4"],
          5 => ["Graphics/Pictures/", "ev_vendetta_hb5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 40
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_vendetta_ha1"],
          2 => ["Graphics/Pictures/", "ev_vendetta_ha2"],
          3 => ["Graphics/Pictures/", "ev_vendetta_ha3"],
          4 => ["Graphics/Pictures/", "ev_vendetta_ha4"],
          5 => ["Graphics/Pictures/", "ev_vendetta_ha5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 1,
            :id => 3336,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3329,
          :background => {
            :id => 40
          }
        },
        2 => {
          :name => "Request 1 (Buttjob)",
          :common => 5496,
          :condition => {
            :type => 1,
            :id => 3336,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5497,
          :condition => {
            :type => 1,
            :id => 3336,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Reverse Rape...?)",
          :common => 5498,
          :condition => {
            :type => 1,
            :id => 3336,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    514 => {
      :name => "Elder Vampire",
      :condition => {
        :type => 3,
        :id => 330
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_e_vampire_h1"],
          2 => ["Graphics/Pictures/", "ev_e_vampire_h2"],
          3 => ["Graphics/Pictures/", "ev_e_vampire_h3"],
          4 => ["Graphics/Pictures/", "ev_e_vampire_h4"],
          5 => ["Graphics/Pictures/", "ev_e_vampire_h5"],
          6 => ["Graphics/Pictures/", "ev_e_vampire_h6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 40
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3330,
          :background => {
            :id => 40
          }
        },
        2 => {
          :name => "Request 1 (Semen Sucking Tentacle)",
          :common => 5501,
          :condition => {
            :type => 1,
            :id => 3337,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Semen Sucking Tentacle...?)",
          :common => 5502,
          :condition => {
            :type => 1,
            :id => 3337,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    515 => {
      :name => "Carmilla",
      :condition => {
        :type => 3,
        :id => 331
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_carmilla_ha1"],
          2 => ["Graphics/Pictures/", "ev_carmilla_ha2"],
          3 => ["Graphics/Pictures/", "ev_carmilla_ha3"],
          4 => ["Graphics/Pictures/", "ev_carmilla_ha4"],
          5 => ["Graphics/Pictures/", "ev_carmilla_ha5"],
          6 => ["Graphics/Pictures/", "ev_carmilla_ha6"],
          7 => ["Graphics/Pictures/", "ev_carmilla_ha7"],
          8 => ["Graphics/Pictures/", "ev_carmilla_ha8"],
          9 => ["Graphics/Pictures/", "ev_carmilla_ha9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 40
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_carmilla_hb1"],
          2 => ["Graphics/Pictures/", "ev_carmilla_hb2"],
          3 => ["Graphics/Pictures/", "ev_carmilla_hb3"],
          4 => ["Graphics/Pictures/", "ev_carmilla_hb4"],
          5 => ["Graphics/Pictures/", "ev_carmilla_hb5"],
          6 => ["Graphics/Pictures/", "ev_carmilla_hb6"],
          7 => ["Graphics/Pictures/", "ev_carmilla_hb7"],
          8 => ["Graphics/Pictures/", "ev_carmilla_hb8"],
          9 => ["Graphics/Pictures/", "ev_carmilla_hb9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :condition => {
            :type => 1,
            :id => 3338,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3331,
          :background => {
            :id => 40
          }
        },
        2 => {
          :name => "Request 1 (Carmilla's Blood Sucking)",
          :common => 5506,
          :condition => {
            :type => 1,
            :id => 3338,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Carmilla's Blood Sucking...?)",
          :common => 5507,
          :condition => {
            :type => 1,
            :id => 3338,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Reverse Rape)",
          :common => 5508,
          :condition => {
            :type => 1,
            :id => 3338,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    516 => {
      :name => "Elizabeth",
      :condition => {
        :type => 3,
        :id => 332
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_elisabeth_hb1"],
          2 => ["Graphics/Pictures/", "ev_elisabeth_hb2"],
          3 => ["Graphics/Pictures/", "ev_elisabeth_hb3"],
          4 => ["Graphics/Pictures/", "ev_elisabeth_hb4"],
          5 => ["Graphics/Pictures/", "ev_elisabeth_hb5"],
          6 => ["Graphics/Pictures/", "ev_elisabeth_hb6"],
          7 => ["Graphics/Pictures/", "ev_elisabeth_hb7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 40
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_elisabeth_st02"],
          2 => ["Graphics/Pictures/", "ev_elisabeth_ct01"],
          3 => ["Graphics/Pictures/", "ev_elisabeth_ct02"],
          4 => ["Graphics/Pictures/", "ev_elisabeth_ha1"],
          5 => ["Graphics/Pictures/", "ev_elisabeth_ha2"],
          6 => ["Graphics/Pictures/", "ev_elisabeth_ha3"],
          7 => ["Graphics/Pictures/", "ev_elisabeth_ha4"],
          8 => ["Graphics/Pictures/", "ev_elisabeth_ha5"],
          9 => ["Graphics/Pictures/", "ev_elisabeth_ha6"],
          10 => ["Graphics/Pictures/", "ev_elisabeth_ha7"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :condition => {
            :type => 1,
            :id => 3339,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3332,
          :background => {
            :id => 40
          }
        },
        2 => {
          :name => "Request 1 (Semen Sucking Navel)",
          :common => 5511,
          :condition => {
            :type => 1,
            :id => 3339,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Bloodsucking Footjob)",
          :common => 5512,
          :condition => {
            :type => 1,
            :id => 3339,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Bloodsucking Footjob...?)",
          :common => 5513,
          :condition => {
            :type => 1,
            :id => 3339,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 4 (Blowjob)",
          :common => 5514,
          :condition => {
            :type => 1,
            :id => 3339,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    517 => {
      :name => "Queen Vampire",
      :condition => {
        :type => 3,
        :id => 333
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_queenvanpire_hc1"],
          2 => ["Graphics/Pictures/", "ev_queenvanpire_hc2"],
          3 => ["Graphics/Pictures/", "ev_queenvanpire_hc3"],
          4 => ["Graphics/Pictures/", "ev_queenvanpire_hc4"],
          5 => ["Graphics/Pictures/", "ev_queenvanpire_hc5"],
          6 => ["Graphics/Pictures/", "ev_queenvanpire_hc6"],
          7 => ["Graphics/Pictures/", "ev_queenvanpire_hc7"],
          8 => ["Graphics/Pictures/", "ev_queenvanpire_hc8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 39
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_queenvanpire_ha1"],
          2 => ["Graphics/Pictures/", "ev_queenvanpire_ha2"],
          3 => ["Graphics/Pictures/", "ev_queenvanpire_ha3"],
          4 => ["Graphics/Pictures/", "ev_queenvanpire_ha4"],
          5 => ["Graphics/Pictures/", "ev_queenvanpire_ha5"],
          6 => ["Graphics/Pictures/", "ev_queenvanpire_hb1"],
          7 => ["Graphics/Pictures/", "ev_queenvanpire_hb2"],
          8 => ["Graphics/Pictures/", "ev_queenvanpire_hb3"],
          9 => ["Graphics/Pictures/", "ev_queenvanpire_hb4"],
          10 => ["Graphics/Pictures/", "ev_queenvanpire_hb5"],
          11 => ["Graphics/Pictures/", "ev_queenvanpire_hb6"],
          12 => ["Graphics/Pictures/", "ev_queenvanpire_hb7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
        ],
          :condition => {
            :type => 1,
            :id => 3340,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_queenvanpire_hd1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3333,
          :background => {
            :id => 39
          }
        },
        2 => {
          :name => "Request 1 (Nocturnal Bloodsucker)",
          :common => 5516,
          :condition => {
            :type => 1,
            :id => 3340,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Lascivious Tongue)",
          :common => 5517,
          :condition => {
            :type => 1,
            :id => 3340,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Moonlight Nocturne)",
          :common => 5518,
          :condition => {
            :type => 1,
            :id => 3340,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 4 (Moonlight Nocturne...?)",
          :common => 5519,
          :condition => {
            :type => 1,
            :id => 3340,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        6 => {
          :name => "Loop Event (Bloodsucking (boy))",
          :common => 5824,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    518 => {
      :name => "Fatima of Arrogance",
      :condition => {
        :type => 3,
        :id => 921
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_queenvanpire_he01"],
          2 => ["Graphics/Pictures/", "ev_queenvanpire_he02"],
          3 => ["Graphics/Pictures/", "ev_queenvanpire_he03"],
          4 => ["Graphics/Pictures/", "ev_queenvanpire_he04"],
          5 => ["Graphics/Pictures/", "ev_queenvanpire_he05"],
          6 => ["Graphics/Pictures/", "ev_queenvanpire_he06"],
          7 => ["Graphics/Pictures/", "ev_queenvanpire_he07"],
          8 => ["Graphics/Pictures/", "ev_queenvanpire_he08"],
          9 => ["Graphics/Pictures/", "ev_queenvanpire_he09"],
          10 => ["Graphics/Pictures/", "ev_queenvanpire_he10"],
          11 => ["Graphics/Pictures/", "ev_queenvanpire_he11"],
          12 => ["Graphics/Pictures/", "ev_queenvanpire_he12"],
          13 => ["Graphics/Pictures/", "ev_queenvanpire_he13"],
          14 => ["Graphics/Pictures/", "ev_queenvanpire_he14"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
        ],
          :background => {
            :id => 40
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3921,
          :background => {
            :id => 40
          }
        },
        2 => {
          :name => "Pleasure Request 1 (Reverse Rape Death by Squeeze)",
          :common => 7721,
          :condition => {
            :type => 1,
            :id => 3340,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    519 => {
      :name => "Master Shadow",
      :condition => {
        :type => 3,
        :id => 334
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_m_shadow_h1"],
          2 => ["Graphics/Pictures/", "ev_m_shadow_h2"],
          3 => ["Graphics/Pictures/", "ev_m_shadow_h3"],
          4 => ["Graphics/Pictures/", "ev_m_shadow_h4"],
          5 => ["Graphics/Pictures/", "ev_m_shadow_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 21
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3334,
          :background => {
            :id => 21
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5526,
          :condition => {
            :type => 1,
            :id => 3342,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape...?)",
          :common => 5527,
          :condition => {
            :type => 1,
            :id => 3342,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    520 => {
      :name => "Enenra",
      :condition => {
        :type => 3,
        :id => 335
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_enenra_hb1"],
          2 => ["Graphics/Pictures/", "ev_enenra_hb2"],
          3 => ["Graphics/Pictures/", "ev_enenra_hb3"],
          4 => ["Graphics/Pictures/", "ev_enenra_hb4"],
          5 => ["Graphics/Pictures/", "ev_enenra_hb5"],
          6 => ["Graphics/Pictures/", "ev_enenra_hb6"],
          7 => ["Graphics/Pictures/", "ev_enenra_ct01"],
          8 => ["Graphics/Pictures/", "ev_enenra_ct02"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5,7],
          [6,8],
        ],
          :background => {
            :id => 21
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_enenra_ha1"],
          2 => ["Graphics/Pictures/", "ev_enenra_ha2"],
          3 => ["Graphics/Pictures/", "ev_enenra_ha3"],
          4 => ["Graphics/Pictures/", "ev_enenra_ha4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3343,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3335,
          :background => {
            :id => 21
          }
        },
        2 => {
          :name => "Request 1 (Handjob)",
          :common => 5531,
          :condition => {
            :type => 1,
            :id => 3343,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5532,
          :condition => {
            :type => 1,
            :id => 3343,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    521 => {
      :name => "Kirin",
      :condition => {
        :type => 3,
        :id => 336
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kirin_hb1"],
          2 => ["Graphics/Pictures/", "ev_kirin_hb2"],
          3 => ["Graphics/Pictures/", "ev_kirin_hb3"],
          4 => ["Graphics/Pictures/", "ev_kirin_hb4"],
          5 => ["Graphics/Pictures/", "ev_kirin_hb5"],
          6 => ["Graphics/Pictures/", "ev_kirin_hb6"],
          7 => ["Graphics/Pictures/", "ev_kirin_ct01"],
          8 => ["Graphics/Pictures/", "ev_kirin_ct02"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5,7],
          [6,8],
        ],
          :background => {
            :id => 21
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kirin_ha1"],
          2 => ["Graphics/Pictures/", "ev_kirin_ha2"],
          3 => ["Graphics/Pictures/", "ev_kirin_ha3"],
          4 => ["Graphics/Pictures/", "ev_kirin_ha4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3344,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3336,
          :background => {
            :id => 21
          }
        },
        2 => {
          :name => "Request 1 (Electric Footjob)",
          :common => 5536,
          :condition => {
            :type => 1,
            :id => 3344,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5537,
          :condition => {
            :type => 1,
            :id => 3344,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    522 => {
      :name => "Jakotsu-Onna",
      :condition => {
        :type => 3,
        :id => 337
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_zyakotuonna_h1"],
          2 => ["Graphics/Pictures/", "ev_zyakotuonna_h2"],
          3 => ["Graphics/Pictures/", "ev_zyakotuonna_h3"],
          4 => ["Graphics/Pictures/", "ev_zyakotuonna_h4"],
          5 => ["Graphics/Pictures/", "ev_zyakotuonna_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 21
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3337,
          :background => {
            :id => 21
          }
        },
        2 => {
          :name => "Request 1 (Snake Teasing)",
          :common => 5541,
          :condition => {
            :type => 1,
            :id => 3345,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    523 => {
      :name => "Behemoth",
      :condition => {
        :type => 3,
        :id => 338
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_behemoth_st02"],
          2 => ["Graphics/Pictures/", "ev_behemoth_ct01"],
          3 => ["Graphics/Pictures/", "ev_behemoth_ct02"],
          4 => ["Graphics/Pictures/", "ev_behemoth_ct03"],
          5 => ["Graphics/Pictures/", "ev_behemoth_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
        ],
          :background => {
            :id => 18
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3338,
          :background => {
            :id => 18
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5546,
          :condition => {
            :type => 1,
            :id => 3346,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    524 => {
      :name => "Wyvern",
      :condition => {
        :type => 3,
        :id => 339
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_wyvern_st02"],
          2 => ["Graphics/Pictures/", "ev_wyvern_ct01"],
          3 => ["Graphics/Pictures/", "ev_wyvern_ct02"],
          4 => ["Graphics/Pictures/", "ev_wyvern_ct03"],
          5 => ["Graphics/Pictures/", "ev_wyvern_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
        ],
          :background => {
            :id => 18
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3339,
          :background => {
            :id => 18
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5551,
          :condition => {
            :type => 1,
            :id => 3347,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape...?)",
          :common => 5552,
          :condition => {
            :type => 1,
            :id => 3347,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    525 => {
      :name => "Kyoryuu",
      :condition => {
        :type => 3,
        :id => 340
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kyoryuu_st11"],
          2 => ["Graphics/Pictures/", "ev_kyoryuu_st12"],
          3 => ["Graphics/Pictures/", "ev_kyoryuu_ct01"],
          4 => ["Graphics/Pictures/", "ev_kyoryuu_ct02"],
          5 => ["Graphics/Pictures/", "ev_kyoryuu_ct03"],
          6 => ["Graphics/Pictures/", "ev_kyoryuu_ct04"],
          7 => ["Graphics/Pictures/", "ev_kyoryuu_ct05"],
          8 => ["Graphics/Pictures/", "ev_kyoryuu_ct06"],
        },
        # 表示パターンの指定
        :draw => [
          [1,3],
          [1,4],
          [1,5],
          [2,6],
          [2,7],
          [2,8],
        ],
          :background => {
            :id => 18
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_kyoryuu_hb1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3340,
          :background => {
            :id => 18
          }
        },
        2 => {
          :name => "Request 1 (Swallow)",
          :common => 5556,
          :condition => {
            :type => 1,
            :id => 3348,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Swallow...?)",
          :common => 5557,
          :condition => {
            :type => 1,
            :id => 3348,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Loop Event (Crushing)",
          :common => 5813,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    526 => {
      :name => "Succubus Monk",
      :condition => {
        :type => 3,
        :id => 341
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_monk_sucubuss_h01"],
          2 => ["Graphics/Pictures/", "ev_monk_sucubuss_h02"],
          3 => ["Graphics/Pictures/", "ev_monk_sucubuss_h03"],
          4 => ["Graphics/Pictures/", "ev_monk_sucubuss_h04"],
          5 => ["Graphics/Pictures/", "ev_monk_sucubuss_h05"],
          6 => ["Graphics/Pictures/", "ev_monk_sucubuss_h06"],
          7 => ["Graphics/Pictures/", "ev_monk_sucubuss_h07"],
          8 => ["Graphics/Pictures/", "ev_monk_sucubuss_h08"],
          9 => ["Graphics/Pictures/", "ev_monk_sucubuss_h09"],
          10 => ["Graphics/Pictures/", "ev_monk_sucubuss_h10"],
          11 => ["Graphics/Pictures/", "ev_monk_sucubuss_h11"],
          12 => ["Graphics/Pictures/", "ev_monk_sucubuss_h12"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
        ],
          :background => {
            :id => 41
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3341,
          :background => {
            :id => 41
          }
        },
        2 => {
          :name => "Request 1 (Restraining Handjob)",
          :common => 5561,
          :condition => {
            :type => 1,
            :id => 3349,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    527 => {
      :name => "Demon Monk",
      :condition => {
        :type => 3,
        :id => 342
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_monk_demon_h1"],
          2 => ["Graphics/Pictures/", "ev_monk_demon_h2"],
          3 => ["Graphics/Pictures/", "ev_monk_demon_h3"],
          4 => ["Graphics/Pictures/", "ev_monk_demon_h4"],
          5 => ["Graphics/Pictures/", "ev_monk_demon_h5"],
          6 => ["Graphics/Pictures/", "ev_monk_demon_h6"],
          7 => ["Graphics/Pictures/", "ev_monk_demon_h7"],
          8 => ["Graphics/Pictures/", "ev_monk_demon_h8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 41
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3342,
          :background => {
            :id => 41
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5566,
          :condition => {
            :type => 1,
            :id => 3350,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    528 => {
      :name => "Scylla Servant",
      :condition => {
        :type => 3,
        :id => 343
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_scylla_s_ha01"],
          2 => ["Graphics/Pictures/", "ev_scylla_s_ha02"],
          3 => ["Graphics/Pictures/", "ev_scylla_s_ha03"],
          4 => ["Graphics/Pictures/", "ev_scylla_s_ha04"],
          5 => ["Graphics/Pictures/", "ev_scylla_s_ha05"],
          6 => ["Graphics/Pictures/", "ev_scylla_s_ha06"],
          7 => ["Graphics/Pictures/", "ev_scylla_s_ha07"],
          8 => ["Graphics/Pictures/", "ev_scylla_s_ha08"],
          9 => ["Graphics/Pictures/", "ev_scylla_s_ha09"],
          10 => ["Graphics/Pictures/", "ev_scylla_s_ha10"],
          11 => ["Graphics/Pictures/", "ev_scylla_s_ha11"],
          12 => ["Graphics/Pictures/", "ev_scylla_s_ha12"],
          13 => ["Graphics/Pictures/", "ev_scylla_s_ha13"],
          14 => ["Graphics/Pictures/", "ev_scylla_s_ha14"],
          15 => ["Graphics/Pictures/", "ev_scylla_s_ha15"],
          16 => ["Graphics/Pictures/", "ev_scylla_s_ha16"],
          17 => ["Graphics/Pictures/", "ev_scylla_s_ha17"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
        ],
          :background => {
            :id => 41
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_scylla_s_hb01"],
          2 => ["Graphics/Pictures/", "ev_scylla_s_hb02"],
          3 => ["Graphics/Pictures/", "ev_scylla_s_hb03"],
          4 => ["Graphics/Pictures/", "ev_scylla_s_hb04"],
          5 => ["Graphics/Pictures/", "ev_scylla_s_hb05"],
          6 => ["Graphics/Pictures/", "ev_scylla_s_hb06"],
          7 => ["Graphics/Pictures/", "ev_scylla_s_hb07"],
          8 => ["Graphics/Pictures/", "ev_scylla_s_hb08"],
          9 => ["Graphics/Pictures/", "ev_scylla_s_hb09"],
          10 => ["Graphics/Pictures/", "ev_scylla_s_hb10"],
          11 => ["Graphics/Pictures/", "ev_scylla_s_hb11"],
          12 => ["Graphics/Pictures/", "ev_scylla_s_hb12"],
          13 => ["Graphics/Pictures/", "ev_scylla_s_hb13"],
          14 => ["Graphics/Pictures/", "ev_scylla_s_hb14"],
          15 => ["Graphics/Pictures/", "ev_scylla_s_hb15"],
          16 => ["Graphics/Pictures/", "ev_scylla_s_hb16"],
          17 => ["Graphics/Pictures/", "ev_scylla_s_hb17"],
          18 => ["Graphics/Pictures/", "ev_scylla_s_hb18"],
          19 => ["Graphics/Pictures/", "ev_scylla_s_hb19"],
          20 => ["Graphics/Pictures/", "ev_scylla_s_hb20"],
          21 => ["Graphics/Pictures/", "ev_scylla_s_hb21"],
          22 => ["Graphics/Pictures/", "ev_scylla_s_hb22"],
          23 => ["Graphics/Pictures/", "ev_scylla_s_hb23"],
          24 => ["Graphics/Pictures/", "ev_scylla_s_hb24"],
          25 => ["Graphics/Pictures/", "ev_scylla_s_hb25"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
        ],
          :condition => {
            :type => 1,
            :id => 3351,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3343,
          :background => {
            :id => 41
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5571,
          :condition => {
            :type => 1,
            :id => 3351,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Sex Tape)",
          :common => 5572,
          :condition => {
            :type => 1,
            :id => 3351,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    529 => {
      :name => "Vouivre",
      :condition => {
        :type => 3,
        :id => 344
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_vouivre_hb1"],
          2 => ["Graphics/Pictures/", "ev_vouivre_hb2"],
          3 => ["Graphics/Pictures/", "ev_vouivre_hb3"],
          4 => ["Graphics/Pictures/", "ev_vouivre_hb4"],
          5 => ["Graphics/Pictures/", "ev_vouivre_hb5"],
          6 => ["Graphics/Pictures/", "ev_vouivre_hb6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 41
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_vouivre_ha1"],
          2 => ["Graphics/Pictures/", "ev_vouivre_ha2"],
          3 => ["Graphics/Pictures/", "ev_vouivre_ha3"],
          4 => ["Graphics/Pictures/", "ev_vouivre_ha4"],
          5 => ["Graphics/Pictures/", "ev_vouivre_ha5"],
          6 => ["Graphics/Pictures/", "ev_vouivre_ha6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3352,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3344,
          :background => {
            :id => 41
          }
        },
        2 => {
          :name => "Request 1 (Blowjob)",
          :common => 5576,
          :condition => {
            :type => 1,
            :id => 3352,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5577,
          :condition => {
            :type => 1,
            :id => 3352,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    530 => {
      :name => "Ice Witch",
      :condition => {
        :type => 3,
        :id => 351
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_icemaze_h1"],
          2 => ["Graphics/Pictures/", "ev_icemaze_h2"],
          3 => ["Graphics/Pictures/", "ev_icemaze_h3"],
          4 => ["Graphics/Pictures/", "ev_icemaze_h4"],
          5 => ["Graphics/Pictures/", "ev_icemaze_h5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 23
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3351,
          :background => {
            :id => 23
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5581,
          :condition => {
            :type => 1,
            :id => 3353,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape...?)",
          :common => 5582,
          :condition => {
            :type => 1,
            :id => 3353,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    531 => {
      :name => "Polar Bear Girl",
      :condition => {
        :type => 3,
        :id => 352
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_shirokuma_h1"],
          2 => ["Graphics/Pictures/", "ev_shirokuma_h2"],
          3 => ["Graphics/Pictures/", "ev_shirokuma_h3"],
          4 => ["Graphics/Pictures/", "ev_shirokuma_h4"],
          5 => ["Graphics/Pictures/", "ev_shirokuma_ct01"],
          6 => ["Graphics/Pictures/", "ev_shirokuma_ct02"],
          7 => ["Graphics/Pictures/", "ev_shirokuma_ct03"],
          8 => ["Graphics/Pictures/", "ev_shirokuma_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,5],
          [2,6],
          [3,7],
          [4,8],
        ],
          :background => {
            :id => 23
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3352,
          :background => {
            :id => 23
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5586,
          :condition => {
            :type => 1,
            :id => 3354,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    532 => {
      :name => "Angel Soldiers",
      :condition => {
        :type => 3,
        :id => 353
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_angels_h01"],
          2 => ["Graphics/Pictures/", "ev_angels_h02"],
          3 => ["Graphics/Pictures/", "ev_angels_h03"],
          4 => ["Graphics/Pictures/", "ev_angels_h04"],
          5 => ["Graphics/Pictures/", "ev_angels_h05"],
          6 => ["Graphics/Pictures/", "ev_angels_h06"],
          7 => ["Graphics/Pictures/", "ev_angels_h07"],
          8 => ["Graphics/Pictures/", "ev_angels_h08"],
          9 => ["Graphics/Pictures/", "ev_angels_h09"],
          10 => ["Graphics/Pictures/", "ev_angels_h10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 23
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3353,
          :background => {
            :id => 23
          }
        },
        2 => {
          :name => "Request 1 (Group Paizuri)",
          :common => 5591,
          :condition => {
            :type => 1,
            :id => 3355,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    533 => {
      :name => "Trinity",
      :condition => {
        :type => 3,
        :id => 358
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_trinity_hb1"],
          2 => ["Graphics/Pictures/", "ev_trinity_hb2"],
          3 => ["Graphics/Pictures/", "ev_trinity_hb3"],
          4 => ["Graphics/Pictures/", "ev_trinity_hb4"],
          5 => ["Graphics/Pictures/", "ev_trinity_hb5"],
          6 => ["Graphics/Pictures/", "ev_trinity_hb6"],
          7 => ["Graphics/Pictures/", "ev_trinity_hb7"],
          8 => ["Graphics/Pictures/", "ev_trinity_hb8"],
          9 => ["Graphics/Pictures/", "ev_trinity_hb9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 15
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_trinity_ha1"],
          2 => ["Graphics/Pictures/", "ev_trinity_ha2"],
          3 => ["Graphics/Pictures/", "ev_trinity_ha3"],
          4 => ["Graphics/Pictures/", "ev_trinity_ha4"],
          5 => ["Graphics/Pictures/", "ev_trinity_ha5"],
          6 => ["Graphics/Pictures/", "ev_trinity_ha6"],
          7 => ["Graphics/Pictures/", "ev_trinity_ct01"],
          8 => ["Graphics/Pictures/", "ev_trinity_ct02"],
          9 => ["Graphics/Pictures/", "ev_trinity_ct03"],
          10 => ["Graphics/Pictures/", "ev_trinity_ct04"],
          11 => ["Graphics/Pictures/", "ev_trinity_ct05"],
          12 => ["Graphics/Pictures/", "ev_trinity_ct06"],
          13 => ["Graphics/Pictures/", "ev_trinity_ct07"],
          14 => ["Graphics/Pictures/", "ev_trinity_ct08"],
        },
        # 表示パターンの指定
        :draw => [
          [1,7],
          [2,8],
          [2,9],
          [3,10],
          [4,11],
          [4,12],
          [5,13],
          [6,14],
        ],
          :condition => {
            :type => 1,
            :id => 3356,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3358,
          :background => {
            :id => 15
          }
        },
        2 => {
          :name => "Request 1 (Ascending Paizuri)",
          :common => 5596,
          :condition => {
            :type => 1,
            :id => 3356,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Cross of Pleasure)",
          :common => 5597,
          :condition => {
            :type => 1,
            :id => 3356,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    534 => {
      :name => "Uranus",
      :condition => {
        :type => 3,
        :id => 361
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_uranus_h1"],
          2 => ["Graphics/Pictures/", "ev_uranus_h2"],
          3 => ["Graphics/Pictures/", "ev_uranus_h3"],
          4 => ["Graphics/Pictures/", "ev_uranus_h4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 15
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3361,
          :background => {
            :id => 15
          }
        },
        2 => {
          :name => "Request 1 (Semen Sucking Predation)",
          :common => 5601,
          :condition => {
            :type => 1,
            :id => 3357,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Semen Sucking Predation...?)",
          :common => 5602,
          :condition => {
            :type => 1,
            :id => 3357,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    535 => {
      :name => "Eliciel",
      :condition => {
        :type => 3,
        :id => 362
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_ediniel_h1"],
          2 => ["Graphics/Pictures/", "ev_ediniel_h2"],
          3 => ["Graphics/Pictures/", "ev_ediniel_h3"],
          4 => ["Graphics/Pictures/", "ev_ediniel_h4"],
          5 => ["Graphics/Pictures/", "ev_ediniel_h5"],
          6 => ["Graphics/Pictures/", "ev_ediniel_h6"],
          7 => ["Graphics/Pictures/", "ev_ediniel_h7"],
          8 => ["Graphics/Pictures/", "ev_ediniel_h8"],
          9 => ["Graphics/Pictures/", "ev_ediniel_h9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 15
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3362,
          :background => {
            :id => 15
          }
        },
        2 => {
          :name => "Request 1 (Semen Sucking Assimilation)",
          :common => 5606,
          :condition => {
            :type => 1,
            :id => 3358,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Semen Sucking Assimilation...?)",
          :common => 5607,
          :condition => {
            :type => 1,
            :id => 3358,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    536 => {
      :name => "Cupid",
      :condition => {
        :type => 3,
        :id => 363
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cupid_ha1"],
          2 => ["Graphics/Pictures/", "ev_cupid_ha2"],
          3 => ["Graphics/Pictures/", "ev_cupid_ha3"],
          4 => ["Graphics/Pictures/", "ev_cupid_ha4"],
          5 => ["Graphics/Pictures/", "ev_cupid_ha5"],
          6 => ["Graphics/Pictures/", "ev_cupid_ha6"],
          7 => ["Graphics/Pictures/", "ev_cupid_ha7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 24
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cupid_hb1"],
          2 => ["Graphics/Pictures/", "ev_cupid_hb2"],
          3 => ["Graphics/Pictures/", "ev_cupid_hb3"],
          4 => ["Graphics/Pictures/", "ev_cupid_hb4"],
          5 => ["Graphics/Pictures/", "ev_cupid_hb5"],
          6 => ["Graphics/Pictures/", "ev_cupid_hb6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3359,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3363,
          :background => {
            :id => 24
          }
        },
        2 => {
          :name => "Request 1 (Paizuri Temptation)",
          :common => 5611,
          :condition => {
            :type => 1,
            :id => 3359,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Love Angel's Lust)",
          :common => 5612,
          :condition => {
            :type => 1,
            :id => 3359,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    537 => {
      :name => "Valkyrie",
      :condition => {
        :type => 3,
        :id => 364
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_valkyrie_ha1"],
          2 => ["Graphics/Pictures/", "ev_valkyrie_ha2"],
          3 => ["Graphics/Pictures/", "ev_valkyrie_ha3"],
          4 => ["Graphics/Pictures/", "ev_valkyrie_ha4"],
          5 => ["Graphics/Pictures/", "ev_valkyrie_ha5"],
          6 => ["Graphics/Pictures/", "ev_valkyrie_ha6"],
          7 => ["Graphics/Pictures/", "ev_valkyrie_ha7"],
          8 => ["Graphics/Pictures/", "ev_valkyrie_ha8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 24
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_valkyrie_hb1"],
          2 => ["Graphics/Pictures/", "ev_valkyrie_hb2"],
          3 => ["Graphics/Pictures/", "ev_valkyrie_hb3"],
          4 => ["Graphics/Pictures/", "ev_valkyrie_hb4"],
          5 => ["Graphics/Pictures/", "ev_valkyrie_hb5"],
          6 => ["Graphics/Pictures/", "ev_valkyrie_hb6"],
          7 => ["Graphics/Pictures/", "ev_valkyrie_hb7"],
          8 => ["Graphics/Pictures/", "ev_valkyrie_hc1"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3364,
          :background => {
            :id => 24
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5616,
          :condition => {
            :type => 1,
            :id => 3360,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Loop Event (Sexual Training)",
          :common => 5830,
          :condition => {
            :type => 0,
            :id => :roopend
          },
          :background => {
            :id => 77
          }
        }
      }
    },
    538 => {
      :name => "Heriel",
      :condition => {
        :type => 3,
        :id => 366
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_heriel_hc1"],
          2 => ["Graphics/Pictures/", "ev_heriel_hc2"],
          3 => ["Graphics/Pictures/", "ev_heriel_hc3"],
          4 => ["Graphics/Pictures/", "ev_heriel_hc4"],
          5 => ["Graphics/Pictures/", "ev_heriel_hc5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 69
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_heriel_ha1"],
          2 => ["Graphics/Pictures/", "ev_heriel_ha2"],
          3 => ["Graphics/Pictures/", "ev_heriel_ha3"],
          4 => ["Graphics/Pictures/", "ev_heriel_ha4"],
          5 => ["Graphics/Pictures/", "ev_heriel_hb1"],
          6 => ["Graphics/Pictures/", "ev_heriel_hb2"],
          7 => ["Graphics/Pictures/", "ev_heriel_hb3"],
          8 => ["Graphics/Pictures/", "ev_heriel_hb4"],
          9 => ["Graphics/Pictures/", "ev_heriel_hd1"],
          10 => ["Graphics/Pictures/", "ev_heriel_hd2"],
          11 => ["Graphics/Pictures/", "ev_heriel_hd3"],
          12 => ["Graphics/Pictures/", "ev_heriel_hd4"],
          13 => ["Graphics/Pictures/", "ev_heriel_hd5"],
          14 => ["Graphics/Pictures/", "ev_heriel_hd6"],
          15 => ["Graphics/Pictures/", "ev_heriel_hd7"],
          16 => ["Graphics/Pictures/", "ev_heriel_hd8"],
          17 => ["Graphics/Pictures/", "ev_heriel_hd9"],
          18 => ["Graphics/Pictures/", "ev_heriel_ct01"],
          19 => ["Graphics/Pictures/", "ev_heriel_ct02"],
          20 => ["Graphics/Pictures/", "ev_heriel_ct03"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2,18],
          [3,19],
          [3,20],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
        ],
          :condition => {
            :type => 1,
            :id => 3361,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3366,
          :background => {
            :id => 69
          }
        },
        2 => {
          :name => "Request 1 (Handjob)",
          :common => 5621,
          :condition => {
            :type => 1,
            :id => 3361,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Blowjob)",
          :common => 5622,
          :condition => {
            :type => 1,
            :id => 3361,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Restraining Hairjob)",
          :common => 5623,
          :condition => {
            :type => 1,
            :id => 3361,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 4 (Semen Sucking Restraint)",
          :common => 5624,
          :condition => {
            :type => 1,
            :id => 3361,
            :op => 1,
            :value => 70
          },
          :background => {
            :id => 1
          }
        },
        6 => {
          :name => "Request 5 (Reverse Rape)",
          :common => 5625,
          :condition => {
            :type => 1,
            :id => 3361,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    539 => {
      :name => "Alciel",
      :condition => {
        :type => 3,
        :id => 367
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_arusiel_ha1"],
          2 => ["Graphics/Pictures/", "ev_arusiel_ha2"],
          3 => ["Graphics/Pictures/", "ev_arusiel_ha3"],
          4 => ["Graphics/Pictures/", "ev_arusiel_ha4"],
          5 => ["Graphics/Pictures/", "ev_arusiel_ha5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 69
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_arusiel_st01"],
          2 => ["Graphics/Pictures/", "ev_arusiel_ct01"],
          3 => ["Graphics/Pictures/", "ev_arusiel_ct02"],
          4 => ["Graphics/Pictures/", "ev_arusiel_ct03"],
          5 => ["Graphics/Pictures/", "ev_arusiel_hb1"],
          6 => ["Graphics/Pictures/", "ev_arusiel_hb2"],
          7 => ["Graphics/Pictures/", "ev_arusiel_hb3"],
          8 => ["Graphics/Pictures/", "ev_arusiel_hb4"],
          9 => ["Graphics/Pictures/", "ev_arusiel_hb5"],
          10 => ["Graphics/Pictures/", "ev_arusiel_hb6"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :condition => {
            :type => 1,
            :id => 3362,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3367,
          :background => {
            :id => 69
          }
        },
        2 => {
          :name => "Request 1 (Feminine Teasing)",
          :common => 5626,
          :condition => {
            :type => 1,
            :id => 3362,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Semen Squeezing Giant Tongue)",
          :common => 5627,
          :condition => {
            :type => 1,
            :id => 3362,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Semen Squeezing Giant Tongue...?)",
          :common => 5628,
          :condition => {
            :type => 1,
            :id => 3362,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    540 => {
      :name => "Chimera Beast",
      :condition => {
        :type => 3,
        :id => 373
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_c_beast_h1"],
          2 => ["Graphics/Pictures/", "ev_c_beast_h2"],
          3 => ["Graphics/Pictures/", "ev_c_beast_h3"],
          4 => ["Graphics/Pictures/", "ev_c_beast_h4"],
          5 => ["Graphics/Pictures/", "ev_c_beast_h5"],
          6 => ["Graphics/Pictures/", "ev_c_beast_h6"],
          7 => ["Graphics/Pictures/", "ev_c_beast_ct01"],
          8 => ["Graphics/Pictures/", "ev_c_beast_ct02"],
          9 => ["Graphics/Pictures/", "ev_c_beast_ct03"],
          10 => ["Graphics/Pictures/", "ev_c_beast_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [4,7],
          [5,8],
          [6,9],
          [6,10],
        ],
          :background => {
            :id => 12
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_c_beast_st01"],
          2 => ["Graphics/Pictures/", "ev_c_beast_ct11"],
          3 => ["Graphics/Pictures/", "ev_c_beast_ct12"],
          4 => ["Graphics/Pictures/", "ev_c_beast_ct13"],
          5 => ["Graphics/Pictures/", "ev_c_beast_ct14"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [1,4],
          [1,5],
        ],
          :condition => {
            :type => 1,
            :id => 3363,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3373,
          :background => {
            :id => 12
          }
        },
        2 => {
          :name => "Request 1 (Rape Assault)",
          :common => 5631,
          :condition => {
            :type => 1,
            :id => 3363,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Rape Assault...?)",
          :common => 5632,
          :condition => {
            :type => 1,
            :id => 3363,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    541 => {
      :name => "S-2",
      :condition => {
        :type => 3,
        :id => 374
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_c_s2_ha1"],
          2 => ["Graphics/Pictures/", "ev_c_s2_ha2"],
          3 => ["Graphics/Pictures/", "ev_c_s2_ha3"],
          4 => ["Graphics/Pictures/", "ev_c_s2_ha4"],
          5 => ["Graphics/Pictures/", "ev_c_s2_ha5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 12
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_c_s2_hb1"],
          2 => ["Graphics/Pictures/", "ev_c_s2_hb2"],
          3 => ["Graphics/Pictures/", "ev_c_s2_hb3"],
          4 => ["Graphics/Pictures/", "ev_c_s2_hb4"],
          5 => ["Graphics/Pictures/", "ev_c_s2_ct01"],
          6 => ["Graphics/Pictures/", "ev_c_s2_ct02"],
          7 => ["Graphics/Pictures/", "ev_c_s2_ct03"],
          8 => ["Graphics/Pictures/", "ev_c_s2_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,5],
          [2,6],
          [3,7],
          [4,8],
        ],
          :condition => {
            :type => 1,
            :id => 3364,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3374,
          :background => {
            :id => 12
          }
        },
        2 => {
          :name => "Request 1 (Bubble Heaven)",
          :common => 5636,
          :condition => {
            :type => 1,
            :id => 3364,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Semen Sucking Tentacle)",
          :common => 5637,
          :condition => {
            :type => 1,
            :id => 3364,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    542 => {
      :name => "A-3",
      :condition => {
        :type => 3,
        :id => 375
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_c_a3_ha1"],
          2 => ["Graphics/Pictures/", "ev_c_a3_ha2"],
          3 => ["Graphics/Pictures/", "ev_c_a3_ha3"],
          4 => ["Graphics/Pictures/", "ev_c_a3_ha4"],
          5 => ["Graphics/Pictures/", "ev_c_a3_ha5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 12
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_c_a3_hb1"],
          2 => ["Graphics/Pictures/", "ev_c_a3_hb2"],
          3 => ["Graphics/Pictures/", "ev_c_a3_hb3"],
          4 => ["Graphics/Pictures/", "ev_c_a3_hb4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3365,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3375,
          :background => {
            :id => 12
          }
        },
        2 => {
          :name => "Request 1 (Immoral Blowjob)",
          :common => 5641,
          :condition => {
            :type => 1,
            :id => 3365,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Immoral Blowjob...?)",
          :common => 5642,
          :condition => {
            :type => 1,
            :id => 3365,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Semen Squeezing Slime)",
          :common => 5643,
          :condition => {
            :type => 1,
            :id => 3365,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    543 => {
      :name => "AD-5",
      :condition => {
        :type => 3,
        :id => 376
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_AD-5_h1"],
          2 => ["Graphics/Pictures/", "ev_AD-5_h2"],
          3 => ["Graphics/Pictures/", "ev_AD-5_h3"],
          4 => ["Graphics/Pictures/", "ev_AD-5_h4"],
          5 => ["Graphics/Pictures/", "ev_AD-5_h5"],
          6 => ["Graphics/Pictures/", "ev_AD-5_ct01"],
          7 => ["Graphics/Pictures/", "ev_AD-5_ct02"],
          8 => ["Graphics/Pictures/", "ev_AD-5_ct03"],
          9 => ["Graphics/Pictures/", "ev_AD-5_ct04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [4,6],
          [5,7],
          [5,8],
          [5,9],
        ],
          :background => {
            :id => 12
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3376,
          :background => {
            :id => 12
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5646,
          :condition => {
            :type => 1,
            :id => 3366,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    544 => {
      :name => "Q-5",
      :condition => {
        :type => 3,
        :id => 377
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_q_5_h1"],
          2 => ["Graphics/Pictures/", "ev_q_5_h2"],
          3 => ["Graphics/Pictures/", "ev_q_5_h3"],
          4 => ["Graphics/Pictures/", "ev_q_5_h4"],
          5 => ["Graphics/Pictures/", "ev_q_5_ct01"],
          6 => ["Graphics/Pictures/", "ev_q_5_ct02"],
          7 => ["Graphics/Pictures/", "ev_q_5_ct03"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,5],
          [2,6],
          [3,7],
          [4,7],
        ],
          :background => {
            :id => 12
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_q_5_h1"],
          2 => ["Graphics/Pictures/", "ev_q_5_h2"],
          3 => ["Graphics/Pictures/", "ev_q_5_h3"],
          4 => ["Graphics/Pictures/", "ev_q_5_h4"],
          5 => ["Graphics/Pictures/", "ev_q_5_ct11"],
          6 => ["Graphics/Pictures/", "ev_q_5_ct12"],
          7 => ["Graphics/Pictures/", "ev_q_5_ct13"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,5],
          [2,6],
          [3,7],
          [4,7],
        ],
          :condition => {
            :type => 1,
            :id => 3367,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3377,
          :background => {
            :id => 12
          }
        },
        2 => {
          :name => "Request 1 (Tentacle Embrace)",
          :common => 5651,
          :condition => {
            :type => 1,
            :id => 3367,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    545 => {
      :name => "Fernandez",
      :condition => {
        :type => 3,
        :id => 572
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cirque_hg1"],
          2 => ["Graphics/Pictures/", "ev_cirque_hg2"],
          3 => ["Graphics/Pictures/", "ev_cirque_hg3"],
          4 => ["Graphics/Pictures/", "ev_cirque_hg7"],
          5 => ["Graphics/Pictures/", "ev_cirque_hg8"],
          6 => ["Graphics/Pictures/", "ev_cirque_hg9"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3369,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cirque_hg1"],
          2 => ["Graphics/Pictures/", "ev_cirque_hg2"],
          3 => ["Graphics/Pictures/", "ev_cirque_hg3"],
          4 => ["Graphics/Pictures/", "ev_cirque_hg4"],
          5 => ["Graphics/Pictures/", "ev_cirque_hg5"],
          6 => ["Graphics/Pictures/", "ev_cirque_hg6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 65
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3572,
          :background => {
            :id => 65
          }
        },
        2 => {
          :name => "Request 1 (Anal)",
          :common => 5659,
          :condition => {
            :type => 1,
            :id => 3369,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5660,
          :condition => {
            :type => 1,
            :id => 3369,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    546 => {
      :name => "Fernandez (Zombie)",
      :condition => {
        :type => 3,
        :id => 378
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cirque_h01"],
          2 => ["Graphics/Pictures/", "ev_cirque_h02"],
          3 => ["Graphics/Pictures/", "ev_cirque_h03"],
          4 => ["Graphics/Pictures/", "ev_cirque_h04"],
          5 => ["Graphics/Pictures/", "ev_cirque_h05"],
          6 => ["Graphics/Pictures/", "ev_cirque_h06"],
          7 => ["Graphics/Pictures/", "ev_cirque_h07"],
          8 => ["Graphics/Pictures/", "ev_cirque_h08"],
          9 => ["Graphics/Pictures/", "ev_cirque_h09"],
          10 => ["Graphics/Pictures/", "ev_cirque_h10"],
          11 => ["Graphics/Pictures/", "ev_cirque_h11"],
          12 => ["Graphics/Pictures/", "ev_cirque_h12"],
          13 => ["Graphics/Pictures/", "ev_cirque_h13"],
          14 => ["Graphics/Pictures/", "ev_cirque_h14"],
          15 => ["Graphics/Pictures/", "ev_cirque_h15"],
          16 => ["Graphics/Pictures/", "ev_cirque_h16"],
          17 => ["Graphics/Pictures/", "ev_cirque_h17"],
          18 => ["Graphics/Pictures/", "ev_cirque_h18"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
        ],
          :background => {
            :id => 56
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_cirque_st02"],
          2 => ["Graphics/Pictures/", "ev_cirque_ct01"],
          3 => ["Graphics/Pictures/", "ev_cirque_ct02"],
          4 => ["Graphics/Pictures/", "ev_cirque_ha01"],
          5 => ["Graphics/Pictures/", "ev_cirque_ha02"],
          6 => ["Graphics/Pictures/", "ev_cirque_ha03"],
          7 => ["Graphics/Pictures/", "ev_cirque_ha04"],
          8 => ["Graphics/Pictures/", "ev_cirque_ha05"],
          9 => ["Graphics/Pictures/", "ev_cirque_ha06"],
          10 => ["Graphics/Pictures/", "ev_cirque_ha07"],
          11 => ["Graphics/Pictures/", "ev_cirque_ha08"],
          12 => ["Graphics/Pictures/", "ev_cirque_ha09"],
          13 => ["Graphics/Pictures/", "ev_cirque_ha10"],
          14 => ["Graphics/Pictures/", "ev_cirque_ha11"],
          15 => ["Graphics/Pictures/", "ev_cirque_ha12"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
        ],
          :condition => {
            :type => 1,
            :id => 3368,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3378,
          :background => {
            :id => 56
          }
        },
        2 => {
          :name => "Request 1 (Buttjob)",
          :common => 5656,
          :condition => {
            :type => 1,
            :id => 3368,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape 1)",
          :common => 5657,
          :condition => {
            :type => 1,
            :id => 3368,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Reverse Rape 2)",
          :common => 5658,
          :condition => {
            :type => 1,
            :id => 3368,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    547 => {
      :name => "Titania",
      :condition => {
        :type => 3,
        :id => 618
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cirque_hh01"],
          2 => ["Graphics/Pictures/", "ev_cirque_hh02"],
          3 => ["Graphics/Pictures/", "ev_cirque_hh03"],
          4 => ["Graphics/Pictures/", "ev_cirque_hh04"],
          5 => ["Graphics/Pictures/", "ev_cirque_hh05"],
          6 => ["Graphics/Pictures/", "ev_cirque_hh06"],
          7 => ["Graphics/Pictures/", "ev_cirque_hh07"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 91
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cirque_hh01"],
          2 => ["Graphics/Pictures/", "ev_cirque_hh09"],
          3 => ["Graphics/Pictures/", "ev_cirque_hh10"],
          4 => ["Graphics/Pictures/", "ev_cirque_hh11"],
          5 => ["Graphics/Pictures/", "ev_cirque_hh12"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 1,
            :id => 3371,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3618,
          :background => {
            :id => 91
          }
        },
        2 => {
          :name => "Request 1 (Outdoor Play 1)",
          :common => 5672,
          :condition => {
            :type => 1,
            :id => 3371,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Outdoor Play 2)",
          :common => 5673,
          :condition => {
            :type => 1,
            :id => 3371,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    548 => {
      :name => "Titania (Zombie)",
      :condition => {
        :type => 3,
        :id => 379
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cirque_h01"],
          2 => ["Graphics/Pictures/", "ev_cirque_h02"],
          3 => ["Graphics/Pictures/", "ev_cirque_h03"],
          4 => ["Graphics/Pictures/", "ev_cirque_h04"],
          5 => ["Graphics/Pictures/", "ev_cirque_h05"],
          6 => ["Graphics/Pictures/", "ev_cirque_h06"],
          7 => ["Graphics/Pictures/", "ev_cirque_h07"],
          8 => ["Graphics/Pictures/", "ev_cirque_h08"],
          9 => ["Graphics/Pictures/", "ev_cirque_h09"],
          10 => ["Graphics/Pictures/", "ev_cirque_h10"],
          11 => ["Graphics/Pictures/", "ev_cirque_h11"],
          12 => ["Graphics/Pictures/", "ev_cirque_h12"],
          13 => ["Graphics/Pictures/", "ev_cirque_h13"],
          14 => ["Graphics/Pictures/", "ev_cirque_h14"],
          15 => ["Graphics/Pictures/", "ev_cirque_h15"],
          16 => ["Graphics/Pictures/", "ev_cirque_h16"],
          17 => ["Graphics/Pictures/", "ev_cirque_h17"],
          18 => ["Graphics/Pictures/", "ev_cirque_h18"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
        ],
          :background => {
            :id => 56
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_cirque_st12"],
          2 => ["Graphics/Pictures/", "ev_cirque_ct11"],
          3 => ["Graphics/Pictures/", "ev_cirque_ct12"],
          4 => ["Graphics/Pictures/", "ev_cirque_hb01"],
          5 => ["Graphics/Pictures/", "ev_cirque_hb02"],
          6 => ["Graphics/Pictures/", "ev_cirque_hb03"],
          7 => ["Graphics/Pictures/", "ev_cirque_hb04"],
          8 => ["Graphics/Pictures/", "ev_cirque_hb05"],
          9 => ["Graphics/Pictures/", "ev_cirque_hb06"],
          10 => ["Graphics/Pictures/", "ev_cirque_hb07"],
          11 => ["Graphics/Pictures/", "ev_cirque_hb08"],
          12 => ["Graphics/Pictures/", "ev_cirque_hb09"],
          13 => ["Graphics/Pictures/", "ev_cirque_hb10"],
          14 => ["Graphics/Pictures/", "ev_cirque_hb11"],
          15 => ["Graphics/Pictures/", "ev_cirque_hb12"],
          16 => ["Graphics/Pictures/", "ev_cirque_hb13"],
          17 => ["Graphics/Pictures/", "ev_cirque_hb14"],
          18 => ["Graphics/Pictures/", "ev_cirque_hb15"],
          19 => ["Graphics/Pictures/", "ev_cirque_hb16"],
          20 => ["Graphics/Pictures/", "ev_cirque_hb17"],
          21 => ["Graphics/Pictures/", "ev_cirque_hb18"],
          22 => ["Graphics/Pictures/", "ev_cirque_hb19"],
          23 => ["Graphics/Pictures/", "ev_cirque_hb20"],
          24 => ["Graphics/Pictures/", "ev_cirque_hb21"],
          25 => ["Graphics/Pictures/", "ev_cirque_hb22"],
          26 => ["Graphics/Pictures/", "ev_cirque_hb31"],
          27 => ["Graphics/Pictures/", "ev_cirque_hb32"],
          28 => ["Graphics/Pictures/", "ev_cirque_hb33"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
          [26],
          [27],
          [28],
        ],
          :condition => {
            :type => 1,
            :id => 3370,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3379,
          :background => {
            :id => 56
          }
        },
        2 => {
          :name => "Request 1 (Coercive Masturbation)",
          :common => 5666,
          :condition => {
            :type => 1,
            :id => 3370,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Buttjob)",
          :common => 5667,
          :condition => {
            :type => 1,
            :id => 3370,
            :op => 1,
            :value => 30
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Pantyjob)",
          :common => 5668,
          :condition => {
            :type => 1,
            :id => 3370,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        5 => {
          :name => "Request 4 (Fairy Hug)",
          :common => 5669,
          :condition => {
            :type => 1,
            :id => 3370,
            :op => 1,
            :value => 70
          },
          :background => {
            :id => 1
          }
        },
        6 => {
          :name => "Request 5 (Cheer Play)",
          :common => 5670,
          :condition => {
            :type => 1,
            :id => 3370,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        },
        7 => {
          :name => "Request 6 (Boxing Play)",
          :common => 5671,
          :condition => {
            :type => 1,
            :id => 3370,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    549 => {
      :name => "Roza",
      :condition => {
        :type => 3,
        :id => 740
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cirque_hi1"],
          2 => ["Graphics/Pictures/", "ev_cirque_hi2"],
          3 => ["Graphics/Pictures/", "ev_cirque_hi3"],
          4 => ["Graphics/Pictures/", "ev_cirque_hi4"],
          5 => ["Graphics/Pictures/", "ev_cirque_hi5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 90
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3740,
          :background => {
            :id => 90
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5683,
          :condition => {
            :type => 1,
            :id => 3373,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    550 => {
      :name => "Roza (Zombie)",
      :condition => {
        :type => 3,
        :id => 380
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cirque_h01"],
          2 => ["Graphics/Pictures/", "ev_cirque_h02"],
          3 => ["Graphics/Pictures/", "ev_cirque_h03"],
          4 => ["Graphics/Pictures/", "ev_cirque_h04"],
          5 => ["Graphics/Pictures/", "ev_cirque_h05"],
          6 => ["Graphics/Pictures/", "ev_cirque_h06"],
          7 => ["Graphics/Pictures/", "ev_cirque_h07"],
          8 => ["Graphics/Pictures/", "ev_cirque_h08"],
          9 => ["Graphics/Pictures/", "ev_cirque_h09"],
          10 => ["Graphics/Pictures/", "ev_cirque_h10"],
          11 => ["Graphics/Pictures/", "ev_cirque_h11"],
          12 => ["Graphics/Pictures/", "ev_cirque_h12"],
          13 => ["Graphics/Pictures/", "ev_cirque_h13"],
          14 => ["Graphics/Pictures/", "ev_cirque_h14"],
          15 => ["Graphics/Pictures/", "ev_cirque_h15"],
          16 => ["Graphics/Pictures/", "ev_cirque_h16"],
          17 => ["Graphics/Pictures/", "ev_cirque_h17"],
          18 => ["Graphics/Pictures/", "ev_cirque_h18"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
        ],
          :background => {
            :id => 56
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_cirque_st22"],
          2 => ["Graphics/Pictures/", "ev_cirque_ct21"],
          3 => ["Graphics/Pictures/", "ev_cirque_ct22"],
          4 => ["Graphics/Pictures/", "ev_cirque_hc1"],
          5 => ["Graphics/Pictures/", "ev_cirque_hc2"],
          6 => ["Graphics/Pictures/", "ev_cirque_hc3"],
          7 => ["Graphics/Pictures/", "ev_cirque_hc4"],
          8 => ["Graphics/Pictures/", "ev_cirque_hc5"],
          9 => ["Graphics/Pictures/", "ev_cirque_hc6"],
          10 => ["Graphics/Pictures/", "ev_cirque_hc7"],
          11 => ["Graphics/Pictures/", "ev_cirque_hc8"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
        ],
          :condition => {
            :type => 1,
            :id => 3372,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3380,
          :background => {
            :id => 56
          }
        },
        2 => {
          :name => "Request 1 (Buttjob)",
          :common => 5681,
          :condition => {
            :type => 1,
            :id => 3372,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Paizuri)",
          :common => 5682,
          :condition => {
            :type => 1,
            :id => 3372,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    551 => {
      :name => "Queen Lamia",
      :condition => {
        :type => 3,
        :id => 716
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cirque_hk1"],
          2 => ["Graphics/Pictures/", "ev_cirque_hk2"],
          3 => ["Graphics/Pictures/", "ev_cirque_hk3"],
          4 => ["Graphics/Pictures/", "ev_cirque_hk4"],
          5 => ["Graphics/Pictures/", "ev_cirque_hk5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 17
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3716,
          :background => {
            :id => 17
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5693,
          :condition => {
            :type => 1,
            :id => 375,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    552 => {
      :name => "Queen Lamia (Zombie)",
      :condition => {
        :type => 3,
        :id => 381
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cirque_h01"],
          2 => ["Graphics/Pictures/", "ev_cirque_h02"],
          3 => ["Graphics/Pictures/", "ev_cirque_h03"],
          4 => ["Graphics/Pictures/", "ev_cirque_h04"],
          5 => ["Graphics/Pictures/", "ev_cirque_h05"],
          6 => ["Graphics/Pictures/", "ev_cirque_h06"],
          7 => ["Graphics/Pictures/", "ev_cirque_h07"],
          8 => ["Graphics/Pictures/", "ev_cirque_h08"],
          9 => ["Graphics/Pictures/", "ev_cirque_h09"],
          10 => ["Graphics/Pictures/", "ev_cirque_h10"],
          11 => ["Graphics/Pictures/", "ev_cirque_h11"],
          12 => ["Graphics/Pictures/", "ev_cirque_h12"],
          13 => ["Graphics/Pictures/", "ev_cirque_h13"],
          14 => ["Graphics/Pictures/", "ev_cirque_h14"],
          15 => ["Graphics/Pictures/", "ev_cirque_h15"],
          16 => ["Graphics/Pictures/", "ev_cirque_h16"],
          17 => ["Graphics/Pictures/", "ev_cirque_h17"],
          18 => ["Graphics/Pictures/", "ev_cirque_h18"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
        ],
          :background => {
            :id => 56
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_cirque_st32"],
          2 => ["Graphics/Pictures/", "ev_cirque_ct31"],
          3 => ["Graphics/Pictures/", "ev_cirque_ct32"],
          4 => ["Graphics/Pictures/", "ev_cirque_he01"],
          5 => ["Graphics/Pictures/", "ev_cirque_he02"],
          6 => ["Graphics/Pictures/", "ev_cirque_he03"],
          7 => ["Graphics/Pictures/", "ev_cirque_he04"],
          8 => ["Graphics/Pictures/", "ev_cirque_he05"],
          9 => ["Graphics/Pictures/", "ev_cirque_he06"],
          10 => ["Graphics/Pictures/", "ev_cirque_he07"],
          11 => ["Graphics/Pictures/", "ev_cirque_he08"],
          12 => ["Graphics/Pictures/", "ev_cirque_he09"],
          13 => ["Graphics/Pictures/", "ev_cirque_he10"],
          14 => ["Graphics/Pictures/", "ev_cirque_he11"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
        ],
          :condition => {
            :type => 1,
            :id => 3374,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3381,
          :background => {
            :id => 56
          }
        },
        2 => {
          :name => "Request 1 (Blowjob)",
          :common => 5691,
          :condition => {
            :type => 1,
            :id => 3374,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Swallowing Rape)",
          :common => 5692,
          :condition => {
            :type => 1,
            :id => 3374,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    553 => {
      :name => "Queen Harpy (Refletsia)",
      :condition => {
        :type => 3,
        :id => 735
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cirque_hja1"],
          2 => ["Graphics/Pictures/", "ev_cirque_hja7"],
          3 => ["Graphics/Pictures/", "ev_cirque_hja8"],
          4 => ["Graphics/Pictures/", "ev_cirque_hja9"],
          5 => ["Graphics/Pictures/", "ev_cirque_hja10"],
          6 => ["Graphics/Pictures/", "ev_cirque_hja11"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 377,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cirque_hja1"],
          2 => ["Graphics/Pictures/", "ev_cirque_hja2"],
          3 => ["Graphics/Pictures/", "ev_cirque_hja3"],
          4 => ["Graphics/Pictures/", "ev_cirque_hja4"],
          5 => ["Graphics/Pictures/", "ev_cirque_hja5"],
          6 => ["Graphics/Pictures/", "ev_cirque_hja6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 377,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cirque_hjb1"],
          2 => ["Graphics/Pictures/", "ev_cirque_hjb2"],
          3 => ["Graphics/Pictures/", "ev_cirque_hjb3"],
          4 => ["Graphics/Pictures/", "ev_cirque_hjb4"],
          5 => ["Graphics/Pictures/", "ev_cirque_hjb5"],
          6 => ["Graphics/Pictures/", "ev_cirque_hjb6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :background => {
            :id => 99
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3735,
          :background => {
            :id => 99
          }
        },
        2 => {
          :name => "Request 1 (Blowjob)",
          :common => 5703,
          :condition => {
            :type => 1,
            :id => 377,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Paizuri)",
          :common => 5704,
          :condition => {
            :type => 1,
            :id => 377,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Reverse Rape)",
          :common => 5705,
          :condition => {
            :type => 1,
            :id => 377,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    554 => {
      :name => "Queen Harpy (Refletsia: Zombie)",
      :condition => {
        :type => 3,
        :id => 382
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cirque_h01"],
          2 => ["Graphics/Pictures/", "ev_cirque_h02"],
          3 => ["Graphics/Pictures/", "ev_cirque_h03"],
          4 => ["Graphics/Pictures/", "ev_cirque_h04"],
          5 => ["Graphics/Pictures/", "ev_cirque_h05"],
          6 => ["Graphics/Pictures/", "ev_cirque_h06"],
          7 => ["Graphics/Pictures/", "ev_cirque_h07"],
          8 => ["Graphics/Pictures/", "ev_cirque_h08"],
          9 => ["Graphics/Pictures/", "ev_cirque_h09"],
          10 => ["Graphics/Pictures/", "ev_cirque_h10"],
          11 => ["Graphics/Pictures/", "ev_cirque_h11"],
          12 => ["Graphics/Pictures/", "ev_cirque_h12"],
          13 => ["Graphics/Pictures/", "ev_cirque_h13"],
          14 => ["Graphics/Pictures/", "ev_cirque_h14"],
          15 => ["Graphics/Pictures/", "ev_cirque_h15"],
          16 => ["Graphics/Pictures/", "ev_cirque_h16"],
          17 => ["Graphics/Pictures/", "ev_cirque_h17"],
          18 => ["Graphics/Pictures/", "ev_cirque_h18"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
        ],
          :background => {
            :id => 56
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cirque_ct41"],
          2 => ["Graphics/Pictures/", "ev_cirque_ct42"],
          3 => ["Graphics/Pictures/", "ev_cirque_ct43"],
          4 => ["Graphics/Pictures/", "ev_cirque_hd01"],
          5 => ["Graphics/Pictures/", "ev_cirque_hd02"],
          6 => ["Graphics/Pictures/", "ev_cirque_hd03"],
          7 => ["Graphics/Pictures/", "ev_cirque_hd04"],
          8 => ["Graphics/Pictures/", "ev_cirque_hd05"],
          9 => ["Graphics/Pictures/", "ev_cirque_hd06"],
          10 => ["Graphics/Pictures/", "ev_cirque_hd07"],
          11 => ["Graphics/Pictures/", "ev_cirque_hd08"],
          12 => ["Graphics/Pictures/", "ev_cirque_hd09"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
        ],
          :condition => {
            :type => 1,
            :id => 3376,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3382,
          :background => {
            :id => 56
          }
        },
        2 => {
          :name => "Request 1 (Blowjob)",
          :common => 5701,
          :condition => {
            :type => 1,
            :id => 3376,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5702,
          :condition => {
            :type => 1,
            :id => 3376,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    555 => {
      :name => "Queen Scylla",
      :condition => {
        :type => 3,
        :id => 720
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cirque_hl01"],
          2 => ["Graphics/Pictures/", "ev_cirque_hl02"],
          3 => ["Graphics/Pictures/", "ev_cirque_hl10"],
          4 => ["Graphics/Pictures/", "ev_cirque_hl11"],
          5 => ["Graphics/Pictures/", "ev_cirque_hl12"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 20
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cirque_hl01"],
          2 => ["Graphics/Pictures/", "ev_cirque_hl02"],
          3 => ["Graphics/Pictures/", "ev_cirque_hl03"],
          4 => ["Graphics/Pictures/", "ev_cirque_hl04"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 379,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cirque_hl01"],
          2 => ["Graphics/Pictures/", "ev_cirque_hl02"],
          3 => ["Graphics/Pictures/", "ev_cirque_hl06"],
          4 => ["Graphics/Pictures/", "ev_cirque_hl07"],
          5 => ["Graphics/Pictures/", "ev_cirque_hl08"],
          6 => ["Graphics/Pictures/", "ev_cirque_hl09"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 379,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3720,
          :background => {
            :id => 20
          }
        },
        2 => {
          :name => "Request 1 (Tentacle Energy Drain)",
          :common => 5713,
          :condition => {
            :type => 1,
            :id => 379,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Paizuri)",
          :common => 5714,
          :condition => {
            :type => 1,
            :id => 379,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Gills)",
          :common => 5715,
          :condition => {
            :type => 1,
            :id => 379,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    556 => {
      :name => "Queen Scylla (Zombie)",
      :condition => {
        :type => 3,
        :id => 383
      },
      :cg => {
        1 => {
          :regist => {
          1 => ["Graphics/Pictures/", "ev_cirque_h01"],
          2 => ["Graphics/Pictures/", "ev_cirque_h02"],
          3 => ["Graphics/Pictures/", "ev_cirque_h03"],
          4 => ["Graphics/Pictures/", "ev_cirque_h04"],
          5 => ["Graphics/Pictures/", "ev_cirque_h05"],
          6 => ["Graphics/Pictures/", "ev_cirque_h06"],
          7 => ["Graphics/Pictures/", "ev_cirque_h07"],
          8 => ["Graphics/Pictures/", "ev_cirque_h08"],
          9 => ["Graphics/Pictures/", "ev_cirque_h09"],
          10 => ["Graphics/Pictures/", "ev_cirque_h10"],
          11 => ["Graphics/Pictures/", "ev_cirque_h11"],
          12 => ["Graphics/Pictures/", "ev_cirque_h12"],
          13 => ["Graphics/Pictures/", "ev_cirque_h13"],
          14 => ["Graphics/Pictures/", "ev_cirque_h14"],
          15 => ["Graphics/Pictures/", "ev_cirque_h15"],
          16 => ["Graphics/Pictures/", "ev_cirque_h16"],
          17 => ["Graphics/Pictures/", "ev_cirque_h17"],
          18 => ["Graphics/Pictures/", "ev_cirque_h18"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
        ],
          :background => {
            :id => 56
          }
        },
        2 => {
          :regist => {
          1 => ["Graphics/Pictures/", "80_cirque_st52"],
          2 => ["Graphics/Pictures/", "ev_cirque_ct51"],
          3 => ["Graphics/Pictures/", "ev_cirque_ct52"],
          4 => ["Graphics/Pictures/", "ev_cirque_hf01"],
          5 => ["Graphics/Pictures/", "ev_cirque_hf02"],
          6 => ["Graphics/Pictures/", "ev_cirque_hf03"],
          7 => ["Graphics/Pictures/", "ev_cirque_hf04"],
          8 => ["Graphics/Pictures/", "ev_cirque_hf05"],
          9 => ["Graphics/Pictures/", "ev_cirque_hf06"],
          10 => ["Graphics/Pictures/", "ev_cirque_hf07"],
          11 => ["Graphics/Pictures/", "ev_cirque_hf08"],
        },
        # 表示パターンの指定
        :draw => [
          [1,2],
          [1,3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
        ],
          :condition => {
            :type => 1,
            :id => 3378,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3383,
          :background => {
            :id => 56
          }
        },
        2 => {
          :name => "Request 1 (Queen's Tentacle Squeeze)",
          :common => 5711,
          :condition => {
            :type => 1,
            :id => 3378,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5712,
          :condition => {
            :type => 1,
            :id => 3378,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },

    602 => {
      :name => "Cockroach Girl",
      :condition => {
        :type => 3,
        :id => 502
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_cockroacha_ha11"],
          2 => ["Graphics/Pictures/", "ev_cockroacha_ha12"],
          3 => ["Graphics/Pictures/", "ev_cockroacha_ha13"],
          4 => ["Graphics/Pictures/", "ev_cockroacha_ha14"],
          5 => ["Graphics/Pictures/", "ev_cockroacha_ha15"],
          6 => ["Graphics/Pictures/", "ev_cockroacha_ha16"],
          7 => ["Graphics/Pictures/", "ev_cockroacha_ha17"],
          8 => ["Graphics/Pictures/", "ev_cockroacha_ha18"],
          9 => ["Graphics/Pictures/", "ev_cockroacha_ha19"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 27
          }
        },
        2 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_cockroacha_ha01"],
          2 => ["Graphics/Pictures/", "ev_cockroacha_ha02"],
          3 => ["Graphics/Pictures/", "ev_cockroacha_ha03"],
          4 => ["Graphics/Pictures/", "ev_cockroacha_ha04"],
          5 => ["Graphics/Pictures/", "ev_cockroacha_ha05"],
          6 => ["Graphics/Pictures/", "ev_cockroacha_ha06"],
          7 => ["Graphics/Pictures/", "ev_cockroacha_ha07"],
          8 => ["Graphics/Pictures/", "ev_cockroacha_ha08"],
          9 => ["Graphics/Pictures/", "ev_cockroacha_ha09"],
          10 => ["Graphics/Pictures/", "ev_cockroacha_ha10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :condition => {
            :type => 1,
            :id => 3404,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 27
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3502,
          :background => {
            :id => 27
          }
        },
        2 => {
          :name => "Request 1 (Insect Hole Mating)",
          :common => 5946,
          :condition => {
            :type => 1,
            :id => 3404,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 5947,
          :condition => {
            :type => 1,
            :id => 3404,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    603 => {
      :name => "Speed Roach",
      :condition => {
        :type => 3,
        :id => 503
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_cockroachb_hb01"],
          2 => ["Graphics/Pictures/", "ev_cockroachb_hb02"],
          3 => ["Graphics/Pictures/", "ev_cockroachb_hb03"],
          4 => ["Graphics/Pictures/", "ev_cockroachb_hb04"],
          5 => ["Graphics/Pictures/", "ev_cockroachb_hb05"],
          6 => ["Graphics/Pictures/", "ev_cockroachb_hb06"],
          7 => ["Graphics/Pictures/", "ev_cockroachb_hb07"],
          8 => ["Graphics/Pictures/", "ev_cockroachb_hb08"],
          9 => ["Graphics/Pictures/", "ev_cockroachb_hb09"],
          10 => ["Graphics/Pictures/", "ev_cockroachb_hb10"],
          11 => ["Graphics/Pictures/", "ev_cockroachb_hb11"],
          12 => ["Graphics/Pictures/", "ev_cockroachb_hb12"],
          13 => ["Graphics/Pictures/", "ev_cockroachb_hb13"],
          14 => ["Graphics/Pictures/", "ev_cockroachb_hb14"],
          15 => ["Graphics/Pictures/", "ev_cockroachb_hb15"],
          16 => ["Graphics/Pictures/", "ev_cockroachb_hb16"],
          17 => ["Graphics/Pictures/", "ev_cockroachb_hb17"],
          18 => ["Graphics/Pictures/", "ev_cockroachb_hb18"],
          19 => ["Graphics/Pictures/", "ev_cockroachb_hb19"],
          20 => ["Graphics/Pictures/", "ev_cockroachb_hb20"],
          21 => ["Graphics/Pictures/", "ev_cockroachb_hb21"],
          22 => ["Graphics/Pictures/", "ev_cockroachb_hb22"],
          23 => ["Graphics/Pictures/", "ev_cockroachb_hb23"],
          24 => ["Graphics/Pictures/", "ev_cockroachb_hb24"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
        ],
          :background => {
            :id => 27
          }
        },
        2 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_cockroachb_ha01"],
          2 => ["Graphics/Pictures/", "ev_cockroachb_ha02"],
          3 => ["Graphics/Pictures/", "ev_cockroachb_ha03"],
          4 => ["Graphics/Pictures/", "ev_cockroachb_ha04"],
          5 => ["Graphics/Pictures/", "ev_cockroachb_ha05"],
          6 => ["Graphics/Pictures/", "ev_cockroachb_ha06"],
          7 => ["Graphics/Pictures/", "ev_cockroachb_ha07"],
          8 => ["Graphics/Pictures/", "ev_cockroachb_ha08"],
          9 => ["Graphics/Pictures/", "ev_cockroachb_ha09"],
          10 => ["Graphics/Pictures/", "ev_cockroachb_ha10"],
          11 => ["Graphics/Pictures/", "ev_cockroachb_ha11"],
          12 => ["Graphics/Pictures/", "ev_cockroachb_ha12"],
          13 => ["Graphics/Pictures/", "ev_cockroachb_ha13"],
          14 => ["Graphics/Pictures/", "ev_cockroachb_ha14"],
          15 => ["Graphics/Pictures/", "ev_cockroachb_ha15"],
          16 => ["Graphics/Pictures/", "ev_cockroachb_ha16"],
          17 => ["Graphics/Pictures/", "ev_cockroachb_ha17"],
          18 => ["Graphics/Pictures/", "ev_cockroachb_ha18"],
          19 => ["Graphics/Pictures/", "ev_cockroachb_ha19"],
          20 => ["Graphics/Pictures/", "ev_cockroachb_ha20"],
          21 => ["Graphics/Pictures/", "ev_cockroachb_ha21"],
          22 => ["Graphics/Pictures/", "ev_cockroachb_ha22"],
          23 => ["Graphics/Pictures/", "ev_cockroachb_ha23"],
          24 => ["Graphics/Pictures/", "ev_cockroachb_ha24"],
          25 => ["Graphics/Pictures/", "ev_cockroachb_ha25"],
          26 => ["Graphics/Pictures/", "ev_cockroachb_ha26"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
          [18],
          [19],
          [20],
          [21],
          [22],
          [23],
          [24],
          [25],
          [26],
        ],
          :condition => {
            :type => 1,
            :id => 3405,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 27
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3503,
          :background => {
            :id => 27
          }
        },
        2 => {
          :name => "Request 1 (Egg Sac Onahole)",
          :common => 5951,
          :condition => {
            :type => 1,
            :id => 3405,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Mating)",
          :common => 5952,
          :condition => {
            :type => 1,
            :id => 3405,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    604 => {
      :name => "Queen Roach",
      :condition => {
        :type => 3,
        :id => 504
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_queenroach_h17"],
          2 => ["Graphics/Pictures/", "ev_queenroach_h18"],
          3 => ["Graphics/Pictures/", "ev_queenroach_h19"],
          4 => ["Graphics/Pictures/", "ev_queenroach_h20"],
          5 => ["Graphics/Pictures/", "ev_queenroach_h21"],
          6 => ["Graphics/Pictures/", "ev_queenroach_h22"],
          7 => ["Graphics/Pictures/", "ev_queenroach_h23"],
          8 => ["Graphics/Pictures/", "ev_queenroach_h24"],
          9 => ["Graphics/Pictures/", "ev_queenroach_h25"],
          10 => ["Graphics/Pictures/", "ev_queenroach_h26"],
          11 => ["Graphics/Pictures/", "ev_queenroach_h27"],
          12 => ["Graphics/Pictures/", "ev_queenroach_h28"],
          13 => ["Graphics/Pictures/", "ev_queenroach_h29"],
          14 => ["Graphics/Pictures/", "ev_queenroach_h30"],
          15 => ["Graphics/Pictures/", "ev_queenroach_h31"],
          16 => ["Graphics/Pictures/", "ev_queenroach_h32"],
          17 => ["Graphics/Pictures/", "ev_queenroach_h33"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
          [17],
        ],
          :background => {
            :id => 27
          }
        },
        2 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_queenroach_h01"],
          2 => ["Graphics/Pictures/", "ev_queenroach_h02"],
          3 => ["Graphics/Pictures/", "ev_queenroach_h03"],
          4 => ["Graphics/Pictures/", "ev_queenroach_h04"],
          5 => ["Graphics/Pictures/", "ev_queenroach_h05"],
          6 => ["Graphics/Pictures/", "ev_queenroach_h06"],
          7 => ["Graphics/Pictures/", "ev_queenroach_h07"],
          8 => ["Graphics/Pictures/", "ev_queenroach_h08"],
          9 => ["Graphics/Pictures/", "ev_queenroach_h09"],
          10 => ["Graphics/Pictures/", "ev_queenroach_h10"],
          11 => ["Graphics/Pictures/", "ev_queenroach_h11"],
          12 => ["Graphics/Pictures/", "ev_queenroach_h12"],
          13 => ["Graphics/Pictures/", "ev_queenroach_h13"],
          14 => ["Graphics/Pictures/", "ev_queenroach_h14"],
          15 => ["Graphics/Pictures/", "ev_queenroach_h15"],
          16 => ["Graphics/Pictures/", "ev_queenroach_h16"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
          [13],
          [14],
          [15],
          [16],
        ],
          :background => {
            :id => 27
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3504,
          :background => {
            :id => 27
          }
        },
        2 => {
          :name => "Request 1 (Mating)",
          :common => 5956,
          :condition => {
            :type => 1,
            :id => 3406,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    607 => {
      :name => "Magic Pot",
      :condition => {
        :type => 3,
        :id => 507
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_magicpot_h1"],
          2 => ["Graphics/Pictures/", "ev_magicpot_h2"],
          3 => ["Graphics/Pictures/", "ev_magicpot_h3"],
          4 => ["Graphics/Pictures/", "ev_magicpot_h4"],
          5 => ["Graphics/Pictures/", "ev_magicpot_h5"],
          6 => ["Graphics/Pictures/", "ev_magicpot_h6"],
          7 => ["Graphics/Pictures/", "ev_magicpot_h7"],
          8 => ["Graphics/Pictures/", "ev_magicpot_h8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 27
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3507,
          :background => {
            :id => 27
          }
        },
        2 => {
          :name => "Request 1 (Sticky Flesh Semen Sucking)",
          :common => 5961,
          :condition => {
            :type => 1,
            :id => 3407,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    608 => {
      :name => "Junior Tanuki",
      :condition => {
        :type => 3,
        :id => 508
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_mametanuki_h1"],
          2 => ["Graphics/Pictures/", "ev_mametanuki_h2"],
          3 => ["Graphics/Pictures/", "ev_mametanuki_h3"],
          4 => ["Graphics/Pictures/", "ev_mametanuki_h4"],
          5 => ["Graphics/Pictures/", "ev_mametanuki_h5"],
          6 => ["Graphics/Pictures/", "ev_mametanuki_h6"],
          7 => ["Graphics/Pictures/", "ev_mametanuki_h7"],
          8 => ["Graphics/Pictures/", "ev_mametanuki_h8"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
        ],
          :background => {
            :id => 72
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3508,
          :background => {
            :id => 72
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 5966,
          :condition => {
            :type => 1,
            :id => 3408,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    609 => {
      :name => "High Tanuki",
      :condition => {
        :type => 3,
        :id => 509
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_zyoutanuki_hb1"],
          2 => ["Graphics/Pictures/", "ev_zyoutanuki_hb2"],
          3 => ["Graphics/Pictures/", "ev_zyoutanuki_hb3"],
          4 => ["Graphics/Pictures/", "ev_zyoutanuki_ct11"],
          5 => ["Graphics/Pictures/", "ev_zyoutanuki_ct12"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,4],
          [2,5],
          [3,5],
        ],
          :background => {
            :id => 72
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3509,
          :background => {
            :id => 72
          }
        },
        2 => {
          :name => "Request 1 (Labia Grind)",
          :common => 5971,
          :condition => {
            :type => 1,
            :id => 3409,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    610 => {
      :name => "Shinobitanuki",
      :condition => {
        :type => 3,
        :id => 510
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_shinobitanuki_ha1"],
          2 => ["Graphics/Pictures/", "ev_shinobitanuki_ha2"],
          3 => ["Graphics/Pictures/", "ev_shinobitanuki_ha3"],
          4 => ["Graphics/Pictures/", "ev_shinobitanuki_ha4"],
          5 => ["Graphics/Pictures/", "ev_shinobitanuki_ha5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 72
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3510,
          :background => {
            :id => 72
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5976,
          :condition => {
            :type => 1,
            :id => 3410,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    611 => {
      :name => "Bakedanuki",
      :condition => {
        :type => 3,
        :id => 511
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_baketanuki_h01"],
          2 => ["Graphics/Pictures/", "ev_baketanuki_h02"],
          3 => ["Graphics/Pictures/", "ev_baketanuki_h03"],
          4 => ["Graphics/Pictures/", "ev_baketanuki_h04"],
          5 => ["Graphics/Pictures/", "ev_baketanuki_h05"],
          6 => ["Graphics/Pictures/", "ev_baketanuki_h06"],
          7 => ["Graphics/Pictures/", "ev_baketanuki_h07"],
          8 => ["Graphics/Pictures/", "ev_baketanuki_h08"],
          9 => ["Graphics/Pictures/", "ev_baketanuki_h09"],
          10 => ["Graphics/Pictures/", "ev_baketanuki_h10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 72
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3511,
          :background => {
            :id => 72
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 5981,
          :condition => {
            :type => 1,
            :id => 3411,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    612 => {
      :name => "Inugami Gyobu-danuki",
      :condition => {
        :type => 3,
        :id => 512
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_inugami_h1s"],
          2 => ["Graphics/Pictures/", "ev_inugami_h2s"],
          3 => ["Graphics/Pictures/", "ev_inugami_h3s"],
          4 => ["Graphics/Pictures/", "ev_inugami_h4s"],
          5 => ["Graphics/Pictures/", "ev_inugami_h5s"],
          6 => ["Graphics/Pictures/", "ev_inugami_h6s"],
          7 => ["Graphics/Pictures/", "ev_inugami_h7s"],
          8 => ["Graphics/Pictures/", "ev_inugami_h8s"],
          9 => ["Graphics/Pictures/", "ev_inugami_h9s"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
        ],
          :background => {
            :id => 72
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3512,
          :background => {
            :id => 72
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5986,
          :condition => {
            :type => 1,
            :id => 3412,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    613 => {
      :name => "Black Tanuki",
      :condition => {
        :type => 3,
        :id => 513
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_kurodanuki_ha0s"],
          2 => ["Graphics/Pictures/", "ev_kurodanuki_ha1s"],
          3 => ["Graphics/Pictures/", "ev_kurodanuki_ha2s"],
          4 => ["Graphics/Pictures/", "ev_kurodanuki_ha3s"],
          5 => ["Graphics/Pictures/", "ev_kurodanuki_ha4s"],
          6 => ["Graphics/Pictures/", "ev_kurodanuki_ha5s"],
          7 => ["Graphics/Pictures/", "ev_kurodanuki_ha6s"],
          8 => ["Graphics/Pictures/", "ev_kurodanuki_ha7s"],
          9 => ["Graphics/Pictures/", "ev_kurodanuki_ha8s"],
          10 => ["Graphics/Pictures/", "ev_kurodanuki_ha9s"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 78
          }
        },
        2 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_kurodanuki_hb0s"],
          2 => ["Graphics/Pictures/", "ev_kurodanuki_hb1s"],
          3 => ["Graphics/Pictures/", "ev_kurodanuki_hb2s"],
          4 => ["Graphics/Pictures/", "ev_kurodanuki_hb3s"],
          5 => ["Graphics/Pictures/", "ev_kurodanuki_hb4s"],
          6 => ["Graphics/Pictures/", "ev_kurodanuki_hb5s"],
          7 => ["Graphics/Pictures/", "ev_kurodanuki_hb6s"],
          8 => ["Graphics/Pictures/", "ev_kurodanuki_hb7s"],
          9 => ["Graphics/Pictures/", "ev_kurodanuki_hb8s"],
          10 => ["Graphics/Pictures/", "ev_kurodanuki_hb9s"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 78
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3513,
          :background => {
            :id => 78
          }
        },
        2 => {
          :name => "Request 1 (Reverse Rape)",
          :common => 5991,
          :condition => {
            :type => 1,
            :id => 3413,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    615 => {
      :name => "Kunoichi Elves",
      :condition => {
        :type => 3,
        :id => 515
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_kunoitielf2_hb01"],
          2 => ["Graphics/Pictures/", "ev_kunoitielf2_hb02"],
          3 => ["Graphics/Pictures/", "ev_kunoitielf2_hb03"],
          4 => ["Graphics/Pictures/", "ev_kunoitielf2_hb04"],
          5 => ["Graphics/Pictures/", "ev_kunoitielf2_hb05"],
          6 => ["Graphics/Pictures/", "ev_kunoitielf2_hb06"],
          7 => ["Graphics/Pictures/", "ev_kunoitielf2_hb07"],
          8 => ["Graphics/Pictures/", "ev_kunoitielf2_hb08"],
          9 => ["Graphics/Pictures/", "ev_kunoitielf2_hb09"],
          10 => ["Graphics/Pictures/", "ev_kunoitielf2_hb10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :background => {
            :id => 80
          }
        },
        2 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_kunoitielf2_ha01"],
          2 => ["Graphics/Pictures/", "ev_kunoitielf2_ha02"],
          3 => ["Graphics/Pictures/", "ev_kunoitielf2_ha03"],
          4 => ["Graphics/Pictures/", "ev_kunoitielf2_ha04"],
          5 => ["Graphics/Pictures/", "ev_kunoitielf2_ha05"],
          6 => ["Graphics/Pictures/", "ev_kunoitielf2_ha06"],
          7 => ["Graphics/Pictures/", "ev_kunoitielf2_ha07"],
          8 => ["Graphics/Pictures/", "ev_kunoitielf2_ha08"],
          9 => ["Graphics/Pictures/", "ev_kunoitielf2_ha09"],
          10 => ["Graphics/Pictures/", "ev_kunoitielf2_ha10"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
        ],
          :condition => {
            :type => 1,
            :id => 3414,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 80
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3515,
          :background => {
            :id => 80
          }
        },
        2 => {
          :name => "Request 1 (Triple Play)",
          :common => 5996,
          :condition => {
            :type => 1,
            :id => 3414,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Harem)",
          :common => 5997,
          :condition => {
            :type => 1,
            :id => 3414,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    618 => {
      :name => "Kunoichi Succubus",
      :condition => {
        :type => 3,
        :id => 518
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_kuno_succubus_ha1"],
          2 => ["Graphics/Pictures/", "ev_kuno_succubus_ha2"],
          3 => ["Graphics/Pictures/", "ev_kuno_succubus_ha3"],
          4 => ["Graphics/Pictures/", "ev_kuno_succubus_ha4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 80
          }
        },
        2 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_kuno_succubus_hb01"],
          2 => ["Graphics/Pictures/", "ev_kuno_succubus_hb02"],
          3 => ["Graphics/Pictures/", "ev_kuno_succubus_hb03"],
          4 => ["Graphics/Pictures/", "ev_kuno_succubus_hb04"],
          5 => ["Graphics/Pictures/", "ev_kuno_succubus_hb05"],
          6 => ["Graphics/Pictures/", "ev_kuno_succubus_hb06"],
          7 => ["Graphics/Pictures/", "ev_kuno_succubus_hb07"],
          8 => ["Graphics/Pictures/", "ev_kuno_succubus_hb08"],
          9 => ["Graphics/Pictures/", "ev_kuno_succubus_hb09"],
          10 => ["Graphics/Pictures/", "ev_kuno_succubus_hb10"],
          11 => ["Graphics/Pictures/", "ev_kuno_succubus_hb11"],
          12 => ["Graphics/Pictures/", "ev_kuno_succubus_hb12"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
          [8],
          [9],
          [10],
          [11],
          [12],
        ],
          :condition => {
            :type => 1,
            :id => 3415,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 80
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3518,
          :background => {
            :id => 80
          }
        },
        2 => {
          :name => "Request 1 (Blowjob)",
          :common => 6001,
          :condition => {
            :type => 1,
            :id => 3415,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Cowgirl Drain)",
          :common => 6002,
          :condition => {
            :type => 1,
            :id => 3415,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Cowgirl Drain...?)",
          :common => 6003,
          :condition => {
            :type => 1,
            :id => 3415,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    619 => {
      :name => "Kunoichi Harpy",
      :condition => {
        :type => 3,
        :id => 519
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_kuno_hapy_ha1"],
          2 => ["Graphics/Pictures/", "ev_kuno_hapy_ha2"],
          3 => ["Graphics/Pictures/", "ev_kuno_hapy_ha3"],
          4 => ["Graphics/Pictures/", "ev_kuno_hapy_ha4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 80
          }
        },
        2 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_kuno_hapy_hb1"],
          2 => ["Graphics/Pictures/", "ev_kuno_hapy_hb2"],
          3 => ["Graphics/Pictures/", "ev_kuno_hapy_hb3"],
          4 => ["Graphics/Pictures/", "ev_kuno_hapy_hb4"],
          5 => ["Graphics/Pictures/", "ev_kuno_hapy_hb5"],
          6 => ["Graphics/Pictures/", "ev_kuno_hapy_hb6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3416,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 80
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3519,
          :background => {
            :id => 80
          }
        },
        2 => {
          :name => "Request 1 (Paizuri)",
          :common => 6006,
          :condition => {
            :type => 1,
            :id => 3416,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 6007,
          :condition => {
            :type => 1,
            :id => 3416,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    620 => {
      :name => "Kunoichi Scylla",
      :condition => {
        :type => 3,
        :id => 520
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_kuno_scylla_ha1"],
          2 => ["Graphics/Pictures/", "ev_kuno_scylla_ha2"],
          3 => ["Graphics/Pictures/", "ev_kuno_scylla_ha3"],
          4 => ["Graphics/Pictures/", "ev_kuno_scylla_ha4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :background => {
            :id => 80
          }
        },
        2 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_kuno_scylla_hb1"],
          2 => ["Graphics/Pictures/", "ev_kuno_scylla_hb2"],
          3 => ["Graphics/Pictures/", "ev_kuno_scylla_hb3"],
          4 => ["Graphics/Pictures/", "ev_kuno_scylla_hb4"],
          5 => ["Graphics/Pictures/", "ev_kuno_scylla_hb5"],
          6 => ["Graphics/Pictures/", "ev_kuno_scylla_hb6"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
        ],
          :condition => {
            :type => 1,
            :id => 3417,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 80
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3520,
          :background => {
            :id => 80
          }
        },
        2 => {
          :name => "Request 1 (Tentaclejob)",
          :common => 6011,
          :condition => {
            :type => 1,
            :id => 3417,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 6012,
          :condition => {
            :type => 1,
            :id => 3417,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    621 => {
      :name => "Kunoichi Arachne",
      :condition => {
        :type => 3,
        :id => 521
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_kuno_arachne_hb1"],
          2 => ["Graphics/Pictures/", "ev_kuno_arachne_hb2"],
          3 => ["Graphics/Pictures/", "ev_kuno_arachne_hb3"],
          4 => ["Graphics/Pictures/", "ev_kuno_arachne_hb4"],
          5 => ["Graphics/Pictures/", "ev_kuno_arachne_hb5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 80
          }
        },
        2 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_kuno_arachne_ha1"],
          2 => ["Graphics/Pictures/", "ev_kuno_arachne_ha2"],
          3 => ["Graphics/Pictures/", "ev_kuno_arachne_ha3"],
          4 => ["Graphics/Pictures/", "ev_kuno_arachne_ha4"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
        ],
          :condition => {
            :type => 1,
            :id => 3418,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 80
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3521,
          :background => {
            :id => 80
          }
        },
        2 => {
          :name => "Request 1 (Sticky Thread Teasing)",
          :common => 6016,
          :condition => {
            :type => 1,
            :id => 3418,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Reverse Rape)",
          :common => 6017,
          :condition => {
            :type => 1,
            :id => 3418,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Reverse Rape...?)",
          :common => 6018,
          :condition => {
            :type => 1,
            :id => 3418,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    622 => {
      :name => "Elf Princess",
      :condition => {
        :type => 3,
        :id => 522
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_elfhime_ha1"],
          2 => ["Graphics/Pictures/", "ev_elfhime_ha2"],
          3 => ["Graphics/Pictures/", "ev_elfhime_ha3"],
          4 => ["Graphics/Pictures/", "ev_elfhime_ha4"],
          5 => ["Graphics/Pictures/", "ev_elfhime_ha5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :background => {
            :id => 66
          }
        },
        2 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_elfhime_hb1"],
          2 => ["Graphics/Pictures/", "ev_elfhime_hb2"],
          3 => ["Graphics/Pictures/", "ev_elfhime_hb3"],
          4 => ["Graphics/Pictures/", "ev_elfhime_hb4"],
          5 => ["Graphics/Pictures/", "ev_elfhime_hb5"],
          6 => ["Graphics/Pictures/", "ev_elfhime_hb6"],
          7 => ["Graphics/Pictures/", "ev_elfhime_hb7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :condition => {
            :type => 1,
            :id => 3419,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 66
          }
        },
        3 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_elfhime_hc1"],
          2 => ["Graphics/Pictures/", "ev_elfhime_hc2"],
          3 => ["Graphics/Pictures/", "ev_elfhime_hc3"],
          4 => ["Graphics/Pictures/", "ev_elfhime_hc4"],
          5 => ["Graphics/Pictures/", "ev_elfhime_hc5"],
          6 => ["Graphics/Pictures/", "ev_elfhime_hc6"],
          7 => ["Graphics/Pictures/", "ev_elfhime_hc7"],
          8 => ["Graphics/Pictures/", "ev_elfhime_ct01"],
          9 => ["Graphics/Pictures/", "ev_elfhime_ct02"],
          10 => ["Graphics/Pictures/", "ev_elfhime_ct03"],
          11 => ["Graphics/Pictures/", "ev_elfhime_ct04"],
          12 => ["Graphics/Pictures/", "ev_elfhime_ct05"],
          13 => ["Graphics/Pictures/", "ev_elfhime_ct06"],
          14 => ["Graphics/Pictures/", "ev_elfhime_ct07"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [1,8],
          [2,9],
          [3,10],
          [4,11],
          [5,12],
          [6,13],
          [7,14],
        ],
          :condition => {
            :type => 1,
            :id => 3419,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 66
          }
        }
      },
      :items => {
        1 => {
          :name => "Defeat 1",
          :common => 3522,
          :background => {
            :id => 66
          }
        },
        2 => {
          :name => "Request 1 (Attendants' Training)",
          :common => 6021,
          :condition => {
            :type => 1,
            :id => 3419,
            :op => 1,
            :value => 10
          },
          :background => {
            :id => 1
          }
        },
        3 => {
          :name => "Request 2 (Handjob)",
          :common => 6022,
          :condition => {
            :type => 1,
            :id => 3419,
            :op => 1,
            :value => 50
          },
          :background => {
            :id => 1
          }
        },
        4 => {
          :name => "Request 3 (Reverse Rape)",
          :common => 6023,
          :condition => {
            :type => 1,
            :id => 3419,
            :op => 1,
            :value => 100
          },
          :background => {
            :id => 1
          }
        }
      }
    },
    625 => {
      :name => "Yao",
      :condition => {
        :type => 3,
        :id => 525
      },
      :cg => {
        1 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_hatibi_hb1"],
          2 => ["Graphics/Pictures/", "ev_hatibi_hb2"],
          3 => ["Graphics/Pictures/", "ev_hatibi_hb3"],
          4 => ["Graphics/Pictures/", "ev_hatibi_hb4"],
          5 => ["Graphics/Pictures/", "ev_hatibi_hb5"],
          6 => ["Graphics/Pictures/", "ev_hatibi_hb6"],
          7 => ["Graphics/Pictures/", "ev_hatibi_hb7"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
          [6],
          [7],
        ],
          :background => {
            :id => 41
          }
        },
        2 => {
        :regist => {
          1 => ["Graphics/Pictures/", "ev_hatibi_hc1"],
          2 => ["Graphics/Pictures/", "ev_hatibi_hc2"],
          3 => ["Graphics/Pictures/", "ev_hatibi_hc3"],
          4 => ["Graphics/Pictures/", "ev_hatibi_hc4"],
          5 => ["Graphics/Pictures/", "ev_hatibi_hc5"],
        },
        # 表示パターンの指定
        :draw => [
          [1],
          [2],
          [3],
          [4],
          [5],
        ],
          :condition => {
            :type => 1,
            :id => 34